/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.apache.activemq.tool.ClientRunBasis;
import org.apache.activemq.tool.properties.AbstractObjectProperties;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.apache.activemq.tool.properties.JmsClientSystemProperties;
import org.apache.activemq.tool.properties.JmsFactoryProperties;
import org.apache.activemq.tool.properties.ReflectionUtil;
import org.apache.activemq.tool.reports.PerformanceReportWriter;
import org.apache.activemq.tool.reports.VerbosePerfReportWriter;
import org.apache.activemq.tool.reports.XmlFilePerfReportWriter;
import org.apache.activemq.tool.sampler.AbstractPerformanceSampler;
import org.apache.activemq.tool.sampler.CpuSamplerTask;
import org.apache.activemq.tool.sampler.PerformanceSampler;
import org.apache.activemq.tool.sampler.ThroughputSamplerTask;
import org.apache.activemq.tool.spi.SPIConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJmsClientSystem
extends AbstractObjectProperties {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJmsClientSystem.class);
    protected ThreadGroup clientThreadGroup;
    protected ConnectionFactory jmsConnFactory;
    protected JmsFactoryProperties factory = new JmsFactoryProperties();
    protected ThroughputSamplerTask tpSampler = new ThroughputSamplerTask();
    private int clientDestIndex;
    private int clientDestCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runSystemTest() throws JMSException {
        this.jmsConnFactory = this.loadJmsFactory(this.getSysTest().getSpiClass(), this.factory.getFactorySettings());
        this.setProviderMetaData(this.jmsConnFactory.createConnection().getMetaData(), this.getJmsClientProperties());
        PerformanceReportWriter writer = this.createPerfWriter();
        writer.openReportWriter();
        writer.writeProperties("jvmSettings", System.getProperties());
        writer.writeProperties("testSystemSettings", ReflectionUtil.retrieveObjectProperties(this.getSysTest()));
        writer.writeProperties("jmsFactorySettings", ReflectionUtil.retrieveObjectProperties(this.jmsConnFactory));
        writer.writeProperties("jmsClientSettings", ReflectionUtil.retrieveObjectProperties(this.getJmsClientProperties()));
        ArrayList<AbstractPerformanceSampler> samplers = new ArrayList<AbstractPerformanceSampler>();
        Set<String> requestedSamplers = this.getSysTest().getSamplersSet();
        if (requestedSamplers.contains("tp")) {
            writer.writeProperties("tpSamplerSettings", ReflectionUtil.retrieveObjectProperties(this.tpSampler));
            samplers.add(this.tpSampler);
        }
        if (requestedSamplers.contains("cpu")) {
            CpuSamplerTask cpuSampler = new CpuSamplerTask();
            writer.writeProperties("cpuSamplerSettings", ReflectionUtil.retrieveObjectProperties(cpuSampler));
            try {
                cpuSampler.createPlugin();
                samplers.add(cpuSampler);
            }
            catch (IOException e) {
                LOG.warn("Unable to start CPU sampler plugin. Reason: " + e.getMessage());
            }
        }
        this.clientThreadGroup = new ThreadGroup(this.getSysTest().getClientPrefix() + " Thread Group");
        int numClients = this.getSysTest().getNumClients();
        CountDownLatch clientCompletionLatch = new CountDownLatch(numClients);
        for (int i = 0; i < numClients; ++i) {
            this.distributeDestinations(this.getSysTest().getDestDistro(), i, numClients, this.getSysTest().getTotalDests());
            Iterator clientName = this.getSysTest().getClientPrefix() + i;
            int n = this.clientDestIndex;
            int clientDestCount = this.clientDestCount;
            Thread t = new Thread(this.clientThreadGroup, new Runnable((String)((Object)clientName), n, clientDestCount, clientCompletionLatch){
                final /* synthetic */ String val$clientName;
                final /* synthetic */ int val$clientDestIndex;
                final /* synthetic */ int val$clientDestCount;
                final /* synthetic */ CountDownLatch val$clientCompletionLatch;
                {
                    this.val$clientName = string;
                    this.val$clientDestIndex = n;
                    this.val$clientDestCount = n2;
                    this.val$clientCompletionLatch = countDownLatch;
                }

                @Override
                public void run() {
                    AbstractJmsClientSystem.this.runJmsClient(this.val$clientName, this.val$clientDestIndex, this.val$clientDestCount);
                    LOG.info("Client completed");
                    this.val$clientCompletionLatch.countDown();
                }
            });
            t.setName(this.getSysTest().getClientPrefix() + i + " Thread");
            t.start();
        }
        CountDownLatch samplerCompletionLatch = new CountDownLatch(requestedSamplers.size());
        for (PerformanceSampler performanceSampler : samplers) {
            performanceSampler.setPerfReportWriter(writer);
            performanceSampler.startSampler(samplerCompletionLatch, this.getClientRunBasis(), this.getClientRunDuration());
        }
        try {
            clientCompletionLatch.await();
            LOG.debug("All clients completed");
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (this.getClientRunBasis() == ClientRunBasis.count) {
                for (PerformanceSampler performanceSampler : samplers) {
                    performanceSampler.finishSampling();
                }
            }
            try {
                LOG.debug("Waiting for samplers to shut down");
                samplerCompletionLatch.await();
                LOG.debug("All samplers completed");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                writer.closeReportWriter();
            }
        }
    }

    protected abstract ClientRunBasis getClientRunBasis();

    protected abstract long getClientRunDuration();

    public ThroughputSamplerTask getTpSampler() {
        return this.tpSampler;
    }

    public JmsFactoryProperties getFactory() {
        return this.factory;
    }

    public void setFactory(JmsFactoryProperties factory) {
        this.factory = factory;
    }

    public abstract JmsClientSystemProperties getSysTest();

    public abstract void setSysTest(JmsClientSystemProperties var1);

    public abstract JmsClientProperties getJmsClientProperties();

    protected PerformanceReportWriter createPerfWriter() {
        if (this.getSysTest().getReportType().equalsIgnoreCase("xml")) {
            Object reportName = this.getSysTest().getReportName();
            if (reportName == null) {
                reportName = this.getSysTest().getClientPrefix() + "_numClients" + this.getSysTest().getNumClients() + "_numDests" + this.getSysTest().getTotalDests() + "_" + this.getSysTest().getDestDistro();
            }
            return new XmlFilePerfReportWriter(this.getSysTest().getReportDir(), (String)reportName);
        }
        if (this.getSysTest().getReportType().equalsIgnoreCase("verbose")) {
            return new VerbosePerfReportWriter();
        }
        return new VerbosePerfReportWriter();
    }

    protected void distributeDestinations(String distroType, int clientIndex, int numClients, int numDests) {
        if (distroType.equalsIgnoreCase("all")) {
            this.clientDestCount = numDests;
            this.clientDestIndex = 0;
        } else if (distroType.equalsIgnoreCase("equal")) {
            int destPerClient = numDests / numClients;
            if (destPerClient > 0) {
                this.clientDestCount = destPerClient;
                this.clientDestIndex = destPerClient * clientIndex;
            } else {
                this.clientDestCount = 1;
                this.clientDestIndex = clientIndex % numDests;
            }
        } else if (distroType.equalsIgnoreCase("divide")) {
            int destPerClient = numDests / numClients;
            if (destPerClient > 0) {
                int remain = numDests % numClients;
                int nextIndex = clientIndex < remain ? clientIndex * ++destPerClient : clientIndex * destPerClient + remain;
                this.clientDestCount = destPerClient;
                this.clientDestIndex = nextIndex;
            } else {
                this.clientDestCount = 1;
                this.clientDestIndex = clientIndex % numDests;
            }
        } else {
            LOG.warn("Unknown destination distribution type: " + distroType);
            this.clientDestCount = numDests;
            this.clientDestIndex = 0;
        }
    }

    protected ConnectionFactory loadJmsFactory(String spiClass, Properties factorySettings) throws JMSException {
        try {
            Class<?> spi = Class.forName(spiClass);
            SPIConnectionFactory spiFactory = (SPIConnectionFactory)SPIConnectionFactory.class.cast(spi.getConstructor(new Class[0]).newInstance(new Object[0]));
            ConnectionFactory jmsFactory = spiFactory.createConnectionFactory(factorySettings);
            LOG.info("Created: " + jmsFactory.getClass().getName() + " using SPIConnectionFactory: " + spiFactory.getClass().getName());
            return jmsFactory;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JMSException(e.getMessage());
        }
    }

    protected void setProviderMetaData(ConnectionMetaData metaData, JmsClientProperties props) throws JMSException {
        props.setJmsProvider(metaData.getJMSProviderName() + "-" + metaData.getProviderVersion());
        props.setJmsVersion(metaData.getJMSVersion());
        Object jmsProperties = "";
        Enumeration jmsProps = metaData.getJMSXPropertyNames();
        while (jmsProps.hasMoreElements()) {
            jmsProperties = (String)jmsProperties + jmsProps.nextElement().toString() + ",";
        }
        if (((String)jmsProperties).length() > 0) {
            jmsProperties = ((String)jmsProperties).substring(0, ((String)jmsProperties).length() - 1);
        }
        props.setJmsProperties((String)jmsProperties);
    }

    protected abstract void runJmsClient(String var1, int var2, int var3);

    protected static Properties parseStringArgs(String[] args) {
        Properties fileProps;
        Properties props;
        block12: {
            File configFile = null;
            props = new Properties();
            if (args == null || args.length == 0) {
                return props;
            }
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("-D") || arg.startsWith("-d")) {
                    arg = arg.substring(2);
                }
                int index = arg.indexOf("=");
                String key = arg.substring(0, index);
                Object val = arg.substring(index + 1);
                if (key.equalsIgnoreCase("sysTest.propsConfigFile")) {
                    if (!((String)val).endsWith(".properties")) {
                        val = (String)val + ".properties";
                    }
                    configFile = new File((String)val);
                }
                props.setProperty(key, (String)val);
            }
            fileProps = new Properties();
            try {
                if (configFile == null) break block12;
                try (FileInputStream inputStream = new FileInputStream(configFile);){
                    LOG.info("Loading properties file: " + configFile.getAbsolutePath());
                    fileProps.load(inputStream);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        fileProps.putAll((Map<?, ?>)props);
        return fileProps;
    }
}

