/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJmsClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJmsClient.class);
    private static final String QUEUE_SCHEME = "queue://";
    private static final String TOPIC_SCHEME = "topic://";
    private static final String TEMP_QUEUE_SCHEME = "temp-queue://";
    private static final String TEMP_TOPIC_SCHEME = "temp-topic://";
    public static final String DESTINATION_SEPARATOR = ",";
    protected ConnectionFactory factory;
    protected Connection jmsConnection;
    protected Session jmsSession;
    protected int destCount = 1;
    protected int destIndex;
    protected String clientName = "";
    private int internalTxCounter = 0;

    public AbstractJmsClient(ConnectionFactory factory) {
        this.factory = factory;
    }

    public abstract JmsClientProperties getClient();

    public abstract void setClient(JmsClientProperties var1);

    public ConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ConnectionFactory factory) {
        this.factory = factory;
    }

    public int getDestCount() {
        return this.destCount;
    }

    public void setDestCount(int destCount) {
        this.destCount = destCount;
    }

    public int getDestIndex() {
        return this.destIndex;
    }

    public void setDestIndex(int destIndex) {
        this.destIndex = destIndex;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Connection getConnection() throws JMSException {
        if (this.jmsConnection == null) {
            this.jmsConnection = this.factory.createConnection();
            this.jmsConnection.setClientID(this.getClientName());
            LOG.info("Creating JMS Connection: Provider=" + this.getClient().getJmsProvider() + ", JMS Spec=" + this.getClient().getJmsVersion());
        }
        return this.jmsConnection;
    }

    public Session getSession() throws JMSException {
        if (this.jmsSession == null) {
            int ackMode = this.getClient().getSessAckMode().equalsIgnoreCase("autoAck") ? 1 : (this.getClient().getSessAckMode().equalsIgnoreCase("clientAck") ? 2 : (this.getClient().getSessAckMode().equalsIgnoreCase("dupsAck") ? 3 : (this.getClient().getSessAckMode().equalsIgnoreCase("transacted") ? 0 : 1)));
            this.jmsSession = this.getConnection().createSession(this.getClient().isSessTransacted(), ackMode);
        }
        return this.jmsSession;
    }

    public Destination[] createDestinations(int destCount) throws JMSException {
        String destName = this.getClient().getDestName();
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        if (destName.contains(DESTINATION_SEPARATOR)) {
            if (this.getClient().isDestComposite() && destCount == 1) {
                String[] simpleNames = this.mapToSimpleNames(destName.split(DESTINATION_SEPARATOR));
                String joinedSimpleNames = this.join(simpleNames, DESTINATION_SEPARATOR);
                byte destinationType = this.getDestinationType(destName);
                destinations.add(this.createCompositeDestination(destinationType, joinedSimpleNames, 1));
            } else {
                String[] destinationNames;
                LOG.info("User requested multiple destinations, splitting: {}", (Object)destName);
                for (String splitDestName : destinationNames = destName.split(DESTINATION_SEPARATOR)) {
                    this.addDestinations(destinations, splitDestName, destCount);
                }
            }
        } else {
            this.addDestinations(destinations, destName, destCount);
        }
        return destinations.toArray(new Destination[0]);
    }

    private String join(String[] stings, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stings.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(stings[i]);
        }
        return sb.toString();
    }

    private void addDestinations(List<Destination> destinations, String destName, int destCount) throws JMSException {
        boolean destComposite = this.getClient().isDestComposite();
        if (destComposite && destCount > 1) {
            destinations.add(this.createCompositeDestination(destName, destCount));
        } else {
            for (int i = 0; i < destCount; ++i) {
                destinations.add(this.createDestination(this.withDestinationSuffix(destName, i, destCount)));
            }
        }
    }

    private String withDestinationSuffix(String name, int destIndex, int destCount) {
        return destCount == 1 ? name : name + "." + destIndex;
    }

    protected Destination createCompositeDestination(String destName, int destCount) throws JMSException {
        return this.createCompositeDestination(this.getDestinationType(destName), destName, destCount);
    }

    protected Destination createCompositeDestination(byte destinationType, String destName, int destCount) throws JMSException {
        Topic destination;
        String simpleName = this.getSimpleName(destName);
        String compDestName = "";
        for (int i = 0; i < destCount; ++i) {
            if (i > 0) {
                compDestName = compDestName + DESTINATION_SEPARATOR;
            }
            compDestName = compDestName + this.withDestinationSuffix(simpleName, i, destCount);
        }
        LOG.info("Creating composite destination: {}", (Object)compDestName);
        Session session = this.getSession();
        if (destinationType == 2) {
            destination = session.createTopic(compDestName);
        } else if (destinationType == 1) {
            destination = session.createQueue(compDestName);
        } else {
            throw new UnsupportedOperationException("Cannot create composite destinations using temporary queues or topics.");
        }
        assert (destination != null);
        return destination;
    }

    private String[] mapToSimpleNames(String[] destNames) {
        assert (destNames != null);
        String[] simpleNames = new String[destNames.length];
        for (int i = 0; i < destNames.length; ++i) {
            simpleNames[i] = this.getSimpleName(destNames[i]);
        }
        return simpleNames;
    }

    protected String getSimpleName(String destName) {
        String simpleName = destName.startsWith(QUEUE_SCHEME) ? destName.substring(QUEUE_SCHEME.length()) : (destName.startsWith(TOPIC_SCHEME) ? destName.substring(TOPIC_SCHEME.length()) : (destName.startsWith(TEMP_QUEUE_SCHEME) ? destName.substring(TEMP_QUEUE_SCHEME.length()) : (destName.startsWith(TEMP_TOPIC_SCHEME) ? destName.substring(TEMP_TOPIC_SCHEME.length()) : destName)));
        return simpleName;
    }

    protected byte getDestinationType(String destName) {
        assert (destName != null);
        if (destName.startsWith(QUEUE_SCHEME)) {
            return 1;
        }
        if (destName.startsWith(TEMP_QUEUE_SCHEME)) {
            return 5;
        }
        if (destName.startsWith(TEMP_TOPIC_SCHEME)) {
            return 6;
        }
        return 2;
    }

    protected Destination createDestination(String destName) throws JMSException {
        String simpleName = this.getSimpleName(destName);
        byte destinationType = this.getDestinationType(destName);
        if (destinationType == 1) {
            LOG.info("Creating queue: {}", (Object)destName);
            return this.getSession().createQueue(simpleName);
        }
        if (destinationType == 2) {
            LOG.info("Creating topic: {}", (Object)destName);
            return this.getSession().createTopic(simpleName);
        }
        return this.createTemporaryDestination(destName);
    }

    protected Destination createTemporaryDestination(String destName) throws JMSException {
        byte destinationType = this.getDestinationType(destName);
        if (destinationType == 5) {
            LOG.warn("Creating temporary queue. Requested name ({}) ignored.", (Object)destName);
            TemporaryQueue temporaryQueue = this.getSession().createTemporaryQueue();
            LOG.info("Temporary queue created: {}", (Object)temporaryQueue.getQueueName());
            return temporaryQueue;
        }
        if (destinationType == 6) {
            LOG.warn("Creating temporary topic. Requested name ({}) ignored.", (Object)destName);
            TemporaryTopic temporaryTopic = this.getSession().createTemporaryTopic();
            LOG.info("Temporary topic created: {}", (Object)temporaryTopic.getTopicName());
            return temporaryTopic;
        }
        throw new IllegalArgumentException("Unrecognized destination type: " + destinationType);
    }

    public boolean commitTxIfNecessary() throws JMSException {
        ++this.internalTxCounter;
        if (this.getClient().isSessTransacted() && this.internalTxCounter % this.getClient().getCommitAfterXMsgs() == 0) {
            LOG.debug("Committing transaction.");
            this.internalTxCounter = 0;
            this.getSession().commit();
            return true;
        }
        return false;
    }
}

