/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.Properties;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.tool.MemConsumer;
import org.apache.activemq.tool.MemProducer;
import org.apache.activemq.tool.MemoryMonitoringTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMemtest {
    private static final Logger LOG = LoggerFactory.getLogger(JMSMemtest.class);
    private static final int DEFAULT_MESSAGECOUNT = 5000;
    protected BrokerService broker;
    protected boolean topic = true;
    protected boolean durable;
    protected long messageCount;
    protected int connectionCheckpointSize;
    protected long connectionInterval;
    protected int consumerCount;
    protected int producerCount;
    protected int checkpointInterval;
    protected int prefetchSize;
    protected int messageSize;
    protected String reportDirectory;
    protected String reportName;
    protected String url = "";
    protected MemProducer[] producers;
    protected MemConsumer[] consumers;
    protected String destinationName;
    protected boolean allMessagesConsumed = true;
    protected MemConsumer allMessagesList = new MemConsumer();
    protected Message payload;
    protected ActiveMQConnectionFactory connectionFactory;
    protected Connection connection;
    protected Destination destination;
    protected boolean createConnectionPerClient = true;
    protected boolean transacted;
    protected boolean useEmbeddedBroker = true;
    protected MemoryMonitoringTool memoryMonitoringTool;

    public JMSMemtest(Properties settings) {
        this.url = settings.getProperty("url");
        this.topic = Boolean.parseBoolean(settings.getProperty("topic"));
        this.durable = Boolean.parseBoolean(settings.getProperty("durable"));
        this.connectionCheckpointSize = Integer.valueOf(settings.getProperty("connectionCheckpointSize"));
        this.producerCount = Integer.valueOf(settings.getProperty("producerCount"));
        this.consumerCount = Integer.valueOf(settings.getProperty("consumerCount"));
        this.messageCount = Integer.valueOf(settings.getProperty("messageCount")).intValue();
        this.messageSize = Integer.valueOf(settings.getProperty("messageSize"));
        this.prefetchSize = Integer.valueOf(settings.getProperty("prefetchSize"));
        this.checkpointInterval = Integer.valueOf(settings.getProperty("checkpointInterval")) * 1000;
        this.producerCount = Integer.valueOf(settings.getProperty("producerCount"));
        this.reportName = settings.getProperty("reportName");
        this.destinationName = settings.getProperty("destinationName");
        this.reportDirectory = settings.getProperty("reportDirectory");
        this.connectionInterval = (long)this.connectionCheckpointSize * 1024L;
    }

    public static void main(String[] args) {
        Properties sysSettings = new Properties();
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].indexOf("=");
            String key = args[i].substring(0, index);
            String val = args[i].substring(index + 1);
            sysSettings.setProperty(key, val);
        }
        JMSMemtest memtest = new JMSMemtest(sysSettings);
        try {
            memtest.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void start() throws Exception {
        LOG.info("Starting Monitor");
        this.memoryMonitoringTool = new MemoryMonitoringTool();
        this.memoryMonitoringTool.setTestSettings(this.getSysTestSettings());
        Thread monitorThread = this.memoryMonitoringTool.startMonitor();
        if (this.messageCount == 0L) {
            this.messageCount = 5000L;
        }
        if (this.useEmbeddedBroker && this.broker == null) {
            this.broker = this.createBroker();
        }
        this.connectionFactory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        if (this.prefetchSize > 0) {
            this.connectionFactory.getPrefetchPolicy().setTopicPrefetch(this.prefetchSize);
            this.connectionFactory.getPrefetchPolicy().setQueuePrefetch(this.prefetchSize);
        }
        this.connection = this.connectionFactory.createConnection();
        Session session = this.connection.createSession(this.transacted, 1);
        this.destination = this.topic ? session.createTopic(this.destinationName) : session.createQueue(this.destinationName);
        this.createPayload(session);
        this.publishAndConsume();
        LOG.info("Closing resources");
        this.close();
        monitorThread.join();
    }

    protected boolean resetConnection(int counter) {
        long totalMsgSizeConsumed;
        return this.connectionInterval > 0L && this.connectionInterval < (totalMsgSizeConsumed = (long)counter * 1024L);
    }

    protected void publishAndConsume() throws Exception {
        this.createConsumers();
        this.createProducers();
        int counter = 0;
        boolean resetCon = false;
        LOG.info("Start sending messages ");
        int i = 0;
        while ((long)i < this.messageCount) {
            if (resetCon) {
                this.closeConsumers();
                this.closeProducers();
                this.createConsumers();
                this.createProducers();
                resetCon = false;
            }
            for (int k = 0; k < this.producers.length; ++k) {
                this.producers[k].sendMessage(this.payload, "counter", counter);
                if (!this.resetConnection(++counter)) continue;
                resetCon = true;
                break;
            }
            ++i;
        }
    }

    protected void close() throws Exception {
        this.connection.close();
        this.broker.stop();
        this.memoryMonitoringTool.stopMonitor();
    }

    protected void createPayload(Session session) throws JMSException {
        byte[] array = new byte[this.messageSize];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)i;
        }
        BytesMessage bystePayload = session.createBytesMessage();
        bystePayload.writeBytes(array);
        this.payload = bystePayload;
    }

    protected void createProducers() throws JMSException {
        this.producers = new MemProducer[this.producerCount];
        for (int i = 0; i < this.producerCount; ++i) {
            this.producers[i] = new MemProducer((ConnectionFactory)this.connectionFactory, this.destination);
            if (this.durable) {
                this.producers[i].setDeliveryMode(2);
            } else {
                this.producers[i].setDeliveryMode(1);
            }
            this.producers[i].start();
        }
    }

    protected void createConsumers() throws JMSException {
        this.consumers = new MemConsumer[this.consumerCount];
        for (int i = 0; i < this.consumerCount; ++i) {
            this.consumers[i] = new MemConsumer((ConnectionFactory)this.connectionFactory, this.destination);
            this.consumers[i].setParent(this.allMessagesList);
            this.consumers[i].start();
        }
    }

    protected void closeProducers() throws JMSException {
        for (int i = 0; i < this.producerCount; ++i) {
            this.producers[i].shutDown();
        }
    }

    protected void closeConsumers() throws JMSException {
        for (int i = 0; i < this.consumerCount; ++i) {
            this.consumers[i].shutDown();
        }
    }

    protected ConnectionFactory createConnectionFactory() throws JMSException {
        if (this.url == null || this.url.trim().equals("") || this.url.trim().equals("null")) {
            return new ActiveMQConnectionFactory("vm://localhost");
        }
        return new ActiveMQConnectionFactory(this.url);
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        this.configureBroker(broker);
        broker.start();
        return broker;
    }

    protected void configureBroker(BrokerService broker) throws Exception {
        broker.addConnector("vm://localhost");
        broker.setDeleteAllMessagesOnStartup(true);
    }

    protected Properties getSysTestSettings() {
        Properties settings = new Properties();
        settings.setProperty("domain", this.topic ? "topic" : "queue");
        settings.setProperty("durable", this.durable ? "durable" : "non-durable");
        settings.setProperty("connection_checkpoint_size_kb", Integer.valueOf(this.connectionCheckpointSize).toString());
        settings.setProperty("producer_count", Integer.valueOf(this.producerCount).toString());
        settings.setProperty("consumer_count", Integer.valueOf(this.consumerCount).toString());
        settings.setProperty("message_count", Long.valueOf(this.messageCount).toString());
        settings.setProperty("message_size", Integer.valueOf(this.messageSize).toString());
        settings.setProperty("prefetchSize", Integer.valueOf(this.prefetchSize).toString());
        settings.setProperty("checkpoint_interval", Integer.valueOf(this.checkpointInterval).toString());
        settings.setProperty("destination_name", this.destinationName);
        settings.setProperty("report_name", this.reportName);
        settings.setProperty("report_directory", this.reportDirectory);
        settings.setProperty("connection_checkpoint_size", Integer.valueOf(this.connectionCheckpointSize).toString());
        return settings;
    }
}

