/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.io.DataOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.tool.ReportGenerator;

public class MemoryMonitoringTool
implements Runnable {
    protected Properties testSettings = new Properties();
    protected ReportGenerator reportGenerator = new ReportGenerator();
    private long checkpointInterval = 5000L;
    private long resultIndex;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private DataOutputStream dataDoutputStream;
    private MemoryMXBean memoryBean;

    public Properties getTestSettings() {
        return this.testSettings;
    }

    public void setTestSettings(Properties sysTestSettings) {
        this.testSettings = sysTestSettings;
    }

    public DataOutputStream getDataOutputStream() {
        return this.dataDoutputStream;
    }

    public void setDataOutputStream(DataOutputStream dataDoutputStream) {
        this.dataDoutputStream = dataDoutputStream;
    }

    public void stopMonitor() {
        this.isRunning.set(false);
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public Thread startMonitor() {
        String intervalStr = this.getTestSettings().getProperty("checkpoint_interval");
        this.checkpointInterval = Integer.valueOf(intervalStr).intValue();
        this.getTestSettings().remove("checkpoint_interval");
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.reportGenerator.setTestSettings(this.getTestSettings());
        this.addTestInformation();
        Thread t = new Thread(this);
        t.setName("Memory monitoring tool");
        this.isRunning.set(true);
        t.start();
        return t;
    }

    public void addTestInformation() {
        this.reportGenerator.setReportName(this.getTestSettings().getProperty("report_name"));
        this.reportGenerator.setReportDirectory(this.getTestSettings().getProperty("report_directory"));
        this.reportGenerator.startGenerateReport();
        this.reportGenerator.addTestInformation();
        this.reportGenerator.writeWithIndent(4, "<jvm_memory_settings>");
        this.reportGenerator.writeWithIndent(6, "<heap_memory>");
        this.reportGenerator.writeWithIndent(8, "<committed>" + this.memoryBean.getHeapMemoryUsage().getCommitted() + "</committed>");
        this.reportGenerator.writeWithIndent(8, "<max>" + this.memoryBean.getHeapMemoryUsage().getMax() + "</max>");
        this.reportGenerator.writeWithIndent(6, "</heap_memory>");
        this.reportGenerator.writeWithIndent(6, "<non_heap_memory>");
        this.reportGenerator.writeWithIndent(8, "<committed>" + this.memoryBean.getNonHeapMemoryUsage().getCommitted() + "</committed>");
        this.reportGenerator.writeWithIndent(8, "<max>" + this.memoryBean.getNonHeapMemoryUsage().getMax() + "</max>");
        this.reportGenerator.writeWithIndent(6, "</non_heap_memory>");
        this.reportGenerator.writeWithIndent(4, "</jvm_memory_settings>");
        this.reportGenerator.addClientSettings();
        this.reportGenerator.endTestInformation();
    }

    @Override
    public void run() {
        long nonHeapMB = 0L;
        long heapMB = 0L;
        long oneMB = 0x100000L;
        this.reportGenerator.startTestResult(this.getCheckpointInterval());
        while (this.isRunning.get()) {
            try {
                Thread.sleep(this.checkpointInterval);
                nonHeapMB = this.memoryBean.getNonHeapMemoryUsage().getUsed() / oneMB;
                heapMB = this.memoryBean.getHeapMemoryUsage().getUsed() / oneMB;
                this.reportGenerator.writeWithIndent(6, "<memory_usage index='" + this.resultIndex + "' non_heap_mb='" + nonHeapMB + "' non_heap_bytes='" + this.memoryBean.getNonHeapMemoryUsage().getUsed() + "' heap_mb='" + heapMB + "' heap_bytes='" + this.memoryBean.getHeapMemoryUsage().getUsed() + "'/>");
                ++this.resultIndex;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.reportGenerator.endTestResult();
        this.reportGenerator.stopGenerateReport();
    }
}

