/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.maven;

import java.util.Map;
import java.util.Properties;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.maven.MavenBrokerManager;
import org.apache.activemq.maven.MavenBrokerSingletonManager;
import org.apache.activemq.maven.XBeanFileResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class StartBrokerMojo
extends AbstractMojo {
    public static final String DEFAULT_CONNECTOR_PROPERTY_NAME_FORMAT = "org.apache.activemq.connector.%s.uri";
    protected MavenProject project;
    private String configUri;
    private boolean fork;
    private Properties systemProperties;
    private boolean skip;
    private String connectorPropertyNameFormat = "org.apache.activemq.connector.%s.uri";
    private MavenBrokerManager brokerManager;
    private XBeanFileResolver xBeanFileResolver = new XBeanFileResolver();

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getConfigUri() {
        return this.configUri;
    }

    public void setConfigUri(String configUri) {
        this.configUri = configUri;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public String getConnectorPropertyNameFormat() {
        return this.connectorPropertyNameFormat;
    }

    public void setConnectorPropertyNameFormat(String connectorPropertyNameFormat) {
        this.connectorPropertyNameFormat = connectorPropertyNameFormat;
    }

    public MavenBrokerManager getBrokerManager() {
        return this.brokerManager;
    }

    public void setBrokerManager(MavenBrokerManager brokerManager) {
        this.brokerManager = brokerManager;
    }

    public XBeanFileResolver getxBeanFileResolver() {
        return this.xBeanFileResolver;
    }

    public void setxBeanFileResolver(XBeanFileResolver xBeanFileResolver) {
        this.xBeanFileResolver = xBeanFileResolver;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipped execution of ActiveMQ Broker");
            return;
        }
        this.addActiveMQSystemProperties();
        this.getLog().info((CharSequence)("Loading broker configUri: " + this.configUri));
        if (this.xBeanFileResolver.isXBeanFile(this.configUri)) {
            this.getLog().debug((CharSequence)("configUri before transformation: " + this.configUri));
            this.configUri = this.xBeanFileResolver.toUrlCompliantAbsolutePath(this.configUri);
            this.getLog().debug((CharSequence)("configUri after transformation: " + this.configUri));
        }
        this.useBrokerManager().start(this.fork, this.configUri);
        this.registerTransportConnectorUris();
        this.getLog().info((CharSequence)"Started the ActiveMQ Broker");
    }

    protected void addActiveMQSystemProperties() {
        System.setProperty("activemq.base", this.project.getBuild().getDirectory() + "/");
        System.setProperty("activemq.home", this.project.getBuild().getDirectory() + "/");
        System.setProperty("org.apache.activemq.UseDedicatedTaskRunner", "true");
        System.setProperty("org.apache.activemq.default.directory.prefix", this.project.getBuild().getDirectory() + "/");
        System.setProperty("derby.system.home", this.project.getBuild().getDirectory() + "/");
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        System.getProperties().putAll((Map<?, ?>)this.systemProperties);
    }

    protected void registerTransportConnectorUris() {
        Properties props = this.project.getProperties();
        for (TransportConnector oneConnector : this.useBrokerManager().getBroker().getTransportConnectors()) {
            try {
                String propName = String.format(this.connectorPropertyNameFormat, oneConnector.getName());
                String value = oneConnector.getPublishableConnectString();
                this.getLog().debug((CharSequence)("setting transport connector URI property: propertyName=\"" + propName + "\"; value=\"" + value + "\""));
                props.setProperty(propName, value);
            }
            catch (Exception exc) {
                this.getLog().warn((CharSequence)("error on obtaining broker connector uri; connector=" + String.valueOf(oneConnector)), (Throwable)exc);
            }
        }
    }

    protected MavenBrokerManager useBrokerManager() {
        if (this.brokerManager == null) {
            this.brokerManager = new MavenBrokerSingletonManager();
        }
        return this.brokerManager;
    }
}

