/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.junit;

import org.apache.activemq.junit.Repeat;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepeatStatement
extends Statement {
    private static final Logger LOG = LoggerFactory.getLogger(RepeatStatement.class);
    private final int repetitions;
    private final boolean untilFailure;
    private final Statement statement;

    public static Builder builder() {
        return new Builder();
    }

    public RepeatStatement(int times, boolean untilFailure, Statement statement) {
        this.repetitions = times;
        this.untilFailure = untilFailure;
        this.statement = statement;
    }

    protected RepeatStatement(Builder builder, Statement next) {
        this.repetitions = builder.getRepetitions();
        this.untilFailure = builder.isUntilFailure();
        this.statement = next;
    }

    public void evaluate() throws Throwable {
        for (int i = 0; i < this.repetitions && !this.untilFailure; ++i) {
            if (this.untilFailure) {
                LOG.info("Running test iteration: {}.", (Object)(i + 1));
            } else {
                LOG.info("Running test iteration: {} of configured repetitions: {}", (Object)(i + 1), (Object)this.repetitions);
            }
            this.statement.evaluate();
        }
    }

    public static class Builder {
        private int repetitions = 1;
        private boolean untilFailure = false;

        protected Builder() {
        }

        public Builder withRepetitions(int repetitions) {
            if (repetitions <= 0) {
                throw new IllegalArgumentException("repetitions must be greater than zero");
            }
            this.repetitions = repetitions;
            return this;
        }

        public Builder withRunUntilFailure(boolean untilFailure) {
            this.untilFailure = untilFailure;
            return this;
        }

        protected int getRepetitions() {
            return this.repetitions;
        }

        protected boolean isUntilFailure() {
            return this.untilFailure;
        }

        public RepeatStatement build(Statement next) {
            if (next == null) {
                throw new NullPointerException("statement cannot be null");
            }
            return new RepeatStatement(this, next);
        }

        public RepeatStatement build(Repeat annotation, Statement next) {
            if (next == null) {
                throw new NullPointerException("statement cannot be null");
            }
            if (annotation == null) {
                throw new NullPointerException("annotation cannot be null");
            }
            this.withRepetitions(annotation.repetitions());
            this.withRunUntilFailure(annotation.untilFailure());
            return new RepeatStatement(this, next);
        }
    }
}

