/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.artemiswrapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManagerImpl;
import org.apache.activemq.artemiswrapper.ArtemisBrokerHelper;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.artemiswrapper.ArtemisBrokerBase;
import org.apache.activemq.broker.artemiswrapper.InVMNamingContext;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;

public class ArtemisBrokerWrapper
extends ArtemisBrokerBase {
    protected final Map<String, SimpleString> testQueues = new HashMap<String, SimpleString>();
    protected JMSServerManagerImpl jmsServer;

    public ArtemisBrokerWrapper(BrokerService brokerService) {
        this.bservice = brokerService;
    }

    public void start() throws Exception {
        String match;
        AddressSettings commonSettings;
        this.testDir = this.temporaryFolder.getRoot().getAbsolutePath();
        this.clearDataRecreateServerDirs();
        this.server = this.createServer(this.realStore, true);
        this.server.getConfiguration().getAcceptorConfigurations().clear();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("port", "61616");
        params.put("protocols", "OPENWIRE,CORE");
        TransportConfiguration transportConfiguration = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
        Configuration serverConfig = this.server.getConfiguration();
        Map addressSettingsMap = serverConfig.getAddressesSettings();
        PolicyMap policyMap = this.bservice.getDestinationPolicy();
        if (policyMap != null) {
            this.translatePolicyMap(serverConfig, policyMap);
        }
        if ((commonSettings = (AddressSettings)addressSettingsMap.get(match = "jms.queue.#")) == null) {
            commonSettings = new AddressSettings();
            addressSettingsMap.put(match, commonSettings);
        }
        SimpleString dla = new SimpleString("jms.queue.ActiveMQ.DLQ");
        commonSettings.setDeadLetterAddress(dla);
        commonSettings.setAutoCreateJmsQueues(true);
        serverConfig.getAcceptorConfigurations().add(transportConfiguration);
        if (this.bservice.enableSsl()) {
            params = new HashMap();
            params.put("sslEnabled", true);
            params.put("port", 61611);
            params.put("protocols", "OPENWIRE");
            params.put("keyStorePath", this.bservice.SERVER_SIDE_KEYSTORE);
            params.put("keyStorePassword", this.bservice.KEYSTORE_PASSWORD);
            params.put("keyStoreProvider", this.bservice.storeType);
            if (this.bservice.SERVER_SIDE_TRUSTSTORE != null) {
                params.put("needClientAuth", true);
                params.put("trustStorePath", this.bservice.SERVER_SIDE_TRUSTSTORE);
                params.put("trustStorePassword", this.bservice.TRUSTSTORE_PASSWORD);
                params.put("trustStoreProvider", this.bservice.storeType);
            }
            TransportConfiguration sslTransportConfig = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
            serverConfig.getAcceptorConfigurations().add(sslTransportConfig);
        }
        for (Integer port : this.bservice.extraConnectors) {
            if (port == 61616) continue;
            params = new HashMap();
            params.put("port", port);
            params.put("protocols", "OPENWIRE");
            TransportConfiguration extraTransportConfiguration = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
            serverConfig.getAcceptorConfigurations().add(extraTransportConfiguration);
        }
        serverConfig.setSecurityEnabled(this.enableSecurity);
        if (this.enableSecurity) {
            HashSet<Role> anySet;
            ActiveMQSecurityManagerImpl sm = (ActiveMQSecurityManagerImpl)this.server.getSecurityManager();
            SecurityConfiguration securityConfig = sm.getConfiguration();
            securityConfig.addRole("openwireSender", "sender");
            securityConfig.addUser("openwireSender", "SeNdEr");
            Role senderRole = new Role("sender", true, false, false, false, true, true, false);
            securityConfig.addRole("openwireReceiver", "receiver");
            securityConfig.addUser("openwireReceiver", "ReCeIvEr");
            Role receiverRole = new Role("receiver", false, true, false, false, true, true, false);
            securityConfig.addRole("openwireGuest", "guest");
            securityConfig.addUser("openwireGuest", "GuEsT");
            Role guestRole = new Role("guest", false, false, false, false, false, false, false);
            securityConfig.addRole("openwireDestinationManager", "manager");
            securityConfig.addUser("openwireDestinationManager", "DeStInAtIoN");
            Role destRole = new Role("manager", false, false, false, false, true, true, false);
            HashMap<String, HashSet<Role>> settings = this.server.getConfiguration().getSecurityRoles();
            if (settings == null) {
                settings = new HashMap<String, HashSet<Role>>();
                this.server.getConfiguration().setSecurityRoles(settings);
            }
            if ((anySet = (HashSet<Role>)settings.get("#")) == null) {
                anySet = new HashSet<Role>();
                settings.put("#", anySet);
            }
            anySet.add(senderRole);
            anySet.add(receiverRole);
            anySet.add(guestRole);
            anySet.add(destRole);
        }
        Set acceptors = serverConfig.getAcceptorConfigurations();
        Iterator iter = acceptors.iterator();
        while (iter.hasNext()) {
            System.out.println("acceptor =>: " + iter.next());
        }
        this.jmsServer = new JMSServerManagerImpl(this.server);
        InVMNamingContext namingContext = new InVMNamingContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)namingContext));
        this.jmsServer.start();
        this.server.start();
        ArtemisBrokerHelper.setBroker(this.bservice);
        this.stopped = false;
    }

    private void translatePolicyMap(Configuration serverConfig, PolicyMap policyMap) {
        List allEntries = policyMap.getAllEntries();
        Map settingsMap = serverConfig.getAddressesSettings();
        for (Object o : allEntries) {
            PolicyEntry entry = (PolicyEntry)o;
            ActiveMQDestination targetDest = entry.getDestination();
            String match = this.getCorePattern(targetDest);
            AddressSettings settings = (AddressSettings)settingsMap.get(match);
            if (settings == null) {
                settings = new AddressSettings();
                settingsMap.put(match, settings);
            }
            if (entry.isAdvisoryForSlowConsumers()) {
                settings.setSlowConsumerThreshold(1000L);
                settings.setSlowConsumerCheckPeriod(1L);
                settings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
            }
            if (!entry.isProducerFlowControl()) continue;
            settings.setMaxSizeBytes(10240000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
            if (!this.bservice.getSystemUsage().isSendFailIfNoSpace()) continue;
            settings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        }
        PolicyEntry defaultEntry = policyMap.getDefaultEntry();
        if (defaultEntry != null) {
            AddressSettings defSettings = (AddressSettings)settingsMap.get("#");
            if (defSettings == null) {
                defSettings = new AddressSettings();
                settingsMap.put("#", defSettings);
            }
            if (defaultEntry.isProducerFlowControl()) {
                defSettings.setMaxSizeBytes(10240000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
                if (this.bservice.getSystemUsage().isSendFailIfNoSpace()) {
                    defSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
                }
            }
        }
    }

    private String getCorePattern(ActiveMQDestination dest) {
        String physicalName = dest.getPhysicalName();
        String pattern = physicalName.replace(">", "#");
        pattern = dest.isTopic() ? "jms.topic." + pattern : "jms.queue." + pattern;
        return pattern;
    }

    public void stop() throws Exception {
        try {
            this.server.stop();
            this.testQueues.clear();
            this.stopped = true;
        }
        catch (Throwable throwable) {
        }
        finally {
            this.server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSureQueueExists(String qname) throws Exception {
        Map<String, SimpleString> map = this.testQueues;
        synchronized (map) {
            SimpleString coreQ = this.testQueues.get(qname);
            if (coreQ == null) {
                coreQ = new SimpleString("jms.queue." + qname);
                try {
                    this.server.createQueue(coreQ, coreQ, null, false, false);
                    this.testQueues.put(qname, coreQ);
                }
                catch (ActiveMQQueueExistsException e) {
                    // empty catch block
                }
            }
        }
    }
}

