/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.net.URI;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServerComponent
implements ExternalComponent {
    private Server server;
    private HandlerList handlers;
    private WebServerDTO webServerConfig;

    public void configure(ComponentDTO config, String artemisInstance, String artemisHome) throws Exception {
        this.webServerConfig = (WebServerDTO)config;
        String path = this.webServerConfig.path.startsWith("/") ? this.webServerConfig.path : "/" + this.webServerConfig.path;
        URI uri = new URI(this.webServerConfig.bind);
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(uri.getPort());
        connector.setHost(uri.getHost());
        this.server.setConnectors(new Connector[]{connector});
        this.handlers = new HandlerList();
        if (this.webServerConfig.apps != null) {
            for (AppDTO app : this.webServerConfig.apps) {
                this.deployWar(app.url, app.war, artemisHome, path);
            }
        }
        WebAppContext handler = new WebAppContext();
        handler.setContextPath("/");
        handler.setResourceBase(artemisHome + path);
        handler.setLogUrlOnStart(true);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(artemisHome + path);
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        this.handlers.addHandler((Handler)resourceHandler);
        this.handlers.addHandler((Handler)defaultHandler);
        this.server.setHandler((Handler)this.handlers);
    }

    public void start() throws Exception {
        this.server.start();
        System.out.println("HTTP Server started at " + this.webServerConfig.bind);
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    private void deployWar(String url, String warURL, String activeMQHome, String path) {
        WebAppContext webapp = new WebAppContext();
        if (url.startsWith("/")) {
            webapp.setContextPath(url);
        } else {
            webapp.setContextPath("/" + url);
        }
        webapp.setWar(activeMQHome + path + "/" + warURL);
        this.handlers.addHandler((Handler)webapp);
    }
}

