/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLeakCheckDelegate {
    private static Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Set<String> knownThreads = new HashSet<String>();
    protected boolean enabled = true;
    protected Map<Thread, StackTraceElement[]> previousThreads;
    private static int failedGCCalls = 0;

    public void beforeTest() {
        this.previousThreads = Thread.getAllStackTraces();
    }

    public void disable() {
        this.enabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTest(Throwable failure, String nameOfTest, Consumer<String> failureCallback) {
        boolean testFailed = failure != null;
        logger.debug("checking thread enabled? {}, testFailed? {}", (Object)this.enabled, (Object)testFailed);
        try {
            if (this.enabled) {
                String failedThread = null;
                boolean failedOnce = false;
                int checks = 0;
                int timeout = testFailed ? 0 : 60000;
                long deadline = System.currentTimeMillis() + (long)timeout;
                do {
                    if ((failedThread = this.checkThread()) == null) continue;
                    ++checks;
                    if (timeout > 0 && !failedOnce) {
                        logger.warn("There are unexpected threads remaining. ThreadLeakCheckExtension will retry for {} milliseconds", (Object)timeout);
                    }
                    failedOnce = true;
                    ThreadLeakCheckDelegate.forceGC();
                    if (timeout <= 0) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                } while (failedThread != null && deadline > System.currentTimeMillis());
                if (failedThread != null) {
                    logger.warn("There are leaked threads: \n{}", (Object)failedThread);
                    if (!testFailed) {
                        failureCallback.accept("Thread leaked (see log)");
                    } else {
                        logger.warn("The test failed and there is a thread leak (see log)", failure);
                        failure.printStackTrace();
                        failureCallback.accept("Test " + nameOfTest + " failed and there is a thread leak (see log) - " + failure.getMessage());
                    }
                } else if (failedOnce) {
                    logger.info("Threads were cleared after {} checks", (Object)checks);
                }
            } else {
                this.enabled = true;
            }
        }
        finally {
            this.previousThreads = null;
        }
    }

    public static void forceGC() {
        if (failedGCCalls >= 10) {
            logger.info("ignoring forceGC call since it seems System.gc is not working anyways");
            return;
        }
        logger.info("#test forceGC");
        CountDownLatch finalized = new CountDownLatch(1);
        WeakReference<DumbReference> dumbReference = new WeakReference<DumbReference>(new DumbReference(finalized));
        long timeout = System.currentTimeMillis() + 1000L;
        while ((dumbReference.get() != null || finalized.getCount() != 0L) && System.currentTimeMillis() < timeout) {
            System.gc();
            System.runFinalization();
            try {
                finalized.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (dumbReference.get() != null) {
            ++failedGCCalls;
            logger.info("It seems that GC is disabled at your VM");
        } else {
            failedGCCalls = 0;
        }
        logger.info("#test forceGC Done ");
    }

    public static void forceGC(Reference<?> ref, long timeout) {
        long waitUntil = System.currentTimeMillis() + timeout;
        while (ref.get() != null && System.currentTimeMillis() < waitUntil) {
            ArrayList<CallSite> list = new ArrayList<CallSite>();
            for (int i = 0; i < 1000; ++i) {
                list.add((CallSite)((Object)("Some string with garbage with concatenation " + i)));
            }
            list.clear();
            list = null;
            System.gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void removeKownThread(String name) {
        knownThreads.remove(name);
    }

    public static void addKownThread(String name) {
        knownThreads.add(name);
    }

    private String checkThread() {
        boolean failedThread = false;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        Map<Thread, StackTraceElement[]> postThreads = Thread.getAllStackTraces();
        if (postThreads != null && this.previousThreads != null && postThreads.size() > this.previousThreads.size()) {
            for (Thread aliveThread : postThreads.keySet()) {
                StackTraceElement[] elements;
                if (!aliveThread.isAlive() || this.isExpectedThread(aliveThread) || this.previousThreads.containsKey(aliveThread)) continue;
                if (!failedThread) {
                    writer.println("*********************************************************************************");
                    writer.println("LEAKING THREADS");
                }
                failedThread = true;
                writer.println("=============================================================================");
                writer.println("Thread " + String.valueOf(aliveThread) + " is still alive with the following stackTrace:");
                for (StackTraceElement el : elements = postThreads.get(aliveThread)) {
                    writer.println(el);
                }
                writer.println("*********************************************************************************");
                writer.println("ThreadGroup: " + String.valueOf(aliveThread.getThreadGroup()));
                aliveThread.interrupt();
            }
            if (failedThread) {
                writer.println("*********************************************************************************");
                return stringWriter.toString();
            }
        }
        return null;
    }

    private boolean isExpectedThread(Thread thread) {
        String threadName = thread.getName();
        ThreadGroup group = thread.getThreadGroup();
        boolean isSystemThread = group != null && ("system".equals(group.getName()) || "InnocuousThreadGroup".equals(group.getName()));
        String javaVendor = System.getProperty("java.vendor");
        if (threadName.contains("SunPKCS11")) {
            return true;
        }
        if (threadName.contains("Keep-Alive-Timer")) {
            return true;
        }
        if (threadName.contains("Attach Listener")) {
            return true;
        }
        if ((javaVendor.contains("IBM") || isSystemThread) && threadName.startsWith("process reaper")) {
            return true;
        }
        if ((javaVendor.contains("IBM") || isSystemThread) && threadName.equals("ClassCache Reaper")) {
            return true;
        }
        if (javaVendor.contains("IBM") && threadName.equals("MemoryPoolMXBean notification dispatcher")) {
            return true;
        }
        if (threadName.contains("MemoryMXBean")) {
            return true;
        }
        if (threadName.contains("globalEventExecutor")) {
            return true;
        }
        if (threadName.contains("activemq-remoting") || threadName.contains("activemq-client-remoting")) {
            return true;
        }
        if (threadName.contains("threadDeathWatcher")) {
            return true;
        }
        if (threadName.contains("Abandoned connection cleanup thread")) {
            return true;
        }
        if (threadName.contains("hawtdispatch") || group != null && group.getName().contains("hawtdispatch")) {
            return true;
        }
        if (threadName.contains("ObjectCleanerThread")) {
            return true;
        }
        if (threadName.contains("RMI TCP")) {
            return true;
        }
        if (threadName.contains("RMI Scheduler")) {
            return true;
        }
        if (threadName.contains("RMI RenewClean")) {
            return true;
        }
        if (threadName.contains("Signal Dispatcher")) {
            return true;
        }
        if (threadName.contains("ForkJoinPool.commonPool")) {
            return true;
        }
        if (threadName.contains("GC Daemon")) {
            return true;
        }
        if (threadName.contains("junit-jupiter-timeout-watcher")) {
            return true;
        }
        for (StackTraceElement element : thread.getStackTrace()) {
            if (!element.getClassName().contains("org.jboss.byteman.agent.TransformListener") && !element.getClassName().contains("jdk.internal.ref.CleanerImpl")) continue;
            return true;
        }
        for (String known : knownThreads) {
            if (!threadName.contains(known)) continue;
            return true;
        }
        return false;
    }

    protected static class DumbReference {
        private CountDownLatch finalized;

        public DumbReference(CountDownLatch finalized) {
            this.finalized = finalized;
        }

        public void finalize() throws Throwable {
            this.finalized.countDown();
            super.finalize();
        }
    }
}

