/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMethodNameMatchExtension
implements BeforeEachCallback,
Extension {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<String> methodNames;
    private boolean matches = false;

    public TestMethodNameMatchExtension(String ... methodNames) {
        this.methodNames = List.of(methodNames);
        if (this.methodNames.isEmpty()) {
            throw new IllegalArgumentException("At least one method name to match against must be specified");
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        String testName = context.getRequiredTestMethod().getName();
        this.matches = this.methodNames.contains(testName);
        logger.trace("Match for test method {}: {}", (Object)context.getRequiredTestMethod().getName(), (Object)this.matches);
    }

    public boolean matches() {
        return this.matches;
    }
}

