/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.io.File;
import java.lang.invoke.MethodHandles;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesLeftBehindCheckExtension
implements Extension,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String[] filesToCheck;

    public FilesLeftBehindCheckExtension(String ... filesToCheck) {
        this.filesToCheck = filesToCheck;
    }

    private File checkFiles() {
        for (String f : this.filesToCheck) {
            File fileCheck = new File(f);
            if (!fileCheck.exists()) continue;
            return fileCheck;
        }
        return null;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        File leaked = this.checkFiles();
        if (leaked != null) {
            Assertions.fail((String)("A previous test (unknown) left a file/directory around: " + leaked.getAbsolutePath()));
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        String testName = context.getRequiredTestClass().getName();
        logger.debug("Checking files left behind after {}", (Object)testName);
        File leaked = this.checkFiles();
        if (leaked != null) {
            Assertions.fail((String)("A file/directory is being left behind by " + testName + ": " + leaked.getAbsolutePath()));
        }
    }
}

