/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.extension.AnnotatedElementContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.io.TempDirFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetTempDirFactory
implements TempDirFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String TARGET_TMP = "./target/tmp";

    public Path createTempDirectory(AnnotatedElementContext elementContext, ExtensionContext extensionContext) throws IOException {
        String testClassName = extensionContext.getRequiredTestClass().getSimpleName();
        Path parentDir = Paths.get(TARGET_TMP, testClassName);
        parentDir.toFile().mkdirs();
        Path createdTempDirectory = Files.createTempDirectory(parentDir, "junit", new FileAttribute[0]);
        logger.trace("TargetTempDirFactory created temporary directory: {}", (Object)createdTempDirectory);
        return createdTempDirectory;
    }
}

