/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.channels.ClosedChannelException;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SharedStoreLiveActivation
extends LiveActivation {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SharedStoreMasterPolicy sharedStoreMasterPolicy;
    private final ActiveMQServerImpl activeMQServer;
    private volatile NodeManager.LockListener activeLockListener;
    private volatile ActivateCallback nodeManagerActivateCallback;
    private final IOCriticalErrorListener ioCriticalErrorListener;

    public SharedStoreLiveActivation(ActiveMQServerImpl server, SharedStoreMasterPolicy sharedStoreMasterPolicy, IOCriticalErrorListener ioCriticalErrorListener) {
        this.activeMQServer = server;
        this.sharedStoreMasterPolicy = sharedStoreMasterPolicy;
        this.ioCriticalErrorListener = ioCriticalErrorListener;
    }

    @Override
    public void run() {
        try {
            ActiveMQServerLogger.LOGGER.awaitingLiveLock();
            this.activeMQServer.checkJournalDirectory();
            logger.debug("First part initialization on {}", (Object)this);
            if (!this.activeMQServer.initialisePart1(false)) {
                return;
            }
            if (this.activeMQServer.getNodeManager().isBackupLive()) {
                logger.debug("announcing backup to the former live {}", (Object)this);
                this.activeMQServer.getBackupManager().start();
                if (!this.sharedStoreMasterPolicy.isWaitForActivation()) {
                    this.activeMQServer.setState(ActiveMQServer.SERVER_STATE.STARTED);
                }
                this.activeMQServer.getBackupManager().announceBackup();
            }
            this.registerActiveLockListener(this.activeMQServer.getNodeManager());
            this.nodeManagerActivateCallback = this.activeMQServer.getNodeManager().startLiveNode();
            this.activeMQServer.registerActivateCallback(this.nodeManagerActivateCallback);
            if (this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPED || this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPING) {
                return;
            }
            this.activeMQServer.initialisePart2(false);
            this.activeMQServer.completeActivation(false);
            ActiveMQServerLogger.LOGGER.serverIsLive();
        }
        catch (NodeManager.NodeManagerException nodeManagerException) {
            if (nodeManagerException.getCause() instanceof ClosedChannelException) {
                return;
            }
            if (nodeManagerException.getCause() instanceof ActiveMQLockAcquisitionTimeoutException) {
                this.onActivationFailure((Exception)((Object)((ActiveMQLockAcquisitionTimeoutException)((Object)nodeManagerException.getCause()))));
                return;
            }
            this.unregisterActiveLockListener(this.activeMQServer.getNodeManager());
            this.ioCriticalErrorListener.onIOException((Throwable)nodeManagerException, nodeManagerException.getMessage(), null);
        }
        catch (Exception e) {
            this.onActivationFailure(e);
        }
    }

    private void onActivationFailure(Exception e) {
        this.unregisterActiveLockListener(this.activeMQServer.getNodeManager());
        ActiveMQServerLogger.LOGGER.initializationError(e);
        this.activeMQServer.callActivationFailureListeners(e);
    }

    private void registerActiveLockListener(NodeManager nodeManager) {
        NodeManager.LockListener lockListener;
        this.activeLockListener = lockListener = () -> this.ioCriticalErrorListener.onIOException((Throwable)new IOException("lost lock"), "Lost NodeManager lock", null);
        nodeManager.registerLockListener(lockListener);
    }

    private void unregisterActiveLockListener(NodeManager nodeManager) {
        NodeManager.LockListener activeLockListener = this.activeLockListener;
        if (activeLockListener != null) {
            nodeManager.unregisterLockListener(activeLockListener);
            this.activeLockListener = null;
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (nodeManagerInUse != null) {
            this.unregisterActiveLockListener(nodeManagerInUse);
            ActivateCallback activateCallback = this.nodeManagerActivateCallback;
            if (activateCallback != null) {
                this.activeMQServer.unregisterActivateCallback(activateCallback);
            }
            if (this.sharedStoreMasterPolicy.isFailoverOnServerShutdown() || permanently) {
                try {
                    nodeManagerInUse.crashLiveServer();
                }
                catch (Throwable t) {
                    if (!permanently) {
                        throw t;
                    }
                    logger.warn("Errored while closing activation: can be ignored because of permanent close", t);
                }
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }
}

