/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.protocol.ProtocolHandler;
import org.apache.activemq.artemis.core.remoting.impl.AbstractAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQChannelHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.CheckDependencies;
import org.apache.activemq.artemis.core.remoting.impl.netty.ConnectionCreator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettySNIHostnameHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ServerConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ssl.OpenSSLContextFactory;
import org.apache.activemq.artemis.spi.core.remoting.ssl.OpenSSLContextFactoryProvider;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactoryProvider;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAcceptor
extends AbstractAcceptor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String INVM_ACCEPTOR_TYPE = "IN-VM";
    public static final String NIO_ACCEPTOR_TYPE = "NIO";
    public static final String EPOLL_ACCEPTOR_TYPE = "EPOLL";
    public static final String KQUEUE_ACCEPTOR_TYPE = "KQUEUE";
    private final String protocolsString;
    private final String name;
    private final ClusterConnection clusterConnection;
    private Class<? extends ServerChannel> channelClazz;
    private EventLoopGroup eventLoopGroup;
    private volatile ChannelGroup serverChannelGroup;
    private volatile ChannelGroup channelGroup;
    private ServerBootstrap bootstrap;
    private final BufferHandler handler;
    private final ServerConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean useInvm;
    private final boolean useEpoll;
    private final boolean useKQueue;
    private final ProtocolHandler protocolHandler;
    private final String host;
    private final int port;
    private final String keyStoreProvider;
    private final String keyStoreType;
    private String keyStorePath;
    private final String keyStorePassword;
    private final String keystoreAlias;
    private final String trustStoreProvider;
    private final String trustStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String crlPath;
    private SSLContextConfig sslContextConfig;
    private final String enabledCipherSuites;
    private final String enabledProtocols;
    private final boolean needClientAuth;
    private final boolean wantClientAuth;
    private final String sslProvider;
    private final boolean verifyHost;
    private final String trustManagerFactoryPlugin;
    private String sniHost;
    private final boolean tcpNoDelay;
    private final int backlog;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final int writeBufferLowWaterMark;
    private final int writeBufferHighWaterMark;
    private int remotingThreads;
    private final ConcurrentMap<Object, NettyServerConnection> connections = new ConcurrentHashMap<Object, NettyServerConnection>();
    private final Map<String, Object> configuration;
    private final ScheduledExecutorService scheduledThreadPool;
    private NotificationService notificationService;
    private int quietPeriod;
    private int shutdownTimeout;
    private boolean paused;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private final long batchDelay;
    private final boolean directDeliver;
    private final boolean httpUpgradeEnabled;
    private final long connectionsAllowed;
    private final boolean autoStart;
    private final String router;
    final AtomicBoolean warningPrinted = new AtomicBoolean(false);
    final Executor failureExecutor;
    private volatile Object providerAgnosticSslContext;
    private volatile int actualPort = 0;

    public NettyAcceptor(String name, ClusterConnection clusterConnection, Map<String, Object> configuration, BufferHandler handler, ServerConnectionLifeCycleListener listener, ScheduledExecutorService scheduledThreadPool, Executor failureExecutor, Map<String, ProtocolManager> protocolMap) {
        super(protocolMap);
        this.failureExecutor = failureExecutor;
        this.name = name;
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
        this.handler = handler;
        this.listener = listener;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty((String)"sslEnabled", (boolean)false, configuration);
        this.remotingThreads = ConfigurationHelper.getIntProperty((String)"nioRemotingThreads", (int)-1, configuration);
        this.remotingThreads = ConfigurationHelper.getIntProperty((String)"remotingThreads", (int)this.remotingThreads, configuration);
        this.useEpoll = ConfigurationHelper.getBooleanProperty((String)"useEpoll", (boolean)true, configuration);
        this.useKQueue = ConfigurationHelper.getBooleanProperty((String)"useKQueue", (boolean)true, configuration);
        this.backlog = ConfigurationHelper.getIntProperty((String)"backlog", (int)-1, configuration);
        this.useInvm = ConfigurationHelper.getBooleanProperty((String)"useInvm", (boolean)false, configuration);
        this.protocolHandler = new ProtocolHandler(protocolMap, this, scheduledThreadPool);
        this.protocolsString = NettyAcceptor.getProtocols(protocolMap);
        this.quietPeriod = ConfigurationHelper.getIntProperty((String)"quietPeriod", (int)TransportConstants.DEFAULT_QUIET_PERIOD, configuration);
        this.shutdownTimeout = ConfigurationHelper.getIntProperty((String)"shutdownTimeout", (int)TransportConstants.DEFAULT_SHUTDOWN_TIMEOUT, configuration);
        this.host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, configuration);
        if (this.sslEnabled) {
            Pair keyStoreCompat = SSLSupport.getValidProviderAndType((String)ConfigurationHelper.getStringProperty((String)"keyStoreProvider", (String)TransportConstants.DEFAULT_KEYSTORE_PROVIDER, configuration), (String)ConfigurationHelper.getStringProperty((String)"keyStoreType", (String)"JKS", configuration));
            this.keyStoreProvider = (String)keyStoreCompat.getA();
            this.keyStoreType = (String)keyStoreCompat.getB();
            this.keyStorePath = ConfigurationHelper.getStringProperty((String)"keyStorePath", (String)TransportConstants.DEFAULT_KEYSTORE_PATH, configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty((String)"keyStorePassword", (String)TransportConstants.DEFAULT_KEYSTORE_PASSWORD, configuration, (String)ActiveMQDefaultConfiguration.getPropMaskPassword(), (String)ActiveMQDefaultConfiguration.getPropPasswordCodec());
            Pair trustStoreCompat = SSLSupport.getValidProviderAndType((String)ConfigurationHelper.getStringProperty((String)"trustStoreProvider", (String)TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER, configuration), (String)ConfigurationHelper.getStringProperty((String)"trustStoreType", (String)"JKS", configuration));
            this.trustStoreProvider = (String)trustStoreCompat.getA();
            this.trustStoreType = (String)trustStoreCompat.getB();
            this.trustStorePath = ConfigurationHelper.getStringProperty((String)"trustStorePath", (String)TransportConstants.DEFAULT_TRUSTSTORE_PATH, configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty((String)"trustStorePassword", (String)TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD, configuration, (String)ActiveMQDefaultConfiguration.getPropMaskPassword(), (String)ActiveMQDefaultConfiguration.getPropPasswordCodec());
            this.crlPath = ConfigurationHelper.getStringProperty((String)"crlPath", (String)TransportConstants.DEFAULT_CRL_PATH, configuration);
            this.enabledCipherSuites = ConfigurationHelper.getStringProperty((String)"enabledCipherSuites", (String)TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES, configuration);
            this.enabledProtocols = ConfigurationHelper.getStringProperty((String)"enabledProtocols", (String)TransportConstants.DEFAULT_ENABLED_PROTOCOLS, configuration);
            this.needClientAuth = ConfigurationHelper.getBooleanProperty((String)"needClientAuth", (boolean)false, configuration);
            this.wantClientAuth = ConfigurationHelper.getBooleanProperty((String)"wantClientAuth", (boolean)false, configuration);
            this.verifyHost = ConfigurationHelper.getBooleanProperty((String)"verifyHost", (boolean)false, configuration);
            this.sslProvider = ConfigurationHelper.getStringProperty((String)"sslProvider", (String)"JDK", configuration);
            this.sniHost = ConfigurationHelper.getStringProperty((String)"sniHost", (String)TransportConstants.DEFAULT_SNIHOST_CONFIG, configuration);
            this.trustManagerFactoryPlugin = ConfigurationHelper.getStringProperty((String)"trustManagerFactoryPlugin", (String)TransportConstants.DEFAULT_TRUST_MANAGER_FACTORY_PLUGIN, configuration);
            this.keystoreAlias = ConfigurationHelper.getStringProperty((String)"keyStoreAlias", (String)TransportConstants.DEFAULT_KEYSTORE_ALIAS, configuration);
            this.sslContextConfig = SSLContextConfig.builder().keystoreProvider(this.keyStoreProvider).keystorePath(this.keyStorePath).keystoreType(this.keyStoreType).keystorePassword(this.keyStorePassword).keystoreAlias(this.keystoreAlias).truststoreProvider(this.trustStoreProvider).truststorePath(this.trustStorePath).truststoreType(this.trustStoreType).truststorePassword(this.trustStorePassword).trustManagerFactoryPlugin(this.trustManagerFactoryPlugin).crlPath(this.crlPath).build();
            this.providerAgnosticSslContext = this.loadSSLContext();
        } else {
            this.keyStoreProvider = TransportConstants.DEFAULT_KEYSTORE_PROVIDER;
            this.keyStoreType = "JKS";
            this.keyStorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
            this.keyStorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
            this.keystoreAlias = TransportConstants.DEFAULT_KEYSTORE_ALIAS;
            this.trustStoreProvider = TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER;
            this.trustStoreType = "JKS";
            this.trustStorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
            this.trustStorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
            this.crlPath = TransportConstants.DEFAULT_CRL_PATH;
            this.enabledCipherSuites = TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES;
            this.enabledProtocols = TransportConstants.DEFAULT_ENABLED_PROTOCOLS;
            this.needClientAuth = false;
            this.wantClientAuth = false;
            this.verifyHost = false;
            this.sslProvider = "JDK";
            this.sniHost = TransportConstants.DEFAULT_SNIHOST_CONFIG;
            this.trustManagerFactoryPlugin = TransportConstants.DEFAULT_TRUST_MANAGER_FACTORY_PLUGIN;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty((String)"tcpNoDelay", (boolean)true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty((String)"tcpSendBufferSize", (int)0x100000, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty((String)"tcpReceiveBufferSize", (int)0x100000, configuration);
        this.writeBufferLowWaterMark = ConfigurationHelper.getIntProperty((String)"writeBufferLowWaterMark", (int)32768, configuration);
        this.writeBufferHighWaterMark = ConfigurationHelper.getIntProperty((String)"writeBufferHighWaterMark", (int)131072, configuration);
        this.scheduledThreadPool = scheduledThreadPool;
        this.batchDelay = ConfigurationHelper.getLongProperty((String)"batchDelay", (long)0L, configuration);
        this.directDeliver = ConfigurationHelper.getBooleanProperty((String)"directDeliver", (boolean)true, configuration);
        this.httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty((String)"httpUpgradeEnabled", (boolean)false, configuration);
        this.connectionsAllowed = ConfigurationHelper.getLongProperty((String)"connectionsAllowed", (long)-1L, configuration);
        this.autoStart = ConfigurationHelper.getBooleanProperty((String)"autoStart", (boolean)true, configuration);
        this.router = ConfigurationHelper.getStringProperty((String)"router", (String)TransportConstants.DEFAULT_ROUTER, configuration);
    }

    private Object loadSSLContext() {
        this.checkSSLConfiguration();
        try {
            if ("OPENSSL".equals(this.sslProvider)) {
                OpenSSLContextFactory factory = OpenSSLContextFactoryProvider.getOpenSSLContextFactory();
                if (factory != null) {
                    return factory.getServerSslContext(this.sslContextConfig, this.configuration);
                }
                throw new IllegalStateException("No OpenSSLContextFactory registered!");
            }
            return SSLContextFactoryProvider.getSSLContextFactory().getSSLContext(this.sslContextConfig, this.configuration);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to create NettyAcceptor for " + this.host + ":" + this.port, e);
            throw ise;
        }
    }

    public int getTcpReceiveBufferSize() {
        return this.tcpReceiveBufferSize;
    }

    public synchronized void start() throws Exception {
        String acceptorType;
        if (this.channelClazz != null) {
            return;
        }
        if (this.useInvm) {
            acceptorType = INVM_ACCEPTOR_TYPE;
            this.channelClazz = LocalServerChannel.class;
            this.eventLoopGroup = new DefaultEventLoopGroup();
        } else {
            if (this.remotingThreads == -1) {
                this.remotingThreads = Runtime.getRuntime().availableProcessors() * 3;
            }
            if (this.useEpoll && CheckDependencies.isEpollAvailable()) {
                this.channelClazz = EpollServerSocketChannel.class;
                this.eventLoopGroup = new EpollEventLoopGroup(this.remotingThreads, (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<ActiveMQThreadFactory>(){

                    @Override
                    public ActiveMQThreadFactory run() {
                        return new ActiveMQThreadFactory("activemq-netty-threads", true, ClientSessionFactoryImpl.class.getClassLoader());
                    }
                }));
                acceptorType = EPOLL_ACCEPTOR_TYPE;
                logger.debug("Acceptor using native epoll");
            } else if (this.useKQueue && CheckDependencies.isKQueueAvailable()) {
                this.channelClazz = KQueueServerSocketChannel.class;
                this.eventLoopGroup = new KQueueEventLoopGroup(this.remotingThreads, (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<ActiveMQThreadFactory>(){

                    @Override
                    public ActiveMQThreadFactory run() {
                        return new ActiveMQThreadFactory("activemq-netty-threads", true, ClientSessionFactoryImpl.class.getClassLoader());
                    }
                }));
                acceptorType = KQUEUE_ACCEPTOR_TYPE;
                logger.debug("Acceptor using native kqueue");
            } else {
                this.channelClazz = NioServerSocketChannel.class;
                this.eventLoopGroup = new NioEventLoopGroup(this.remotingThreads, (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<ActiveMQThreadFactory>(){

                    @Override
                    public ActiveMQThreadFactory run() {
                        return new ActiveMQThreadFactory("activemq-netty-threads", true, ClientSessionFactoryImpl.class.getClassLoader());
                    }
                }));
                acceptorType = NIO_ACCEPTOR_TYPE;
                logger.debug("Acceptor using nio");
            }
        }
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group(this.eventLoopGroup);
        this.bootstrap.channel(this.channelClazz);
        ChannelInitializer<Channel> factory = new ChannelInitializer<Channel>(){

            public void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyAcceptor.this.sslEnabled) {
                    Pair<String, Integer> peerInfo = this.getPeerInfo(channel);
                    try {
                        pipeline.addLast("sni", (ChannelHandler)new NettySNIHostnameHandler());
                        pipeline.addLast("ssl", (ChannelHandler)NettyAcceptor.this.getSslHandler(channel.alloc(), (String)peerInfo.getA(), (Integer)peerInfo.getB()));
                        pipeline.addLast("sslHandshakeExceptionHandler", (ChannelHandler)new SslHandshakeExceptionHandler());
                    }
                    catch (Exception e) {
                        Throwable rootCause = NettyAcceptor.this.getRootCause(e);
                        ActiveMQServerLogger.LOGGER.gettingSslHandlerFailed(channel.remoteAddress().toString(), rootCause.getClass().getName() + ": " + rootCause.getMessage());
                        logger.debug("Getting SSL handler failed", (Throwable)e);
                        throw e;
                    }
                }
                pipeline.addLast(new ChannelHandler[]{NettyAcceptor.this.protocolHandler.getProtocolDecoder()});
            }

            private Pair<String, Integer> getPeerInfo(Channel channel) {
                try {
                    String[] peerInfo = channel.remoteAddress().toString().replace("/", "").split(":");
                    return new Pair((Object)peerInfo[0], (Object)Integer.parseInt(peerInfo[1]));
                }
                catch (Exception e) {
                    logger.debug("Failed to parse peer info for SSL engine initialization", (Throwable)e);
                    return new Pair(null, (Object)0);
                }
            }
        };
        this.bootstrap.childHandler((ChannelHandler)factory);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.tcpSendBufferSize);
        }
        int writeBufferLowWaterMark = this.writeBufferLowWaterMark != -1 ? this.writeBufferLowWaterMark : WriteBufferWaterMark.DEFAULT.low();
        int writeBufferHighWaterMark = this.writeBufferHighWaterMark != -1 ? this.writeBufferHighWaterMark : WriteBufferWaterMark.DEFAULT.high();
        WriteBufferWaterMark writeBufferWaterMark = new WriteBufferWaterMark(writeBufferLowWaterMark, writeBufferHighWaterMark);
        this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)writeBufferWaterMark);
        if (this.backlog != -1) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.backlog);
        }
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.channelGroup = new DefaultChannelGroup("activemq-accepted-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.serverChannelGroup = new DefaultChannelGroup("activemq-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        if (!this.httpUpgradeEnabled) {
            this.startServerChannels();
            this.paused = false;
            if (this.notificationService != null) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
                props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
                props.putIntProperty(new SimpleString("port"), this.actualPort);
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.ACCEPTOR_STARTED, props);
                this.notificationService.sendNotification(notification);
            }
            ActiveMQServerLogger.LOGGER.startedAcceptor(acceptorType, this.host, this.actualPort, this.protocolsString);
        }
        if (this.batchDelay > 0L) {
            this.flusher = new BatchFlusher();
            this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<Object, NettyServerConnection> getConnections() {
        return this.connections;
    }

    @Override
    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setKeyStoreParameters(String keyStorePath, String keyStoreAlias) {
        this.keyStorePath = keyStorePath;
        this.configuration.put("keyStorePath", keyStorePath);
        this.configuration.put("keyStoreAlias", keyStoreAlias);
        this.sslContextConfig = SSLContextConfig.builder().from(this.sslContextConfig).keystorePath(keyStorePath).keystoreAlias(keyStoreAlias).build();
    }

    public void transfer(Channel channel) {
        if (this.paused || this.eventLoopGroup == null) {
            throw ActiveMQMessageBundle.BUNDLE.acceptorUnavailable();
        }
        channel.pipeline().addLast(new ChannelHandler[]{this.protocolHandler.getProtocolDecoder()});
    }

    @Override
    public void reload() {
        ChannelGroupFuture future = this.serverChannelGroup.disconnect();
        try {
            future.awaitUninterruptibly();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverChannelGroup.clear();
        if (this.sslEnabled) {
            this.providerAgnosticSslContext = this.loadSSLContext();
        }
        this.startServerChannels();
    }

    public SslHandler getSslHandler(ByteBufAllocator alloc, String peerHost, int peerPort) throws Exception {
        SSLParameters sslParameters;
        SSLEngine engine = "OPENSSL".equals(this.sslProvider) ? this.loadOpenSslEngine(alloc, peerHost, peerPort) : this.loadJdkSslEngine(peerHost, peerPort);
        engine.setUseClientMode(false);
        if (this.needClientAuth) {
            engine.setNeedClientAuth(true);
        } else if (this.wantClientAuth) {
            engine.setWantClientAuth(true);
        }
        String[] originalProtocols = engine.getEnabledProtocols();
        if (this.enabledCipherSuites != null) {
            try {
                engine.setEnabledCipherSuites(SSLSupport.parseCommaSeparatedListIntoArray((String)this.enabledCipherSuites));
            }
            catch (IllegalArgumentException e) {
                ActiveMQServerLogger.LOGGER.invalidCipherSuite(SSLSupport.parseArrayIntoCommandSeparatedList((String[])engine.getSupportedCipherSuites()));
                throw e;
            }
        }
        if (this.enabledProtocols != null) {
            try {
                engine.setEnabledProtocols(SSLSupport.parseCommaSeparatedListIntoArray((String)this.enabledProtocols));
            }
            catch (IllegalArgumentException e) {
                ActiveMQServerLogger.LOGGER.invalidProtocol(SSLSupport.parseArrayIntoCommandSeparatedList((String[])engine.getSupportedProtocols()));
                throw e;
            }
        } else {
            engine.setEnabledProtocols(originalProtocols);
        }
        String[] protocols = engine.getEnabledProtocols();
        HashSet<String> set = new HashSet<String>();
        for (String s : protocols) {
            if (s.equalsIgnoreCase("SSLv3") || s.equals("SSLv2Hello")) {
                if (this.warningPrinted.get()) continue;
                ActiveMQServerLogger.LOGGER.disallowedProtocol(s, this.name);
                continue;
            }
            set.add(s);
        }
        this.warningPrinted.set(true);
        engine.setEnabledProtocols(set.toArray(new String[set.size()]));
        if (this.verifyHost) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        if (this.sniHost != null) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setSNIMatchers(Arrays.asList(SNIHostName.createSNIMatcher(this.sniHost)));
            engine.setSSLParameters(sslParameters);
        }
        return new SslHandler(engine);
    }

    private SSLEngine loadJdkSslEngine(String peerHost, int peerPort) throws Exception {
        SSLContext context = (SSLContext)this.providerAgnosticSslContext;
        if (peerHost != null && peerPort != 0) {
            return context.createSSLEngine(peerHost, peerPort);
        }
        return context.createSSLEngine();
    }

    private void checkSSLConfiguration() throws IllegalArgumentException {
        if (this.configuration.containsKey("sslContext")) {
            return;
        }
        if (this.keyStorePath == null && TransportConstants.DEFAULT_KEYSTORE_PROVIDER.equals(this.keyStoreProvider)) {
            throw new IllegalArgumentException("If \"sslEnabled\" is true then \"keyStorePath\" must be non-null unless an alternative \"keyStoreProvider\" has been specified.");
        }
    }

    private SSLEngine loadOpenSslEngine(ByteBufAllocator alloc, String peerHost, int peerPort) throws Exception {
        SslContext context = (SslContext)this.providerAgnosticSslContext;
        if (peerHost != null && peerPort != 0) {
            return context.newEngine(alloc, peerHost, peerPort);
        }
        return context.newEngine(alloc);
    }

    private void startServerChannels() {
        String[] hosts;
        for (String h : hosts = TransportConfiguration.splitHosts((String)this.host)) {
            Object address = this.useInvm ? new LocalAddress(h) : new InetSocketAddress(h, this.port);
            Channel serverChannel = null;
            try {
                serverChannel = this.bootstrap.bind((SocketAddress)address).syncUninterruptibly().channel();
                this.actualPort = serverChannel.localAddress() instanceof InetSocketAddress ? ((InetSocketAddress)serverChannel.localAddress()).getPort() : this.port;
            }
            catch (Exception e) {
                throw ActiveMQMessageBundle.BUNDLE.failedToBind(this.getName(), h + ":" + this.port, e);
            }
            this.serverChannelGroup.add((Object)serverChannel);
        }
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void stop() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.asyncStop(latch::countDown);
        latch.await();
    }

    public synchronized void asyncStop(Runnable callback) {
        Object future;
        if (this.channelClazz == null) {
            callback.run();
            return;
        }
        if (this.protocolHandler != null) {
            this.protocolHandler.close();
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        if (this.serverChannelGroup != null) {
            this.serverChannelGroup.close().awaitUninterruptibly();
        }
        if (this.channelGroup != null && !(future = this.channelGroup.close().awaitUninterruptibly()).isSuccess()) {
            ActiveMQServerLogger.LOGGER.nettyChannelGroupError();
            for (Channel channel : future.group()) {
                if (!channel.isActive()) continue;
                ActiveMQServerLogger.LOGGER.nettyChannelStillOpen(channel, channel.remoteAddress());
            }
        }
        this.channelClazz = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToSendNotification(e);
            }
        }
        this.paused = false;
        this.eventLoopGroup.shutdownGracefully((long)this.quietPeriod, (long)this.shutdownTimeout, TimeUnit.MILLISECONDS).addListener(f -> callback.run());
        this.eventLoopGroup = null;
    }

    public boolean isStarted() {
        return this.channelClazz != null;
    }

    @Override
    public synchronized void pause() {
        ChannelGroupFuture future;
        if (this.paused) {
            return;
        }
        if (this.channelClazz == null) {
            return;
        }
        if (this.serverChannelGroup != null && !(future = this.serverChannelGroup.close().awaitUninterruptibly()).isSuccess()) {
            ActiveMQServerLogger.LOGGER.nettyChannelGroupBindError();
            for (Channel channel : future.group()) {
                if (!channel.isActive()) continue;
                ActiveMQServerLogger.LOGGER.nettyChannelStillBound(channel, channel.remoteAddress());
            }
        }
        this.paused = true;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public void setDefaultActiveMQPrincipal(ActiveMQPrincipal defaultActiveMQPrincipal) {
        throw new IllegalStateException("unsecure connections not allowed");
    }

    @Override
    public boolean isUnsecurable() {
        return false;
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    public ConnectionCreator createConnectionCreator() {
        return new ActiveMQServerChannelHandler(this.channelGroup, this.handler, new Listener(), this.failureExecutor);
    }

    public int getQuietPeriod() {
        return this.quietPeriod;
    }

    public NettyAcceptor setQuietPeriod(int quietPeriod) {
        this.quietPeriod = quietPeriod;
        return this;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public NettyAcceptor setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    private static String getProtocols(Map<String, ProtocolManager> protocolManagers) {
        if (protocolManagers == null || protocolManagers.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", protocolManagers.keySet());
    }

    private Throwable getRootCause(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list.size() < 2 ? throwable : (Throwable)list.get(list.size() - 1);
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    @Override
    public int getActualPort() {
        return this.actualPort;
    }

    static {
        if (System.getProperty("io.netty.leakDetectionLevel") == null && System.getProperty("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
    }

    private class SslHandshakeExceptionHandler
    implements ChannelHandler {
        private SslHandshakeExceptionHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause.getMessage() != null && cause.getMessage().startsWith(SSLHandshakeException.class.getName())) {
                Throwable rootCause = NettyAcceptor.this.getRootCause(cause);
                String errorMessage = rootCause.getClass().getName() + ": " + rootCause.getMessage();
                ActiveMQServerLogger.LOGGER.sslHandshakeFailed(ctx.channel().remoteAddress().toString(), errorMessage);
                logger.debug("SSL handshake failed", cause);
            }
        }
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (Connection connection : NettyAcceptor.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ServerConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(ActiveMQComponent component, Connection connection, ProtocolManager protocol) {
            if (NettyAcceptor.this.connections.putIfAbsent(connection.getID(), (NettyServerConnection)connection) != null) {
                throw ActiveMQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            NettyAcceptor.this.listener.connectionCreated(component, connection, protocol);
        }

        public void connectionDestroyed(Object connectionID) {
            if (NettyAcceptor.this.connections.remove(connectionID) != null) {
                NettyAcceptor.this.listener.connectionDestroyed(connectionID);
            }
        }

        public void connectionException(final Object connectionID, final ActiveMQException me) {
            new Thread(){

                @Override
                public void run() {
                    NettyAcceptor.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
            NettyServerConnection conn = (NettyServerConnection)((Object)NettyAcceptor.this.connections.get(connectionID));
            if (conn != null) {
                conn.fireReady(ready);
            }
            NettyAcceptor.this.listener.connectionReadyForWrites(connectionID, ready);
        }
    }

    private final class ActiveMQServerChannelHandler
    extends ActiveMQChannelHandler
    implements ConnectionCreator {
        ActiveMQServerChannelHandler(ChannelGroup group, BufferHandler handler, ServerConnectionLifeCycleListener listener, Executor failureExecutor) {
            super(group, handler, (BaseConnectionLifeCycleListener)listener, failureExecutor);
        }

        @Override
        public NettyServerConnection createConnection(ChannelHandlerContext ctx, String protocol, boolean httpEnabled) throws Exception {
            if (NettyAcceptor.this.connectionsAllowed == -1L || (long)NettyAcceptor.this.connections.size() < NettyAcceptor.this.connectionsAllowed) {
                super.channelActive(ctx);
                Listener connectionListener = new Listener();
                NettyServerConnection nc = new NettyServerConnection(NettyAcceptor.this.configuration, ctx.channel(), connectionListener, !httpEnabled && NettyAcceptor.this.batchDelay > 0L, NettyAcceptor.this.directDeliver, NettyAcceptor.this.router);
                connectionListener.connectionCreated((ActiveMQComponent)NettyAcceptor.this, (Connection)nc, NettyAcceptor.this.protocolHandler.getProtocol(protocol));
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                if (sslHandler != null) {
                    sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                        public void operationComplete(Future<Channel> future) throws Exception {
                            if (future.isSuccess()) {
                                ActiveMQServerChannelHandler.this.active = true;
                            } else {
                                ((Channel)future.getNow()).close();
                            }
                        }
                    });
                } else {
                    this.active = true;
                }
                return nc;
            }
            ActiveMQServerLogger.LOGGER.connectionLimitReached(NettyAcceptor.this.connectionsAllowed, ctx.channel().remoteAddress().toString());
            ctx.channel().close();
            return null;
        }
    }
}

