/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.jboss.logging.Logger;

public class MessagePersister
implements Persister<Message> {
    private static final Logger logger = Logger.getLogger(MessagePersister.class);
    private static final MessagePersister theInstance = new MessagePersister();
    private static Map<Byte, Persister<Message>> protocols = new ConcurrentHashMap<Byte, Persister<Message>>();

    public static void registerProtocol(ProtocolManagerFactory manager) {
        Persister<Message> messagePersister = manager.getPersister();
        if (messagePersister == null) {
            logger.debug((Object)("Cannot find persister for " + manager));
        } else {
            MessagePersister.registerPersister(manager.getStoreID(), manager.getPersister());
        }
    }

    public static void clearPersisters() {
        protocols.clear();
    }

    public static void registerPersister(byte recordType, Persister<Message> persister) {
        if (persister != null) {
            protocols.put(recordType, persister);
        }
    }

    public static MessagePersister getInstance() {
        return theInstance;
    }

    protected MessagePersister() {
    }

    protected byte getID() {
        return 0;
    }

    public int getEncodeSize(Message record) {
        return 0;
    }

    public void encode(ActiveMQBuffer buffer, Message record) {
        buffer.writeByte(this.getID());
    }

    public Message decode(ActiveMQBuffer buffer, Message record) {
        byte protocol = buffer.readByte();
        Persister<Message> persister = protocols.get(protocol);
        if (persister == null) {
            throw new NullPointerException("couldn't find factory for type=" + protocol);
        }
        return (Message)persister.decode(buffer, (Object)record);
    }

    static {
        MessagePersister.registerPersister((byte)1, (Persister<Message>)CoreMessagePersister.getInstance());
        ServiceLoader<ProtocolManagerFactory> protocols = ServiceLoader.load(ProtocolManagerFactory.class, MessagePersister.class.getClassLoader());
        for (ProtocolManagerFactory next : protocols) {
            MessagePersister.registerPersister(next.getStoreID(), next.getPersister());
        }
    }
}

