/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.management.impl.AcceptorControlImpl;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.management.impl.AddressControlImpl;
import org.apache.activemq.artemis.core.management.impl.BridgeControlImpl;
import org.apache.activemq.artemis.core.management.impl.BroadcastGroupControlImpl;
import org.apache.activemq.artemis.core.management.impl.ClusterConnectionControlImpl;
import org.apache.activemq.artemis.core.management.impl.DivertControlImpl;
import org.apache.activemq.artemis.core.management.impl.QueueControlImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.core.messagecounter.MessageCounterManager;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterManagerImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class ManagementServiceImpl
implements ManagementService {
    private static final Logger logger = Logger.getLogger(ManagementServiceImpl.class);
    private final MBeanServer mbeanServer;
    private final boolean jmxManagementEnabled;
    private final Map<String, Object> registry;
    private final NotificationBroadcasterSupport broadcaster;
    private PostOffice postOffice;
    private SecurityStore securityStore;
    private PagingManager pagingManager;
    private StorageManager storageManager;
    private ActiveMQServer messagingServer;
    private HierarchicalRepository<Set<Role>> securityRepository;
    private HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private ActiveMQServerControlImpl messagingServerControl;
    private MessageCounterManager messageCounterManager;
    private final SimpleString managementNotificationAddress;
    private final SimpleString managementAddress;
    private boolean started = false;
    private final boolean messageCounterEnabled;
    private boolean notificationsEnabled;
    private final Set<NotificationListener> listeners = new ConcurrentHashSet();
    private final ObjectNameBuilder objectNameBuilder;
    private final Set<ObjectName> registeredNames = new HashSet<ObjectName>();

    public ManagementServiceImpl(MBeanServer mbeanServer, Configuration configuration) {
        this.mbeanServer = mbeanServer;
        this.jmxManagementEnabled = configuration.isJMXManagementEnabled();
        this.messageCounterEnabled = configuration.isMessageCounterEnabled();
        this.managementAddress = configuration.getManagementAddress();
        this.managementNotificationAddress = configuration.getManagementNotificationAddress();
        this.registry = new ConcurrentHashMap<String, Object>();
        this.broadcaster = new NotificationBroadcasterSupport();
        this.notificationsEnabled = true;
        this.objectNameBuilder = ObjectNameBuilder.create((String)configuration.getJMXDomain(), (String)configuration.getName(), (boolean)configuration.isJMXUseBrokerName());
    }

    @Override
    public ObjectNameBuilder getObjectNameBuilder() {
        return this.objectNameBuilder;
    }

    @Override
    public MessageCounterManager getMessageCounterManager() {
        return this.messageCounterManager;
    }

    @Override
    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public ActiveMQServerControlImpl registerServer(PostOffice postOffice, SecurityStore securityStore, StorageManager storageManager1, Configuration configuration, HierarchicalRepository<AddressSettings> addressSettingsRepository, HierarchicalRepository<Set<Role>> securityRepository, ResourceManager resourceManager, RemotingService remotingService, ActiveMQServer messagingServer, QueueFactory queueFactory, ScheduledExecutorService scheduledThreadPool, PagingManager pagingManager, boolean backup) throws Exception {
        this.postOffice = postOffice;
        this.securityStore = securityStore;
        this.addressSettingsRepository = addressSettingsRepository;
        this.securityRepository = securityRepository;
        this.storageManager = storageManager1;
        this.messagingServer = messagingServer;
        this.pagingManager = pagingManager;
        this.messageCounterManager = new MessageCounterManagerImpl(scheduledThreadPool, messagingServer.getExecutorFactory().getExecutor());
        this.messageCounterManager.setMaxDayCount(configuration.getMessageCounterMaxDayHistory());
        this.messageCounterManager.reschedule(configuration.getMessageCounterSamplePeriod());
        this.messagingServerControl = new ActiveMQServerControlImpl(postOffice, configuration, resourceManager, remotingService, messagingServer, this.messageCounterManager, storageManager1, this.broadcaster);
        ObjectName objectName = this.objectNameBuilder.getActiveMQServerObjectName();
        this.registerInJMX(objectName, this.messagingServerControl);
        this.registerInRegistry("broker", this.messagingServerControl);
        return this.messagingServerControl;
    }

    @Override
    public synchronized void unregisterServer() throws Exception {
        ObjectName objectName = this.objectNameBuilder.getActiveMQServerObjectName();
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("broker");
    }

    @Override
    public void registerAddress(AddressInfo addressInfo) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAddressObjectName(addressInfo.getName());
        AddressControlImpl addressControl = new AddressControlImpl(addressInfo, this.postOffice, this.pagingManager, this.storageManager, this.securityRepository, this.securityStore, this);
        this.registerInJMX(objectName, addressControl);
        this.registerInRegistry("address." + addressInfo.getName(), addressControl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registered address " + objectName));
        }
    }

    @Override
    public synchronized void unregisterAddress(SimpleString address) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAddressObjectName(address);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("address." + address);
    }

    @Override
    public synchronized void registerQueue(Queue queue, SimpleString address, StorageManager storageManager) throws Exception {
        QueueControlImpl queueControl = new QueueControlImpl(queue, address.toString(), this.postOffice, storageManager, this.securityStore, this.addressSettingsRepository);
        if (this.messageCounterManager != null) {
            MessageCounter counter = new MessageCounter(queue.getName().toString(), null, queue, false, queue.isDurable(), this.messageCounterManager.getMaxDayCount());
            queueControl.setMessageCounter(counter);
            this.messageCounterManager.registerMessageCounter(queue.getName().toString(), counter);
        }
        ObjectName objectName = this.objectNameBuilder.getQueueObjectName(address, queue.getName(), queue.getRoutingType());
        this.registerInJMX(objectName, queueControl);
        this.registerInRegistry("queue." + queue.getName(), queueControl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registered queue " + objectName));
        }
    }

    @Override
    public synchronized void unregisterQueue(SimpleString name, SimpleString address, RoutingType routingType) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getQueueObjectName(address, name, routingType);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("queue." + name);
        this.messageCounterManager.unregisterMessageCounter(name.toString());
    }

    @Override
    public synchronized void registerDivert(Divert divert, DivertConfiguration config) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getDivertObjectName(divert.getUniqueName().toString(), config.getAddress());
        DivertControlImpl divertControl = new DivertControlImpl(divert, this.storageManager, config);
        this.registerInJMX(objectName, divertControl);
        this.registerInRegistry("divert." + config.getName(), divertControl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registered divert " + objectName));
        }
    }

    @Override
    public synchronized void unregisterDivert(SimpleString name, SimpleString address) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getDivertObjectName(name.toString(), address.toString());
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("divert." + name);
    }

    @Override
    public synchronized void registerAcceptor(Acceptor acceptor, TransportConfiguration configuration) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAcceptorObjectName(configuration.getName());
        AcceptorControlImpl control = new AcceptorControlImpl(acceptor, this.storageManager, configuration);
        this.registerInJMX(objectName, control);
        this.registerInRegistry("acceptor." + configuration.getName(), control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAcceptors() {
        ArrayList<String> acceptors = new ArrayList<String>();
        ManagementServiceImpl managementServiceImpl = this;
        synchronized (managementServiceImpl) {
            for (String resourceName : this.registry.keySet()) {
                if (!resourceName.startsWith("acceptor.")) continue;
                acceptors.add(resourceName);
            }
        }
        for (String acceptor : acceptors) {
            String name = acceptor.substring("acceptor.".length());
            try {
                this.unregisterAcceptor(name);
            }
            catch (Exception e) {
                logger.warn("Failed to unregister acceptors", (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void unregisterAcceptor(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAcceptorObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("acceptor." + name);
    }

    @Override
    public synchronized void registerBroadcastGroup(BroadcastGroup broadcastGroup, BroadcastGroupConfiguration configuration) throws Exception {
        broadcastGroup.setNotificationService(this);
        ObjectName objectName = this.objectNameBuilder.getBroadcastGroupObjectName(configuration.getName());
        BroadcastGroupControlImpl control = new BroadcastGroupControlImpl(broadcastGroup, this.storageManager, configuration);
        this.registerInJMX(objectName, control);
        this.registerInRegistry("broadcastgroup." + configuration.getName(), control);
    }

    @Override
    public synchronized void unregisterBroadcastGroup(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getBroadcastGroupObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("broadcastgroup." + name);
    }

    @Override
    public synchronized void registerBridge(Bridge bridge, BridgeConfiguration configuration) throws Exception {
        bridge.setNotificationService(this);
        ObjectName objectName = this.objectNameBuilder.getBridgeObjectName(configuration.getName());
        BridgeControlImpl control = new BridgeControlImpl(bridge, this.storageManager, configuration);
        this.registerInJMX(objectName, control);
        this.registerInRegistry("bridge." + configuration.getName(), control);
    }

    @Override
    public synchronized void unregisterBridge(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getBridgeObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("bridge." + name);
    }

    @Override
    public synchronized void registerCluster(ClusterConnection cluster, ClusterConnectionConfiguration configuration) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getClusterConnectionObjectName(configuration.getName());
        ClusterConnectionControlImpl control = new ClusterConnectionControlImpl(cluster, this.storageManager, configuration);
        this.registerInJMX(objectName, control);
        this.registerInRegistry("clusterconnection." + configuration.getName(), control);
    }

    @Override
    public synchronized void unregisterCluster(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getClusterConnectionObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("clusterconnection." + name);
    }

    @Override
    public ICoreMessage handleMessage(Message message) throws Exception {
        String operation;
        message = message.toCore();
        CoreMessage reply = new CoreMessage(this.storageManager.generateID(), 512);
        reply.setType((byte)3);
        reply.setReplyTo(message.getReplyTo());
        String resourceName = message.getStringProperty(ManagementHelper.HDR_RESOURCE_NAME);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("handling management message for " + resourceName));
        }
        if ((operation = message.getStringProperty(ManagementHelper.HDR_OPERATION_NAME)) != null) {
            Object[] params = ManagementHelper.retrieveOperationParameters((Message)message);
            if (params == null) {
                params = new Object[]{};
            }
            try {
                Object result = this.invokeOperation(resourceName, operation, params);
                ManagementHelper.storeResult((CoreMessage)reply, (Object)result);
                reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.managementOperationError(e, operation, resourceName);
                reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, false);
                String exceptionMessage = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : e.getMessage();
                ManagementHelper.storeResult((CoreMessage)reply, (Object)exceptionMessage);
            }
        } else {
            String attribute = message.getStringProperty(ManagementHelper.HDR_ATTRIBUTE);
            if (attribute != null) {
                try {
                    Object result = this.getAttribute(resourceName, attribute);
                    ManagementHelper.storeResult((CoreMessage)reply, (Object)result);
                    reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, true);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.managementAttributeError(e, attribute, resourceName);
                    reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, false);
                    String exceptionMessage = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : e.getMessage();
                    ManagementHelper.storeResult((CoreMessage)reply, (Object)exceptionMessage);
                }
            }
        }
        return reply;
    }

    @Override
    public synchronized Object getResource(String resourceName) {
        return this.registry.get(resourceName);
    }

    @Override
    public synchronized Object[] getResources(Class<?> resourceType) {
        ArrayList resources = new ArrayList();
        ArrayList<Object> clone = new ArrayList<Object>(this.registry.values());
        for (Object e : clone) {
            if (!resourceType.isAssignableFrom(e.getClass())) continue;
            resources.add(e);
        }
        return resources.toArray(new Object[resources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInJMX(ObjectName objectName, Object managedResource) throws Exception {
        if (!this.jmxManagementEnabled) {
            return;
        }
        MBeanServer mBeanServer = this.mbeanServer;
        synchronized (mBeanServer) {
            this.unregisterFromJMX(objectName);
            this.mbeanServer.registerMBean(managedResource, objectName);
            this.registeredNames.add(objectName);
        }
    }

    @Override
    public synchronized void registerInRegistry(String resourceName, Object managedResource) {
        this.unregisterFromRegistry(resourceName);
        this.registry.put(resourceName, managedResource);
    }

    @Override
    public synchronized void unregisterFromRegistry(String resourceName) {
        this.registry.remove(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFromJMX(ObjectName objectName) throws MBeanRegistrationException, InstanceNotFoundException {
        if (!this.jmxManagementEnabled) {
            return;
        }
        MBeanServer mBeanServer = this.mbeanServer;
        synchronized (mBeanServer) {
            if (this.mbeanServer.isRegistered(objectName)) {
                this.mbeanServer.unregisterMBean(objectName);
                this.registeredNames.remove(objectName);
            }
        }
    }

    public void addNotificationListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SimpleString getManagementAddress() {
        return this.managementAddress;
    }

    @Override
    public SimpleString getManagementNotificationAddress() {
        return this.managementNotificationAddress;
    }

    public void start() throws Exception {
        if (this.messageCounterEnabled) {
            this.messageCounterManager.start();
        }
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        HashSet<String> resourceNames = new HashSet<String>(this.registry.keySet());
        for (String resourceName : resourceNames) {
            this.unregisterFromRegistry(resourceName);
        }
        if (this.jmxManagementEnabled && !this.registeredNames.isEmpty()) {
            ArrayList<String> unexpectedResourceNames = new ArrayList<String>();
            for (String name : resourceNames) {
                if (name.startsWith("address.") || name.startsWith("queue.") || name.startsWith("divert.")) continue;
                unexpectedResourceNames.add(name);
            }
            if (!unexpectedResourceNames.isEmpty()) {
                ActiveMQServerLogger.LOGGER.managementStopError(unexpectedResourceNames.size(), unexpectedResourceNames);
            }
            for (ObjectName on : this.registeredNames) {
                try {
                    this.mbeanServer.unregisterMBean(on);
                }
                catch (Exception exception) {}
            }
        }
        if (this.messageCounterManager != null) {
            this.messageCounterManager.stop();
            this.messageCounterManager.resetAllCounters();
            this.messageCounterManager.resetAllCounterHistories();
            this.messageCounterManager.clear();
        }
        this.listeners.clear();
        this.registry.clear();
        this.messagingServer = null;
        this.securityRepository = null;
        this.addressSettingsRepository = null;
        this.messagingServerControl = null;
        this.messageCounterManager = null;
        this.postOffice = null;
        this.pagingManager = null;
        this.storageManager = null;
        this.messagingServer = null;
        this.registeredNames.clear();
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Sending Notification = " + notification + ", notificationEnabled=" + this.notificationsEnabled + " messagingServerControl=" + this.messagingServerControl));
        }
        ManagementServiceImpl managementServiceImpl = this;
        synchronized (managementServiceImpl) {
            if (this.messagingServerControl != null && this.notificationsEnabled) {
                Object object = this.postOffice.getNotificationLock();
                synchronized (object) {
                    for (NotificationListener listener : this.listeners) {
                        try {
                            listener.onNotification(notification);
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.errorCallingNotifListener(e);
                        }
                    }
                    if (this.messagingServer == null || !this.messagingServer.isActive()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("ignoring message " + notification + " as the server is not initialized"));
                        }
                        return;
                    }
                    long messageID = this.storageManager.generateID();
                    CoreMessage notificationMessage = new CoreMessage(messageID, 512);
                    notificationMessage.setDurable(true);
                    notificationMessage.setAddress(this.managementNotificationAddress);
                    if (notification.getProperties() != null) {
                        TypedProperties props = notification.getProperties();
                        for (SimpleString name : notification.getProperties().getPropertyNames()) {
                            notificationMessage.putObjectProperty(name, props.getProperty(name));
                        }
                    }
                    notificationMessage.putStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE, new SimpleString(notification.getType().toString()));
                    notificationMessage.putLongProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP, System.currentTimeMillis());
                    if (notification.getUID() != null) {
                        notificationMessage.putStringProperty(new SimpleString("foobar"), new SimpleString(notification.getUID()));
                    }
                    this.postOffice.route((Message)notificationMessage, false);
                }
            }
        }
    }

    public void enableNotifications(boolean enabled) {
        this.notificationsEnabled = enabled;
    }

    public Object getAttribute(String resourceName, String attribute) {
        try {
            Object resource = this.registry.get(resourceName);
            if (resource == null) {
                throw ActiveMQMessageBundle.BUNDLE.cannotFindResource(resourceName);
            }
            Method method = null;
            String upperCaseAttribute = attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            try {
                method = resource.getClass().getMethod("get" + upperCaseAttribute, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    method = resource.getClass().getMethod("is" + upperCaseAttribute, new Class[0]);
                }
                catch (NoSuchMethodException nsme2) {
                    throw ActiveMQMessageBundle.BUNDLE.noGetterMethod(attribute);
                }
            }
            return method.invoke(resource, new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Problem while retrieving attribute " + attribute, t);
        }
    }

    private Object invokeOperation(String resourceName, String operation, Object[] params) throws Exception {
        Method[] methods;
        Object resource = this.registry.get(resourceName);
        if (resource == null) {
            throw ActiveMQMessageBundle.BUNDLE.cannotFindResource(resourceName);
        }
        Method method = null;
        for (Method m : methods = resource.getClass().getMethods()) {
            if (!m.getName().equals(operation) || m.getParameterTypes().length != params.length) continue;
            boolean match = true;
            Class<?>[] paramTypes = m.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (params[i] == null) continue;
                params[i] = JsonUtil.convertJsonValue((Object)params[i], paramTypes[i]);
                if (paramTypes[i].isAssignableFrom(params[i].getClass()) || paramTypes[i] == Long.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Double.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Long.TYPE && params[i].getClass() == Long.class || paramTypes[i] == Double.TYPE && params[i].getClass() == Double.class || paramTypes[i] == Integer.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Boolean.TYPE && params[i].getClass() == Boolean.class || paramTypes[i] == Object[].class && params[i].getClass() == Object[].class) continue;
                match = false;
                break;
            }
            if (!match) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw ActiveMQMessageBundle.BUNDLE.noOperation(operation, params.length);
        }
        Object result = method.invoke(resource, params);
        return result;
    }
}

