/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.impl;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager2;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager3;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class SecurityStoreImpl
implements SecurityStore,
HierarchicalRepositoryChangeListener {
    private static final Logger logger = Logger.getLogger(SecurityStoreImpl.class);
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final ActiveMQSecurityManager securityManager;
    private final ConcurrentMap<String, ConcurrentHashSet<SimpleString>> cache = new ConcurrentHashMap<String, ConcurrentHashSet<SimpleString>>();
    private final long invalidationInterval;
    private volatile long lastCheck;
    private final boolean securityEnabled;
    private final String managementClusterUser;
    private final String managementClusterPassword;
    private final NotificationService notificationService;

    public SecurityStoreImpl(HierarchicalRepository<Set<Role>> securityRepository, ActiveMQSecurityManager securityManager, long invalidationInterval, boolean securityEnabled, String managementClusterUser, String managementClusterPassword, NotificationService notificationService) {
        this.securityRepository = securityRepository;
        this.securityManager = securityManager;
        this.invalidationInterval = invalidationInterval;
        this.securityEnabled = securityEnabled;
        this.managementClusterUser = managementClusterUser;
        this.managementClusterPassword = managementClusterPassword;
        this.notificationService = notificationService;
        this.securityRepository.registerListener(this);
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public void stop() {
        this.securityRepository.unRegisterListener(this);
    }

    @Override
    public String authenticate(String user, String password, Connection connection) throws Exception {
        if (this.securityEnabled) {
            if (this.managementClusterUser.equals(user)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Authenticating cluster admin user");
                }
                if (!this.managementClusterPassword.equals(password)) {
                    throw ActiveMQMessageBundle.BUNDLE.unableToValidateClusterUser(user);
                }
                return this.managementClusterUser;
            }
            String validatedUser = null;
            boolean userIsValid = false;
            if (this.securityManager instanceof ActiveMQSecurityManager3) {
                validatedUser = ((ActiveMQSecurityManager3)this.securityManager).validateUser(user, password, connection);
            } else {
                userIsValid = this.securityManager instanceof ActiveMQSecurityManager2 ? ((ActiveMQSecurityManager2)this.securityManager).validateUser(user, password, CertificateUtil.getCertsFromConnection((Connection)connection)) : this.securityManager.validateUser(user, password);
            }
            if (!userIsValid && validatedUser == null) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_AUTHENTICATION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                throw ActiveMQMessageBundle.BUNDLE.unableToValidateUser();
            }
            return validatedUser;
        }
        return null;
    }

    @Override
    public void check(SimpleString address, CheckType checkType, SecurityAuth session) throws Exception {
        if (this.securityEnabled) {
            boolean validated;
            String user;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("checking access permissions to " + address));
            }
            if (this.checkCached(address, user = session.getUsername(), checkType)) {
                return;
            }
            String saddress = address.toString();
            Set<Role> roles = this.securityRepository.getMatch(saddress);
            if (this.managementClusterUser.equals(user) && session.getPassword().equals(this.managementClusterPassword)) {
                return;
            }
            if (this.securityManager instanceof ActiveMQSecurityManager3) {
                ActiveMQSecurityManager3 securityManager3 = (ActiveMQSecurityManager3)this.securityManager;
                validated = securityManager3.validateUserAndRole(user, session.getPassword(), roles, checkType, saddress, session.getRemotingConnection().getTransportConnection()) != null;
            } else if (this.securityManager instanceof ActiveMQSecurityManager2) {
                ActiveMQSecurityManager2 securityManager2 = (ActiveMQSecurityManager2)this.securityManager;
                validated = securityManager2.validateUserAndRole(user, session.getPassword(), roles, checkType, saddress, session.getRemotingConnection());
            } else {
                validated = this.securityManager.validateUserAndRole(user, session.getPassword(), roles, checkType);
            }
            if (!validated) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, address);
                    props.putSimpleStringProperty(ManagementHelper.HDR_CHECK_TYPE, new SimpleString(checkType.toString()));
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)user));
                    Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_PERMISSION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                throw ActiveMQMessageBundle.BUNDLE.userNoPermissions(session.getUsername(), checkType, saddress);
            }
            ConcurrentHashSet<SimpleString> set = new ConcurrentHashSet<SimpleString>();
            ConcurrentHashSet<SimpleString> act = this.cache.putIfAbsent(user + "." + checkType.name(), set);
            if (act != null) {
                set = act;
            }
            set.add((Object)address);
        }
    }

    @Override
    public void onChange() {
        this.invalidateCache();
    }

    private void invalidateCache() {
        this.cache.clear();
    }

    private boolean checkCached(SimpleString dest, String user, CheckType checkType) {
        long now = System.currentTimeMillis();
        boolean granted = false;
        if (now - this.lastCheck > this.invalidationInterval) {
            this.invalidateCache();
            this.lastCheck = now;
        } else {
            ConcurrentHashSet act = (ConcurrentHashSet)this.cache.get(user + "." + checkType.name());
            if (act != null) {
                granted = act.contains((Object)dest);
            }
        }
        return granted;
    }
}

