/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.postoffice.AddressManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.jboss.logging.Logger;

public class SimpleAddressManager
implements AddressManager {
    private static final Logger logger = Logger.getLogger(SimpleAddressManager.class);
    private final ConcurrentMap<SimpleString, AddressInfo> addressInfoMap = new ConcurrentHashMap<SimpleString, AddressInfo>();
    private final ConcurrentMap<SimpleString, Bindings> mappings = new ConcurrentHashMap<SimpleString, Bindings>();
    private final ConcurrentMap<SimpleString, Binding> nameMap = new ConcurrentHashMap<SimpleString, Binding>();
    private final BindingsFactory bindingsFactory;
    protected final WildcardConfiguration wildcardConfiguration;

    public SimpleAddressManager(BindingsFactory bindingsFactory) {
        this(bindingsFactory, new WildcardConfiguration());
    }

    public SimpleAddressManager(BindingsFactory bindingsFactory, WildcardConfiguration wildcardConfiguration) {
        this.wildcardConfiguration = wildcardConfiguration;
        this.bindingsFactory = bindingsFactory;
    }

    @Override
    public boolean addBinding(Binding binding) throws Exception {
        if (this.nameMap.putIfAbsent(binding.getUniqueName(), binding) != null) {
            throw ActiveMQMessageBundle.BUNDLE.bindingAlreadyExists(binding);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding binding " + binding + " with address = " + binding.getUniqueName()), (Throwable)new Exception("trace"));
        }
        return this.addMappingInternal(binding.getAddress(), binding);
    }

    @Override
    public Binding removeBinding(SimpleString uniqueName, Transaction tx) throws Exception {
        Binding binding = (Binding)this.nameMap.remove(uniqueName);
        if (binding == null) {
            return null;
        }
        this.removeBindingInternal(binding.getAddress(), uniqueName);
        return binding;
    }

    @Override
    public Bindings getBindingsForRoutingAddress(SimpleString address) throws Exception {
        return (Bindings)this.mappings.get(address);
    }

    @Override
    public Binding getBinding(SimpleString bindableName) {
        return (Binding)this.nameMap.get(CompositeAddress.extractQueueName((SimpleString)bindableName));
    }

    @Override
    public Map<SimpleString, Binding> getBindings() {
        return this.nameMap;
    }

    @Override
    public Bindings getMatchingBindings(SimpleString address) throws Exception {
        AddressImpl add = new AddressImpl(address, this.wildcardConfiguration);
        Bindings bindings = this.bindingsFactory.createBindings(address);
        for (Binding binding : this.nameMap.values()) {
            AddressImpl addCheck = new AddressImpl(binding.getAddress(), this.wildcardConfiguration);
            if (!addCheck.matches(add)) continue;
            bindings.addBinding(binding);
        }
        return bindings;
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        Bindings bindings;
        Binding binding = this.getBinding(address);
        if (!(binding != null && binding instanceof LocalQueueBinding && binding.getAddress().equals((Object)address) || (bindings = (Bindings)this.mappings.get(address)) == null)) {
            for (Binding theBinding : bindings.getBindings()) {
                if (!(theBinding instanceof LocalQueueBinding)) continue;
                binding = theBinding;
                break;
            }
        }
        return binding != null ? binding.getUniqueName() : null;
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        Binding binding = this.getBinding(queueName);
        if (binding != null && !binding.getAddress().equals((Object)address) && !address.toString().isEmpty()) {
            throw new IllegalStateException("queue belongs to address" + binding.getAddress());
        }
        return binding != null ? binding.getUniqueName() : null;
    }

    @Override
    public void clear() {
        this.nameMap.clear();
        this.mappings.clear();
    }

    @Override
    public Set<SimpleString> getAddresses() {
        HashSet<SimpleString> addresses = new HashSet<SimpleString>();
        addresses.addAll(this.mappings.keySet());
        return addresses;
    }

    protected void removeBindingInternal(SimpleString address, SimpleString bindableName) {
        Bindings bindings = (Bindings)this.mappings.get(address);
        if (bindings != null) {
            this.removeMapping(bindableName, bindings);
            if (bindings.getBindings().isEmpty()) {
                this.mappings.remove(address);
            }
        }
    }

    protected Binding removeMapping(SimpleString bindableName, Bindings bindings) {
        Binding theBinding = null;
        for (Binding binding : bindings.getBindings()) {
            if (!binding.getUniqueName().equals((Object)CompositeAddress.extractQueueName((SimpleString)bindableName))) continue;
            theBinding = binding;
            break;
        }
        if (theBinding == null) {
            throw new IllegalStateException("Cannot find binding " + bindableName);
        }
        bindings.removeBinding(theBinding);
        return theBinding;
    }

    protected boolean addMappingInternal(SimpleString address, Binding binding) throws Exception {
        Bindings bindings = (Bindings)this.mappings.get(address);
        Bindings prevBindings = null;
        if (bindings == null && (prevBindings = this.mappings.putIfAbsent(address, bindings = this.bindingsFactory.createBindings(address))) != null) {
            bindings = prevBindings;
        }
        bindings.addBinding(binding);
        return prevBindings != null;
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) {
        return this.addressInfoMap.putIfAbsent(addressInfo.getName(), addressInfo) == null;
    }

    @Override
    public AddressInfo updateAddressInfo(SimpleString addressName, Collection<RoutingType> routingTypes) {
        if (routingTypes == null || routingTypes.isEmpty()) {
            return (AddressInfo)this.addressInfoMap.get(addressName);
        }
        return this.addressInfoMap.computeIfPresent(addressName, (name, oldAddressInfo) -> {
            this.validateRoutingTypes((SimpleString)name, routingTypes);
            EnumSet<RoutingType> updatedRoutingTypes = EnumSet.copyOf(routingTypes);
            oldAddressInfo.setRoutingTypes(updatedRoutingTypes);
            return oldAddressInfo;
        });
    }

    private void validateRoutingTypes(SimpleString addressName, Collection<RoutingType> routingTypes) {
        Bindings bindings = (Bindings)this.mappings.get(addressName);
        if (bindings != null) {
            for (Binding binding : bindings.getBindings()) {
                QueueBinding queueBinding;
                RoutingType routingType;
                if (!(binding instanceof QueueBinding) || routingTypes.contains(routingType = (queueBinding = (QueueBinding)binding).getQueue().getRoutingType()) || !binding.getAddress().equals((Object)addressName)) continue;
                throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeDelete(routingType, addressName.toString());
            }
        }
    }

    @Override
    public AddressInfo removeAddressInfo(SimpleString address) {
        return (AddressInfo)this.addressInfoMap.remove(address);
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString addressName) {
        return (AddressInfo)this.addressInfoMap.get(addressName);
    }
}

