/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.QueueStatus;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedRoles;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.persistence.impl.journal.AddMessageRecord;
import org.apache.activemq.artemis.core.persistence.impl.journal.BatchingIDGenerator;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeMessageTXFailureCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.TXLargeMessageConfirmationOperation;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.CursorAckRecordEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DeleteEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DeliveryCountUpdateEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DuplicateIDEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.FinishPageMessageOperation;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.GroupingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.HeuristicCompletionEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountPendingImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecord;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecordInc;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageUpdateTXEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PendingLargeMessageEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentAddressBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentQueueBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.QueueEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.QueueStatusEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.RefEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.ScheduledDeliveryEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.XidEncoding;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.jboss.logging.Logger;

public abstract class AbstractJournalStorageManager
implements StorageManager {
    private static final Logger logger = Logger.getLogger(AbstractJournalStorageManager.class);
    private static final long CHECKPOINT_BATCH_SIZE = Integer.MAX_VALUE;
    protected Semaphore pageMaxConcurrentIO;
    protected BatchingIDGenerator idGenerator;
    protected final ExecutorFactory ioExecutors;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final ReentrantReadWriteLock storageManagerLock = new ReentrantReadWriteLock(true);
    protected Journal messageJournal;
    protected Journal bindingsJournal;
    protected volatile boolean started;
    protected final ExecutorFactory executorFactory;
    final Executor executor;
    Executor singleThreadExecutor;
    private final boolean syncTransactional;
    private final boolean syncNonTransactional;
    protected boolean journalLoaded = false;
    private final IOCriticalErrorListener ioCriticalErrorListener;
    protected final Configuration config;
    protected final Map<SimpleString, PersistedRoles> mapPersistedRoles = new ConcurrentHashMap<SimpleString, PersistedRoles>();
    protected final Map<SimpleString, PersistedAddressSetting> mapPersistedAddressSettings = new ConcurrentHashMap<SimpleString, PersistedAddressSetting>();
    protected final Set<Long> largeMessagesToDelete = new HashSet<Long>();

    public AbstractJournalStorageManager(Configuration config, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutors) {
        this(config, executorFactory, scheduledExecutorService, ioExecutors, null);
    }

    public AbstractJournalStorageManager(Configuration config, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutors, IOCriticalErrorListener criticalErrorListener) {
        this.executorFactory = executorFactory;
        this.ioCriticalErrorListener = criticalErrorListener;
        this.ioExecutors = ioExecutors;
        this.scheduledExecutorService = scheduledExecutorService;
        this.config = config;
        this.executor = executorFactory.getExecutor();
        this.syncNonTransactional = config.isJournalSyncNonTransactional();
        this.syncTransactional = config.isJournalSyncTransactional();
        this.init(config, criticalErrorListener);
        this.idGenerator = new BatchingIDGenerator(0L, Integer.MAX_VALUE, this);
    }

    protected abstract void init(Configuration var1, IOCriticalErrorListener var2);

    @Override
    public void criticalError(Throwable error) {
        this.ioCriticalErrorListener.onIOException(error, error.getMessage(), null);
    }

    @Override
    public void clearContext() {
        OperationContextImpl.clearContext();
    }

    public static String md5(File file) {
        try {
            byte[] digest;
            byte[] buffer = new byte[16];
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (FileInputStream is = new FileInputStream(file);
                 DigestInputStream is2 = new DigestInputStream(is, md);){
                while (is2.read(buffer) > 0) {
                }
                digest = md.digest();
            }
            return Base64.encodeBytes((byte[])digest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    @Override
    public final void waitOnOperations() throws Exception {
        if (!this.started) {
            ActiveMQServerLogger.LOGGER.serverIsStopped();
            throw new IllegalStateException("Server is stopped");
        }
        this.waitOnOperations(0L);
    }

    @Override
    public final boolean waitOnOperations(long timeout) throws Exception {
        if (!this.started) {
            ActiveMQServerLogger.LOGGER.serverIsStopped();
            throw new IllegalStateException("Server is stopped");
        }
        return this.getContext().waitCompletion(timeout);
    }

    @Override
    public OperationContext getContext() {
        return OperationContextImpl.getContext(this.executorFactory);
    }

    @Override
    public void setContext(OperationContext context) {
        OperationContextImpl.setContext(context);
    }

    @Override
    public OperationContext newSingleThreadContext() {
        return this.newContext(this.singleThreadExecutor);
    }

    @Override
    public OperationContext newContext(Executor executor1) {
        return new OperationContextImpl(executor1);
    }

    @Override
    public void afterCompleteOperations(IOCallback run) {
        this.getContext().executeOnCompletion(run);
    }

    @Override
    public void afterStoreOperations(IOCallback run) {
        this.getContext().executeOnCompletion(run, true);
    }

    public long generateID() {
        return this.idGenerator.generateID();
    }

    public long getCurrentID() {
        return this.idGenerator.getCurrentID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmPendingLargeMessageTX(Transaction tx, long messageID, long recordID) throws Exception {
        this.readLock();
        try {
            this.installLargeMessageConfirmationOnTX(tx, recordID);
            this.messageJournal.appendDeleteRecordTransactional(tx.getID(), recordID, (EncodingSupport)new DeleteEncoding(29, messageID));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void confirmPendingLargeMessage(long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(recordID, true, (IOCompletion)this.getContext());
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void storeMessage(Message message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw ActiveMQMessageBundle.BUNDLE.messageIdNotAssigned();
        }
        this.readLock();
        try {
            if (message.isLargeMessage()) {
                this.messageJournal.appendAddRecord(message.getMessageID(), (byte)30, (Persister)LargeMessagePersister.getInstance(), (Object)message, false, (IOCompletion)this.getContext(false));
            } else {
                this.messageJournal.appendAddRecord(message.getMessageID(), (byte)45, message.getPersister(), (Object)message, false, (IOCompletion)this.getContext(false));
            }
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeReference(long queueID, long messageID, boolean last) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(messageID, (byte)32, (EncodingSupport)new RefEncoding(queueID), last && this.syncNonTransactional, (IOCompletion)this.getContext(last && this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void readLock() {
        this.storageManagerLock.readLock().lock();
    }

    @Override
    public void readUnLock() {
        this.storageManagerLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAcknowledge(long queueID, long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(messageID, (byte)33, (EncodingSupport)new RefEncoding(queueID), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCursorAcknowledge(long queueID, PagePosition position) throws Exception {
        this.readLock();
        try {
            long ackID = this.idGenerator.generateID();
            position.setRecordID(ackID);
            this.messageJournal.appendAddRecord(ackID, (byte)39, (EncodingSupport)new CursorAckRecordEncoding(queueID, position), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void deleteMessage(long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(messageID, false, (IOCompletion)this.getContext(false));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(ref.getMessage().getMessageID(), (byte)36, (EncodingSupport)encoding, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
        this.readLock();
        try {
            DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
            this.messageJournal.appendAddRecord(recordID, (byte)37, (EncodingSupport)encoding, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void deleteDuplicateID(long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(recordID, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessageTransactional(long txID, Message message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw ActiveMQMessageBundle.BUNDLE.messageIdNotAssigned();
        }
        this.readLock();
        try {
            if (message.isLargeMessage()) {
                this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)30, (Persister)LargeMessagePersister.getInstance(), (Object)message);
            } else {
                this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)45, message.getPersister(), (Object)message);
            }
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
        this.readLock();
        try {
            pageTransaction.setRecordID(this.generateID());
            this.messageJournal.appendAddRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, (EncodingSupport)pageTransaction);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction, int depages) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, (EncodingSupport)new PageUpdateTXEncoding(pageTransaction.getTransactionID(), depages));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)32, (EncodingSupport)new RefEncoding(queueID));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAcknowledgeTransactional(long txID, long queueID, long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)33, (EncodingSupport)new RefEncoding(queueID));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCursorAcknowledgeTransactional(long txID, long queueID, PagePosition position) throws Exception {
        this.readLock();
        try {
            long ackID = this.idGenerator.generateID();
            position.setRecordID(ackID);
            this.messageJournal.appendAddRecordTransactional(txID, ackID, (byte)39, (EncodingSupport)new CursorAckRecordEncoding(queueID, position));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void storePageCompleteTransactional(long txID, long queueID, PagePosition position) throws Exception {
        long recordID = this.idGenerator.generateID();
        position.setRecordID(recordID);
        this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)42, (EncodingSupport)new CursorAckRecordEncoding(queueID, position));
    }

    @Override
    public void deletePageComplete(long ackID) throws Exception {
        this.messageJournal.appendDeleteRecord(ackID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCursorAcknowledgeTransactional(long txID, long ackID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, ackID);
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void deleteCursorAcknowledge(long ackID) throws Exception {
        this.messageJournal.appendDeleteRecord(ackID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
        this.readLock();
        try {
            long id = this.generateID();
            this.messageJournal.appendAddRecord(id, (byte)38, (EncodingSupport)new HeuristicCompletionEncoding(xid, isCommit), true, (IOCompletion)this.getContext(true));
            long l = id;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void deleteHeuristicCompletion(long id) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(id, true, (IOCompletion)this.getContext(true));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void deletePageTransactional(long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(recordID, false);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, ref.getMessage().getMessageID(), (byte)36, (EncodingSupport)encoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(long txID, Xid xid) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendPrepareRecord(txID, (EncodingSupport)new XidEncoding(xid), this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void commit(long txID) throws Exception {
        this.commit(txID, true);
    }

    @Override
    public void commitBindings(long txID) throws Exception {
        this.bindingsJournal.appendCommitRecord(txID, true);
    }

    @Override
    public void rollbackBindings(long txID) throws Exception {
        this.bindingsJournal.appendRollbackRecord(txID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(long txID, boolean lineUpContext) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendCommitRecord(txID, this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional), lineUpContext);
            if (!lineUpContext && !this.syncTransactional) {
                this.getContext(true).done();
            }
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void rollback(long txID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendRollbackRecord(txID, this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        this.readLock();
        try {
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)37, (EncodingSupport)encoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, recordID, (byte)37, (EncodingSupport)encoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void updateDeliveryCount(MessageReference ref) throws Exception {
        if (ref.getDeliveryCount() == ref.getPersistedCount()) {
            return;
        }
        ref.setPersistedCount(ref.getDeliveryCount());
        DeliveryCountUpdateEncoding updateInfo = new DeliveryCountUpdateEncoding(ref.getQueue().getID(), ref.getDeliveryCount());
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(ref.getMessage().getMessageID(), (byte)34, (EncodingSupport)updateInfo, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
        this.deleteAddressSetting(addressSetting.getAddressMatch());
        this.readLock();
        try {
            long id = this.idGenerator.generateID();
            addressSetting.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)25, (EncodingSupport)addressSetting, true);
            this.mapPersistedAddressSettings.put(addressSetting.getAddressMatch(), addressSetting);
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
        return new ArrayList<PersistedAddressSetting>(this.mapPersistedAddressSettings.values());
    }

    @Override
    public List<PersistedRoles> recoverPersistedRoles() throws Exception {
        return new ArrayList<PersistedRoles>(this.mapPersistedRoles.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSecurityRoles(PersistedRoles persistedRoles) throws Exception {
        this.deleteSecurityRoles(persistedRoles.getAddressMatch());
        this.readLock();
        try {
            long id = this.idGenerator.generateID();
            persistedRoles.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)26, (EncodingSupport)persistedRoles, true);
            this.mapPersistedRoles.put(persistedRoles.getAddressMatch(), persistedRoles);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeID(long journalID, long id) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendAddRecord(journalID, (byte)24, BatchingIDGenerator.createIDEncodingSupport(id), true);
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void deleteID(long journalD) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendDeleteRecord(journalD, false);
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
        PersistedAddressSetting oldSetting = this.mapPersistedAddressSettings.remove(addressMatch);
        if (oldSetting != null) {
            this.readLock();
            try {
                this.bindingsJournal.appendDeleteRecord(oldSetting.getStoreId(), false);
            }
            finally {
                this.readUnLock();
            }
        }
    }

    @Override
    public void deleteSecurityRoles(SimpleString addressMatch) throws Exception {
        PersistedRoles oldRoles = this.mapPersistedRoles.remove(addressMatch);
        if (oldRoles != null) {
            this.readLock();
            try {
                this.bindingsJournal.appendDeleteRecord(oldRoles.getStoreId(), false);
            }
            finally {
                this.readUnLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, QueueBindingInfo> queueInfos, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Set<Pair<Long, Long>> pendingLargeMessages, List<PageCountPending> pendingNonTXPageCounter, JournalLoader journalLoader) throws Exception {
        ArrayList records = new ArrayList();
        ArrayList<PreparedTransactionInfo> preparedTransactions = new ArrayList<PreparedTransactionInfo>();
        HashMap<Long, Message> messages = new HashMap<Long, Message>();
        this.readLock();
        try {
            JournalLoadInformation info = this.messageJournal.load(records, preparedTransactions, (TransactionFailureCallback)new LargeMessageTXFailureCallback(this, messages));
            ArrayList<LargeServerMessage> largeMessages = new ArrayList<LargeServerMessage>();
            HashMap<Long, Map<Long, AddMessageRecord>> queueMap = new HashMap<Long, Map<Long, AddMessageRecord>>();
            HashMap<Long, PageSubscription> pageSubscriptions = new HashMap<Long, PageSubscription>();
            int totalSize = records.size();
            for (int reccount = 0; reccount < totalSize; ++reccount) {
                if (reccount > 0 && reccount % 1000000 == 0) {
                    long percent = (long)((double)reccount / (double)totalSize * 100.0);
                    ActiveMQServerLogger.LOGGER.percentLoaded(percent);
                }
                RecordInfo record = (RecordInfo)records.get(reccount);
                byte[] data = record.data;
                ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
                byte recordType = record.getUserRecordType();
                switch (recordType) {
                    case 29: {
                        PendingLargeMessageEncoding pending = new PendingLargeMessageEncoding();
                        pending.decode(buff);
                        if (pendingLargeMessages == null) break;
                        pendingLargeMessages.add((Pair<Long, Long>)new Pair((Object)record.id, (Object)pending.largeMessageID));
                        break;
                    }
                    case 30: {
                        LargeServerMessage largeMessage = this.parseLargeMessage(messages, buff);
                        messages.put(record.id, (Message)largeMessage);
                        largeMessages.add(largeMessage);
                        break;
                    }
                    case 31: {
                        throw new IllegalStateException("This is using old journal data, export your data and import at the correct version");
                    }
                    case 45: {
                        Message message = MessagePersister.getInstance().decode(buff, null);
                        messages.put(record.id, message);
                        break;
                    }
                    case 32: {
                        Message message;
                        long messageID = record.id;
                        Object encoding = new RefEncoding();
                        ((QueueEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (LinkedHashMap<Long, AddMessageRecord>)queueMap.get(((RefEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            queueMessages = new LinkedHashMap<Long, AddMessageRecord>();
                            queueMap.put(((RefEncoding)encoding).queueID, queueMessages);
                        }
                        if ((message = (Message)messages.get(messageID)) == null) {
                            ActiveMQServerLogger.LOGGER.cannotFindMessage(record.id);
                            break;
                        }
                        queueMessages.put(messageID, new AddMessageRecord(message));
                        break;
                    }
                    case 33: {
                        long messageID = record.id;
                        Object encoding = new RefEncoding();
                        ((QueueEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((RefEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            ActiveMQServerLogger.LOGGER.journalCannotFindQueue(((RefEncoding)encoding).queueID, messageID);
                            break;
                        }
                        AddMessageRecord rec = (AddMessageRecord)queueMessages.remove(messageID);
                        if (rec != null) break;
                        ActiveMQServerLogger.LOGGER.cannotFindMessage(messageID);
                        break;
                    }
                    case 34: {
                        long messageID = record.id;
                        Object encoding = new DeliveryCountUpdateEncoding();
                        ((DeliveryCountUpdateEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((DeliveryCountUpdateEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            ActiveMQServerLogger.LOGGER.journalCannotFindQueueDelCount(((DeliveryCountUpdateEncoding)encoding).queueID);
                            break;
                        }
                        AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                        if (rec == null) {
                            ActiveMQServerLogger.LOGGER.journalCannotFindMessageDelCount(messageID);
                            break;
                        }
                        rec.setDeliveryCount(((DeliveryCountUpdateEncoding)encoding).count);
                        break;
                    }
                    case 35: {
                        if (record.isUpdate) {
                            PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                            pageUpdate.decode(buff);
                            PageTransactionInfo pageTX = pagingManager.getTransaction(pageUpdate.pageTX);
                            if (pageTX == null) {
                                ActiveMQServerLogger.LOGGER.journalCannotFindPageTX(pageUpdate.pageTX);
                                break;
                            }
                            pageTX.onUpdate(pageUpdate.recods, null, null);
                            break;
                        }
                        PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                        pageTransactionInfo.decode(buff);
                        pageTransactionInfo.setRecordID(record.id);
                        pagingManager.addTransaction(pageTransactionInfo);
                        break;
                    }
                    case 36: {
                        long messageID = record.id;
                        Object encoding = new ScheduledDeliveryEncoding();
                        ((ScheduledDeliveryEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((ScheduledDeliveryEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            ActiveMQServerLogger.LOGGER.journalCannotFindQueueScheduled(((ScheduledDeliveryEncoding)encoding).queueID, messageID);
                            break;
                        }
                        AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                        if (rec == null) {
                            ActiveMQServerLogger.LOGGER.cannotFindMessage(messageID);
                            break;
                        }
                        rec.setScheduledDeliveryTime(((ScheduledDeliveryEncoding)encoding).scheduledDeliveryTime);
                        break;
                    }
                    case 37: {
                        DuplicateIDEncoding encoding = new DuplicateIDEncoding();
                        encoding.decode(buff);
                        List<Pair<byte[], Long>> ids = duplicateIDMap.get(encoding.address);
                        if (ids == null) {
                            ids = new ArrayList<Pair<byte[], Long>>();
                            duplicateIDMap.put(encoding.address, ids);
                        }
                        ids.add((Pair<byte[], Long>)new Pair((Object)encoding.duplID, (Object)record.id));
                        break;
                    }
                    case 38: {
                        HeuristicCompletionEncoding encoding = new HeuristicCompletionEncoding();
                        encoding.decode(buff);
                        resourceManager.putHeuristicCompletion(record.id, encoding.xid, encoding.isCommit);
                        break;
                    }
                    case 39: {
                        CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                        encoding.decode(buff);
                        encoding.position.setRecordID(record.id);
                        PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.reloadACK(encoding.position);
                            break;
                        }
                        ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloading(encoding.queueID);
                        this.messageJournal.appendDeleteRecord(record.id, false);
                        break;
                    }
                    case 40: {
                        PageCountRecord encoding = new PageCountRecord();
                        encoding.decode(buff);
                        PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.getQueueID(), pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.getCounter().loadValue(record.id, encoding.getValue());
                            break;
                        }
                        ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloadingPage(encoding.getQueueID());
                        this.messageJournal.appendDeleteRecord(record.id, false);
                        break;
                    }
                    case 41: {
                        PageCountRecordInc encoding = new PageCountRecordInc();
                        encoding.decode(buff);
                        PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.getQueueID(), pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.getCounter().loadInc(record.id, encoding.getValue());
                            break;
                        }
                        ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloadingPageCursor(encoding.getQueueID());
                        this.messageJournal.appendDeleteRecord(record.id, false);
                        break;
                    }
                    case 42: {
                        CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                        encoding.decode(buff);
                        encoding.position.setRecordID(record.id);
                        PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            if (sub.reloadPageCompletion(encoding.position)) break;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Complete page " + encoding.position.getPageNr() + " doesn't exist on page manager " + sub.getPagingStore().getAddress()));
                            }
                            this.messageJournal.appendDeleteRecord(record.id, false);
                            break;
                        }
                        ActiveMQServerLogger.LOGGER.cantFindQueueOnPageComplete(encoding.queueID);
                        this.messageJournal.appendDeleteRecord(record.id, false);
                        break;
                    }
                    case 43: {
                        PageCountPendingImpl pendingCountEncoding = new PageCountPendingImpl();
                        pendingCountEncoding.decode(buff);
                        pendingCountEncoding.setID(record.id);
                        if (pendingNonTXPageCounter == null) break;
                        pendingNonTXPageCounter.add(pendingCountEncoding);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid record type " + recordType);
                    }
                }
                records.set(reccount, null);
            }
            records.clear();
            records = null;
            journalLoader.handleAddMessage(queueMap);
            this.loadPreparedTransactions(postOffice, pagingManager, resourceManager, queueInfos, preparedTransactions, duplicateIDMap, pageSubscriptions, pendingLargeMessages, journalLoader);
            for (PageSubscription sub : pageSubscriptions.values()) {
                sub.getCounter().processReload();
            }
            for (LargeServerMessage msg : largeMessages) {
                if (msg.getRefCount() != 0) continue;
                ActiveMQServerLogger.LOGGER.largeMessageWithNoRef(msg.getMessageID());
                msg.decrementDelayDeletionCount();
            }
            journalLoader.handleNoMessageReferences(messages);
            if (pagingManager != null) {
                pagingManager.processReload();
            }
            journalLoader.postLoad(this.messageJournal, resourceManager, duplicateIDMap);
            this.journalLoaded = true;
            Iterator<Object> iterator = info;
            return iterator;
        }
        finally {
            this.readUnLock();
        }
    }

    private static PageSubscription locateSubscription(long queueID, Map<Long, PageSubscription> pageSubscriptions, Map<Long, QueueBindingInfo> queueInfos, PagingManager pagingManager) throws Exception {
        QueueBindingInfo queueInfo;
        PageSubscription subs = pageSubscriptions.get(queueID);
        if (subs == null && (queueInfo = queueInfos.get(queueID)) != null) {
            SimpleString address = queueInfo.getAddress();
            PagingStore store = pagingManager.getPageStore(address);
            subs = store.getCursorProvider().getSubscription(queueID);
            pageSubscriptions.put(queueID, subs);
        }
        return subs;
    }

    @Override
    public void addGrouping(GroupBinding groupBinding) throws Exception {
        GroupingEncoding groupingEncoding = new GroupingEncoding(groupBinding.getId(), groupBinding.getGroupId(), groupBinding.getClusterName());
        this.readLock();
        try {
            this.bindingsJournal.appendAddRecord(groupBinding.getId(), (byte)20, (EncodingSupport)groupingEncoding, true);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGrouping(long tx, GroupBinding groupBinding) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendDeleteRecordTransactional(tx, groupBinding.getId());
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueueBinding(long tx, Binding binding) throws Exception {
        Queue queue = (Queue)binding.getBindable();
        Filter filter = queue.getFilter();
        SimpleString filterString = filter == null ? null : filter.getFilterString();
        PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding(queue.getName(), binding.getAddress(), filterString, queue.getUser(), queue.isAutoCreated(), queue.getMaxConsumers(), queue.isPurgeOnNoConsumers(), queue.getRoutingType().getType());
        this.readLock();
        try {
            this.bindingsJournal.appendAddRecordTransactional(tx, binding.getID(), (byte)21, (EncodingSupport)bindingEncoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueueBinding(long tx, long queueBindingID) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendDeleteRecordTransactional(tx, queueBindingID);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storeQueueStatus(long queueID, QueueStatus status) throws Exception {
        long recordID = this.idGenerator.generateID();
        this.readLock();
        try {
            this.bindingsJournal.appendAddRecord(recordID, (byte)22, (EncodingSupport)new QueueStatusEncoding(queueID, status), true);
        }
        finally {
            this.readUnLock();
        }
        return recordID;
    }

    @Override
    public void deleteQueueStatus(long recordID) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendDeleteRecord(recordID, true);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAddressBinding(long tx, AddressInfo addressInfo) throws Exception {
        PersistentAddressBindingEncoding bindingEncoding = new PersistentAddressBindingEncoding(addressInfo.getName(), addressInfo.getRoutingTypes(), addressInfo.isAutoCreated());
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            bindingEncoding.setId(recordID);
            addressInfo.setId(recordID);
            this.bindingsJournal.appendAddRecordTransactional(tx, recordID, (byte)44, (EncodingSupport)bindingEncoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressBinding(long tx, long addressBindingID) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendDeleteRecordTransactional(tx, addressBindingID);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storePageCounterInc(long txID, long queueID, int value) throws Exception {
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)41, (EncodingSupport)new PageCountRecordInc(queueID, value));
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storePageCounterInc(long queueID, int value) throws Exception {
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecord(recordID, (byte)41, (EncodingSupport)new PageCountRecordInc(queueID, value), true, (IOCompletion)this.getContext());
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storePageCounter(long txID, long queueID, long value) throws Exception {
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)40, (EncodingSupport)new PageCountRecord(queueID, value));
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storePendingCounter(long queueID, long pageID, int inc) throws Exception {
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            PageCountPendingImpl pendingInc = new PageCountPendingImpl(queueID, pageID, inc);
            this.messageJournal.appendAddRecord(recordID, (byte)43, (EncodingSupport)pendingInc, true);
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIncrementRecord(long txID, long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePageCounter(long txID, long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePendingPageCounter(long txID, long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos, List<AddressBindingInfo> addressBindingInfos) throws Exception {
        ArrayList records = new ArrayList();
        ArrayList preparedTransactions = new ArrayList();
        JournalLoadInformation bindingsInfo = this.bindingsJournal.load(records, preparedTransactions, null);
        HashMap<Long, PersistentQueueBindingEncoding> mapBindings = new HashMap<Long, PersistentQueueBindingEncoding>();
        for (RecordInfo record : records) {
            EncodingSupport bindingEncoding;
            long id = record.id;
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])record.data);
            byte rec = record.getUserRecordType();
            if (rec == 21) {
                bindingEncoding = AbstractJournalStorageManager.newQueueBindingEncoding(id, buffer);
                queueBindingInfos.add((QueueBindingInfo)bindingEncoding);
                mapBindings.put(bindingEncoding.getId(), (PersistentQueueBindingEncoding)bindingEncoding);
                continue;
            }
            if (rec == 24) {
                this.idGenerator.loadState(record.id, buffer);
                continue;
            }
            if (rec == 44) {
                bindingEncoding = AbstractJournalStorageManager.newAddressBindingEncoding(id, buffer);
                addressBindingInfos.add((AddressBindingInfo)bindingEncoding);
                continue;
            }
            if (rec == 20) {
                GroupingEncoding encoding = AbstractJournalStorageManager.newGroupEncoding(id, buffer);
                groupingInfos.add(encoding);
                continue;
            }
            if (rec == 25) {
                PersistedAddressSetting setting = AbstractJournalStorageManager.newAddressEncoding(id, buffer);
                this.mapPersistedAddressSettings.put(setting.getAddressMatch(), setting);
                continue;
            }
            if (rec == 26) {
                PersistedRoles roles = AbstractJournalStorageManager.newSecurityRecord(id, buffer);
                this.mapPersistedRoles.put(roles.getAddressMatch(), roles);
                continue;
            }
            if (rec == 22) {
                QueueStatusEncoding statusEncoding = AbstractJournalStorageManager.newQueueStatusEncoding(id, buffer);
                PersistentQueueBindingEncoding queueBindingEncoding = (PersistentQueueBindingEncoding)mapBindings.get(statusEncoding.queueID);
                if (queueBindingEncoding != null) {
                    queueBindingEncoding.addQueueStatusEncoding(statusEncoding);
                    continue;
                }
                logger.info((Object)("There is no queue with ID " + statusEncoding.queueID + ", deleting record " + statusEncoding.getId()));
                this.deleteQueueStatus(statusEncoding.getId());
                continue;
            }
            logger.warn((Object)("Invalid record type " + rec), (Throwable)new Exception("invalid record type " + rec));
        }
        mapBindings.clear();
        this.idGenerator.cleanup();
        return bindingsInfo;
    }

    @Override
    public void lineUpContext() {
        this.readLock();
        try {
            this.messageJournal.lineUpContext((IOCompletion)this.getContext());
        }
        finally {
            this.readUnLock();
        }
    }

    protected abstract void beforeStart() throws Exception;

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.beforeStart();
        this.singleThreadExecutor = this.executorFactory.getExecutor();
        this.bindingsJournal.start();
        this.messageJournal.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.stop(false, true);
    }

    @Override
    public synchronized void persistIdGenerator() {
        if (this.journalLoaded && this.idGenerator != null) {
            this.idGenerator.persistCurrentID();
        }
    }

    protected abstract void performCachedLargeMessageDeletes();

    @Override
    public synchronized void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        if (!this.started) {
            return;
        }
        if (!ioCriticalError) {
            this.performCachedLargeMessageDeletes();
            if (this.journalLoaded && this.idGenerator != null) {
                this.idGenerator.persistCurrentID();
            }
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await(30L, TimeUnit.SECONDS);
        this.beforeStop();
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.journalLoaded = false;
        this.started = false;
    }

    protected abstract void beforeStop() throws Exception;

    public synchronized boolean isStarted() {
        return this.started;
    }

    public JournalLoadInformation[] loadInternalOnly() throws Exception {
        this.readLock();
        try {
            JournalLoadInformation[] info = new JournalLoadInformation[]{this.bindingsJournal.loadInternalOnly(), this.messageJournal.loadInternalOnly()};
            JournalLoadInformation[] journalLoadInformationArray = info;
            return journalLoadInformationArray;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void beforePageRead() throws Exception {
        if (this.pageMaxConcurrentIO != null) {
            this.pageMaxConcurrentIO.acquire();
        }
    }

    @Override
    public void afterPageRead() throws Exception {
        if (this.pageMaxConcurrentIO != null) {
            this.pageMaxConcurrentIO.release();
        }
    }

    @Override
    public Journal getMessageJournal() {
        return this.messageJournal;
    }

    @Override
    public Journal getBindingsJournal() {
        return this.bindingsJournal;
    }

    protected void confirmLargeMessage(LargeServerMessage largeServerMessage) {
        if (largeServerMessage.getPendingRecordID() >= 0L) {
            try {
                this.confirmPendingLargeMessage(largeServerMessage.getPendingRecordID());
                largeServerMessage.setPendingRecordID(-1L);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            }
        }
    }

    protected abstract LargeServerMessage parseLargeMessage(Map<Long, Message> var1, ActiveMQBuffer var2) throws Exception;

    private void loadPreparedTransactions(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, QueueBindingInfo> queueInfos, List<PreparedTransactionInfo> preparedTransactions, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Map<Long, PageSubscription> pageSubscriptions, Set<Pair<Long, Long>> pendingLargeMessages, JournalLoader journalLoader) throws Exception {
        for (PreparedTransactionInfo preparedTransaction : preparedTransactions) {
            ActiveMQBuffer buff;
            byte[] data;
            XidEncoding encodingXid = new XidEncoding(preparedTransaction.getExtraData());
            Xid xid = encodingXid.xid;
            TransactionImpl tx = new TransactionImpl(preparedTransaction.getId(), xid, this);
            ArrayList<MessageReference> referencesToAck = new ArrayList<MessageReference>();
            HashMap<Long, Message> messages = new HashMap<Long, Message>();
            block17: for (RecordInfo record : preparedTransaction.getRecords()) {
                data = record.data;
                buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
                byte recordType = record.getUserRecordType();
                switch (recordType) {
                    case 30: {
                        messages.put(record.id, (Message)this.parseLargeMessage(messages, buff));
                        continue block17;
                    }
                    case 31: {
                        continue block17;
                    }
                    case 45: {
                        Message message = MessagePersister.getInstance().decode(buff, null);
                        messages.put(record.id, message);
                        continue block17;
                    }
                    case 32: {
                        long messageID = record.id;
                        RefEncoding encoding = new RefEncoding();
                        encoding.decode(buff);
                        Message message = (Message)messages.get(messageID);
                        if (message == null) {
                            throw new IllegalStateException("Cannot find message with id " + messageID);
                        }
                        journalLoader.handlePreparedSendMessage(message, tx, encoding.queueID);
                        continue block17;
                    }
                    case 33: {
                        long messageID = record.id;
                        RefEncoding encoding = new RefEncoding();
                        encoding.decode(buff);
                        journalLoader.handlePreparedAcknowledge(messageID, referencesToAck, encoding.queueID);
                        continue block17;
                    }
                    case 35: {
                        PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                        pageTransactionInfo.decode(buff);
                        if (record.isUpdate) {
                            PageTransactionInfo pgTX = pagingManager.getTransaction(pageTransactionInfo.getTransactionID());
                            pgTX.reloadUpdate(this, pagingManager, tx, pageTransactionInfo.getNumberOfMessages());
                            continue block17;
                        }
                        pageTransactionInfo.setCommitted(false);
                        tx.putProperty(5, pageTransactionInfo);
                        pagingManager.addTransaction(pageTransactionInfo);
                        tx.addOperation(new FinishPageMessageOperation());
                        continue block17;
                    }
                    case 36: {
                        continue block17;
                    }
                    case 37: {
                        Object encoding = new DuplicateIDEncoding();
                        ((DuplicateIDEncoding)encoding).decode(buff);
                        DuplicateIDCache cache = postOffice.getDuplicateIDCache(((DuplicateIDEncoding)encoding).address);
                        cache.load(tx, ((DuplicateIDEncoding)encoding).duplID);
                        continue block17;
                    }
                    case 39: {
                        Object encoding = new CursorAckRecordEncoding();
                        ((CursorAckRecordEncoding)encoding).decode(buff);
                        ((CursorAckRecordEncoding)encoding).position.setRecordID(record.id);
                        PageSubscription sub = AbstractJournalStorageManager.locateSubscription(((CursorAckRecordEncoding)encoding).queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.reloadPreparedACK(tx, ((CursorAckRecordEncoding)encoding).position);
                            referencesToAck.add(new PagedReferenceImpl(((CursorAckRecordEncoding)encoding).position, null, sub));
                            continue block17;
                        }
                        ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloadingACK(((CursorAckRecordEncoding)encoding).queueID);
                        continue block17;
                    }
                    case 40: {
                        ActiveMQServerLogger.LOGGER.journalPAGEOnPrepared();
                        continue block17;
                    }
                    case 41: {
                        Object encoding = new PageCountRecordInc();
                        ((PageCountRecordInc)encoding).decode(buff);
                        PageSubscription sub = AbstractJournalStorageManager.locateSubscription(((PageCountRecordInc)encoding).getQueueID(), pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.getCounter().applyIncrementOnTX(tx, record.id, ((PageCountRecordInc)encoding).getValue());
                            sub.notEmpty();
                            continue block17;
                        }
                        ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloadingACK(((PageCountRecordInc)encoding).getQueueID());
                        continue block17;
                    }
                }
                ActiveMQServerLogger.LOGGER.journalInvalidRecordType(recordType);
            }
            block18: for (RecordInfo recordDeleted : preparedTransaction.getRecordsToDelete()) {
                data = recordDeleted.data;
                if (data.length <= 0) continue;
                buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
                byte b = buff.readByte();
                switch (b) {
                    case 29: {
                        long messageID = buff.readLong();
                        if (!pendingLargeMessages.remove(new Pair((Object)recordDeleted.id, (Object)messageID))) {
                            ActiveMQServerLogger.LOGGER.largeMessageNotFound(recordDeleted.id);
                        }
                        this.installLargeMessageConfirmationOnTX(tx, recordDeleted.id);
                        continue block18;
                    }
                }
                ActiveMQServerLogger.LOGGER.journalInvalidRecordTypeOnPreparedTX(b);
            }
            journalLoader.handlePreparedTransaction(tx, referencesToAck, xid, resourceManager);
        }
    }

    OperationContext getContext(boolean sync) {
        if (sync) {
            return this.getContext();
        }
        return DummyOperationContext.getInstance();
    }

    protected static PersistedRoles newSecurityRecord(long id, ActiveMQBuffer buffer) {
        PersistedRoles roles = new PersistedRoles();
        roles.decode(buffer);
        roles.setStoreId(id);
        return roles;
    }

    static PersistedAddressSetting newAddressEncoding(long id, ActiveMQBuffer buffer) {
        PersistedAddressSetting setting = new PersistedAddressSetting();
        setting.decode(buffer);
        setting.setStoreId(id);
        return setting;
    }

    static GroupingEncoding newGroupEncoding(long id, ActiveMQBuffer buffer) {
        GroupingEncoding encoding = new GroupingEncoding();
        encoding.decode(buffer);
        encoding.setId(id);
        return encoding;
    }

    protected static PersistentQueueBindingEncoding newQueueBindingEncoding(long id, ActiveMQBuffer buffer) {
        PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding();
        bindingEncoding.decode(buffer);
        bindingEncoding.setId(id);
        return bindingEncoding;
    }

    protected static QueueStatusEncoding newQueueStatusEncoding(long id, ActiveMQBuffer buffer) {
        QueueStatusEncoding statusEncoding = new QueueStatusEncoding();
        statusEncoding.decode(buffer);
        statusEncoding.setId(id);
        return statusEncoding;
    }

    protected static PersistentAddressBindingEncoding newAddressBindingEncoding(long id, ActiveMQBuffer buffer) {
        PersistentAddressBindingEncoding bindingEncoding = new PersistentAddressBindingEncoding();
        bindingEncoding.decode(buffer);
        bindingEncoding.setId(id);
        return bindingEncoding;
    }

    @Override
    public boolean addToPage(PagingStore store, Message msg, Transaction tx, RouteContextList listCtx) throws Exception {
        return store.page(msg, tx, listCtx, this.storageManagerLock.readLock());
    }

    private void installLargeMessageConfirmationOnTX(Transaction tx, long recordID) {
        TXLargeMessageConfirmationOperation txoper = (TXLargeMessageConfirmationOperation)tx.getProperty(1);
        if (txoper == null) {
            txoper = new TXLargeMessageConfirmationOperation(this);
            tx.putProperty(1, txoper);
        }
        txoper.confirmedMessages.add(recordID);
    }

    private static final class DummyOperationContext
    implements OperationContext {
        private static DummyOperationContext instance = new DummyOperationContext();

        private DummyOperationContext() {
        }

        public static OperationContext getInstance() {
            return instance;
        }

        @Override
        public void executeOnCompletion(IOCallback runnable) {
            runnable.done();
        }

        @Override
        public void executeOnCompletion(IOCallback runnable, boolean storeOnly) {
            this.executeOnCompletion(runnable);
        }

        @Override
        public void replicationDone() {
        }

        @Override
        public void replicationLineUp() {
        }

        public void storeLineUp() {
        }

        public void done() {
        }

        public void onError(int errorCode, String errorMessage) {
        }

        @Override
        public void waitCompletion() {
        }

        @Override
        public boolean waitCompletion(long timeout) {
            return true;
        }

        @Override
        public void pageSyncLineUp() {
        }

        @Override
        public void pageSyncDone() {
        }
    }

    public static enum JournalContent {
        BINDINGS(0),
        MESSAGES(1);

        public final byte typeByte;

        private JournalContent(byte b) {
            this.typeByte = b;
        }

        public static JournalContent getType(byte type) {
            if (JournalContent.MESSAGES.typeByte == type) {
                return MESSAGES;
            }
            if (JournalContent.BINDINGS.typeByte == type) {
                return BINDINGS;
            }
            throw new InvalidParameterException("invalid byte: " + type);
        }
    }
}

