/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;

public class WildcardConfiguration
implements Serializable {
    static final char SINGLE_WORD = '*';
    static final char ANY_WORDS = '#';
    static final char DELIMITER = '.';
    boolean enabled = true;
    char singleWord = (char)42;
    char anyWords = (char)35;
    char delimiter = (char)46;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WildcardConfiguration)) {
            return false;
        }
        WildcardConfiguration that = (WildcardConfiguration)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.singleWord != that.singleWord) {
            return false;
        }
        if (this.anyWords != that.anyWords) {
            return false;
        }
        return this.delimiter == that.delimiter;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + this.singleWord;
        result = 31 * result + this.anyWords;
        result = 31 * result + this.delimiter;
        return result;
    }

    public String toString() {
        return "WildcardConfiguration{anyWords=" + this.anyWords + ", enabled=" + this.enabled + ", singleWord=" + this.singleWord + ", delimiter=" + this.delimiter + '}';
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public char getAnyWords() {
        return this.anyWords;
    }

    public void setAnyWords(char anyWords) {
        this.anyWords = anyWords;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getSingleWord() {
        return this.singleWord;
    }

    public void setSingleWord(char singleWord) {
        this.singleWord = singleWord;
    }

    public String convert(String filter, WildcardConfiguration to) {
        return filter.replace(this.getDelimiter(), to.getDelimiter()).replace(this.getSingleWord(), to.getSingleWord()).replace(this.getAnyWords(), to.getAnyWords());
    }
}

