/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToLongFunction;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNullRefException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ScheduledDeliveryHandler;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.Redistributor;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.BucketMessageGroups;
import org.apache.activemq.artemis.core.server.impl.DisabledMessageGroups;
import org.apache.activemq.artemis.core.server.impl.GroupFirstMessageReference;
import org.apache.activemq.artemis.core.server.impl.MessageGroups;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.server.impl.QueueConsumers;
import org.apache.activemq.artemis.core.server.impl.QueueConsumersImpl;
import org.apache.activemq.artemis.core.server.impl.QueueMessageMetrics;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.impl.SimpleMessageGroups;
import org.apache.activemq.artemis.core.server.impl.TransientQueueManagerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.BindingsTransactionImpl;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.BooleanUtil;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedList;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedListImpl;
import org.apache.activemq.artemis.utils.collections.SingletonIterator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.jboss.logging.Logger;
import org.jctools.queues.MpscUnboundedArrayQueue;

public class QueueImpl
extends CriticalComponentImpl
implements Queue {
    protected static final int CRITICAL_PATHS = 5;
    protected static final int CRITICAL_PATH_ADD_TAIL = 0;
    protected static final int CRITICAL_PATH_ADD_HEAD = 1;
    protected static final int CRITICAL_DELIVER = 2;
    protected static final int CRITICAL_CONSUMER = 3;
    protected static final int CRITICAL_CHECK_DEPAGE = 4;
    private static final Logger logger = Logger.getLogger(QueueImpl.class);
    private static final AtomicIntegerFieldUpdater<QueueImpl> dispatchingUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueImpl.class, "dispatching");
    private static final AtomicLongFieldUpdater<QueueImpl> dispatchStartTimeUpdater = AtomicLongFieldUpdater.newUpdater(QueueImpl.class, "dispatchStartTime");
    private static final AtomicLongFieldUpdater<QueueImpl> consumerRemovedTimestampUpdater = AtomicLongFieldUpdater.newUpdater(QueueImpl.class, "consumerRemovedTimestamp");
    private static final AtomicReferenceFieldUpdater<QueueImpl, Filter> filterUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueImpl.class, Filter.class, "filter");
    public static final int REDISTRIBUTOR_BATCH_SIZE = 100;
    public static final int NUM_PRIORITIES = 10;
    public static final int MAX_DELIVERIES_IN_LOOP = 1000;
    public static final int CHECK_QUEUE_SIZE_PERIOD = 1000;
    public static final int DELIVERY_TIMEOUT = 1000;
    public static final int DEFAULT_FLUSH_LIMIT = 500;
    private final Long id;
    private final SimpleString name;
    private SimpleString user;
    private volatile Filter filter;
    private final boolean propertyDurable;
    private final boolean temporary;
    private final boolean autoCreated;
    private final PostOffice postOffice;
    private volatile boolean queueDestroyed = false;
    private final PagingStore pagingStore;
    protected final PageSubscription pageSubscription;
    private ReferenceCounter refCountForConsumers;
    private final PageIterator pageIterator;
    private volatile boolean printErrorExpiring = false;
    private boolean mirrorController;
    private final MpscUnboundedArrayQueue<MessageReference> intermediateMessageReferences = new MpscUnboundedArrayQueue(8192);
    private final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl(10, MessageReferenceImpl.getIDComparator());
    private ToLongFunction<MessageReference> idSupplier;
    private final AtomicInteger pagedReferences = new AtomicInteger(0);
    private final AtomicInteger queueMemorySize = new AtomicInteger(0);
    protected final QueueMessageMetrics pendingMetrics = new QueueMessageMetrics(this, "pending");
    private final QueueMessageMetrics deliveringMetrics = new QueueMessageMetrics(this, "delivering");
    protected final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private AtomicLong messagesAdded = new AtomicLong(0L);
    private AtomicLong messagesAcknowledged = new AtomicLong(0L);
    private AtomicLong ackAttempts = new AtomicLong(0L);
    private AtomicLong messagesExpired = new AtomicLong(0L);
    private AtomicLong messagesKilled = new AtomicLong(0L);
    private AtomicLong messagesReplaced = new AtomicLong(0L);
    private boolean paused;
    private long pauseStatusRecord = -1L;
    private static final int MAX_SCHEDULED_RUNNERS = 1;
    private static final int MAX_DEPAGE_NUM = 1000;
    private final AtomicInteger scheduledRunners = new AtomicInteger(0);
    private final Runnable deliverRunner = new DeliverRunner();
    private final ReentrantLock deliverLock = new ReentrantLock();
    private final ReentrantLock depageLock = new ReentrantLock();
    private volatile boolean depagePending = false;
    private final StorageManager storageManager;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ActiveMQServer server;
    private final ScheduledExecutorService scheduledExecutor;
    private final SimpleString address;
    private ConsumerHolder<Redistributor> redistributor;
    private ScheduledFuture<?> redistributorFuture;
    private volatile long consumerRemovedTimestamp = -1L;
    private final QueueConsumers<ConsumerHolder<? extends Consumer>> consumers = new QueueConsumersImpl<ConsumerHolder<? extends Consumer>>();
    private volatile boolean groupRebalance;
    private volatile boolean groupRebalancePauseDispatch;
    private volatile int groupBuckets;
    private volatile SimpleString groupFirstKey;
    private MessageGroups<Consumer> groups;
    private volatile Consumer exclusiveConsumer;
    private volatile SimpleString expiryAddress;
    private final ArtemisExecutor executor;
    private boolean internalQueue;
    private volatile long lastDirectDeliveryCheck = 0L;
    private volatile boolean directDeliver = true;
    private volatile boolean supportsDirectDeliver = false;
    private AddressSettingsRepositoryListener addressSettingsRepositoryListener;
    private final ExpiryScanner expiryScanner = new ExpiryScanner();
    private final ReusableLatch deliveriesInTransit = new ReusableLatch(0);
    private final AtomicLong queueRateCheckTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong messagesAddedSnapshot = new AtomicLong(0L);
    private ScheduledFuture slowConsumerReaperFuture;
    private SlowConsumerReaperRunnable slowConsumerReaperRunnable;
    private volatile int maxConsumers;
    private volatile boolean exclusive;
    private volatile boolean purgeOnNoConsumers;
    private volatile boolean enabled;
    private final AddressInfo addressInfo;
    private volatile RoutingType routingType;
    private final QueueFactory factory;
    public volatile int dispatching = 0;
    public volatile long dispatchStartTime = -1L;
    private volatile int consumersBeforeDispatch = 0;
    private volatile long delayBeforeDispatch = 0L;
    private final boolean autoDelete;
    private final long autoDeleteDelay;
    private final long autoDeleteMessageCount;
    private volatile boolean configurationManaged;
    private volatile boolean nonDestructive;
    private volatile long ringSize;
    private final Object directDeliveryGuard = new Object();
    private final ConcurrentHashSet<String> lingerSessionIds = new ConcurrentHashSet();

    private void checkIDSupplier(ToLongFunction<MessageReference> idSupplier) {
        if (this.idSupplier != idSupplier) {
            this.idSupplier = idSupplier;
            this.messageReferences.setIDSupplier(idSupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("queueMemorySize=" + this.queueMemorySize);
        for (ConsumerHolder queueImpl : this.consumers) {
            out.println("consumer: " + queueImpl.consumer.debug());
        }
        out.println("Intermediate reference size is " + this.intermediateMessageReferences.size());
        boolean foundRef = false;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            LinkedListIterator iter = this.messageReferences.iterator();
            while (iter.hasNext()) {
                foundRef = true;
                out.println("reference = " + iter.next());
            }
        }
        if (!foundRef) {
            out.println("No permanent references on queue");
        }
        System.out.println(str.toString());
        return str.toString();
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, null, null, user, durable, temporary, autoCreated, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, RoutingType.MULTICAST, null, null, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, null, purgeOnNoConsumers, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean purgeOnNoConsumers, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, exclusive, null, null, false, null, null, purgeOnNoConsumers, null, null, null, false, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean purgeOnNoConsumers, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean configurationManaged, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, exclusive, groupRebalance, groupBuckets, null, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, purgeOnNoConsumers, autoDelete, autoDeleteDelay, autoDeleteMessageCount, configurationManaged, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean purgeOnNoConsumers, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean configurationManaged, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, purgeOnNoConsumers, autoDelete, autoDeleteDelay, autoDeleteMessageCount, configurationManaged, null, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean purgeOnNoConsumers, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean configurationManaged, Long ringSize, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(new QueueConfiguration(name).setId(Long.valueOf(id)).setAddress(address).setFilterString(filter == null ? null : filter.getFilterString()).setUser(user).setDurable(Boolean.valueOf(durable)).setTemporary(Boolean.valueOf(temporary)).setAutoCreated(Boolean.valueOf(autoCreated)).setRoutingType(routingType).setMaxConsumers(maxConsumers).setExclusive(exclusive).setGroupRebalance(groupRebalance).setGroupBuckets(groupBuckets).setGroupFirstKey(groupFirstKey).setNonDestructive(nonDestructive).setConsumersBeforeDispatch(consumersBeforeDispatch).setDelayBeforeDispatch(delayBeforeDispatch).setPurgeOnNoConsumers(purgeOnNoConsumers).setAutoDelete(autoDelete).setAutoDeleteDelay(autoDeleteDelay).setAutoDeleteMessageCount(autoDeleteMessageCount).setConfigurationManaged(Boolean.valueOf(configurationManaged)).setRingSize(ringSize), pagingStore, pageSubscription, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
        this.filter = filter;
    }

    public QueueImpl(QueueConfiguration queueConfiguration, PagingStore pagingStore, PageSubscription pageSubscription, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        super((CriticalAnalyzer)(server == null ? EmptyCriticalAnalyzer.getInstance() : server.getCriticalAnalyzer()), 5);
        this.id = queueConfiguration.getId();
        this.address = queueConfiguration.getAddress();
        this.addressInfo = postOffice == null ? null : postOffice.getAddressInfo(this.address);
        this.routingType = queueConfiguration.getRoutingType();
        this.name = queueConfiguration.getName();
        try {
            this.filter = this.filter == null ? FilterImpl.createFilter(queueConfiguration.getFilterString()) : this.filter;
        }
        catch (ActiveMQException e) {
            throw new RuntimeException(e);
        }
        this.pagingStore = pagingStore;
        this.pageSubscription = pageSubscription;
        this.propertyDurable = queueConfiguration.isDurable();
        this.temporary = queueConfiguration.isTemporary();
        this.autoCreated = queueConfiguration.isAutoCreated();
        this.maxConsumers = queueConfiguration.getMaxConsumers() == null ? ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers() : queueConfiguration.getMaxConsumers();
        this.exclusive = queueConfiguration.isExclusive() == null ? ActiveMQDefaultConfiguration.getDefaultExclusive() : queueConfiguration.isExclusive();
        this.nonDestructive = queueConfiguration.isNonDestructive() == null ? ActiveMQDefaultConfiguration.getDefaultNonDestructive() : queueConfiguration.isNonDestructive();
        this.purgeOnNoConsumers = queueConfiguration.isPurgeOnNoConsumers() == null ? ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers() : queueConfiguration.isPurgeOnNoConsumers();
        this.enabled = queueConfiguration.isEnabled() == null ? ActiveMQDefaultConfiguration.getDefaultEnabled() : queueConfiguration.isEnabled();
        this.consumersBeforeDispatch = queueConfiguration.getConsumersBeforeDispatch() == null ? ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch() : queueConfiguration.getConsumersBeforeDispatch();
        this.delayBeforeDispatch = queueConfiguration.getDelayBeforeDispatch() == null ? ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch() : queueConfiguration.getDelayBeforeDispatch();
        this.groupRebalance = queueConfiguration.isGroupRebalance() == null ? ActiveMQDefaultConfiguration.getDefaultGroupRebalance() : queueConfiguration.isGroupRebalance();
        this.groupRebalancePauseDispatch = queueConfiguration.isGroupRebalancePauseDispatch() == null ? ActiveMQDefaultConfiguration.getDefaultGroupRebalancePauseDispatch() : queueConfiguration.isGroupRebalancePauseDispatch();
        this.groupBuckets = queueConfiguration.getGroupBuckets() == null ? ActiveMQDefaultConfiguration.getDefaultGroupBuckets() : queueConfiguration.getGroupBuckets();
        this.groups = QueueImpl.groupMap(this.groupBuckets);
        this.groupFirstKey = queueConfiguration.getGroupFirstKey() == null ? ActiveMQDefaultConfiguration.getDefaultGroupFirstKey() : queueConfiguration.getGroupFirstKey();
        this.autoDelete = queueConfiguration.isAutoDelete() == null ? ActiveMQDefaultConfiguration.getDefaultQueueAutoDelete((boolean)this.autoCreated) : queueConfiguration.isAutoDelete();
        this.autoDeleteDelay = queueConfiguration.getAutoDeleteDelay() == null ? ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteDelay() : queueConfiguration.getAutoDeleteDelay();
        this.autoDeleteMessageCount = queueConfiguration.getAutoDeleteMessageCount() == null ? ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteMessageCount() : queueConfiguration.getAutoDeleteMessageCount();
        this.configurationManaged = queueConfiguration.isConfigurationManaged();
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.server = server;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor, this);
        if (addressSettingsRepository != null) {
            this.addressSettingsRepositoryListener = new AddressSettingsRepositoryListener();
            addressSettingsRepository.registerListener(this.addressSettingsRepositoryListener);
        } else {
            this.expiryAddress = null;
        }
        if (pageSubscription != null) {
            pageSubscription.setQueue(this);
            this.pageIterator = pageSubscription.iterator();
        } else {
            this.pageIterator = null;
        }
        this.executor = executor;
        this.user = queueConfiguration.getUser();
        this.factory = factory;
        if (this.addressInfo != null && this.addressInfo.isPaused()) {
            this.pause(false);
        }
        this.ringSize = queueConfiguration.getRingSize() == null ? ActiveMQDefaultConfiguration.getDefaultRingSize() : queueConfiguration.getRingSize();
    }

    @Override
    public boolean allowsReferenceCallback() {
        return !this.nonDestructive;
    }

    @Override
    public boolean isMirrorController() {
        return this.mirrorController;
    }

    @Override
    public void setMirrorController(boolean mirrorController) {
        this.mirrorController = mirrorController;
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    @Override
    public SimpleString getUser() {
        return this.user;
    }

    @Override
    public void setUser(SimpleString user) {
        this.user = user;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public synchronized void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        if (!exclusive) {
            this.exclusiveConsumer = null;
        }
    }

    @Override
    public int getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    @Override
    public synchronized void setConsumersBeforeDispatch(int consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
    }

    @Override
    public long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    @Override
    public synchronized void setDelayBeforeDispatch(long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
    }

    @Override
    public long getDispatchStartTime() {
        return dispatchStartTimeUpdater.get(this);
    }

    @Override
    public boolean isDispatching() {
        return BooleanUtil.toBoolean((int)dispatchingUpdater.get(this));
    }

    @Override
    public synchronized void setDispatching(boolean dispatching) {
        if (dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((!dispatching ? 1 : 0) != 0), BooleanUtil.toInt((boolean)dispatching))) {
            if (dispatching) {
                dispatchStartTimeUpdater.set(this, System.currentTimeMillis());
            } else {
                dispatchStartTimeUpdater.set(this, -1L);
            }
        }
    }

    @Override
    public boolean isLastValue() {
        return false;
    }

    @Override
    public SimpleString getLastValueKey() {
        return null;
    }

    @Override
    public boolean isNonDestructive() {
        return this.nonDestructive;
    }

    @Override
    public synchronized void setNonDestructive(boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (!this.enabled) {
            context.setReusable(false);
            return;
        }
        if (this.purgeOnNoConsumers) {
            context.setReusable(false);
            if (this.getConsumerCount() == 0) {
                return;
            }
        }
        context.addQueue(this.address, this);
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) {
        context.addQueueWithAck(this.address, this);
    }

    @Override
    public synchronized void setConsumersRefCount(ReferenceCounter referenceCounter) {
        if (this.refCountForConsumers == null) {
            this.refCountForConsumers = referenceCounter;
        }
    }

    @Override
    public ReferenceCounter getConsumersRefCount() {
        return this.refCountForConsumers;
    }

    @Override
    public boolean isDurable() {
        return this.propertyDurable;
    }

    @Override
    public boolean isDurableMessage() {
        return this.propertyDurable && !this.purgeOnNoConsumers;
    }

    @Override
    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    @Override
    public long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    @Override
    public long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    @Override
    public synchronized void setPurgeOnNoConsumers(boolean value) {
        this.purgeOnNoConsumers = value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    @Override
    public synchronized void setMaxConsumer(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    @Override
    public int getGroupBuckets() {
        return this.groupBuckets;
    }

    @Override
    public synchronized void setGroupBuckets(int groupBuckets) {
        if (this.groupBuckets != groupBuckets) {
            this.groups = QueueImpl.groupMap(groupBuckets);
            this.groupBuckets = groupBuckets;
        }
    }

    @Override
    public boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    @Override
    public synchronized void setGroupRebalance(boolean groupRebalance) {
        this.groupRebalance = groupRebalance;
    }

    @Override
    public boolean isGroupRebalancePauseDispatch() {
        return this.groupRebalancePauseDispatch;
    }

    @Override
    public synchronized void setGroupRebalancePauseDispatch(boolean groupRebalancePauseDispatch) {
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
    }

    @Override
    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    @Override
    public synchronized void setGroupFirstKey(SimpleString groupFirstKey) {
        this.groupFirstKey = groupFirstKey;
    }

    @Override
    public boolean isConfigurationManaged() {
        return this.configurationManaged;
    }

    @Override
    public synchronized void setConfigurationManaged(boolean configurationManaged) {
        this.configurationManaged = configurationManaged;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public int durableUp(Message message) {
        return message.durableUp();
    }

    @Override
    public int durableDown(Message message) {
        return message.durableDown();
    }

    @Override
    public void refUp(MessageReference messageReference) {
        int count = messageReference.getMessage().refUp();
        if (count == 1 && messageReference.getOwner() != null) {
            messageReference.getOwner().addSize(messageReference.getMessageMemoryEstimate());
        }
        if (this.pagingStore != null) {
            this.pagingStore.refUp(messageReference.getMessage(), count);
        }
    }

    @Override
    public void refDown(MessageReference messageReference) {
        int count = messageReference.getMessage().refDown();
        if (count == 0 && messageReference.getOwner() != null) {
            messageReference.getOwner().addSize(-messageReference.getMessageMemoryEstimate());
        }
        if (this.pagingStore != null) {
            this.pagingStore.refDown(messageReference.getMessage(), count);
        }
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pagingStore;
    }

    @Override
    public PageSubscription getPageSubscription() {
        return this.pageSubscription;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public void setRoutingType(RoutingType routingType) {
        if (this.addressInfo.getRoutingTypes().contains(routingType)) {
            this.routingType = routingType;
        }
    }

    @Override
    public Filter getFilter() {
        return filterUpdater.get(this);
    }

    @Override
    public void setFilter(Filter filter) {
        filterUpdater.set(this, filter);
    }

    @Override
    public void unproposed(final SimpleString groupID) {
        if (groupID.toString().endsWith("." + this.getName())) {
            final SimpleString groupIDToRemove = (SimpleString)groupID.subSequence(0, groupID.length() - this.getName().length() - 1);
            this.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    QueueImpl queueImpl = QueueImpl.this;
                    synchronized (queueImpl) {
                        if (QueueImpl.this.groups.remove(groupIDToRemove) != null) {
                            logger.debug((Object)("Removing group after unproposal " + groupID + " from queue " + QueueImpl.this));
                        } else {
                            logger.debug((Object)("Couldn't remove Removing group " + groupIDToRemove + " after unproposal on queue " + QueueImpl.this));
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(MessageReference ref, boolean scheduling) {
        this.enterCritical(1);
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            try {
                if (this.ringSize != -1L) {
                    this.enforceRing(ref, scheduling, true);
                }
                if (!ref.isAlreadyAcked()) {
                    if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
                        return;
                    }
                    this.internalAddHead(ref);
                    this.directDeliver = false;
                }
            }
            finally {
                this.leaveCritical(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSorted(MessageReference ref, boolean scheduling) {
        this.enterCritical(1);
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            try {
                if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
                    return;
                }
                this.internalAddSorted(ref);
                this.directDeliver = false;
            }
            finally {
                this.leaveCritical(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(List<MessageReference> refs, boolean scheduling) {
        this.enterCritical(1);
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            try {
                for (MessageReference ref : refs) {
                    this.addHead(ref, scheduling);
                }
                this.resetAllIterators();
                this.deliverAsync();
            }
            finally {
                this.leaveCritical(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSorted(List<MessageReference> refs, boolean scheduling) {
        this.enterCritical(1);
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            try {
                for (MessageReference ref : refs) {
                    this.addSorted(ref, scheduling);
                }
                this.resetAllIterators();
                this.deliverAsync();
            }
            finally {
                this.leaveCritical(1);
            }
        }
    }

    @Override
    public synchronized void reload(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        if (!this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            this.internalAddTail(ref);
        }
        this.directDeliver = false;
        if (!ref.isPaged()) {
            this.incrementMesssagesAdded();
        }
    }

    @Override
    public void addTail(MessageReference ref) {
        this.addTail(ref, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTail(MessageReference ref, boolean direct) {
        this.enterCritical(0);
        try {
            if (this.scheduleIfPossible(ref)) {
                return;
            }
            if (direct && this.supportsDirectDeliver && !this.directDeliver && System.currentTimeMillis() - this.lastDirectDeliveryCheck > 1000L) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Checking to re-enable direct deliver on queue " + this.getName()));
                }
                this.lastDirectDeliveryCheck = System.currentTimeMillis();
                Object object = this.directDeliveryGuard;
                synchronized (object) {
                    if (this.deliveriesInTransit.getCount() == 0 && this.getExecutor().isFlushed() && this.intermediateMessageReferences.isEmpty() && this.messageReferences.isEmpty() && this.pageIterator != null && !this.pageIterator.hasNext() && this.pageSubscription != null && !this.pageSubscription.isPaging()) {
                        this.directDeliver = this.supportsDirectDeliver;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Setting direct deliverer to " + this.supportsDirectDeliver + " on queue " + this.getName()));
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Couldn't set direct deliver back on queue " + this.getName()));
                    }
                }
            }
            if (direct && this.supportsDirectDeliver && this.directDeliver && this.deliveriesInTransit.getCount() == 0 && this.deliverDirect(ref)) {
                return;
            }
            this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
            this.intermediateMessageReferences.add((Object)ref);
            this.directDeliver = false;
            this.deliverAsync();
        }
        finally {
            this.leaveCritical(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scheduleIfPossible(MessageReference ref) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (!ref.isPaged()) {
                    this.incrementMesssagesAdded();
                }
            }
            return true;
        }
        return false;
    }

    private boolean flushDeliveriesInTransit() {
        try {
            if (this.deliveriesInTransit.await(1000L)) {
                return true;
            }
            ActiveMQServerLogger.LOGGER.timeoutFlushInTransit(this.getName().toString(), this.getAddress().toString());
            return false;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToFlushDeliveries(e);
            return false;
        }
    }

    @Override
    public void forceDelivery() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Force delivery scheduling depage");
            }
            this.scheduleDepage(false);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Force delivery delivering async");
        }
        this.deliverAsync();
    }

    @Override
    public void deliverAsync() {
        this.deliverAsync(false);
    }

    private void deliverAsync(boolean noWait) {
        if (this.scheduledRunners.get() < 1) {
            this.scheduledRunners.incrementAndGet();
            this.checkDepage(noWait);
            try {
                this.getExecutor().execute(this.deliverRunner);
            }
            catch (RejectedExecutionException ignored) {
                this.scheduledRunners.decrementAndGet();
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    QueueImpl.this.cancelRedistributor();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToCancelRedistributor(e);
                }
            }
        });
        if (this.addressSettingsRepository != null) {
            this.addressSettingsRepository.unRegisterListener(this.addressSettingsRepositoryListener);
        }
    }

    public ArtemisExecutor getExecutor() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            return this.pageSubscription.getExecutor();
        }
        return this.executor;
    }

    public void deliverNow() {
        this.deliverAsync();
        this.flushExecutor();
    }

    @Override
    public boolean flushExecutor() {
        boolean ok = this.internalFlushExecutor(10000L, true);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.errorFlushingExecutorsOnQueue();
        }
        return ok;
    }

    private boolean internalFlushExecutor(long timeout, boolean log) {
        if (!this.getExecutor().flush(timeout, TimeUnit.MILLISECONDS)) {
            if (log) {
                ActiveMQServerLogger.LOGGER.queueBusy(this.name.toString(), timeout);
            }
            return false;
        }
        return true;
    }

    private boolean canDispatch() {
        boolean canDispatch = BooleanUtil.toBoolean((int)dispatchingUpdater.get(this));
        if (canDispatch) {
            return true;
        }
        if (this.inFlightMessages()) {
            return false;
        }
        if (this.consumers.size() >= this.consumersBeforeDispatch) {
            if (dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((boolean)false), BooleanUtil.toInt((boolean)true))) {
                dispatchStartTimeUpdater.set(this, System.currentTimeMillis());
            }
            return true;
        }
        long currentDispatchStartTime = dispatchStartTimeUpdater.get(this);
        if (currentDispatchStartTime != -1L && currentDispatchStartTime < System.currentTimeMillis()) {
            dispatchingUpdater.set(this, BooleanUtil.toInt((boolean)true));
            return true;
        }
        return false;
    }

    private boolean inFlightMessages() {
        return this.consumers.stream().mapToInt(c -> ((ConsumerHolder)c).consumer().getDeliveringMessages().size()).sum() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(Consumer consumer) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " adding consumer " + consumer));
        }
        this.enterCritical(3);
        try {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                ConsumerHolder<Consumer> newConsumerHolder;
                if (this.maxConsumers != -1 && this.consumers.size() >= this.maxConsumers) {
                    throw ActiveMQMessageBundle.BUNDLE.maxConsumerLimitReachedForQueue(this.address, this.name);
                }
                if (this.consumers.isEmpty()) {
                    this.supportsDirectDeliver = consumer.supportsDirectDelivery();
                } else if (!consumer.supportsDirectDelivery()) {
                    this.supportsDirectDeliver = false;
                }
                this.cancelRedistributor();
                if (this.groupRebalance) {
                    if (this.groupRebalancePauseDispatch) {
                        this.stopDispatch();
                    }
                    this.groups.removeAll();
                }
                if (this.consumers.add(newConsumerHolder = new ConsumerHolder<Consumer>(consumer)) && this.delayBeforeDispatch >= 0L) {
                    dispatchStartTimeUpdater.compareAndSet(this, -1L, this.delayBeforeDispatch + System.currentTimeMillis());
                }
                if (this.refCountForConsumers != null) {
                    this.refCountForConsumers.increment();
                }
            }
        }
        finally {
            this.leaveCritical(3);
        }
    }

    @Override
    public void addLingerSession(String sessionId) {
        this.lingerSessionIds.add((Object)sessionId);
    }

    @Override
    public void removeLingerSession(String sessionId) {
        this.lingerSessionIds.remove((Object)sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(Consumer consumer) {
        this.enterCritical(3);
        try {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                boolean consumerRemoved = false;
                for (ConsumerHolder consumerHolder : this.consumers) {
                    if (consumerHolder.consumer != consumer) continue;
                    if (consumerHolder.iter != null) {
                        consumerHolder.iter.close();
                    }
                    this.consumers.remove(consumerHolder);
                    consumerRemoved = true;
                    break;
                }
                this.supportsDirectDeliver = this.checkConsumerDirectDeliver();
                if (consumerRemoved) {
                    consumerRemovedTimestampUpdater.set(this, System.currentTimeMillis());
                    if (this.consumers.size() == 0) {
                        this.stopDispatch();
                    }
                }
                if (consumer == this.exclusiveConsumer) {
                    this.exclusiveConsumer = null;
                }
                this.groups.removeIf(consumer::equals);
                if (this.refCountForConsumers != null) {
                    this.refCountForConsumers.decrement();
                }
            }
        }
        finally {
            this.leaveCritical(3);
        }
    }

    private void stopDispatch() {
        boolean stopped = dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((boolean)true), BooleanUtil.toInt((boolean)false));
        if (stopped) {
            dispatchStartTimeUpdater.set(this, -1L);
        }
    }

    private boolean checkConsumerDirectDeliver() {
        if (this.consumers.isEmpty()) {
            return false;
        }
        boolean supports = true;
        for (ConsumerHolder consumerHolder : this.consumers) {
            if (consumerHolder.consumer.supportsDirectDelivery()) continue;
            supports = false;
        }
        if (this.redistributor != null && !((Redistributor)this.redistributor.consumer).supportsDirectDelivery()) {
            supports = false;
        }
        return supports;
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        this.clearRedistributorFuture();
        if (this.redistributor != null) {
            this.deliverAsync();
        }
        if (delay > 0L) {
            if (this.consumers.isEmpty()) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.redistributorFuture = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
            }
        } else {
            this.internalAddRedistributor(this.executor);
        }
    }

    private void clearRedistributorFuture() {
        ScheduledFuture<?> future = this.redistributorFuture;
        this.redistributorFuture = null;
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public synchronized void cancelRedistributor() throws Exception {
        if (this.redistributor != null) {
            ((Redistributor)this.redistributor.consumer).stop();
            this.redistributor = null;
        }
        this.clearRedistributorFuture();
    }

    protected void finalize() throws Throwable {
        this.cancelRedistributor();
        super.finalize();
    }

    @Override
    public int getConsumerCount() {
        return this.consumers.size();
    }

    @Override
    public long getConsumerRemovedTimestamp() {
        return consumerRemovedTimestampUpdater.get(this);
    }

    @Override
    public long getRingSize() {
        return this.ringSize;
    }

    @Override
    public synchronized void setRingSize(long ringSize) {
        this.ringSize = ringSize;
    }

    public long getMessageCountForRing() {
        return this.pendingMetrics.getMessageCount();
    }

    public Set<Consumer> getConsumers() {
        HashSet<Consumer> consumersSet = new HashSet<Consumer>(this.consumers.size());
        for (ConsumerHolder consumerHolder : this.consumers) {
            consumersSet.add((Consumer)consumerHolder.consumer);
        }
        return consumersSet;
    }

    @Override
    public synchronized Map<SimpleString, Consumer> getGroups() {
        return this.groups.toMap();
    }

    @Override
    public synchronized void resetGroup(SimpleString groupId) {
        this.groups.remove(groupId);
    }

    @Override
    public synchronized void resetAllGroups() {
        this.groups.removeAll();
    }

    @Override
    public synchronized int getGroupCount() {
        return this.groups.size();
    }

    @Override
    public boolean hasMatchingConsumer(Message message) {
        for (ConsumerHolder consumerHolder : this.consumers) {
            Object consumer = consumerHolder.consumer;
            if (consumer instanceof Redistributor) continue;
            Filter filter1 = consumer.getFilter();
            if (filter1 == null) {
                return true;
            }
            if (!filter1.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedListIterator<MessageReference> iterator() {
        return new SynchronizedIterator((LinkedListIterator<MessageReference>)this.messageReferences.iterator());
    }

    public QueueBrowserIterator browserIterator() {
        return new QueueBrowserIterator();
    }

    @Override
    public synchronized MessageReference removeReferenceWithID(long id1) throws Exception {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            MessageReference removed = null;
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                iterator.remove();
                this.refRemoved(ref);
                removed = ref;
                break;
            }
            if (removed == null) {
                removed = this.scheduledDeliveryHandler.removeReferenceWithID(id1);
            }
            MessageReference messageReference = removed;
            return messageReference;
        }
    }

    @Override
    public synchronized MessageReference getReference(long id1) throws ActiveMQException {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                MessageReference messageReference = ref;
                return messageReference;
            }
            MessageReference messageReference = null;
            return messageReference;
        }
    }

    @Override
    public long getMessageCount() {
        if (this.pageSubscription != null) {
            return (long)this.pendingMetrics.getMessageCount() + (long)this.getScheduledCount() + (long)this.getDeliveringCount() + this.pageSubscription.getMessageCount();
        }
        return (long)this.pendingMetrics.getMessageCount() + (long)this.getScheduledCount() + (long)this.getDeliveringCount();
    }

    @Override
    public long getPersistentSize() {
        if (this.pageSubscription != null) {
            return this.pendingMetrics.getPersistentSize() + this.getScheduledSize() + this.getDeliveringSize() + this.pageSubscription.getPersistentSize();
        }
        return this.pendingMetrics.getPersistentSize() + this.getScheduledSize() + this.getDeliveringSize();
    }

    @Override
    public long getDurableMessageCount() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return (long)this.pendingMetrics.getDurableMessageCount() + (long)this.getDurableScheduledCount() + (long)this.getDurableDeliveringCount() + this.pageSubscription.getMessageCount();
            }
            return (long)this.pendingMetrics.getDurableMessageCount() + (long)this.getDurableScheduledCount() + (long)this.getDurableDeliveringCount();
        }
        return 0L;
    }

    @Override
    public long getDurablePersistentSize() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return this.pendingMetrics.getDurablePersistentSize() + this.getDurableScheduledSize() + this.getDurableDeliveringSize() + this.pageSubscription.getPersistentSize();
            }
            return this.pendingMetrics.getDurablePersistentSize() + this.getDurableScheduledSize() + this.getDurableDeliveringSize();
        }
        return 0L;
    }

    @Override
    public int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public long getScheduledSize() {
        return this.scheduledDeliveryHandler.getScheduledSize();
    }

    @Override
    public int getDurableScheduledCount() {
        return this.scheduledDeliveryHandler.getDurableScheduledCount();
    }

    @Override
    public long getDurableScheduledSize() {
        return this.scheduledDeliveryHandler.getDurableScheduledSize();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<MessageReference>> getDeliveringMessages() {
        Iterator consumerHolderIterator;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            consumerHolderIterator = this.redistributor == null ? this.consumers.iterator() : SingletonIterator.newInstance(this.redistributor);
        }
        HashMap<String, List<MessageReference>> mapReturn = new HashMap<String, List<MessageReference>>();
        while (consumerHolderIterator.hasNext()) {
            ConsumerHolder holder = (ConsumerHolder)consumerHolderIterator.next();
            List<MessageReference> msgs = holder.consumer.getDeliveringMessages();
            if (msgs == null || msgs.size() <= 0) continue;
            mapReturn.put(holder.consumer.toManagementString(), msgs);
        }
        for (String lingerSessionId : this.lingerSessionIds) {
            ServerSession serverSession = this.server.getSessionByID(lingerSessionId);
            List<MessageReference> refs = serverSession == null ? null : serverSession.getInTxLingerMessages();
            if (refs == null || refs.isEmpty()) continue;
            mapReturn.put(serverSession.toManagementString(), refs);
        }
        return mapReturn;
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringMetrics.getMessageCount();
    }

    @Override
    public long getDeliveringSize() {
        return this.deliveringMetrics.getPersistentSize();
    }

    @Override
    public int getDurableDeliveringCount() {
        return this.deliveringMetrics.getDurableMessageCount();
    }

    @Override
    public long getDurableDeliveringSize() {
        return this.deliveringMetrics.getDurablePersistentSize();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        this.acknowledge(ref, null);
    }

    @Override
    public void acknowledge(MessageReference ref, ServerConsumer consumer) throws Exception {
        this.acknowledge(ref, AckReason.NORMAL, consumer);
    }

    @Override
    public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        if (this.nonDestructive && reason == AckReason.NORMAL) {
            this.decDelivering(ref);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"acknowledge ignored nonDestructive=true and reason=NORMAL");
            }
        } else {
            if (ref.isPaged()) {
                this.pageSubscription.ack((PagedReference)ref);
                this.postAcknowledge(ref, reason);
            } else {
                boolean durableRef;
                Message message = ref.getMessage();
                boolean bl = durableRef = message.isDurable() && this.isDurable();
                if (durableRef) {
                    this.storageManager.storeAcknowledge(this.id, message.getMessageID());
                }
                this.postAcknowledge(ref, reason);
            }
            this.ackAttempts.incrementAndGet();
            if (this.server != null && this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.messageAcknowledged(ref, reason, consumer));
            }
        }
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        this.acknowledge(tx, ref, AckReason.NORMAL, null);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        RefsOperation refsOperation = this.getRefsOperation(tx, reason);
        if (this.nonDestructive && reason == AckReason.NORMAL) {
            refsOperation.addOnlyRefAck(ref);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"acknowledge tx ignored nonDestructive=true and reason=NORMAL");
            }
        } else {
            if (ref.isPaged()) {
                this.pageSubscription.ackTx(tx, (PagedReference)ref);
                refsOperation.addAck(ref);
            } else {
                boolean durableRef;
                Message message = ref.getMessage();
                boolean bl = durableRef = message.isDurable() && this.isDurable();
                if (durableRef) {
                    this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.id, message.getMessageID());
                    tx.setContainsPersistent();
                }
                this.ackAttempts.incrementAndGet();
                refsOperation.addAck(ref);
            }
            if (this.server != null && this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.messageAcknowledged(ref, reason, consumer));
            }
        }
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        Message message = ref.getMessage();
        if (message.isDurable() && this.isDurable()) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx, AckReason.NORMAL).addAck(ref);
        this.incDelivering(ref);
        this.messagesAcknowledged.incrementAndGet();
    }

    private RefsOperation getRefsOperation(Transaction tx, AckReason ackReason) {
        return this.getRefsOperation(tx, ackReason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefsOperation getRefsOperation(Transaction tx, AckReason ackReason, boolean ignoreRedlieveryCheck) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = tx.createRefsOperation(this, ackReason);
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            if (ignoreRedlieveryCheck) {
                oper.setIgnoreRedeliveryCheck();
            }
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) {
        this.cancel(tx, reference, false);
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference, boolean ignoreRedeliveryCheck) {
        this.getRefsOperation(tx, AckReason.NORMAL, ignoreRedeliveryCheck).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference, long timeBase, boolean sorted) throws Exception {
        Pair<Boolean, Boolean> redeliveryResult = this.checkRedelivery(reference, timeBase, false);
        if (((Boolean)redeliveryResult.getA()).booleanValue()) {
            if (!this.scheduledDeliveryHandler.checkAndSchedule(reference, false)) {
                if (sorted) {
                    this.internalAddSorted(reference);
                } else {
                    this.internalAddHead(reference);
                }
            }
            this.resetAllIterators();
        } else if (!((Boolean)redeliveryResult.getB()).booleanValue()) {
            this.decDelivering(reference);
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        this.expire(ref, null);
    }

    @Override
    public void expire(MessageReference ref, ServerConsumer consumer) throws Exception {
        SimpleString messageExpiryAddress = this.expiryAddressFromMessageAddress(ref);
        if (messageExpiryAddress == null) {
            messageExpiryAddress = this.expiryAddressFromAddressSettings(ref);
        }
        if (messageExpiryAddress != null) {
            this.createExpiryResources();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("moving expired reference " + ref + " to address = " + messageExpiryAddress + " from queue=" + this.getName()));
            }
            this.move(null, messageExpiryAddress, null, ref, false, AckReason.EXPIRED, consumer);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("expiry is null, just acking expired message for reference " + ref + " from queue=" + this.getName()));
            }
            this.acknowledge(ref, AckReason.EXPIRED, consumer);
        }
        this.refCountForConsumers.check();
        if (this.server != null && this.server.hasBrokerMessagePlugins()) {
            SimpleString expiryAddress = messageExpiryAddress;
            this.server.callBrokerMessagePlugins(plugin -> plugin.messageExpired(ref, expiryAddress, consumer));
        }
    }

    private SimpleString expiryAddressFromMessageAddress(MessageReference ref) {
        SimpleString messageAddress = this.extractAddress(ref.getMessage());
        SimpleString expiryAddress = null;
        if (messageAddress == null || messageAddress.equals((Object)this.getAddress())) {
            expiryAddress = this.getExpiryAddress();
        }
        return expiryAddress;
    }

    private SimpleString expiryAddressFromAddressSettings(MessageReference ref) {
        SimpleString messageAddress = this.extractAddress(ref.getMessage());
        SimpleString expiryAddress = null;
        if (messageAddress != null) {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(messageAddress.toString());
            expiryAddress = addressSettings.getExpiryAddress();
        }
        return expiryAddress;
    }

    private SimpleString extractAddress(Message message) {
        if (message.containsProperty(Message.HDR_ORIG_MESSAGE_ID.toString())) {
            return message.getSimpleStringProperty(Message.HDR_ORIGINAL_ADDRESS.toString());
        }
        return message.getAddressSimpleString();
    }

    @Override
    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    @Override
    public void referenceHandled(MessageReference ref) {
        this.incDelivering(ref);
    }

    @Override
    public void incrementMesssagesAdded() {
        this.messagesAdded.incrementAndGet();
    }

    @Override
    public void deliverScheduledMessages() throws ActiveMQException {
        List<MessageReference> scheduledMessages = this.scheduledDeliveryHandler.cancel(null);
        if (scheduledMessages != null && scheduledMessages.size() > 0) {
            for (MessageReference ref : scheduledMessages) {
                ref.getMessage().setScheduledDeliveryTime(Long.valueOf(ref.getScheduledDeliveryTime()));
                ref.setScheduledDeliveryTime(0L);
            }
            this.addHead(scheduledMessages, true);
        }
    }

    @Override
    public long getMessagesAdded() {
        if (this.pageSubscription != null) {
            return this.messagesAdded.get() + this.pageSubscription.getCounter().getValueAdded();
        }
        return this.messagesAdded.get();
    }

    @Override
    public long getMessagesAcknowledged() {
        return this.messagesAcknowledged.get();
    }

    @Override
    public long getAcknowledgeAttempts() {
        return this.ackAttempts.get();
    }

    @Override
    public long getMessagesExpired() {
        return this.messagesExpired.get();
    }

    @Override
    public long getMessagesKilled() {
        return this.messagesKilled.get();
    }

    @Override
    public long getMessagesReplaced() {
        return this.messagesReplaced.get();
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteAllReferences(500);
    }

    @Override
    public int deleteAllReferences(int flushLimit) throws Exception {
        return this.deleteMatchingReferences(flushLimit, null);
    }

    @Override
    public int deleteMatchingReferences(Filter filter) throws Exception {
        return this.deleteMatchingReferences(500, filter);
    }

    @Override
    public int deleteMatchingReferences(int flushLimit, Filter filter1, AckReason ackReason) throws Exception {
        return this.iterQueue(flushLimit, filter1, this.createDeleteMatchingAction(ackReason));
    }

    QueueIterateAction createDeleteMatchingAction(final AckReason ackReason) {
        return new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                QueueImpl.this.incDelivering(ref);
                QueueImpl.this.acknowledge(tx, ref, ackReason, null);
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int iterQueue(int flushLimit, Filter filter1, QueueIterateAction messageAction) throws Exception {
        int count = 0;
        int txCount = 0;
        Integer expectedHits = messageAction.expectedHits();
        this.depagePending = true;
        this.depageLock.lock();
        try {
            TransactionImpl tx = new TransactionImpl(this.storageManager);
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                try (LinkedListIterator<MessageReference> iter = this.iterator();){
                    while (iter.hasNext()) {
                        MessageReference ref = (MessageReference)iter.next();
                        if (ref.isPaged() && this.queueDestroyed || filter1 != null && !filter1.match(ref.getMessage())) continue;
                        if (messageAction.actMessage(tx, ref)) {
                            iter.remove();
                            this.refRemoved(ref);
                        }
                        ++txCount;
                        if (expectedHits == null || ++count < expectedHits) continue;
                        break;
                    }
                    if (txCount > 0) {
                        tx.commit();
                        tx = new TransactionImpl(this.storageManager);
                        txCount = 0;
                    }
                    List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter1);
                    for (MessageReference messageReference : cancelled) {
                        messageAction.actMessage(tx, messageReference);
                        ++count;
                        ++txCount;
                    }
                    if (txCount > 0) {
                        tx.commit();
                        tx = new TransactionImpl(this.storageManager);
                        txCount = 0;
                    }
                }
            }
            if (this.pageIterator != null && !this.queueDestroyed) {
                while (this.pageIterator.hasNext()) {
                    PagedReference reference = (PagedReference)this.pageIterator.next();
                    this.pageIterator.remove();
                    if (filter1 == null || filter1.match(reference.getMessage())) {
                        ++count;
                        ++txCount;
                        if (!messageAction.actMessage(tx, reference)) {
                            this.addTail(reference, false);
                        }
                    } else {
                        this.addTail(reference, false);
                    }
                    if (txCount <= 0 || txCount % flushLimit != 0) continue;
                    tx.commit();
                    tx = new TransactionImpl(this.storageManager);
                    txCount = 0;
                }
            }
            if (txCount > 0) {
                tx.commit();
                tx = null;
            }
            if (this.filter != null && !this.queueDestroyed && this.pageSubscription != null) {
                this.scheduleDepage(false);
            }
            int n = count;
            return n;
        }
        finally {
            this.depageLock.unlock();
            this.depagePending = false;
            this.forceDelivery();
        }
    }

    @Override
    public void destroyPaging() throws Exception {
        if (this.pageSubscription != null) {
            this.pageSubscription.destroy();
            this.pageSubscription.cleanupEntries(true);
        }
    }

    @Override
    public synchronized boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.acknowledge(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                deleted = true;
                break;
            }
            if (!deleted) {
                deleted = this.scheduledDeliveryHandler.removeReferenceWithID(messageID, tx) != null;
            }
            tx.commit();
            boolean bl = deleted;
            return bl;
        }
    }

    @Override
    public void deleteQueue() throws Exception {
        this.deleteQueue(false);
    }

    @Override
    public void removeAddress() throws Exception {
        this.server.removeAddressInfo(this.getAddress(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(boolean removeConsumers) throws Exception {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.queueDestroyed) {
                return;
            }
            this.queueDestroyed = true;
        }
        BindingsTransactionImpl tx = new BindingsTransactionImpl(this.storageManager);
        try {
            this.deleteAllReferences();
            this.destroyPaging();
            this.postOffice.removeBinding(this.name, tx, true);
            if (removeConsumers) {
                for (ConsumerHolder consumerHolder : this.consumers) {
                    consumerHolder.consumer.disconnect();
                }
            }
            if (this.isDurable()) {
                this.storageManager.deleteQueueBinding(tx.getID(), this.getID());
                tx.setContainsPersistent();
            }
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (this.factory != null) {
                this.factory.queueRemoved(this);
            }
        }
    }

    @Override
    public synchronized boolean expireReference(long messageID) throws Exception {
        if (this.isExpirationRedundant()) {
            return false;
        }
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.expire(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int expireReferences(Filter filter) throws Exception {
        if (this.isExpirationRedundant()) {
            return 0;
        }
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering(ref);
                this.expire(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            tx.commit();
            int n = count;
            return n;
        }
    }

    @Override
    public void expireReferences() {
        if (this.isExpirationRedundant()) {
            return;
        }
        if (!this.queueDestroyed && this.expiryScanner.scannerRunning.get() == 0) {
            this.expiryScanner.scannerRunning.incrementAndGet();
            this.getExecutor().execute((Runnable)this.expiryScanner);
        }
    }

    public boolean isExpirationRedundant() {
        if (this.expiryAddress != null && this.expiryAddress.equals((Object)this.address)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Redundant expiration from " + this.address + " to " + this.expiryAddress));
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.sendToDeadLetterAddress(null, ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering(ref);
                this.sendToDeadLetterAddress(null, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized boolean moveReference(long messageID, SimpleString toAddress, Binding binding, boolean rejectDuplicate) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                this.incDelivering(ref);
                try {
                    this.move(null, toAddress, binding, ref, rejectDuplicate, AckReason.NORMAL, null);
                }
                catch (Exception e) {
                    this.decDelivering(ref);
                    throw e;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress, Binding binding) throws Exception {
        return this.moveReferences(500, filter, toAddress, false, binding);
    }

    @Override
    public int moveReferences(int flushLimit, Filter filter, final SimpleString toAddress, final boolean rejectDuplicates, final Binding binding) throws Exception {
        final DuplicateIDCache targetDuplicateCache = this.postOffice.getDuplicateIDCache(toAddress);
        return this.iterQueue(flushLimit, filter, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                byte[] duplicateBytes;
                boolean ignored = false;
                QueueImpl.this.incDelivering(ref);
                if (rejectDuplicates && (duplicateBytes = ref.getMessage().getDuplicateIDBytes()) != null && targetDuplicateCache.contains(duplicateBytes)) {
                    ActiveMQServerLogger.LOGGER.messageWithDuplicateID(ref.getMessage().getDuplicateProperty(), toAddress, QueueImpl.this.address, QueueImpl.this.address);
                    QueueImpl.this.acknowledge(tx, ref);
                    ignored = true;
                }
                if (!ignored) {
                    QueueImpl.this.move(null, toAddress, binding, ref, rejectDuplicates, AckReason.NORMAL, null);
                }
                return true;
            }
        });
    }

    public int moveReferencesBetweenSnFQueues(final SimpleString queueSuffix) throws Exception {
        return this.iterQueue(500, null, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                return QueueImpl.this.moveBetweenSnFQueues(queueSuffix, tx, ref);
            }
        });
    }

    public synchronized int rerouteMessages(final SimpleString queueName, Filter filter) throws Exception {
        return this.iterQueue(500, filter, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                RoutingContextImpl routingContext = new RoutingContextImpl(tx);
                routingContext.setAddress(QueueImpl.this.server.locateQueue(queueName).getAddress());
                QueueImpl.this.server.getPostOffice().getBinding(queueName).route(ref.getMessage(), routingContext);
                QueueImpl.this.postOffice.processRoute(ref.getMessage(), routingContext, false);
                return false;
            }
        });
    }

    @Override
    public int retryMessages(Filter filter) throws Exception {
        return this.retryMessages(filter, null);
    }

    @Override
    public int retryMessages(Filter filter, final Integer expectedHits) throws Exception {
        final HashMap queues = new HashMap();
        return this.iterQueue(500, filter, new QueueIterateAction(){

            @Override
            public Integer expectedHits() {
                return expectedHits;
            }

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                String originalMessageAddress = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_ADDRESS);
                String originalMessageQueue = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_QUEUE);
                if (originalMessageAddress != null) {
                    Binding binding;
                    QueueImpl.this.incDelivering(ref);
                    Long targetQueue = null;
                    if (originalMessageQueue != null && !originalMessageQueue.equals(originalMessageAddress) && (targetQueue = (Long)queues.get(originalMessageQueue)) == null && (binding = QueueImpl.this.postOffice.getBinding(SimpleString.toSimpleString((String)originalMessageQueue))) != null && binding instanceof LocalQueueBinding) {
                        targetQueue = ((LocalQueueBinding)binding).getID();
                        queues.put(originalMessageQueue, targetQueue);
                    }
                    if (targetQueue != null) {
                        QueueImpl.this.move(SimpleString.toSimpleString((String)originalMessageAddress), tx, ref, false, false, new long[]{targetQueue});
                    } else {
                        QueueImpl.this.move(SimpleString.toSimpleString((String)originalMessageAddress), tx, ref, false, false, new long[0]);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public synchronized boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            int count = 0;
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                ++count;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized void resetAllIterators() {
        for (ConsumerHolder consumerHolder : this.consumers) {
            consumerHolder.resetIterator();
        }
        if (this.redistributor != null) {
            ((ConsumerHolder)this.redistributor).resetIterator();
        }
    }

    @Override
    public synchronized void pause() {
        this.pause(false);
    }

    @Override
    public synchronized void reloadPause(long recordID) {
        this.paused = true;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToDeleteQueueStatus(e);
            }
        }
        this.pauseStatusRecord = recordID;
    }

    @Override
    public synchronized void pause(boolean persist) {
        try {
            this.flushDeliveriesInTransit();
            if (persist && this.isDurable()) {
                if (this.pauseStatusRecord >= 0L) {
                    this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
                }
                this.pauseStatusRecord = this.storageManager.storeQueueStatus(this.id, AddressQueueStatus.PAUSED);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToPauseQueue(e);
        }
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToResumeQueue(e);
            }
            this.pauseStatusRecord = -1L;
        }
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused || this.addressInfo != null && this.addressInfo.isPaused();
    }

    @Override
    public synchronized boolean isPersistedPause() {
        return this.pauseStatusRecord >= 0L;
    }

    @Override
    public boolean isDirectDeliver() {
        return this.directDeliver && this.supportsDirectDeliver;
    }

    @Override
    public boolean isInternalQueue() {
        return this.internalQueue;
    }

    @Override
    public void setInternalQueue(boolean internalQueue) {
        this.internalQueue = internalQueue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueueImpl)) {
            return false;
        }
        QueueImpl qother = (QueueImpl)other;
        return this.name.equals((Object)qother.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + this.name.toString() + ", postOffice=" + this.postOffice + ", temp=" + this.temporary + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private synchronized void internalAddTail(MessageReference ref) {
        this.refAdded(ref);
        this.messageReferences.addTail((Object)ref, this.getPriority(ref));
        this.pendingMetrics.incrementMetrics(ref);
        this.enforceRing(false);
    }

    private void internalAddHead(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addHead((Object)ref, priority);
        ref.setInDelivery(false);
    }

    private void internalAddSorted(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addSorted((Object)ref, priority);
    }

    private int getPriority(MessageReference ref) {
        try {
            return ref.getMessage().getPriority();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToGetMessagePriority(e);
            return 4;
        }
    }

    private synchronized void doInternalPoll() {
        MessageReference ref;
        int added = 0;
        while ((ref = (MessageReference)this.intermediateMessageReferences.poll()) != null) {
            this.internalAddTail(ref);
            if (!ref.isPaged()) {
                this.incrementMesssagesAdded();
            }
            if (added++ <= 1000) continue;
            this.deliverAsync(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean deliver() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " doing deliver. messageReferences=" + this.messageReferences.size()));
        }
        this.scheduledRunners.decrementAndGet();
        this.doInternalPoll();
        int noDelivery = 0;
        int handled = 0;
        long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
        this.consumers.reset();
        while (true) {
            MessageReference ref;
            ConsumerHolder holder;
            if (handled == 1000) {
                this.deliverAsync(true);
                return false;
            }
            if (System.nanoTime() - timeout > 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"delivery has been running for too long. Scheduling another delivery task now");
                }
                this.deliverAsync(true);
                return false;
            }
            int existingMemoryEstimate = 0;
            Consumer handledconsumer = null;
            QueueImpl queueImpl = this;
            // MONITORENTER : queueImpl
            if (this.isPaused() || !this.canDispatch() && this.redistributor == null) {
                // MONITOREXIT : queueImpl
                return false;
            }
            if (this.messageReferences.size() == 0) {
                // MONITOREXIT : queueImpl
                return true;
            }
            if (this.redistributor == null) {
                if (!this.consumers.hasNext()) {
                    // MONITOREXIT : queueImpl
                    return true;
                }
                holder = (ConsumerHolder)this.consumers.next();
            } else {
                holder = this.redistributor;
            }
            Object t = holder.consumer;
            Consumer groupConsumer = null;
            if (holder.iter == null) {
                holder.iter = this.messageReferences.iterator();
            }
            if (holder.iter.hasNext()) {
                ref = (MessageReference)holder.iter.next();
            } else {
                ref = null;
                existingMemoryEstimate = 0;
            }
            if (ref == null) {
                ++noDelivery;
            } else {
                void var10_9;
                HandleStatus status;
                if (this.checkExpired(ref)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Reference " + ref + " being expired"));
                    }
                    this.removeMessageReference(holder, ref);
                    ++handled;
                    this.consumers.reset();
                    // MONITOREXIT : queueImpl
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Queue " + this.getName() + " is delivering reference " + ref));
                }
                existingMemoryEstimate = ref.getMessageMemoryEstimate();
                SimpleString groupID = this.extractGroupID(ref);
                groupConsumer = this.getGroupConsumer(groupID);
                if (groupConsumer != null) {
                    Consumer consumer = groupConsumer;
                }
                if ((status = this.handle(ref, (Consumer)var10_9)) == HandleStatus.HANDLED) {
                    noDelivery = 0;
                    if (this.redistributor == null) {
                        ref = this.handleMessageGroup(ref, (Consumer)var10_9, groupConsumer, groupID);
                    }
                    this.deliveriesInTransit.countUp();
                    if (!this.nonDestructive) {
                        this.removeMessageReference(holder, ref);
                    }
                    ref.setInDelivery(true);
                    handledconsumer = var10_9;
                    ++handled;
                    this.consumers.reset();
                } else if (status == HandleStatus.BUSY) {
                    try {
                        holder.iter.repeat();
                    }
                    catch (NoSuchElementException e) {
                        logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    ++noDelivery;
                } else if (status == HandleStatus.NO_MATCH) {
                    this.consumers.reset();
                }
            }
            if (this.redistributor != null || groupConsumer != null) {
                if (noDelivery > 0) {
                    // MONITOREXIT : queueImpl
                    return true;
                }
                noDelivery = 0;
            } else if (!this.consumers.hasNext()) {
                if (noDelivery == this.consumers.size()) {
                    if (handledconsumer != null) {
                        ActiveMQServerLogger.LOGGER.nonDeliveryHandled();
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(this + "::All the consumers were busy, giving up now"));
                        }
                        // MONITOREXIT : queueImpl
                        return true;
                    }
                }
                noDelivery = 0;
            }
            // MONITOREXIT : queueImpl
            if (handledconsumer != null) {
                this.proceedDeliver(handledconsumer, ref);
            }
            if (existingMemoryEstimate <= 0) continue;
            QueueImpl.accountForChangeInMemoryEstimate(ref, existingMemoryEstimate);
        }
    }

    protected void removeMessageReference(ConsumerHolder<? extends Consumer> holder, MessageReference ref) {
        holder.iter.remove();
        this.refRemoved(ref);
    }

    private void checkDepage(boolean noWait) {
        if (this.pageIterator != null && this.pageSubscription.isPaging() && !this.depagePending && this.needsDepage() && (noWait ? this.pageIterator.tryNext() > 0 : this.pageIterator.hasNext())) {
            this.scheduleDepage(false);
        }
    }

    private boolean needsDepage() {
        return (long)this.queueMemorySize.get() < this.pageSubscription.getPagingStore().getMaxSize() && this.intermediateMessageReferences.size() + this.messageReferences.size() < 1000;
    }

    private SimpleString extractGroupID(MessageReference ref) {
        if (this.internalQueue || this.exclusive || this.groupBuckets == 0) {
            return null;
        }
        try {
            return ref.getMessage().getGroupID();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToExtractGroupID(e);
            return null;
        }
    }

    private int extractGroupSequence(MessageReference ref) {
        if (this.internalQueue) {
            return 0;
        }
        try {
            return ref.getMessage().getGroupSequence();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToExtractGroupSequence(e);
            return 0;
        }
    }

    protected void refRemoved(MessageReference ref) {
        this.queueMemorySize.addAndGet(-ref.getMessageMemoryEstimate());
        this.pendingMetrics.decrementMetrics(ref);
        if (ref.isPaged()) {
            this.pagedReferences.decrementAndGet();
        }
    }

    protected void addRefSize(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
    }

    protected void refAdded(MessageReference ref) {
        if (ref.isPaged()) {
            this.pagedReferences.incrementAndGet();
        }
    }

    private void scheduleDepage(boolean scheduleExpiry) {
        if (!this.depagePending) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Scheduling depage for queue " + this.getName()));
            }
            this.depagePending = true;
            this.pageSubscription.getExecutor().execute((Runnable)new DepageRunner(scheduleExpiry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void depage(boolean scheduleExpiry) {
        this.depagePending = false;
        if (!this.depageLock.tryLock()) {
            return;
        }
        try {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.isPaused()) return;
                if (this.pageIterator == null) {
                    return;
                }
            }
            long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("QueueMemorySize before depage on queue=" + this.getName() + " is " + this.queueMemorySize.get()));
            }
            this.directDeliver = false;
            int depaged = 0;
            while (timeout - System.nanoTime() > 0L && this.needsDepage()) {
                int status = this.pageIterator.tryNext();
                if (status == 2) continue;
                if (status == 0) break;
                ++depaged;
                PagedReference reference = (PagedReference)this.pageIterator.next();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Depaging reference " + reference + " on queue " + this.getName()));
                }
                this.addTail(reference, false);
                this.pageIterator.remove();
                this.pageSubscription.incrementDeliveredSize(this.getPersistentSize(reference));
            }
            if (logger.isDebugEnabled()) {
                int maxSize = this.pageSubscription.getPagingStore().getPageSizeBytes();
                if (depaged == 0 && this.queueMemorySize.get() >= maxSize) {
                    logger.debug((Object)"Couldn't depage any message as the maxSize on the queue was achieved. There are too many pending messages to be acked in reference to the page configuration");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Queue Memory Size after depage on queue=" + this.getName() + " is " + this.queueMemorySize.get() + " with maxSize = " + maxSize + ". Depaged " + depaged + " messages, pendingDelivery=" + this.messageReferences.size() + ", intermediateMessageReferences= " + this.intermediateMessageReferences.size() + ", queueDelivering=" + this.deliveringMetrics.getMessageCount()));
                }
            }
            this.deliverAsync(true);
            if (depaged <= 0) return;
            if (!scheduleExpiry) return;
            this.expireReferences();
            return;
        }
        finally {
            this.depageLock.unlock();
        }
    }

    @Override
    public MessageReference removeWithSuppliedID(long id, ToLongFunction<MessageReference> idSupplier) {
        this.checkIDSupplier(idSupplier);
        return (MessageReference)this.messageReferences.removeWithID(id);
    }

    private void internalAddRedistributor(ArtemisExecutor executor) {
        if (this.consumers.isEmpty() && this.redistributor == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("QueueImpl::Adding redistributor on queue " + this.toString()));
            }
            this.redistributor = new ConsumerHolder<Redistributor>(new Redistributor(this, this.storageManager, this.postOffice, (Executor)executor, 100));
            ((Redistributor)this.redistributor.consumer).start();
            this.deliverAsync();
        }
    }

    @Override
    public Pair<Boolean, Boolean> checkRedelivery(MessageReference reference, long timeBase, boolean ignoreRedeliveryDelay) throws Exception {
        if (this.internalQueue) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Queue " + this.getName() + " is an internal queue, no checkRedelivery"));
            }
            return new Pair((Object)true, (Object)false);
        }
        if (!this.internalQueue && reference.isDurable() && this.isDurable() && !reference.isPaged() && !this.storageManager.updateDeliveryCount(reference)) {
            return new Pair((Object)false, (Object)false);
        }
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address.toString());
        int maxDeliveries = addressSettings.getMaxDeliveryAttempts();
        int deliveryCount = reference.getDeliveryCount();
        if (maxDeliveries > 0 && deliveryCount >= maxDeliveries) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Sending reference " + reference + " to DLA = " + addressSettings.getDeadLetterAddress() + " since ref.getDeliveryCount=" + reference.getDeliveryCount() + "and maxDeliveries=" + maxDeliveries + " from queue=" + this.getName()));
            }
            boolean dlaResult = this.sendToDeadLetterAddress(null, reference, addressSettings.getDeadLetterAddress());
            return new Pair((Object)false, (Object)dlaResult);
        }
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        if (!ignoreRedeliveryDelay && redeliveryDelay > 0L) {
            redeliveryDelay = this.calculateRedeliveryDelay(addressSettings, deliveryCount);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Setting redeliveryDelay=" + redeliveryDelay + " on reference=" + reference));
            }
            reference.setScheduledDeliveryTime(timeBase + redeliveryDelay);
            if (!reference.isPaged() && reference.isDurable() && this.isDurable()) {
                this.storageManager.updateScheduledDeliveryTime(reference);
            }
        }
        this.decDelivering(reference);
        return new Pair((Object)true, (Object)false);
    }

    public int getNumberOfReferences() {
        return this.messageReferences.size();
    }

    private void move(SimpleString toAddress, Transaction tx, MessageReference ref, boolean expiry, boolean rejectDuplicate, long ... queueIDs) throws Exception {
        Message copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(toAddress);
        if (queueIDs != null && queueIDs.length > 0) {
            ByteBuffer buffer = ByteBuffer.allocate(8 * queueIDs.length);
            for (long id : queueIDs) {
                buffer.putLong(id);
            }
            copyMessage.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), buffer.array());
        }
        this.postOffice.route(copyMessage, tx, false, rejectDuplicate);
        if (expiry) {
            this.acknowledge(tx, ref, AckReason.EXPIRED, null);
        } else {
            this.acknowledge(tx, ref);
        }
    }

    private boolean moveBetweenSnFQueues(SimpleString queueSuffix, Transaction tx, MessageReference ref) throws Exception {
        Message copyMessage = this.makeCopy(ref, false, false);
        byte[] oldRouteToIDs = null;
        for (SimpleString propName : copyMessage.getPropertyNames()) {
            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
            oldRouteToIDs = (byte[])copyMessage.removeProperty(propName.toString());
            String hashcodeToString = oldRouteToIDs.toString();
            logger.debug((Object)("Removed property from message: " + propName + " = " + hashcodeToString + " (" + ByteBuffer.wrap(oldRouteToIDs).getLong() + ")"));
            break;
        }
        ByteBuffer oldBuffer = ByteBuffer.wrap(oldRouteToIDs);
        RoutingContextImpl routingContext = new RoutingContextImpl(tx);
        while (oldBuffer.hasRemaining()) {
            long oldQueueID = oldBuffer.getLong();
            Pair<String, Binding> result = this.locateTargetBinding(queueSuffix, copyMessage, oldQueueID);
            Binding targetBinding = (Binding)result.getB();
            String targetNodeID = (String)result.getA();
            if (targetBinding == null) {
                ActiveMQServerLogger.LOGGER.unableToFindTargetQueue(targetNodeID);
                continue;
            }
            logger.debug((Object)("Routing on binding: " + targetBinding));
            targetBinding.route(copyMessage, routingContext);
        }
        this.postOffice.processRoute(copyMessage, routingContext, false);
        ref.handled();
        this.acknowledge(tx, ref);
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorRedistributing(errorCode, errorMessage);
            }

            public void done() {
                QueueImpl.this.deliverAsync();
            }
        });
        return true;
    }

    private Pair<String, Binding> locateTargetBinding(SimpleString queueSuffix, Message copyMessage, long oldQueueID) {
        String targetNodeID = null;
        RemoteQueueBinding targetBinding = null;
        block0: for (RemoteQueueBinding remoteQueueBinding : IterableStream.iterableOf(this.postOffice.getAllBindings().filter(RemoteQueueBinding.class::isInstance).map(RemoteQueueBinding.class::cast))) {
            if (oldQueueID != remoteQueueBinding.getRemoteQueueID()) continue;
            SimpleString oldQueueName = remoteQueueBinding.getRoutingName();
            String temp = remoteQueueBinding.getQueue().getName().toString();
            targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
            logger.debug((Object)("Message formerly destined for " + oldQueueName + " with ID: " + oldQueueID + " on address " + copyMessage.getAddressSimpleString() + " on node " + targetNodeID));
            for (RemoteQueueBinding innerRemoteQueueBinding : IterableStream.iterableOf(this.postOffice.getAllBindings().filter(RemoteQueueBinding.class::isInstance).map(RemoteQueueBinding.class::cast))) {
                temp = innerRemoteQueueBinding.getQueue().getName().toString();
                targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
                if (oldQueueName.equals((Object)innerRemoteQueueBinding.getRoutingName()) && targetNodeID.equals(queueSuffix.toString())) {
                    targetBinding = innerRemoteQueueBinding;
                    if (!logger.isDebugEnabled()) continue block0;
                    logger.debug((Object)("Message now destined for " + innerRemoteQueueBinding.getRoutingName() + " with ID: " + innerRemoteQueueBinding.getRemoteQueueID() + " on address " + copyMessage.getAddress() + " on node " + targetNodeID));
                    continue block0;
                }
                logger.debug((Object)("Failed to match: " + innerRemoteQueueBinding));
            }
        }
        return new Pair(targetNodeID, targetBinding);
    }

    private Message makeCopy(MessageReference ref, boolean expiry) throws Exception {
        return this.makeCopy(ref, expiry, true);
    }

    private Message makeCopy(MessageReference ref, boolean expiry, boolean copyOriginalHeaders) throws Exception {
        if (ref == null) {
            ActiveMQServerLogger.LOGGER.nullRefMessage();
            throw new ActiveMQNullRefException("Reference to message is null");
        }
        Message message = ref.getMessage();
        long newID = this.storageManager.generateID();
        Message copy = message.copy(newID, true);
        if (copyOriginalHeaders) {
            copy.referenceOriginalMessage(message, ref.getQueue().getName().toString());
        }
        copy.setExpiration(0L);
        if (expiry) {
            copy.setBrokerProperty(Message.HDR_ACTUAL_EXPIRY_TIME, (Object)System.currentTimeMillis());
        }
        copy.reencode();
        return LargeServerMessageImpl.checkLargeMessage(copy, this.storageManager);
    }

    private void expire(Transaction tx, MessageReference ref) throws Exception {
        SimpleString expiryAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getExpiryAddress();
        if (expiryAddress != null) {
            this.createExpiryResources();
            Bindings bindingList = this.postOffice.lookupBindingsForAddress(expiryAddress);
            if (bindingList == null || bindingList.getBindings().isEmpty()) {
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoBindings(expiryAddress);
                this.acknowledge(tx, ref, AckReason.EXPIRED, null);
            } else {
                this.move(expiryAddress, tx, ref, true, true, new long[0]);
            }
        } else {
            if (!this.printErrorExpiring) {
                this.printErrorExpiring = true;
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoQueue(this.name);
            }
            this.acknowledge(tx, ref, AckReason.EXPIRED, null);
        }
        if (this.server != null && this.server.hasBrokerMessagePlugins()) {
            ExpiryLogger expiryLogger = (ExpiryLogger)tx.getProperty(9);
            if (expiryLogger == null) {
                expiryLogger = new ExpiryLogger();
                tx.putProperty(9, expiryLogger);
                tx.addOperation(expiryLogger);
            }
            expiryLogger.addExpiry(this.address, ref);
        }
        tx.addOperation(new TransactionOperationAbstract(){

            @Override
            public void afterCommit(Transaction tx) {
                QueueImpl.this.refCountForConsumers.check();
            }
        });
    }

    @Override
    public boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref) throws Exception {
        return this.sendToDeadLetterAddress(tx, ref, this.addressSettingsRepository.getMatch(this.address.toString()).getDeadLetterAddress());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref, SimpleString deadLetterAddress) throws Exception {
        if (deadLetterAddress == null) {
            ActiveMQServerLogger.LOGGER.messageExceededMaxDeliveryNoDLA(ref, this.name);
            ref.acknowledge(tx, AckReason.KILLED, null);
            return false;
        }
        this.createDeadLetterResources();
        Bindings bindingList = this.postOffice.lookupBindingsForAddress(deadLetterAddress);
        if (bindingList != null && !bindingList.getBindings().isEmpty()) {
            ActiveMQServerLogger.LOGGER.messageExceededMaxDeliverySendtoDLA(ref, deadLetterAddress, this.name);
            RoutingStatus status = this.move(tx, deadLetterAddress, null, ref, false, AckReason.KILLED, null);
            if (!status.equals((Object)RoutingStatus.NO_BINDINGS)) return true;
            if (!this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString()).isAutoCreateDeadLetterResources()) return true;
            ActiveMQServerLogger.LOGGER.noMatchingBindingsOnDLAWithAutoCreateDLAResources(deadLetterAddress, ref.toString());
            return true;
        }
        ActiveMQServerLogger.LOGGER.messageExceededMaxDelivery(ref, deadLetterAddress);
        ref.acknowledge(tx, AckReason.KILLED, null);
        return false;
    }

    private void createDeadLetterResources() throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString());
        if (addressSettings.isAutoCreateDeadLetterResources() && !this.getAddress().equals((Object)addressSettings.getDeadLetterAddress()) && addressSettings.getDeadLetterAddress() != null && addressSettings.getDeadLetterAddress().length() != 0) {
            SimpleString dlqName = addressSettings.getDeadLetterQueuePrefix().concat(this.getAddress()).concat(addressSettings.getDeadLetterQueueSuffix());
            SimpleString dlqFilter = new SimpleString(String.format("%s = '%s'", Message.HDR_ORIGINAL_ADDRESS, this.getAddress()));
            this.server.createQueue(new QueueConfiguration(dlqName).setAddress(addressSettings.getDeadLetterAddress()).setFilterString(dlqFilter).setAutoCreated(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(true)), true);
        }
    }

    private void createExpiryResources() throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString());
        if (addressSettings.isAutoCreateExpiryResources() && !this.getAddress().equals((Object)addressSettings.getExpiryAddress()) && addressSettings.getExpiryAddress() != null && addressSettings.getExpiryAddress().length() != 0) {
            SimpleString expiryQueueName = addressSettings.getExpiryQueuePrefix().concat(this.getAddress()).concat(addressSettings.getExpiryQueueSuffix());
            SimpleString expiryFilter = new SimpleString(String.format("%s = '%s'", Message.HDR_ORIGINAL_ADDRESS, this.getAddress()));
            this.server.createQueue(new QueueConfiguration(expiryQueueName).setAddress(addressSettings.getExpiryAddress()).setFilterString(expiryFilter).setAutoCreated(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(true)), true);
        }
    }

    private RoutingStatus move(Transaction originalTX, SimpleString address, Binding binding, MessageReference ref, boolean rejectDuplicate, AckReason reason, ServerConsumer consumer) throws Exception {
        Transaction tx = originalTX != null ? originalTX : new TransactionImpl(this.storageManager);
        Message copyMessage = this.makeCopy(ref, reason == AckReason.EXPIRED);
        copyMessage.setAddress(address);
        RoutingStatus routingStatus = this.postOffice.route(copyMessage, tx, false, rejectDuplicate, binding);
        this.acknowledge(tx, ref, reason, consumer);
        if (originalTX == null) {
            tx.commit();
        }
        return routingStatus;
    }

    private boolean deliverDirect(MessageReference ref) {
        if (!this.deliverLock.tryLock()) {
            logger.tracef("Cannot perform a directDelivery because there is a running async deliver", new Object[0]);
            return false;
        }
        try {
            boolean bl = this.deliver(ref);
            return bl;
        }
        finally {
            this.deliverLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver(MessageReference ref) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (!this.supportsDirectDeliver) {
                return false;
            }
            if (this.isPaused() || !this.canDispatch() && this.redistributor == null) {
                return false;
            }
            if (this.checkExpired(ref)) {
                return true;
            }
            this.consumers.reset();
            while (this.consumers.hasNext() || this.redistributor != null) {
                ConsumerHolder holder = this.redistributor == null ? (ConsumerHolder)this.consumers.next() : this.redistributor;
                Object consumer = holder.consumer;
                SimpleString groupID = this.extractGroupID(ref);
                Consumer groupConsumer = this.getGroupConsumer(groupID);
                if (groupConsumer != null) {
                    consumer = groupConsumer;
                }
                int existingMemoryEstimate = ref.getMessageMemoryEstimate();
                HandleStatus status = this.handle(ref, (Consumer)consumer);
                QueueImpl.accountForChangeInMemoryEstimate(ref, existingMemoryEstimate);
                if (status == HandleStatus.HANDLED) {
                    MessageReference reference = this.redistributor == null ? this.handleMessageGroup(ref, (Consumer)consumer, groupConsumer, groupID) : ref;
                    this.incrementMesssagesAdded();
                    this.deliveriesInTransit.countUp();
                    reference.setInDelivery(true);
                    this.proceedDeliver((Consumer)consumer, reference);
                    this.consumers.reset();
                    return true;
                }
                if (this.redistributor == null && groupConsumer == null) continue;
                break;
            }
            if (logger.isTraceEnabled()) {
                logger.tracef("Queue " + this.getName() + " is out of direct delivery as no consumers handled a delivery", new Object[0]);
            }
            return false;
        }
    }

    private static void accountForChangeInMemoryEstimate(MessageReference ref, int existingMemoryEstimate) {
        PagingStore pageStore;
        int delta = ref.getMessageMemoryEstimate() - existingMemoryEstimate;
        if (delta > 0 && (pageStore = ref.getOwner()) != null) {
            pageStore.addSize(delta);
        }
    }

    private Consumer getGroupConsumer(SimpleString groupID) {
        Consumer groupConsumer = null;
        if (this.exclusive) {
            groupConsumer = this.exclusiveConsumer;
        } else if (groupID != null) {
            groupConsumer = this.groups.get(groupID);
        }
        return groupConsumer;
    }

    private MessageReference handleMessageGroup(MessageReference ref, Consumer consumer, Consumer groupConsumer, SimpleString groupID) {
        if (this.exclusive) {
            if (groupConsumer == null) {
                this.exclusiveConsumer = consumer;
                if (this.groupFirstKey != null) {
                    return new GroupFirstMessageReference(this.groupFirstKey, ref);
                }
            }
            this.consumers.repeat();
        } else if (groupID != null) {
            if (this.extractGroupSequence(ref) == -1) {
                this.groups.remove(groupID);
                this.consumers.repeat();
            } else if (groupConsumer == null) {
                this.groups.put(groupID, consumer);
                if (this.groupFirstKey != null) {
                    return new GroupFirstMessageReference(this.groupFirstKey, ref);
                }
            } else {
                this.consumers.repeat();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedDeliver(Consumer consumer, MessageReference reference) {
        try {
            consumer.proceedDeliver(reference);
        }
        catch (Throwable t) {
            this.errorProcessing(consumer, t, reference);
        }
        finally {
            this.deliveriesInTransit.countDown();
        }
    }

    @Override
    public void errorProcessing(Consumer consumer, Throwable t, MessageReference reference) {
        this.executor.execute(() -> this.internalErrorProcessing(consumer, t, reference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalErrorProcessing(Consumer consumer, Throwable t, MessageReference reference) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(t, consumer, reference);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
            }
            this.addHead(reference, false);
        }
    }

    private boolean checkExpired(MessageReference reference) {
        try {
            if (reference.getMessage().isExpired()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Reference " + reference + " is expired"));
                }
                reference.handled();
                try {
                    this.expire(reference);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorExpiringRef(e);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToCheckIfMessageExpired(e);
            return false;
        }
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(t, consumer, reference);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason) {
        block20: {
            QueueImpl queue = (QueueImpl)ref.getQueue();
            try {
                int count;
                boolean durableRef;
                Message message;
                queue.decDelivering(ref);
                if (this.nonDestructive && reason == AckReason.NORMAL) {
                    ref.setInDelivery(false);
                    return;
                }
                if (reason == AckReason.EXPIRED) {
                    this.messagesExpired.incrementAndGet();
                } else if (reason == AckReason.KILLED) {
                    this.messagesKilled.incrementAndGet();
                } else if (reason == AckReason.REPLACED) {
                    this.messagesReplaced.incrementAndGet();
                } else {
                    this.messagesAcknowledged.incrementAndGet();
                }
                if (ref.isPaged()) {
                    return;
                }
                try {
                    message = ref.getMessage();
                }
                catch (Throwable e) {
                    ActiveMQServerLogger.LOGGER.unableToPerformPostAcknowledge(e);
                    message = null;
                }
                if (message == null || this.nonDestructive && reason == AckReason.NORMAL) {
                    return;
                }
                queue.refDown(ref);
                boolean bl = durableRef = message.isDurable() && queue.isDurable();
                if (!durableRef || (count = queue.durableDown(message)) != 0) break block20;
                try {
                    if (!this.storageManager.deleteMessage(message.getMessageID())) {
                        ActiveMQServerLogger.LOGGER.errorRemovingMessage(new Exception(), message.getMessageID());
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorRemovingMessage(e, message.getMessageID());
                }
            }
            finally {
                this.postOffice.postAcknowledge(ref, reason);
            }
        }
    }

    void postRollback(LinkedList<MessageReference> refs) {
        this.postRollback(refs, false);
    }

    void postRollback(LinkedList<MessageReference> refs, boolean sorted) {
        if (this.purgeOnNoConsumers && this.getConsumerCount() == 0) {
            this.purgeAfterRollback(refs);
            return;
        }
        if (!this.isNonDestructive()) {
            if (sorted) {
                this.addSorted(refs, false);
            } else {
                this.addHead(refs, false);
            }
        }
    }

    private void purgeAfterRollback(LinkedList<MessageReference> refs) {
        try {
            TransactionImpl transaction = new TransactionImpl(this.storageManager);
            for (MessageReference reference : refs) {
                this.incDelivering(reference);
                this.acknowledge(transaction, reference, AckReason.KILLED, null);
            }
            transaction.commit();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private long calculateRedeliveryDelay(AddressSettings addressSettings, int deliveryCount) {
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        long maxRedeliveryDelay = addressSettings.getMaxRedeliveryDelay();
        double redeliveryMultiplier = addressSettings.getRedeliveryMultiplier();
        double collisionAvoidanceFactor = addressSettings.getRedeliveryCollisionAvoidanceFactor();
        int tmpDeliveryCount = deliveryCount > 0 ? deliveryCount - 1 : 0;
        long delay = (long)((double)redeliveryDelay * Math.pow(redeliveryMultiplier, tmpDeliveryCount));
        if (collisionAvoidanceFactor > 0.0) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            double variance = (((Random)random).nextBoolean() ? collisionAvoidanceFactor : -collisionAvoidanceFactor) * ((Random)random).nextDouble();
            delay = (long)((double)delay + (double)delay * variance);
        }
        if (delay > maxRedeliveryDelay) {
            delay = maxRedeliveryDelay;
        }
        return delay;
    }

    @Override
    public synchronized void resetMessagesAdded() {
        this.messagesAdded.set(0L);
    }

    @Override
    public synchronized void resetMessagesAcknowledged() {
        this.messagesAcknowledged.set(0L);
    }

    @Override
    public synchronized void resetMessagesExpired() {
        this.messagesExpired.set(0L);
    }

    @Override
    public synchronized void resetMessagesKilled() {
        this.messagesKilled.set(0L);
    }

    @Override
    public float getRate() {
        long locaMessageAdded = this.getMessagesAdded();
        float timeSlice = (float)(System.currentTimeMillis() - this.queueRateCheckTime.getAndSet(System.currentTimeMillis())) / 1000.0f;
        if (timeSlice == 0.0f) {
            this.messagesAddedSnapshot.getAndSet(locaMessageAdded);
            return 0.0f;
        }
        return BigDecimal.valueOf((float)(locaMessageAdded - this.messagesAddedSnapshot.getAndSet(locaMessageAdded)) / timeSlice).setScale(2, 0).floatValue();
    }

    @Override
    public void recheckRefCount(OperationContext context) {
        final ReferenceCounter refCount = this.refCountForConsumers;
        if (refCount != null) {
            context.executeOnCompletion(new IOCallback(){

                public void done() {
                    refCount.check();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            });
        }
    }

    public static MessageGroups<Consumer> groupMap(int groupBuckets) {
        if (groupBuckets == -1) {
            return new SimpleMessageGroups<Consumer>();
        }
        if (groupBuckets == 0) {
            return DisabledMessageGroups.instance();
        }
        return new BucketMessageGroups<Consumer>(groupBuckets);
    }

    @Override
    public QueueConfiguration getQueueConfiguration() {
        return new QueueConfiguration(this.name).setAddress(this.address).setId(this.id).setRoutingType(this.routingType).setFilterString(this.filter == null ? null : this.filter.getFilterString()).setDurable(Boolean.valueOf(this.isDurable())).setUser(this.user).setMaxConsumers(Integer.valueOf(this.maxConsumers)).setExclusive(Boolean.valueOf(this.exclusive)).setGroupRebalance(Boolean.valueOf(this.groupRebalance)).setGroupBuckets(Integer.valueOf(this.groupBuckets)).setGroupFirstKey(this.groupFirstKey).setLastValue(Boolean.valueOf(false)).setLastValueKey((String)null).setNonDestructive(Boolean.valueOf(this.nonDestructive)).setPurgeOnNoConsumers(Boolean.valueOf(this.purgeOnNoConsumers)).setConsumersBeforeDispatch(Integer.valueOf(this.consumersBeforeDispatch)).setDelayBeforeDispatch(Long.valueOf(this.delayBeforeDispatch)).setAutoDelete(Boolean.valueOf(this.autoDelete)).setAutoDeleteDelay(Long.valueOf(this.autoDeleteDelay)).setAutoDeleteMessageCount(Long.valueOf(this.autoDeleteMessageCount)).setRingSize(Long.valueOf(this.ringSize)).setConfigurationManaged(Boolean.valueOf(this.configurationManaged)).setTemporary(Boolean.valueOf(this.temporary)).setInternal(Boolean.valueOf(this.internalQueue)).setTransient(Boolean.valueOf(this.refCountForConsumers instanceof TransientQueueManagerImpl)).setAutoCreated(Boolean.valueOf(this.autoCreated));
    }

    private void incDelivering(MessageReference ref) {
        this.deliveringMetrics.incrementMetrics(ref);
    }

    public void decDelivering(MessageReference reference) {
        this.deliveringMetrics.decrementMetrics(reference);
    }

    private long getPersistentSize(MessageReference reference) {
        long size = 0L;
        try {
            size = reference.getPersistentSize() > 0L ? reference.getPersistentSize() : 0L;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
        }
        return size;
    }

    private void configureExpiry(AddressSettings settings) {
        this.expiryAddress = settings == null ? null : settings.getExpiryAddress();
    }

    private void configureSlowConsumerReaper(AddressSettings settings) {
        if (settings == null || settings.getSlowConsumerThreshold() == -1L) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
                this.slowConsumerReaperRunnable = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cancelled slow-consumer-reaper thread for queue \"" + this.getName() + "\""));
                }
            }
        } else if (this.slowConsumerReaperRunnable == null) {
            this.scheduleSlowConsumerReaper(settings);
        } else if (this.slowConsumerReaperRunnable.checkPeriod != settings.getSlowConsumerCheckPeriod() || this.slowConsumerReaperRunnable.threshold != (float)settings.getSlowConsumerThreshold() || !this.slowConsumerReaperRunnable.policy.equals((Object)settings.getSlowConsumerPolicy())) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
            }
            this.scheduleSlowConsumerReaper(settings);
        }
    }

    void scheduleSlowConsumerReaper(AddressSettings settings) {
        this.slowConsumerReaperRunnable = new SlowConsumerReaperRunnable(settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerThreshold(), settings.getSlowConsumerPolicy());
        this.slowConsumerReaperFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.slowConsumerReaperRunnable, settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerCheckPeriod(), TimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduled slow-consumer-reaper thread for queue \"" + this.getName() + "\"; slow-consumer-check-period=" + settings.getSlowConsumerCheckPeriod() + ", slow-consumer-threshold=" + settings.getSlowConsumerThreshold() + ", slow-consumer-policy=" + (Object)((Object)settings.getSlowConsumerPolicy())));
        }
    }

    private void enforceRing(boolean head) {
        if (this.ringSize != -1L) {
            this.enforceRing(null, false, head);
        }
    }

    private void enforceRing(MessageReference refToAck, boolean scheduling, boolean head) {
        int adjustment;
        int n = adjustment = head ? 1 : 0;
        if (this.getMessageCountForRing() + (long)adjustment > this.ringSize) {
            MessageReference messageReference = refToAck = refToAck == null ? (MessageReference)this.messageReferences.poll() : refToAck;
            if (refToAck != null) {
                if (logger.isDebugEnabled()) {
                    logger.debugf("Preserving ringSize %d by acking message ref %s", this.ringSize, (Object)refToAck);
                }
                this.referenceHandled(refToAck);
                try {
                    refToAck.acknowledge(null, AckReason.REPLACED, null);
                    if (!refToAck.isInDelivery() && !scheduling) {
                        this.refRemoved(refToAck);
                    }
                    refToAck.setAlreadyAcked();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debugf("Cannot preserve ringSize %d; message ref is null", this.ringSize);
            }
        }
    }

    private void checkDeadLetterAddressAndExpiryAddress(AddressSettings settings) {
        if (!(Env.isTestEnv() || this.internalQueue || this.address.equals((Object)this.server.getConfiguration().getManagementNotificationAddress()))) {
            if (settings.getDeadLetterAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoDLA(this.name);
            }
            if (settings.getExpiryAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoExpiryAddress(this.name);
            }
        }
    }

    private final class SlowConsumerReaperRunnable
    implements Runnable {
        private final SlowConsumerPolicy policy;
        private final float threshold;
        private final long checkPeriod;

        private SlowConsumerReaperRunnable(long checkPeriod, float threshold, SlowConsumerPolicy policy) {
            this.checkPeriod = checkPeriod;
            this.policy = policy;
            this.threshold = threshold;
        }

        @Override
        public void run() {
            float queueRate = QueueImpl.this.getRate();
            long queueMessages = QueueImpl.this.getMessageCount();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(QueueImpl.this.getAddress() + ":" + QueueImpl.this.getName() + " has " + queueMessages + " message(s) and " + QueueImpl.this.getConsumerCount() + " consumer(s) and is receiving messages at a rate of " + queueRate + " msgs/second."));
            }
            if (QueueImpl.this.consumers.size() == 0) {
                logger.debug((Object)"There are no consumers, no need to check slow consumer's rate");
                return;
            }
            float queueThreshold = this.threshold * (float)QueueImpl.this.consumers.size();
            if (queueRate < queueThreshold && (float)queueMessages < queueThreshold) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Insufficient messages received on queue \"" + QueueImpl.this.getName() + "\" to satisfy slow-consumer-threshold. Skipping inspection of consumer."));
                }
                return;
            }
            for (ConsumerHolder consumerHolder : QueueImpl.this.consumers) {
                ServerConsumerImpl serverConsumer;
                float consumerRate;
                Consumer consumer = consumerHolder.consumer();
                if (!(consumer instanceof ServerConsumerImpl) || !((consumerRate = (serverConsumer = (ServerConsumerImpl)consumer).getRate()) < this.threshold)) continue;
                RemotingConnection connection = null;
                ActiveMQServer server = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer();
                RemotingService remotingService = server.getRemotingService();
                for (RemotingConnection potentialConnection : remotingService.getConnections()) {
                    if (!potentialConnection.getID().toString().equals(serverConsumer.getConnectionID())) continue;
                    connection = potentialConnection;
                }
                serverConsumer.fireSlowConsumer();
                if (connection == null) continue;
                ActiveMQServerLogger.LOGGER.slowConsumerDetected(serverConsumer.getSessionID(), serverConsumer.getID(), QueueImpl.this.getName().toString(), connection.getRemoteAddress(), this.threshold, consumerRate);
                if (this.policy.equals((Object)SlowConsumerPolicy.KILL)) {
                    connection.killMessage(server.getNodeID());
                    remotingService.removeConnection(connection.getID());
                    connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsClosedByManagement(connection.getRemoteAddress()));
                    continue;
                }
                if (!this.policy.equals((Object)SlowConsumerPolicy.NOTIFY)) continue;
                TypedProperties props = new TypedProperties();
                props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, QueueImpl.this.getConsumerCount());
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, QueueImpl.this.address);
                props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)connection.getRemoteAddress()));
                if (connection.getID() != null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.toSimpleString((String)connection.getID().toString()));
                }
                props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, serverConsumer.getID());
                props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)serverConsumer.getSessionID()));
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_SLOW, props);
                ManagementService managementService = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer().getManagementService();
                try {
                    managementService.sendNotification(notification);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToSendSlowConsumerNotification(notification, e);
                }
            }
        }
    }

    private class AddressSettingsRepositoryListener
    implements HierarchicalRepositoryChangeListener {
        private AddressSettingsRepositoryListener() {
        }

        @Override
        public void onChange() {
            AddressSettings settings = (AddressSettings)QueueImpl.this.addressSettingsRepository.getMatch(((ActiveMQServerImpl)QueueImpl.this.server).getRuntimeTempQueueNamespace(QueueImpl.this.temporary) + QueueImpl.this.address.toString());
            QueueImpl.this.configureExpiry(settings);
            QueueImpl.this.checkDeadLetterAddressAndExpiryAddress(settings);
            QueueImpl.this.configureSlowConsumerReaper(settings);
        }
    }

    private final class QueueBrowserIterator
    implements LinkedListIterator<MessageReference> {
        LinkedListIterator<PagedReference> pagingIterator = null;
        LinkedListIterator<MessageReference> messagesIterator = null;
        Iterator<? extends MessageReference> lastIterator = null;
        MessageReference cachedNext = null;
        HashSet<PagePosition> previouslyBrowsed = new HashSet();

        private LinkedListIterator<PagedReference> getPagingIterator() {
            if (this.pagingIterator == null) {
                this.pagingIterator = QueueImpl.this.pageSubscription.iterator(true);
            }
            return this.pagingIterator;
        }

        private QueueBrowserIterator() {
            this.messagesIterator = new SynchronizedIterator((LinkedListIterator<MessageReference>)QueueImpl.this.messageReferences.iterator());
        }

        public boolean hasNext() {
            if (this.messagesIterator != null && this.messagesIterator.hasNext()) {
                this.lastIterator = this.messagesIterator;
                return true;
            }
            if (this.getPagingIterator() != null && this.getPagingIterator().hasNext()) {
                this.lastIterator = this.getPagingIterator();
                return true;
            }
            return false;
        }

        public MessageReference next() {
            if (this.cachedNext != null) {
                try {
                    MessageReference messageReference = this.cachedNext;
                    return messageReference;
                }
                finally {
                    this.cachedNext = null;
                }
            }
            if (this.messagesIterator != null && this.messagesIterator.hasNext()) {
                MessageReference msg = (MessageReference)this.messagesIterator.next();
                if (msg.isPaged()) {
                    this.previouslyBrowsed.add(((PagedReference)msg).getPosition());
                }
                return msg;
            }
            if (this.getPagingIterator() != null) {
                while (this.getPagingIterator().hasNext()) {
                    this.lastIterator = this.getPagingIterator();
                    PagedReference ref = (PagedReference)this.getPagingIterator().next();
                    if (this.previouslyBrowsed.contains(ref.getPosition())) continue;
                    return ref;
                }
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastIterator != null) {
                this.lastIterator.remove();
            }
        }

        public void repeat() {
        }

        public void close() {
            if (this.getPagingIterator() != null) {
                this.getPagingIterator().close();
            }
            if (this.messagesIterator != null) {
                this.messagesIterator.close();
            }
        }
    }

    private class SynchronizedIterator
    implements LinkedListIterator<MessageReference> {
        private final LinkedListIterator<MessageReference> iter;

        SynchronizedIterator(LinkedListIterator<MessageReference> iter) {
            this.iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repeat() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.repeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageReference next() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return (MessageReference)this.iter.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.remove();
            }
        }
    }

    abstract class QueueIterateAction {
        QueueIterateAction() {
        }

        public Integer expectedHits() {
            return null;
        }

        public abstract boolean actMessage(Transaction var1, MessageReference var2) throws Exception;
    }

    private final class DepageRunner
    implements Runnable {
        final boolean scheduleExpiry;

        private DepageRunner(boolean scheduleExpiry) {
            this.scheduleExpiry = scheduleExpiry;
        }

        @Override
        public void run() {
            try {
                QueueImpl.this.depage(this.scheduleExpiry);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorDelivering(e);
            }
        }
    }

    private final class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                try {
                    QueueImpl.this.enterCritical(2);
                    boolean needCheckDepage = false;
                    try {
                        QueueImpl.this.deliverLock.lock();
                        try {
                            needCheckDepage = QueueImpl.this.deliver();
                        }
                        finally {
                            QueueImpl.this.deliverLock.unlock();
                        }
                    }
                    finally {
                        QueueImpl.this.leaveCritical(2);
                    }
                    if (!needCheckDepage) break block12;
                    QueueImpl.this.enterCritical(4);
                    try {
                        QueueImpl.this.checkDepage(true);
                    }
                    finally {
                        QueueImpl.this.leaveCritical(4);
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDelivering(e);
                }
            }
        }
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final ArtemisExecutor executor1;

        DelayedAddRedistributor(ArtemisExecutor executor) {
            this.executor1 = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor(this.executor1);
                QueueImpl.this.clearRedistributorFuture();
            }
        }
    }

    protected static class ConsumerHolder<T extends Consumer>
    implements PriorityAware {
        final T consumer;
        LinkedListIterator<MessageReference> iter;

        ConsumerHolder(T consumer) {
            this.consumer = consumer;
        }

        private void resetIterator() {
            if (this.iter != null) {
                this.iter.close();
            }
            this.iter = null;
        }

        private Consumer consumer() {
            return this.consumer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumerHolder that = (ConsumerHolder)o;
            return Objects.equals(this.consumer, that.consumer);
        }

        public int hashCode() {
            return Objects.hash(this.consumer);
        }

        public int getPriority() {
            return this.consumer.getPriority();
        }
    }

    private class ExpiryLogger
    extends TransactionOperationAbstract {
        List<Pair<SimpleString, MessageReference>> expiries = new LinkedList<Pair<SimpleString, MessageReference>>();

        private ExpiryLogger() {
        }

        public void addExpiry(SimpleString address, MessageReference ref) {
            this.expiries.add((Pair<SimpleString, MessageReference>)new Pair((Object)address, (Object)ref));
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Pair<SimpleString, MessageReference> pair : this.expiries) {
                try {
                    QueueImpl.this.server.callBrokerMessagePlugins(plugin -> plugin.messageExpired((MessageReference)pair.getB(), (SimpleString)pair.getA(), null));
                }
                catch (Throwable e) {
                    logger.warn((Object)e.getMessage(), e);
                }
            }
            this.expiries.clear();
        }
    }

    class ExpiryScanner
    implements Runnable {
        public AtomicInteger scannerRunning = new AtomicInteger(0);

        ExpiryScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean expired = false;
            boolean hasElements = false;
            int elementsExpired = 0;
            LinkedList<MessageReference> expiredMessages = new LinkedList<MessageReference>();
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                if (QueueImpl.this.queueDestroyed) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Scanning for expires on " + QueueImpl.this.getName()));
                }
                LinkedListIterator<MessageReference> iter = QueueImpl.this.iterator();
                try {
                    while (QueueImpl.this.postOffice.isStarted() && iter.hasNext()) {
                        hasElements = true;
                        MessageReference ref = (MessageReference)iter.next();
                        if (!ref.getMessage().isExpired()) continue;
                        QueueImpl.this.incDelivering(ref);
                        expired = true;
                        expiredMessages.add(ref);
                        iter.remove();
                        if (++elementsExpired < 1000) continue;
                        logger.debug((Object)"Breaking loop of expiring");
                        this.scannerRunning.incrementAndGet();
                        QueueImpl.this.getExecutor().execute((Runnable)this);
                        break;
                    }
                }
                finally {
                    try {
                        iter.close();
                    }
                    catch (Throwable ref) {}
                    this.scannerRunning.decrementAndGet();
                    logger.debug((Object)("Scanning for expires on " + QueueImpl.this.getName() + " done"));
                }
            }
            if (!expiredMessages.isEmpty()) {
                TransactionImpl tx = new TransactionImpl(QueueImpl.this.storageManager);
                for (MessageReference ref : expiredMessages) {
                    try {
                        QueueImpl.this.expire(tx, ref);
                        QueueImpl.this.refRemoved(ref);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorExpiringReferencesOnQueue(e, ref);
                    }
                }
                try {
                    tx.commit();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToCommitTransaction(e);
                }
                logger.debug((Object)("Expired " + elementsExpired + " references"));
            }
            if ((!hasElements || expired) && QueueImpl.this.pageIterator != null && QueueImpl.this.pageIterator.tryNext() > 0) {
                QueueImpl.this.scheduleDepage(true);
            }
        }
    }
}

