/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import java.util.List;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public abstract class AbstractProtocolManager<P, I extends BaseInterceptor<P>, C extends RemotingConnection>
implements ProtocolManager<I> {
    protected void invokeInterceptors(List<I> interceptors, P message, C connection) {
        if (interceptors != null && !interceptors.isEmpty()) {
            for (BaseInterceptor interceptor : interceptors) {
                try {
                    if (interceptor.intercept(message, connection)) continue;
                    break;
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.error(e);
                }
            }
        }
    }
}

