/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateLoginModule;

public class TextFileCertificateLoginModule
extends CertificateLoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.user";
    private static final String ROLE_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.role";
    private Map<String, Set<String>> rolesByUser;
    private Map<String, String> usersByDn;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.usersByDn = this.load(USER_FILE_PROP_NAME, "", options).invertedPropertiesMap();
        this.rolesByUser = this.load(ROLE_FILE_PROP_NAME, "", options).invertedPropertiesValuesMap();
    }

    @Override
    protected String getUserNameForCertificates(X509Certificate[] certs) throws LoginException {
        if (certs == null) {
            throw new LoginException("Client certificates not found. Cannot authenticate.");
        }
        return this.usersByDn.get(this.getDistinguishedName(certs));
    }

    @Override
    protected Set<String> getUserRoles(String username) throws LoginException {
        Set<String> userRoles = this.rolesByUser.get(username);
        if (userRoles == null) {
            userRoles = Collections.emptySet();
        }
        return userRoles;
    }
}

