/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.messagecounter.MessageCounterManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedRoles;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.LiveOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.CoreTransactionDetail;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.SecurityFormatter;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class ActiveMQServerControlImpl
extends AbstractControl
implements ActiveMQServerControl,
NotificationEmitter,
org.apache.activemq.artemis.core.server.management.NotificationListener {
    private final PostOffice postOffice;
    private final Configuration configuration;
    private final ResourceManager resourceManager;
    private final RemotingService remotingService;
    private final ActiveMQServer server;
    private final MessageCounterManager messageCounterManager;
    private final NotificationBroadcasterSupport broadcaster;
    private final AtomicLong notifSeq = new AtomicLong(0L);

    public ActiveMQServerControlImpl(PostOffice postOffice, Configuration configuration, ResourceManager resourceManager, RemotingService remotingService, ActiveMQServer messagingServer, MessageCounterManager messageCounterManager, StorageManager storageManager, NotificationBroadcasterSupport broadcaster) throws Exception {
        super(ActiveMQServerControl.class, storageManager);
        this.postOffice = postOffice;
        this.configuration = configuration;
        this.resourceManager = resourceManager;
        this.remotingService = remotingService;
        this.server = messagingServer;
        this.messageCounterManager = messageCounterManager;
        this.broadcaster = broadcaster;
        this.server.getManagementService().addNotificationListener(this);
    }

    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.server.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getVersion() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.getVersion().getFullVersion();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isBackup() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.getHAPolicy().isBackup();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isSharedStore() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.getHAPolicy().isSharedStore();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getBindingsDirectory() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getBindingsDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getInterceptorClassNames() {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getIncomingInterceptorClassNames().toArray(new String[this.configuration.getIncomingInterceptorClassNames().size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getIncomingInterceptorClassNames() {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getIncomingInterceptorClassNames().toArray(new String[this.configuration.getIncomingInterceptorClassNames().size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getOutgoingInterceptorClassNames() {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getOutgoingInterceptorClassNames().toArray(new String[this.configuration.getOutgoingInterceptorClassNames().size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalBufferSize() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalBufferSize_AIO() : this.configuration.getJournalBufferSize_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalBufferTimeout() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalBufferTimeout_AIO() : this.configuration.getJournalBufferTimeout_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.checkStarted();
        this.clearIO();
        try {
            HAPolicy haPolicy = this.server.getHAPolicy();
            if (haPolicy instanceof SharedStoreSlavePolicy) {
                ((SharedStoreSlavePolicy)haPolicy).setFailoverOnServerShutdown(failoverOnServerShutdown);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isFailoverOnServerShutdown() {
        this.checkStarted();
        this.clearIO();
        try {
            HAPolicy haPolicy = this.server.getHAPolicy();
            if (haPolicy instanceof SharedStoreSlavePolicy) {
                boolean bl = ((SharedStoreSlavePolicy)haPolicy).isFailoverOnServerShutdown();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalMaxIO() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalMaxIO_AIO() : this.configuration.getJournalMaxIO_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getJournalDirectory() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getJournalDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalFileSize() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalFileSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalMinFiles() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalMinFiles();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalCompactMinFiles() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalCompactMinFiles();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalCompactPercentage() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalCompactPercentage();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPersistenceEnabled() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isPersistenceEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getJournalType() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getJournalType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getPagingDirectory() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getPagingDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getScheduledThreadPoolMaxSize() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getScheduledThreadPoolMaxSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getThreadPoolMaxSize() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getThreadPoolMaxSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getSecurityInvalidationInterval() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.configuration.getSecurityInvalidationInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isClustered() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isClustered();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isCreateBindingsDir() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isCreateBindingsDir();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isCreateJournalDir() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isCreateJournalDir();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isJournalSyncNonTransactional() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isJournalSyncNonTransactional();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isJournalSyncTransactional() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isJournalSyncTransactional();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isSecurityEnabled() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isSecurityEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isAsyncConnectionExecutionEnabled() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isAsyncConnectionExecutionEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployQueue(String address, String name, String filterString) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.deployQueue(new SimpleString(address), new SimpleString(name), new SimpleString(filterString), true, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployQueue(String address, String name, String filterStr, boolean durable) throws Exception {
        this.checkStarted();
        SimpleString filter = filterStr == null ? null : new SimpleString(filterStr);
        this.clearIO();
        try {
            this.server.deployQueue(new SimpleString(address), new SimpleString(name), filter, durable, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createQueue(String address, String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.createQueue(new SimpleString(address), new SimpleString(name), null, true, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueue(String address, String name, boolean durable) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.createQueue(new SimpleString(address), new SimpleString(name), null, durable, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueue(String address, String name, String filterStr, boolean durable) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            SimpleString filter = null;
            if (filterStr != null && !filterStr.trim().equals("")) {
                filter = new SimpleString(filterStr);
            }
            this.server.createQueue(new SimpleString(address), new SimpleString(name), filter, durable, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getQueueNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] queues = this.server.getManagementService().getResources(QueueControl.class);
            String[] names = new String[queues.length];
            for (int i = 0; i < queues.length; ++i) {
                QueueControl queue = (QueueControl)queues[i];
                names[i] = queue.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAddressNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] addresses = this.server.getManagementService().getResources(AddressControl.class);
            String[] names = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                AddressControl address = (AddressControl)addresses[i];
                names[i] = address.getAddress();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyQueue(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            SimpleString queueName = new SimpleString(name);
            this.server.destroyQueue(queueName, null, true);
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getConnectionCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.server.getConnectionCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void enableMessageCounters() {
        this.checkStarted();
        this.clearIO();
        try {
            this.setMessageCounterEnabled(true);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void disableMessageCounters() {
        this.checkStarted();
        this.clearIO();
        try {
            this.setMessageCounterEnabled(false);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetAllMessageCounters() {
        this.checkStarted();
        this.clearIO();
        try {
            this.messageCounterManager.resetAllCounters();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetAllMessageCounterHistories() {
        this.checkStarted();
        this.clearIO();
        try {
            this.messageCounterManager.resetAllCounterHistories();
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isMessageCounterEnabled() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isMessageCounterEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public synchronized long getMessageCounterSamplePeriod() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.messageCounterManager.getSamplePeriod();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public synchronized void setMessageCounterSamplePeriod(long newPeriod) {
        this.checkStarted();
        this.checkStarted();
        this.clearIO();
        try {
            if (newPeriod < 1000L) {
                if (newPeriod <= 0L) {
                    throw ActiveMQMessageBundle.BUNDLE.periodMustGreaterThanZero(newPeriod);
                }
                ActiveMQServerLogger.LOGGER.invalidMessageCounterPeriod(newPeriod);
            }
            if (this.messageCounterManager != null && newPeriod != this.messageCounterManager.getSamplePeriod()) {
                this.messageCounterManager.reschedule(newPeriod);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMessageCounterMaxDayCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.messageCounterManager.getMaxDayCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void setMessageCounterMaxDayCount(int count) {
        this.checkStarted();
        this.clearIO();
        try {
            if (count <= 0) {
                throw ActiveMQMessageBundle.BUNDLE.greaterThanZero(count);
            }
            this.messageCounterManager.setMaxDayCount(count);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listPreparedTransactions() {
        this.checkStarted();
        this.clearIO();
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            Map<Xid, Long> xids = this.resourceManager.getPreparedTransactionsWithCreationTime();
            ArrayList<Map.Entry<Xid, Long>> xidsSortedByCreationTime = new ArrayList<Map.Entry<Xid, Long>>(xids.entrySet());
            Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

                @Override
                public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                    return (int)(entry1.getValue() - entry2.getValue());
                }
            });
            String[] s = new String[xidsSortedByCreationTime.size()];
            int i = 0;
            for (Map.Entry<Xid, Long> entry : xidsSortedByCreationTime) {
                Date creation = new Date(entry.getValue());
                Xid xid = entry.getKey();
                s[i++] = dateFormat.format(creation) + " base64: " + XidImpl.toBase64String((Xid)xid) + " " + xid.toString();
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPreparedTransactionDetailsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Map<Xid, Long> xids = this.resourceManager.getPreparedTransactionsWithCreationTime();
            if (xids == null || xids.size() == 0) {
                String string = "";
                return string;
            }
            ArrayList<Map.Entry<Xid, Long>> xidsSortedByCreationTime = new ArrayList<Map.Entry<Xid, Long>>(xids.entrySet());
            Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

                @Override
                public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                    return (int)(entry1.getValue() - entry2.getValue());
                }
            });
            JSONArray txDetailListJson = new JSONArray();
            for (Map.Entry<Xid, Long> entry : xidsSortedByCreationTime) {
                Xid xid = entry.getKey();
                Transaction tx = this.resourceManager.getTransaction(xid);
                if (tx == null) continue;
                CoreTransactionDetail detail = new CoreTransactionDetail(xid, tx, entry.getValue());
                txDetailListJson.put((Object)detail.toJSON());
            }
            String string = txDetailListJson.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPreparedTransactionDetailsAsHTML() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Map<Xid, Long> xids = this.resourceManager.getPreparedTransactionsWithCreationTime();
            if (xids == null || xids.size() == 0) {
                String string = "<h3>*** Prepared Transaction Details ***</h3><p>No entry.</p>";
                return string;
            }
            ArrayList<Map.Entry<Xid, Long>> xidsSortedByCreationTime = new ArrayList<Map.Entry<Xid, Long>>(xids.entrySet());
            Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

                @Override
                public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                    return (int)(entry1.getValue() - entry2.getValue());
                }
            });
            StringBuilder html = new StringBuilder();
            html.append("<h3>*** Prepared Transaction Details ***</h3>");
            for (Map.Entry<Xid, Long> entry : xidsSortedByCreationTime) {
                Xid xid = entry.getKey();
                Transaction tx = this.resourceManager.getTransaction(xid);
                if (tx == null) continue;
                CoreTransactionDetail detail = new CoreTransactionDetail(xid, tx, entry.getValue());
                JSONObject txJson = detail.toJSON();
                html.append("<table border=\"1\">");
                html.append("<tr><th>creation_time</th>");
                html.append("<td>" + txJson.get("creation_time") + "</td>");
                html.append("<th>xid_as_base_64</th>");
                html.append("<td colspan=\"3\">" + txJson.get("xid_as_base64") + "</td></tr>");
                html.append("<tr><th>xid_format_id</th>");
                html.append("<td>" + txJson.get("xid_format_id") + "</td>");
                html.append("<th>xid_global_txid</th>");
                html.append("<td>" + txJson.get("xid_global_txid") + "</td>");
                html.append("<th>xid_branch_qual</th>");
                html.append("<td>" + txJson.get("xid_branch_qual") + "</td></tr>");
                html.append("<tr><th colspan=\"6\">Message List</th></tr>");
                html.append("<tr><td colspan=\"6\">");
                html.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
                JSONArray msgs = txJson.getJSONArray("tx_related_messages");
                for (int i = 0; i < msgs.length(); ++i) {
                    JSONObject msgJson = msgs.getJSONObject(i);
                    JSONObject props = msgJson.getJSONObject("message_properties");
                    StringBuilder propstr = new StringBuilder();
                    Iterator propkeys = props.keys();
                    while (propkeys.hasNext()) {
                        String key = (String)propkeys.next();
                        propstr.append(key);
                        propstr.append("=");
                        propstr.append(props.get(key));
                        propstr.append(", ");
                    }
                    html.append("<th>operation_type</th>");
                    html.append("<td>" + msgJson.get("message_operation_type") + "</th>");
                    html.append("<th>message_type</th>");
                    html.append("<td>" + msgJson.get("message_type") + "</td></tr>");
                    html.append("<tr><th>properties</th>");
                    html.append("<td colspan=\"3\">" + propstr.toString() + "</td></tr>");
                }
                html.append("</table></td></tr>");
                html.append("</table><br>");
            }
            String string = html.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listHeuristicCommittedTransactions() {
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getHeuristicCommittedTransactions();
            String[] s = new String[xids.size()];
            int i = 0;
            for (Xid xid : xids) {
                s[i++] = XidImpl.toBase64String((Xid)xid);
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listHeuristicRolledBackTransactions() {
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getHeuristicRolledbackTransactions();
            String[] s = new String[xids.size()];
            int i = 0;
            for (Xid xid : xids) {
                s[i++] = XidImpl.toBase64String((Xid)xid);
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean commitPreparedTransaction(String transactionAsBase64) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getPreparedTransactions();
            for (Xid xid : xids) {
                if (!XidImpl.toBase64String((Xid)xid).equals(transactionAsBase64)) continue;
                Transaction transaction = this.resourceManager.removeTransaction(xid);
                transaction.commit(false);
                long recordID = this.server.getStorageManager().storeHeuristicCompletion(xid, true);
                this.storageManager.waitOnOperations();
                this.resourceManager.putHeuristicCompletion(recordID, xid, true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rollbackPreparedTransaction(String transactionAsBase64) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getPreparedTransactions();
            for (Xid xid : xids) {
                if (!XidImpl.toBase64String((Xid)xid).equals(transactionAsBase64)) continue;
                Transaction transaction = this.resourceManager.removeTransaction(xid);
                transaction.rollback();
                long recordID = this.server.getStorageManager().storeHeuristicCompletion(xid, false);
                this.server.getStorageManager().waitOnOperations();
                this.resourceManager.putHeuristicCompletion(recordID, xid, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses() {
        this.checkStarted();
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            String[] remoteAddresses = new String[connections.size()];
            int i = 0;
            for (RemotingConnection connection : connections) {
                remoteAddresses[i++] = connection.getRemoteAddress();
            }
            String[] stringArray = remoteAddresses;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses(String ipAddress) {
        this.checkStarted();
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            ArrayList<String> remoteConnections = new ArrayList<String>();
            for (RemotingConnection connection : connections) {
                String remoteAddress = connection.getRemoteAddress();
                if (!remoteAddress.contains(ipAddress)) continue;
                remoteConnections.add(connection.getRemoteAddress());
            }
            String[] stringArray = remoteConnections.toArray(new String[remoteConnections.size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeConnectionsForAddress(String ipAddress) {
        this.checkStarted();
        this.clearIO();
        try {
            boolean closed = false;
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            for (RemotingConnection connection : connections) {
                String remoteAddress = connection.getRemoteAddress();
                if (!remoteAddress.contains(ipAddress)) continue;
                connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsClosedByManagement(ipAddress));
                this.remotingService.removeConnection(connection.getID());
                closed = true;
            }
            boolean bl = closed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeConsumerConnectionsForAddress(String address) {
        boolean closed = false;
        this.checkStarted();
        this.clearIO();
        try {
            for (Binding binding : this.postOffice.getMatchingBindings(SimpleString.toSimpleString((String)address)).getBindings()) {
                if (!(binding instanceof LocalQueueBinding)) continue;
                Queue queue = ((LocalQueueBinding)binding).getQueue();
                for (Consumer consumer : queue.getConsumers()) {
                    if (!(consumer instanceof ServerConsumer)) continue;
                    ServerConsumer serverConsumer = (ServerConsumer)consumer;
                    RemotingConnection connection = null;
                    for (RemotingConnection potentialConnection : this.remotingService.getConnections()) {
                        if (!potentialConnection.getID().toString().equals(serverConsumer.getConnectionID())) continue;
                        connection = potentialConnection;
                    }
                    if (connection == null) continue;
                    this.remotingService.removeConnection(connection.getID());
                    connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.consumerConnectionsClosedByManagement(address));
                    closed = true;
                }
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToCloseConsumerConnectionsForAddress(address, e);
        }
        finally {
            this.blockOnIO();
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeConnectionsForUser(String userName) {
        boolean closed = false;
        this.checkStarted();
        this.clearIO();
        try {
            for (ServerSession serverSession : this.server.getSessions()) {
                if (serverSession.getUsername() == null || !serverSession.getUsername().equals(userName)) continue;
                RemotingConnection connection = null;
                for (RemotingConnection potentialConnection : this.remotingService.getConnections()) {
                    if (!potentialConnection.getID().toString().equals(serverSession.getConnectionID().toString())) continue;
                    connection = potentialConnection;
                }
                if (connection == null) continue;
                this.remotingService.removeConnection(connection.getID());
                connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsForUserClosedByManagement(userName));
                closed = true;
            }
        }
        finally {
            this.blockOnIO();
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listConnectionIDs() {
        this.checkStarted();
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            String[] connectionIDs = new String[connections.size()];
            int i = 0;
            for (RemotingConnection connection : connections) {
                connectionIDs[i++] = connection.getID().toString();
            }
            String[] stringArray = connectionIDs;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSessions(String connectionID) {
        this.checkStarted();
        this.clearIO();
        try {
            List<ServerSession> sessions = this.server.getSessions(connectionID);
            String[] sessionIDs = new String[sessions.size()];
            int i = 0;
            for (ServerSession serverSession : sessions) {
                sessionIDs[i++] = serverSession.getName();
            }
            String[] stringArray = sessionIDs;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listProducersInfoAsJSON() throws Exception {
        JSONArray producers = new JSONArray();
        for (ServerSession session : this.server.getSessions()) {
            session.describeProducersInfo(producers);
        }
        return producers.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getConnectors() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Collection<TransportConfiguration> connectorConfigurations = this.configuration.getConnectorConfigurations().values();
            Object[] ret = new Object[connectorConfigurations.size()];
            int i = 0;
            for (TransportConfiguration config : connectorConfigurations) {
                Object[] tc = new Object[]{config.getName(), config.getFactoryClassName(), config.getParams()};
                ret[i++] = tc;
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectorsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            for (TransportConfiguration config : this.configuration.getConnectorConfigurations().values()) {
                array.put((Object)new JSONObject((Object)config));
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Set roles = SecurityFormatter.createSecurity((String)sendRoles, (String)consumeRoles, (String)createDurableQueueRoles, (String)deleteDurableQueueRoles, (String)createNonDurableQueueRoles, (String)deleteNonDurableQueueRoles, (String)manageRoles);
            this.server.getSecurityRepository().addMatch(addressMatch, roles);
            PersistedRoles persistedRoles = new PersistedRoles(addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles);
            this.storageManager.storeSecurityRoles(persistedRoles);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void removeSecuritySettings(String addressMatch) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.getSecurityRepository().removeMatch(addressMatch);
            this.storageManager.deleteSecurityRoles(new SimpleString(addressMatch));
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRoles(String addressMatch) throws Exception {
        this.checkStarted();
        this.checkStarted();
        this.clearIO();
        try {
            Set<Role> roles = this.server.getSecurityRepository().getMatch(addressMatch);
            Object[] objRoles = new Object[roles.size()];
            int i = 0;
            for (Role role : roles) {
                objRoles[i++] = new Object[]{role.getName(), CheckType.SEND.hasRole(role), CheckType.CONSUME.hasRole(role), CheckType.CREATE_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_DURABLE_QUEUE.hasRole(role), CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role), CheckType.MANAGE.hasRole(role)};
            }
            Object[] objectArray = objRoles;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRolesAsJSON(String addressMatch) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JSONArray json = new JSONArray();
            Set<Role> roles = this.server.getSecurityRepository().getMatch(addressMatch);
            for (Role role : roles) {
                json.put((Object)new JSONObject((Object)role));
            }
            String string = json.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getAddressSettingsAsJSON(String address) throws Exception {
        this.checkStarted();
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(address);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (addressSettings.getDeadLetterAddress() != null) {
            settings.put("DLA", addressSettings.getDeadLetterAddress());
        }
        if (addressSettings.getExpiryAddress() != null) {
            settings.put("expiryAddress", addressSettings.getExpiryAddress());
        }
        settings.put("expiryDelay", addressSettings.getExpiryDelay());
        settings.put("maxDeliveryAttempts", addressSettings.getMaxDeliveryAttempts());
        settings.put("pageCacheMaxSize", addressSettings.getPageCacheMaxSize());
        settings.put("maxSizeBytes", addressSettings.getMaxSizeBytes());
        settings.put("pageSizeBytes", addressSettings.getPageSizeBytes());
        settings.put("redeliveryDelay", addressSettings.getRedeliveryDelay());
        settings.put("redeliveryMultiplier", addressSettings.getRedeliveryMultiplier());
        settings.put("maxRedeliveryDelay", addressSettings.getMaxRedeliveryDelay());
        settings.put("redistributionDelay", addressSettings.getRedistributionDelay());
        settings.put("lastValueQueue", addressSettings.isLastValueQueue());
        settings.put("sendToDLAOnNoRoute", addressSettings.isSendToDLAOnNoRoute());
        String policy = addressSettings.getAddressFullMessagePolicy() == AddressFullMessagePolicy.PAGE ? "PAGE" : (addressSettings.getAddressFullMessagePolicy() == AddressFullMessagePolicy.BLOCK ? "BLOCK" : (addressSettings.getAddressFullMessagePolicy() == AddressFullMessagePolicy.DROP ? "DROP" : "FAIL"));
        settings.put("addressFullMessagePolicy", policy);
        settings.put("slowConsumerThreshold", addressSettings.getSlowConsumerThreshold());
        settings.put("slowConsumerCheckPeriod", addressSettings.getSlowConsumerCheckPeriod());
        policy = addressSettings.getSlowConsumerPolicy() == SlowConsumerPolicy.NOTIFY ? "NOTIFY" : "KILL";
        settings.put("slowConsumerPolicy", policy);
        settings.put("autoCreateJmsQueues", addressSettings.isAutoCreateJmsQueues());
        settings.put("autoDeleteJmsQueues", addressSettings.isAutoDeleteJmsQueues());
        JSONObject jsonObject = new JSONObject(settings);
        return jsonObject.toString();
    }

    public void addAddressSettings(String address, String DLA, String expiryAddress, long expiryDelay, boolean lastValueQueue, int deliveryAttempts, long maxSizeBytes, int pageSizeBytes, int pageMaxCacheSize, long redeliveryDelay, double redeliveryMultiplier, long maxRedeliveryDelay, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy, long slowConsumerThreshold, long slowConsumerCheckPeriod, String slowConsumerPolicy, boolean autoCreateJmsQueues, boolean autoDeleteJmsQueues) throws Exception {
        this.checkStarted();
        if ((long)pageSizeBytes > maxSizeBytes && maxSizeBytes > 0L) {
            throw new IllegalStateException("pageSize has to be lower than maxSizeBytes. Invalid argument (" + pageSizeBytes + " < " + maxSizeBytes + ")");
        }
        if (maxSizeBytes < -1L) {
            throw new IllegalStateException("Invalid argument on maxSizeBytes");
        }
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(DLA == null ? null : new SimpleString(DLA));
        addressSettings.setExpiryAddress(expiryAddress == null ? null : new SimpleString(expiryAddress));
        addressSettings.setExpiryDelay(expiryDelay);
        addressSettings.setLastValueQueue(lastValueQueue);
        addressSettings.setMaxDeliveryAttempts(deliveryAttempts);
        addressSettings.setPageCacheMaxSize(pageMaxCacheSize);
        addressSettings.setMaxSizeBytes(maxSizeBytes);
        addressSettings.setPageSizeBytes(pageSizeBytes);
        addressSettings.setRedeliveryDelay(redeliveryDelay);
        addressSettings.setRedeliveryMultiplier(redeliveryMultiplier);
        addressSettings.setMaxRedeliveryDelay(maxRedeliveryDelay);
        addressSettings.setRedistributionDelay(redistributionDelay);
        addressSettings.setSendToDLAOnNoRoute(sendToDLAOnNoRoute);
        if (addressFullMessagePolicy == null) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("PAGE")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("DROP")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("BLOCK")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("FAIL")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        }
        addressSettings.setSlowConsumerThreshold(slowConsumerThreshold);
        addressSettings.setSlowConsumerCheckPeriod(slowConsumerCheckPeriod);
        if (slowConsumerPolicy == null) {
            addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
        } else if (slowConsumerPolicy.equalsIgnoreCase("NOTIFY")) {
            addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
        } else if (slowConsumerPolicy.equalsIgnoreCase("KILL")) {
            addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        }
        addressSettings.setAutoCreateJmsQueues(autoCreateJmsQueues);
        addressSettings.setAutoDeleteJmsQueues(autoDeleteJmsQueues);
        this.server.getAddressSettingsRepository().addMatch(address, addressSettings);
        this.storageManager.storeAddressSetting(new PersistedAddressSetting(new SimpleString(address), addressSettings));
    }

    public void removeAddressSettings(String addressMatch) throws Exception {
        this.checkStarted();
        this.server.getAddressSettingsRepository().removeMatch(addressMatch);
        this.storageManager.deleteAddressSetting(new SimpleString(addressMatch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueueInfoToQueue(String queueName, String address) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.postOffice.sendQueueInfoToQueue(new SimpleString(queueName), new SimpleString(address));
            GroupingHandler handler = this.server.getGroupingHandler();
            if (handler != null) {
                handler.resendPending();
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDivertNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] diverts = this.server.getManagementService().getResources(DivertControl.class);
            String[] names = new String[diverts.length];
            for (int i = 0; i < diverts.length; ++i) {
                DivertControl divert = (DivertControl)diverts[i];
                names[i] = divert.getUniqueName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            DivertConfiguration config = new DivertConfiguration().setName(name).setRoutingName(routingName).setAddress(address).setForwardingAddress(forwardingAddress).setExclusive(exclusive).setFilterString(filterString).setTransformerClassName(transformerClassName);
            this.server.deployDivert(config);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyDivert(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.destroyDivert(SimpleString.toSimpleString((String)name));
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBridgeNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] bridges = this.server.getManagementService().getResources(BridgeControl.class);
            String[] names = new String[bridges.length];
            for (int i = 0; i < bridges.length; ++i) {
                BridgeControl bridge = (BridgeControl)bridges[i];
                names[i] = bridge.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, int producerWindowSize, long clientFailureCheckPeriod, String staticConnectorsOrDiscoveryGroup, boolean useDiscoveryGroup, boolean ha, String user, String password) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setTransformerClassName(transformerClassName).setClientFailureCheckPeriod(clientFailureCheckPeriod).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setHA(ha).setUser(user).setPassword(password);
            if (useDiscoveryGroup) {
                config.setDiscoveryGroupName(staticConnectorsOrDiscoveryGroup);
            } else {
                config.setStaticConnectors(ActiveMQServerControlImpl.toList(staticConnectorsOrDiscoveryGroup));
            }
            this.server.deployBridge(config);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, long clientFailureCheckPeriod, String staticConnectorsOrDiscoveryGroup, boolean useDiscoveryGroup, boolean ha, String user, String password) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setTransformerClassName(transformerClassName).setClientFailureCheckPeriod(clientFailureCheckPeriod).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setHA(ha).setUser(user).setPassword(password);
            if (useDiscoveryGroup) {
                config.setDiscoveryGroupName(staticConnectorsOrDiscoveryGroup);
            } else {
                config.setStaticConnectors(ActiveMQServerControlImpl.toList(staticConnectorsOrDiscoveryGroup));
            }
            this.server.deployBridge(config);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyBridge(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.destroyBridge(name);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void forceFailover() throws Exception {
        this.checkStarted();
        this.clearIO();
        this.server.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDuplicateIdCache(String address, Object[] ids) throws Exception {
        this.clearIO();
        try {
            DuplicateIDCache duplicateIDCache = this.server.getPostOffice().getDuplicateIDCache(new SimpleString(address));
            for (Object id : ids) {
                duplicateIDCache.addToCache(((String)id).getBytes(), null);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public void scaleDown(String connector) throws Exception {
        this.checkStarted();
        this.clearIO();
        HAPolicy haPolicy = this.server.getHAPolicy();
        if (haPolicy instanceof LiveOnlyPolicy) {
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            if (liveOnlyPolicy.getScaleDownPolicy() == null) {
                liveOnlyPolicy.setScaleDownPolicy(new ScaleDownPolicy());
            }
            liveOnlyPolicy.getScaleDownPolicy().setEnabled(true);
            if (connector != null) {
                liveOnlyPolicy.getScaleDownPolicy().getConnectors().add(0, connector);
            }
            this.server.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.clearIO();
        try {
            this.broadcaster.removeNotificationListener(listener, filter, handback);
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.clearIO();
        try {
            this.broadcaster.removeNotificationListener(listener);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.clearIO();
        try {
            this.broadcaster.addNotificationListener(listener, filter, handback);
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        CoreNotificationType[] values = CoreNotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, this.getClass().getName(), "Notifications emitted by a Core Server")};
    }

    private synchronized void setMessageCounterEnabled(boolean enable) {
        if (this.isStarted()) {
            if (this.configuration.isMessageCounterEnabled() && !enable) {
                this.stopMessageCounters();
            } else if (!this.configuration.isMessageCounterEnabled() && enable) {
                this.startMessageCounters();
            }
        }
        this.configuration.setMessageCounterEnabled(enable);
    }

    private void startMessageCounters() {
        this.messageCounterManager.start();
    }

    private void stopMessageCounters() {
        this.messageCounterManager.stop();
        this.messageCounterManager.resetAllCounters();
        this.messageCounterManager.resetAllCounterHistories();
    }

    public long getConnectionTTLOverride() {
        return this.configuration.getConnectionTTLOverride();
    }

    public int getIDCacheSize() {
        return this.configuration.getIDCacheSize();
    }

    public String getLargeMessagesDirectory() {
        return this.configuration.getLargeMessagesDirectory();
    }

    public String getManagementAddress() {
        return this.configuration.getManagementAddress().toString();
    }

    public String getManagementNotificationAddress() {
        return this.configuration.getManagementNotificationAddress().toString();
    }

    public long getMessageExpiryScanPeriod() {
        return this.configuration.getMessageExpiryScanPeriod();
    }

    public long getMessageExpiryThreadPriority() {
        return this.configuration.getMessageExpiryThreadPriority();
    }

    public long getTransactionTimeout() {
        return this.configuration.getTransactionTimeout();
    }

    public long getTransactionTimeoutScanPeriod() {
        return this.configuration.getTransactionTimeoutScanPeriod();
    }

    public boolean isPersistDeliveryCountBeforeDelivery() {
        return this.configuration.isPersistDeliveryCountBeforeDelivery();
    }

    public boolean isPersistIDCache() {
        return this.configuration.isPersistIDCache();
    }

    public boolean isWildcardRoutingEnabled() {
        return this.configuration.isWildcardRoutingEnabled();
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(ActiveMQServerControl.class);
    }

    private void checkStarted() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException("Broker is not started. It can not be managed yet");
        }
    }

    public String[] listTargetAddresses(String sessionID) {
        ServerSession session = this.server.getSessionByID(sessionID);
        if (session != null) {
            return session.getTargetAddresses();
        }
        return new String[0];
    }

    private static List<String> toList(String commaSeparatedString) {
        String[] values;
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return list;
        }
        for (String value : values = commaSeparatedString.split(",")) {
            list.add(value.trim());
        }
        return list;
    }

    public void onNotification(Notification notification) {
        if (!(notification.getType() instanceof CoreNotificationType)) {
            return;
        }
        CoreNotificationType type = (CoreNotificationType)notification.getType();
        TypedProperties prop = notification.getProperties();
        this.broadcaster.sendNotification(new javax.management.Notification(type.toString(), (Object)this, this.notifSeq.incrementAndGet(), notification.toString()));
    }
}

