/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.Bridge;

public class BridgeControlImpl
extends AbstractControl
implements BridgeControl {
    private final Bridge bridge;
    private final BridgeConfiguration configuration;

    public BridgeControlImpl(Bridge bridge, StorageManager storageManager, BridgeConfiguration configuration) throws Exception {
        super(BridgeControl.class, storageManager);
        this.bridge = bridge;
        this.configuration = configuration;
    }

    public String[] getStaticConnectors() throws Exception {
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getStaticConnectors().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getForwardingAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getForwardingAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getQueueName() {
        this.clearIO();
        try {
            String string = this.configuration.getQueueName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getDiscoveryGroupName() {
        this.clearIO();
        try {
            String string = this.configuration.getDiscoveryGroupName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getFilterString() {
        this.clearIO();
        try {
            String string = this.configuration.getFilterString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getReconnectAttempts() {
        this.clearIO();
        try {
            int n = this.configuration.getReconnectAttempts();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getName() {
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getRetryInterval() {
        this.clearIO();
        try {
            long l = this.configuration.getRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public double getRetryIntervalMultiplier() {
        this.clearIO();
        try {
            double d = this.configuration.getRetryIntervalMultiplier();
            return d;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getTransformerClassName() {
        this.clearIO();
        try {
            String string = this.configuration.getTransformerClassName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.bridge.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isUseDuplicateDetection() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isUseDuplicateDetection();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isHA() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isHA();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void start() throws Exception {
        this.clearIO();
        try {
            this.bridge.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void stop() throws Exception {
        this.clearIO();
        try {
            this.bridge.stop();
            this.bridge.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(BridgeControl.class);
    }
}

