/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.security.User;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;

public class SecurityConfiguration {
    protected final Map<String, User> users = new HashMap<String, User>();
    protected String defaultUser = null;
    protected final Map<String, List<String>> roles = new HashMap<String, List<String>>();

    public SecurityConfiguration() {
    }

    public SecurityConfiguration(Map<String, String> users, Map<String, List<String>> roles) {
        for (Map.Entry<String, String> entry : users.entrySet()) {
            this.addUser(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, List<String>> entry : roles.entrySet()) {
            for (String role : entry.getValue()) {
                this.addRole(entry.getKey(), role);
            }
        }
    }

    public void addUser(String user, String password) {
        if (user == null) {
            throw ActiveMQMessageBundle.BUNDLE.nullUser();
        }
        if (password == null) {
            throw ActiveMQMessageBundle.BUNDLE.nullPassword();
        }
        this.users.put(user, new User(user, password));
    }

    public void removeUser(String user) {
        this.users.remove(user);
        this.roles.remove(user);
    }

    public void addRole(String user, String role) {
        if (this.roles.get(user) == null) {
            this.roles.put(user, new ArrayList());
        }
        this.roles.get(user).add(role);
    }

    public void removeRole(String user, String role) {
        if (this.roles.get(user) == null) {
            return;
        }
        this.roles.get(user).remove(role);
    }

    public void setDefaultUser(String username) {
        this.defaultUser = username;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public User getUser(String username) {
        return this.users.get(username);
    }

    public List<String> getRole(String username) {
        return this.roles.get(username);
    }
}

