/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.osgi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.osgi.ProtocolTracker;
import org.apache.activemq.artemis.osgi.ServerTrackerCallBack;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DataSourceTracker
implements ServiceTrackerCustomizer<DataSource, DataSource> {
    private static final Logger LOG = Logger.getLogger(ProtocolTracker.class.getName());
    private final String name;
    private final BundleContext context;
    private final DatabaseStorageConfiguration dsc;
    private final ServerTrackerCallBack callback;

    public DataSourceTracker(String name, BundleContext context, DatabaseStorageConfiguration dsc, ServerTrackerCallBack callback) {
        this.name = name;
        this.context = context;
        this.dsc = dsc;
        this.callback = callback;
    }

    public DataSource addingService(ServiceReference<DataSource> reference) {
        DataSource dataSource = (DataSource)this.context.getService(reference);
        this.dsc.setDataSource(dataSource);
        try (Connection conn = dataSource.getConnection();){
            this.dsc.setSqlProvider(JDBCUtils.getSQLProviderFactory((String)conn.getMetaData().getURL()));
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Error getting dataSource provider infos", ex);
        }
        this.callback.setDataSourceDependency(false);
        try {
            this.callback.start();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error starting broker " + this.name, ex);
        }
        return dataSource;
    }

    public void modifiedService(ServiceReference<DataSource> reference, DataSource service) {
    }

    public void removedService(ServiceReference<DataSource> reference, DataSource service) {
        this.callback.setDataSourceDependency(true);
        try {
            this.callback.stop();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error stopping broker " + this.name, ex);
        }
    }
}

