/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.util.Map;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessagePull;

public class AMQCompositeConsumerBrokerExchange
extends AMQConsumerBrokerExchange {
    private final Map<ActiveMQDestination, AMQConsumer> consumerMap;

    public AMQCompositeConsumerBrokerExchange(AMQSession amqSession, Map<ActiveMQDestination, AMQConsumer> consumerMap) {
        super(amqSession);
        this.consumerMap = consumerMap;
    }

    @Override
    public void processMessagePull(MessagePull messagePull) throws Exception {
        AMQConsumer amqConsumer = this.consumerMap.get(messagePull.getDestination());
        if (amqConsumer != null) {
            amqConsumer.processMessagePull(messagePull);
        }
    }

    @Override
    public void acknowledge(MessageAck ack) throws Exception {
        AMQConsumer amqConsumer = this.consumerMap.get(ack.getDestination());
        if (amqConsumer != null) {
            this.amqSession.acknowledge(ack, amqConsumer);
        }
    }

    @Override
    public void removeConsumer() throws Exception {
        for (AMQConsumer amqConsumer : this.consumerMap.values()) {
            amqConsumer.removeConsumer();
        }
    }
}

