/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQServerSession;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.ByteSequence;

public class OpenWireUtil {
    public static ActiveMQBuffer toActiveMQBuffer(ByteSequence bytes) {
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)bytes.length);
        buffer.writeBytes(bytes.data, bytes.offset, bytes.length);
        return buffer;
    }

    public static SimpleString toCoreAddress(ActiveMQDestination dest) {
        if (dest.isQueue()) {
            return new SimpleString("jms.queue." + dest.getPhysicalName());
        }
        return new SimpleString("jms.topic." + dest.getPhysicalName());
    }

    public static ActiveMQDestination toAMQAddress(ServerMessage message, ActiveMQDestination actualDestination) {
        String address = message.getAddress().toString();
        String strippedAddress = address.replace("jms.queue.", "").replace("jms.topic.", "");
        if (actualDestination.isQueue()) {
            return new ActiveMQQueue(strippedAddress);
        }
        return new ActiveMQTopic(strippedAddress);
    }

    public static void validateDestination(ActiveMQDestination destination, AMQSession amqSession) throws Exception {
        SimpleString physicalName;
        AMQServerSession coreSession;
        BindingQueryResult result;
        if (destination.isQueue() && !(result = (coreSession = amqSession.getCoreSession()).executeBindingQuery(physicalName = OpenWireUtil.toCoreAddress(destination))).isExists() && !result.isAutoCreateJmsQueues()) {
            throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(physicalName);
        }
    }

    public static String convertWildcard(String physicalName) {
        return physicalName.replaceAll("(\\.>)+", ".#");
    }
}

