/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireUtil;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.MarshallingSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.UTF8Buffer;

public class OpenWireMessageConverter
implements MessageConverter {
    public static final String AMQ_PREFIX = "__HDR_";
    public static final String AMQ_MSG_DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY = "__HDR_dlqDeliveryFailureCause";
    private static final String AMQ_MSG_ARRIVAL = "__HDR_ARRIVAL";
    private static final String AMQ_MSG_BROKER_IN_TIME = "__HDR_BROKER_IN_TIME";
    private static final String AMQ_MSG_BROKER_PATH = "__HDR_BROKER_PATH";
    private static final String AMQ_MSG_CLUSTER = "__HDR_CLUSTER";
    private static final String AMQ_MSG_COMMAND_ID = "__HDR_COMMAND_ID";
    private static final String AMQ_MSG_DATASTRUCTURE = "__HDR_DATASTRUCTURE";
    private static final String AMQ_MSG_GROUP_ID = "__HDR_GROUP_ID";
    private static final String AMQ_MSG_GROUP_SEQUENCE = "__HDR_GROUP_SEQUENCE";
    private static final String AMQ_MSG_MESSAGE_ID = "__HDR_MESSAGE_ID";
    private static final String AMQ_MSG_ORIG_DESTINATION = "__HDR_ORIG_DESTINATION";
    private static final String AMQ_MSG_ORIG_TXID = "__HDR_ORIG_TXID";
    private static final String AMQ_MSG_PRODUCER_ID = "__HDR_PRODUCER_ID";
    private static final String AMQ_MSG_MARSHALL_PROP = "__HDR_MARSHALL_PROP";
    private static final String AMQ_MSG_REDELIVER_COUNTER = "__HDR_REDELIVER_COUNTER";
    private static final String AMQ_MSG_REPLY_TO = "__HDR_REPLY_TO";
    private static final String AMQ_MSG_CONSUMER_ID = "__HDR_CONSUMER_ID";
    private static final String AMQ_MSG_TX_ID = "__HDR_TX_ID";
    private static final String AMQ_MSG_USER_ID = "__HDR_USER_ID";
    private static final String AMQ_MSG_COMPRESSED = "__HDR_COMPRESSED";
    private static final String AMQ_MSG_DROPPABLE = "__HDR_DROPPABLE";

    public ServerMessage inbound(Object message) {
        return null;
    }

    public Object outbound(ServerMessage message, int deliveryCount) {
        return null;
    }

    public static void toCoreMessage(ServerMessageImpl coreMessage, Message messageSend, WireFormat marshaller) throws IOException {
        String userId;
        TransactionId txId;
        ConsumerId consumerId;
        ByteSequence propBytes;
        String groupId;
        DataStructure ds;
        BrokerId[] cluster;
        String type = messageSend.getType();
        if (type != null) {
            coreMessage.putStringProperty(new SimpleString("JMSType"), new SimpleString(type));
        }
        coreMessage.setDurable(messageSend.isPersistent());
        coreMessage.setExpiration(messageSend.getExpiration());
        coreMessage.setPriority(messageSend.getPriority());
        coreMessage.setTimestamp(messageSend.getTimestamp());
        byte coreType = OpenWireMessageConverter.toCoreType(messageSend.getDataStructureType());
        coreMessage.setType(coreType);
        ByteSequence contents = messageSend.getContent();
        if (contents != null) {
            ActiveMQBuffer body = coreMessage.getBodyBuffer();
            switch (coreType) {
                case 3: {
                    ByteArrayInputStream tis = new ByteArrayInputStream(contents);
                    DataInputStream tdataIn = new DataInputStream((InputStream)tis);
                    String text = MarshallingSupport.readUTF8((DataInput)tdataIn);
                    tdataIn.close();
                    body.writeNullableSimpleString(new SimpleString(text));
                    break;
                }
                case 5: {
                    ByteArrayInputStream mis = new ByteArrayInputStream(contents);
                    DataInputStream mdataIn = new DataInputStream((InputStream)mis);
                    Map map = MarshallingSupport.unmarshalPrimitiveMap((DataInputStream)mdataIn);
                    mdataIn.close();
                    TypedProperties props = new TypedProperties();
                    OpenWireMessageConverter.loadMapIntoProperties(props, map);
                    props.encode(body);
                    break;
                }
                case 2: {
                    body.writeInt(contents.length);
                    body.writeBytes(contents.data, contents.offset, contents.length);
                    break;
                }
                case 6: {
                    ByteArrayInputStream sis = new ByteArrayInputStream(contents);
                    DataInputStream sdis = new DataInputStream((InputStream)sis);
                    int stype = sdis.read();
                    while (stype != -1) {
                        switch (stype) {
                            case 1: {
                                body.writeByte((byte)2);
                                body.writeBoolean(sdis.readBoolean());
                                break;
                            }
                            case 2: {
                                body.writeByte((byte)3);
                                body.writeByte(sdis.readByte());
                                break;
                            }
                            case 10: {
                                body.writeByte((byte)4);
                                int slen = sdis.readInt();
                                byte[] sbytes = new byte[slen];
                                sdis.read(sbytes);
                                body.writeInt(slen);
                                body.writeBytes(sbytes);
                                break;
                            }
                            case 3: {
                                body.writeByte((byte)11);
                                char schar = sdis.readChar();
                                body.writeShort((short)schar);
                                break;
                            }
                            case 7: {
                                body.writeByte((byte)9);
                                double sdouble = sdis.readDouble();
                                body.writeLong(Double.doubleToLongBits(sdouble));
                                break;
                            }
                            case 8: {
                                body.writeByte((byte)8);
                                float sfloat = sdis.readFloat();
                                body.writeInt(Float.floatToIntBits(sfloat));
                                break;
                            }
                            case 5: {
                                body.writeByte((byte)6);
                                body.writeInt(sdis.readInt());
                                break;
                            }
                            case 6: {
                                body.writeByte((byte)7);
                                body.writeLong(sdis.readLong());
                                break;
                            }
                            case 4: {
                                body.writeByte((byte)5);
                                body.writeShort(sdis.readShort());
                                break;
                            }
                            case 9: {
                                body.writeByte((byte)10);
                                String sstring = sdis.readUTF();
                                body.writeNullableString(sstring);
                                break;
                            }
                            case 13: {
                                body.writeByte((byte)10);
                                String sbigString = MarshallingSupport.readUTF8((DataInput)sdis);
                                body.writeNullableString(sbigString);
                                break;
                            }
                            case 0: {
                                body.writeByte((byte)10);
                                body.writeNullableString(null);
                                break;
                            }
                        }
                        stype = sdis.read();
                    }
                    sdis.close();
                    break;
                }
                default: {
                    body.writeBytes(contents.data, contents.offset, contents.length);
                }
            }
        }
        coreMessage.putLongProperty(AMQ_MSG_ARRIVAL, messageSend.getArrival());
        coreMessage.putLongProperty(AMQ_MSG_BROKER_IN_TIME, messageSend.getBrokerInTime());
        BrokerId[] brokers = messageSend.getBrokerPath();
        if (brokers != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < brokers.length; ++i) {
                builder.append(brokers[i].getValue());
                if (i == brokers.length - 1) continue;
                builder.append(",");
            }
            coreMessage.putStringProperty(AMQ_MSG_BROKER_PATH, builder.toString());
        }
        if ((cluster = messageSend.getCluster()) != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < cluster.length; ++i) {
                builder.append(cluster[i].getValue());
                if (i == cluster.length - 1) continue;
                builder.append(",");
            }
            coreMessage.putStringProperty(AMQ_MSG_CLUSTER, builder.toString());
        }
        coreMessage.putIntProperty(AMQ_MSG_COMMAND_ID, messageSend.getCommandId());
        String corrId = messageSend.getCorrelationId();
        if (corrId != null) {
            coreMessage.putStringProperty("JMSCorrelationID", corrId);
        }
        if ((ds = messageSend.getDataStructure()) != null) {
            ByteSequence dsBytes = marshaller.marshal((Object)ds);
            dsBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_DATASTRUCTURE, dsBytes.data);
        }
        if ((groupId = messageSend.getGroupID()) != null) {
            coreMessage.putStringProperty(AMQ_MSG_GROUP_ID, groupId);
        }
        coreMessage.putIntProperty(AMQ_MSG_GROUP_SEQUENCE, messageSend.getGroupSequence());
        MessageId messageId = messageSend.getMessageId();
        ByteSequence midBytes = marshaller.marshal((Object)messageId);
        midBytes.compact();
        coreMessage.putBytesProperty(AMQ_MSG_MESSAGE_ID, midBytes.data);
        ProducerId producerId = messageSend.getProducerId();
        if (producerId != null) {
            ByteSequence producerIdBytes = marshaller.marshal((Object)producerId);
            producerIdBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_PRODUCER_ID, producerIdBytes.data);
        }
        if ((propBytes = messageSend.getMarshalledProperties()) != null) {
            propBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_MARSHALL_PROP, propBytes.data);
            Map props = messageSend.getProperties();
            for (Map.Entry ent : props.entrySet()) {
                Object value = ent.getValue();
                try {
                    coreMessage.putObjectProperty((String)ent.getKey(), value);
                }
                catch (ActiveMQPropertyConversionException e) {
                    coreMessage.putStringProperty((String)ent.getKey(), value.toString());
                }
            }
        }
        coreMessage.putIntProperty(AMQ_MSG_REDELIVER_COUNTER, messageSend.getRedeliveryCounter());
        ActiveMQDestination replyTo = messageSend.getReplyTo();
        if (replyTo != null) {
            ByteSequence replyToBytes = marshaller.marshal((Object)replyTo);
            replyToBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_REPLY_TO, replyToBytes.data);
        }
        if ((consumerId = messageSend.getTargetConsumerId()) != null) {
            ByteSequence consumerIdBytes = marshaller.marshal((Object)consumerId);
            consumerIdBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_CONSUMER_ID, consumerIdBytes.data);
        }
        if ((txId = messageSend.getTransactionId()) != null) {
            ByteSequence txIdBytes = marshaller.marshal((Object)txId);
            txIdBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_TX_ID, txIdBytes.data);
        }
        if ((userId = messageSend.getUserID()) != null) {
            coreMessage.putStringProperty(AMQ_MSG_USER_ID, userId);
        }
        coreMessage.putBooleanProperty(AMQ_MSG_COMPRESSED, messageSend.isCompressed());
        coreMessage.putBooleanProperty(AMQ_MSG_DROPPABLE, messageSend.isDroppable());
    }

    private static void loadMapIntoProperties(TypedProperties props, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            SimpleString key = new SimpleString(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof UTF8Buffer) {
                value = ((UTF8Buffer)value).toString();
            }
            TypedProperties.setObjectProperty((SimpleString)key, (Object)value, (TypedProperties)props);
        }
    }

    public static byte toCoreType(byte amqType) {
        switch (amqType) {
            case 29: {
                throw new IllegalStateException("We don't support BLOB type yet!");
            }
            case 24: {
                return 4;
            }
            case 25: {
                return 5;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 6;
            }
            case 28: {
                return 3;
            }
            case 23: {
                return 0;
            }
        }
        throw new IllegalStateException("Unknown ActiveMQ Artemis message type: " + amqType);
    }

    public static MessageDispatch createMessageDispatch(ServerMessage message, int deliveryCount, AMQConsumer consumer) throws IOException {
        ActiveMQMessage amqMessage = OpenWireMessageConverter.toAMQMessage(message, consumer.getMarshaller(), consumer.getActualDestination());
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(consumer.getId());
        md.setMessage((Message)amqMessage);
        md.setRedeliveryCounter(deliveryCount);
        ActiveMQDestination destination = amqMessage.getDestination();
        md.setDestination(destination);
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActiveMQMessage toAMQMessage(ServerMessage coreMessage, WireFormat marshaller, ActiveMQDestination actualDestination) throws IOException {
        Set props;
        SimpleString dlqCause;
        Boolean isDroppable;
        Boolean isCompressed;
        String userId;
        byte[] txIdBytes;
        byte[] consumerIdBytes;
        byte[] replyToBytes;
        Integer redeliveryCounter;
        byte[] marshalledBytes;
        byte[] producerIdBytes;
        byte[] origTxIdBytes;
        Integer groupSequence;
        byte[] dsBytes;
        Integer commandId;
        String clusterPath;
        Long arrival;
        ActiveMQBytesMessage amqMsg = null;
        byte coreType = coreMessage.getType();
        switch (coreType) {
            case 4: {
                amqMsg = new ActiveMQBytesMessage();
                break;
            }
            case 5: {
                amqMsg = new ActiveMQMapMessage();
                break;
            }
            case 2: {
                amqMsg = new ActiveMQObjectMessage();
                break;
            }
            case 6: {
                amqMsg = new ActiveMQStreamMessage();
                break;
            }
            case 3: {
                amqMsg = new ActiveMQTextMessage();
                break;
            }
            case 0: {
                amqMsg = new ActiveMQMessage();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown message type: " + coreMessage.getType());
            }
        }
        String type = coreMessage.getStringProperty(new SimpleString("JMSType"));
        if (type != null) {
            amqMsg.setJMSType(type);
        }
        amqMsg.setPersistent(coreMessage.isDurable());
        amqMsg.setExpiration(coreMessage.getExpiration());
        amqMsg.setPriority(coreMessage.getPriority());
        amqMsg.setTimestamp(coreMessage.getTimestamp());
        Long brokerInTime = (Long)coreMessage.getObjectProperty(AMQ_MSG_BROKER_IN_TIME);
        if (brokerInTime == null) {
            brokerInTime = 0L;
        }
        amqMsg.setBrokerInTime(brokerInTime.longValue());
        ActiveMQBuffer buffer = coreMessage.getBodyBufferCopy();
        if (buffer != null) {
            buffer.resetReaderIndex();
            byte[] bytes = null;
            ActiveMQBuffer activeMQBuffer = buffer;
            synchronized (activeMQBuffer) {
                if (coreType == 3) {
                    SimpleString text = buffer.readNullableSimpleString();
                    if (text != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream(text.length() + 4);
                        DataOutputStream dataOut = new DataOutputStream(out);
                        MarshallingSupport.writeUTF8((DataOutput)dataOut, (String)text.toString());
                        bytes = out.toByteArray();
                        out.close();
                    }
                } else if (coreType == 5) {
                    TypedProperties mapData = new TypedProperties();
                    mapData.decode(buffer);
                    Map map = mapData.getMap();
                    ByteArrayOutputStream out = new ByteArrayOutputStream(mapData.getEncodeSize());
                    DataOutputStream dataOut = new DataOutputStream(out);
                    MarshallingSupport.marshalPrimitiveMap((Map)map, (DataOutputStream)dataOut);
                    bytes = out.toByteArray();
                    dataOut.close();
                } else if (coreType == 2) {
                    int len = buffer.readInt();
                    bytes = new byte[len];
                    buffer.readBytes(bytes);
                } else if (coreType == 6) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.readableBytes());
                    DataOutputStream dataOut = new DataOutputStream(out);
                    boolean stop = false;
                    block27: while (!stop && buffer.readable()) {
                        byte primitiveType = buffer.readByte();
                        switch (primitiveType) {
                            case 2: {
                                MarshallingSupport.marshalBoolean((DataOutputStream)dataOut, (boolean)buffer.readBoolean());
                                continue block27;
                            }
                            case 3: {
                                MarshallingSupport.marshalByte((DataOutputStream)dataOut, (byte)buffer.readByte());
                                continue block27;
                            }
                            case 4: {
                                int len = buffer.readInt();
                                byte[] bytesData = new byte[len];
                                buffer.readBytes(bytesData);
                                MarshallingSupport.marshalByteArray((DataOutputStream)dataOut, (byte[])bytesData);
                                continue block27;
                            }
                            case 11: {
                                char ch = (char)buffer.readShort();
                                MarshallingSupport.marshalChar((DataOutputStream)dataOut, (char)ch);
                                continue block27;
                            }
                            case 9: {
                                double doubleVal = Double.longBitsToDouble(buffer.readLong());
                                MarshallingSupport.marshalDouble((DataOutputStream)dataOut, (double)doubleVal);
                                continue block27;
                            }
                            case 8: {
                                Float floatVal = Float.valueOf(Float.intBitsToFloat(buffer.readInt()));
                                MarshallingSupport.marshalFloat((DataOutputStream)dataOut, (float)floatVal.floatValue());
                                continue block27;
                            }
                            case 6: {
                                MarshallingSupport.marshalInt((DataOutputStream)dataOut, (int)buffer.readInt());
                                continue block27;
                            }
                            case 7: {
                                MarshallingSupport.marshalLong((DataOutputStream)dataOut, (long)buffer.readLong());
                                continue block27;
                            }
                            case 5: {
                                MarshallingSupport.marshalShort((DataOutputStream)dataOut, (short)buffer.readShort());
                                continue block27;
                            }
                            case 10: {
                                String string = buffer.readNullableString();
                                if (string == null) {
                                    MarshallingSupport.marshalNull((DataOutputStream)dataOut);
                                    continue block27;
                                }
                                MarshallingSupport.marshalString((DataOutputStream)dataOut, (String)string);
                                continue block27;
                            }
                        }
                        stop = true;
                    }
                    bytes = out.toByteArray();
                    dataOut.close();
                } else {
                    int n = buffer.readableBytes();
                    bytes = new byte[n];
                    buffer.readBytes(bytes);
                }
                buffer.resetReaderIndex();
            }
            if (bytes != null) {
                ByteSequence content = new ByteSequence(bytes);
                amqMsg.setContent(content);
            }
        }
        if ((arrival = (Long)coreMessage.getObjectProperty(AMQ_MSG_ARRIVAL)) == null) {
            arrival = 0L;
        }
        amqMsg.setArrival(arrival.longValue());
        String brokerPath = (String)coreMessage.getObjectProperty(AMQ_MSG_BROKER_PATH);
        if (brokerPath != null && brokerPath.isEmpty()) {
            String[] brokers = brokerPath.split(",");
            BrokerId[] bids = new BrokerId[brokers.length];
            for (int i = 0; i < bids.length; ++i) {
                bids[i] = new BrokerId(brokers[i]);
            }
            amqMsg.setBrokerPath(bids);
        }
        if ((clusterPath = (String)coreMessage.getObjectProperty(AMQ_MSG_CLUSTER)) != null && clusterPath.isEmpty()) {
            String[] cluster = clusterPath.split(",");
            BrokerId[] bids = new BrokerId[cluster.length];
            for (int i = 0; i < bids.length; ++i) {
                bids[i] = new BrokerId(cluster[i]);
            }
            amqMsg.setCluster(bids);
        }
        if ((commandId = (Integer)coreMessage.getObjectProperty(AMQ_MSG_COMMAND_ID)) == null) {
            commandId = -1;
        }
        amqMsg.setCommandId(commandId.intValue());
        SimpleString corrId = (SimpleString)coreMessage.getObjectProperty("JMSCorrelationID");
        if (corrId != null) {
            amqMsg.setCorrelationId(corrId.toString());
        }
        if ((dsBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_DATASTRUCTURE)) != null) {
            ByteSequence seq = new ByteSequence(dsBytes);
            DataStructure ds = (DataStructure)marshaller.unmarshal(seq);
            amqMsg.setDataStructure(ds);
        }
        amqMsg.setDestination(OpenWireUtil.toAMQAddress(coreMessage, actualDestination));
        Object value = coreMessage.getObjectProperty(AMQ_MSG_GROUP_ID);
        if (value != null) {
            String groupId = value.toString();
            amqMsg.setGroupID(groupId);
        }
        if ((groupSequence = (Integer)coreMessage.getObjectProperty(AMQ_MSG_GROUP_SEQUENCE)) == null) {
            groupSequence = -1;
        }
        amqMsg.setGroupSequence(groupSequence.intValue());
        MessageId mid = null;
        byte[] midBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_MESSAGE_ID);
        if (midBytes != null) {
            ByteSequence midSeq = new ByteSequence(midBytes);
            mid = (MessageId)marshaller.unmarshal(midSeq);
        } else {
            mid = new MessageId(UUIDGenerator.getInstance().generateStringUUID() + ":-1");
        }
        amqMsg.setMessageId(mid);
        byte[] origDestBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_ORIG_DESTINATION);
        if (origDestBytes != null) {
            ActiveMQDestination origDest = (ActiveMQDestination)marshaller.unmarshal(new ByteSequence(origDestBytes));
            amqMsg.setOriginalDestination(origDest);
        }
        if ((origTxIdBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_ORIG_TXID)) != null) {
            TransactionId origTxId = (TransactionId)marshaller.unmarshal(new ByteSequence(origTxIdBytes));
            amqMsg.setOriginalTransactionId(origTxId);
        }
        if ((producerIdBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_PRODUCER_ID)) != null) {
            ProducerId producerId = (ProducerId)marshaller.unmarshal(new ByteSequence(producerIdBytes));
            amqMsg.setProducerId(producerId);
        }
        if ((marshalledBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_MARSHALL_PROP)) != null) {
            amqMsg.setMarshalledProperties(new ByteSequence(marshalledBytes));
        }
        if ((redeliveryCounter = (Integer)coreMessage.getObjectProperty(AMQ_MSG_REDELIVER_COUNTER)) != null) {
            amqMsg.setRedeliveryCounter(redeliveryCounter.intValue());
        }
        if ((replyToBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_REPLY_TO)) != null) {
            ActiveMQDestination replyTo = (ActiveMQDestination)marshaller.unmarshal(new ByteSequence(replyToBytes));
            amqMsg.setReplyTo(replyTo);
        }
        if ((consumerIdBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_CONSUMER_ID)) != null) {
            ConsumerId consumerId = (ConsumerId)marshaller.unmarshal(new ByteSequence(consumerIdBytes));
            amqMsg.setTargetConsumerId(consumerId);
        }
        if ((txIdBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_TX_ID)) != null) {
            TransactionId txId = (TransactionId)marshaller.unmarshal(new ByteSequence(txIdBytes));
            amqMsg.setTransactionId(txId);
        }
        if ((userId = (String)coreMessage.getObjectProperty(AMQ_MSG_USER_ID)) != null) {
            amqMsg.setUserID(userId);
        }
        if ((isCompressed = (Boolean)coreMessage.getObjectProperty(AMQ_MSG_COMPRESSED)) != null) {
            amqMsg.setCompressed(isCompressed.booleanValue());
        }
        if ((isDroppable = (Boolean)coreMessage.getObjectProperty(AMQ_MSG_DROPPABLE)) != null) {
            amqMsg.setDroppable(isDroppable.booleanValue());
        }
        if ((dlqCause = (SimpleString)coreMessage.getObjectProperty(AMQ_MSG_DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY)) != null) {
            try {
                amqMsg.setStringProperty("dlqDeliveryFailureCause", dlqCause.toString());
            }
            catch (JMSException e) {
                throw new IOException("failure to set dlq property " + dlqCause, e);
            }
        }
        if ((props = coreMessage.getPropertyNames()) != null) {
            for (SimpleString s : props) {
                String keyStr = s.toString();
                if (keyStr.startsWith("__AMQ") || keyStr.startsWith(AMQ_PREFIX)) continue;
                Object prop = coreMessage.getObjectProperty(s);
                try {
                    if (prop instanceof SimpleString) {
                        amqMsg.setObjectProperty(s.toString(), (Object)prop.toString());
                        continue;
                    }
                    amqMsg.setObjectProperty(s.toString(), prop);
                }
                catch (JMSException e) {
                    throw new IOException("exception setting property " + s + " : " + prop, e);
                }
            }
        }
        return amqMsg;
    }
}

