/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSSecurityException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireUtil;
import org.apache.activemq.artemis.core.protocol.openwire.SendingResult;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQCompositeConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConnectionContext;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQProducerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSingleConsumerBrokerExchange;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ControlCommand;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.FlushCommand;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.transport.TransmitCallback;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public class OpenWireConnection
implements RemotingConnection,
CommandVisitor,
SecurityAuth {
    private final OpenWireProtocolManager protocolManager;
    private final Connection transportConnection;
    private final long creationTime;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private boolean destroyed = false;
    private final Object sendLock = new Object();
    private volatile boolean dataReceived;
    private final Acceptor acceptorUsed;
    private OpenWireFormat wireFormat;
    private AMQConnectionContext context;
    private boolean pendingStop;
    private Throwable stopError = null;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final ReentrantReadWriteLock serviceLock = new ReentrantReadWriteLock();
    protected final List<Command> dispatchQueue = new LinkedList<Command>();
    private boolean inServiceException;
    private final AtomicBoolean asyncException = new AtomicBoolean(false);
    private final Map<ConsumerId, AMQConsumerBrokerExchange> consumerExchanges = new HashMap<ConsumerId, AMQConsumerBrokerExchange>();
    private final Map<ProducerId, AMQProducerBrokerExchange> producerExchanges = new HashMap<ProducerId, AMQProducerBrokerExchange>();
    private ConnectionState state;
    private final Set<ActiveMQDestination> tempQueues = new ConcurrentHashSet();
    private Map<TransactionId, TransactionInfo> txMap = new ConcurrentHashMap<TransactionId, TransactionInfo>();
    private volatile AMQSession advisorySession;

    public OpenWireConnection(Acceptor acceptorUsed, Connection connection, OpenWireProtocolManager openWireProtocolManager, OpenWireFormat wf) {
        this.protocolManager = openWireProtocolManager;
        this.transportConnection = connection;
        this.acceptorUsed = acceptorUsed;
        this.wireFormat = wf;
        this.creationTime = System.currentTimeMillis();
    }

    public String getUsername() {
        ConnectionInfo info = this.getConnectionInfo();
        if (info == null) {
            return null;
        }
        return info.getUserName();
    }

    public String getPassword() {
        ConnectionInfo info = this.getConnectionInfo();
        if (info == null) {
            return null;
        }
        return info.getPassword();
    }

    private ConnectionInfo getConnectionInfo() {
        if (this.state == null) {
            return null;
        }
        ConnectionInfo info = this.state.getInfo();
        if (info == null) {
            return null;
        }
        return info;
    }

    public String getLocalAddress() {
        return this.transportConnection.getLocalAddress();
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        block14: {
            try {
                this.dataReceived = true;
                Command command = (Command)this.wireFormat.unmarshal((DataInput)buffer);
                boolean responseRequired = command.isResponseRequired();
                int commandId = command.getCommandId();
                if (command.getClass() == KeepAliveInfo.class) {
                    KeepAliveInfo info = (KeepAliveInfo)command;
                    info.setResponseRequired(false);
                    this.protocolManager.sendReply(this, (Command)info);
                    break block14;
                }
                if (command.getClass() == WireFormatInfo.class) {
                    this.negotiate((WireFormatInfo)command);
                    break block14;
                }
                if (command.getClass() == ConnectionInfo.class || command.getClass() == ConsumerInfo.class || command.getClass() == RemoveInfo.class || command.getClass() == SessionInfo.class || command.getClass() == ProducerInfo.class || ActiveMQMessage.class.isAssignableFrom(command.getClass()) || command.getClass() == MessageAck.class || command.getClass() == TransactionInfo.class || command.getClass() == DestinationInfo.class || command.getClass() == ShutdownInfo.class || command.getClass() == RemoveSubscriptionInfo.class) {
                    Response response = null;
                    if (this.pendingStop) {
                        response = new ExceptionResponse(this.stopError);
                    } else {
                        block15: {
                            try {
                                response = command.visit((CommandVisitor)this);
                            }
                            catch (Exception e) {
                                if (!responseRequired) break block15;
                                response = new ExceptionResponse((Throwable)e);
                            }
                        }
                        if (response instanceof ExceptionResponse && !responseRequired) {
                            Throwable cause = ((ExceptionResponse)response).getException();
                            this.serviceException(cause);
                            response = null;
                        }
                    }
                    if (responseRequired && response == null) {
                        response = new Response();
                    }
                    if (this.context != null && this.context.isDontSendReponse()) {
                        this.context.setDontSendReponse(false);
                        response = null;
                    }
                    if (response != null && !this.protocolManager.isStopping()) {
                        response.setCorrelationId(commandId);
                        this.dispatchSync((Command)response);
                    }
                    break block14;
                }
                this.protocolManager.handleCommand(this, command);
            }
            catch (IOException e) {
                ActiveMQServerLogger.LOGGER.error((Object)"error decoding", (Throwable)e);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.error((Object)"error decoding", t);
            }
        }
    }

    private void negotiate(WireFormatInfo command) throws IOException {
        this.wireFormat.renegotiateWireFormat(command);
        this.protocolManager.sendBrokerInfo(this);
    }

    public Object getID() {
        return this.transportConnection.getID();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    public ActiveMQBuffer createTransportBuffer(int size) {
        return ActiveMQBuffers.dynamicBuffer((int)size);
    }

    public void fail(ActiveMQException me) {
        if (me != null) {
            ActiveMQServerLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        }
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.destroyed = true;
        this.transportConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        this.transportConnection.close();
        try {
            this.deleteTempQueues();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.sendLock;
        synchronized (object) {
            this.callClosingListeners();
        }
    }

    private void deleteTempQueues() throws Exception {
        for (ActiveMQDestination q : this.tempQueues) {
            this.protocolManager.removeDestination(this, q);
        }
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void disconnect(boolean criticalError) {
        this.fail(null);
    }

    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public void flush() {
    }

    private void callFailureListeners(ActiveMQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public void init() {
        WireFormatInfo info = this.wireFormat.getPreferedWireFormatInfo();
        this.protocolManager.send(this, (Command)info);
    }

    public ConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalSend(Command command) throws IOException {
        try {
            ByteSequence bytes = this.wireFormat.marshal((Object)command);
            ActiveMQBuffer buffer = OpenWireUtil.toActiveMQBuffer(bytes);
            Object object = this.sendLock;
            synchronized (object) {
                this.getTransportConnection().write(buffer, false, false);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.error((Object)"error sending", t);
        }
    }

    public Response processAddConnection(ConnectionInfo info) throws Exception {
        WireFormatInfo wireFormatInfo = this.wireFormat.getPreferedWireFormatInfo();
        if (wireFormatInfo != null && wireFormatInfo.getVersion() <= 2) {
            info.setClientMaster(true);
        }
        this.state = new ConnectionState(info);
        this.context = new AMQConnectionContext();
        this.state.reset(info);
        String clientId = info.getClientId();
        this.context.setBroker(this.protocolManager);
        this.context.setClientId(clientId);
        this.context.setClientMaster(info.isClientMaster());
        this.context.setConnection(this);
        this.context.setConnectionId(info.getConnectionId());
        this.context.setFaultTolerant(info.isFaultTolerant());
        this.context.setUserName(info.getUserName());
        this.context.setWireFormatInfo(wireFormatInfo);
        this.context.setReconnect(info.isFailoverReconnect());
        this.context.setConnectionState(this.state);
        if (info.getClientIp() == null) {
            info.setClientIp(this.getRemoteAddress());
        }
        try {
            this.protocolManager.addConnection(this.context, info);
        }
        catch (Exception e) {
            if (e instanceof SecurityException) {
                this.delayedStop(2000, "Failed with SecurityException: " + e.getLocalizedMessage(), e);
            }
            ExceptionResponse resp = new ExceptionResponse((Throwable)e);
            return resp;
        }
        if (info.isManageable()) {
            ConnectionControl command = new ConnectionControl();
            command.setFaultTolerant(this.protocolManager.isFaultTolerantConfiguration());
            if (info.isFailoverReconnect()) {
                command.setRebalanceConnection(false);
            }
            this.dispatchAsync((Command)command);
        }
        return null;
    }

    public void dispatchAsync(Command message) {
        if (!this.stopping.get()) {
            this.dispatchSync(message);
        } else if (message.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)message;
            TransmitCallback sub = md.getTransmitCallback();
            this.protocolManager.postProcessDispatch(md);
            if (sub != null) {
                sub.onFailure();
            }
        }
    }

    public void dispatchSync(Command message) {
        try {
            this.processDispatch(message);
        }
        catch (IOException e) {
            this.serviceExceptionAsync(e);
        }
    }

    public void serviceExceptionAsync(final IOException e) {
        if (this.asyncException.compareAndSet(false, true)) {
            new Thread("Async Exception Handler"){

                @Override
                public void run() {
                    OpenWireConnection.this.serviceException(e);
                }
            }.start();
        }
    }

    public void serviceException(Throwable e) {
        if (e instanceof IOException) {
            this.serviceTransportException((IOException)e);
        } else if (!this.stopping.get() && !this.inServiceException) {
            this.inServiceException = true;
            try {
                ConnectionError ce = new ConnectionError();
                ce.setException(e);
                if (this.pendingStop) {
                    this.dispatchSync((Command)ce);
                } else {
                    this.dispatchAsync((Command)ce);
                }
            }
            finally {
                this.inServiceException = false;
            }
        }
    }

    public void serviceTransportException(IOException e) {
    }

    protected void dispatch(Command command) throws IOException {
        this.physicalSend(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatch(Command command) throws IOException {
        MessageDispatch messageDispatch = (MessageDispatch)(command.isMessageDispatch() ? command : null);
        try {
            if (!this.stopping.get()) {
                if (messageDispatch != null) {
                    this.protocolManager.preProcessDispatch(messageDispatch);
                }
                this.dispatch(command);
            }
        }
        catch (IOException e) {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onFailure();
                }
                messageDispatch = null;
                throw e;
            }
        }
        finally {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onSuccess();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedStop(int waitTime, String reason, Throwable cause) {
        if (waitTime > 0) {
            OpenWireConnection openWireConnection = this;
            synchronized (openWireConnection) {
                this.pendingStop = true;
                this.stopError = cause;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        OpenWireConnection openWireConnection = this;
        synchronized (openWireConnection) {
            this.pendingStop = true;
        }
        if (this.stopping.compareAndSet(false, true) && this.context != null) {
            this.context.getStopping().set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            this.getTransportConnection().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        List<Command> e = this.dispatchQueue;
        synchronized (e) {
            for (Command command : this.dispatchQueue) {
                if (!command.isMessageDispatch()) continue;
                MessageDispatch md = (MessageDispatch)command;
                TransmitCallback sub = md.getTransmitCallback();
                this.protocolManager.postProcessDispatch(md);
                if (sub == null) continue;
                sub.onFailure();
            }
            this.dispatchQueue.clear();
        }
        if (!this.protocolManager.isStopped()) {
            this.context.getStopping().set(true);
            try {
                this.processRemoveConnection(this.state.getInfo().getConnectionId(), 0L);
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public Response processAddConsumer(ConsumerInfo info) {
        ExceptionResponse resp = null;
        try {
            this.protocolManager.addConsumer(this, info);
        }
        catch (Exception e) {
            resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse((Throwable)e);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumerBrokerExchange(ConsumerId id, AMQSession amqSession, Map<ActiveMQDestination, AMQConsumer> consumerMap) {
        AMQConsumerBrokerExchange result = this.consumerExchanges.get(id);
        if (result == null) {
            result = consumerMap.size() == 1 ? new AMQSingleConsumerBrokerExchange(amqSession, consumerMap.values().iterator().next()) : new AMQCompositeConsumerBrokerExchange(amqSession, consumerMap);
            Map<ConsumerId, AMQConsumerBrokerExchange> map = this.consumerExchanges;
            synchronized (map) {
                ConsumerInfo info;
                ConsumerState cs;
                result.setConnectionContext(this.context);
                SessionState ss = this.state.getSessionState(id.getParentId());
                if (ss != null && (cs = ss.getConsumerState(id)) != null && (info = cs.getInfo()) != null && info.getDestination() != null && info.getDestination().isPattern()) {
                    result.setWildcard(true);
                }
                this.consumerExchanges.put(id, result);
            }
        }
    }

    public int getConsumerCount() {
        int result = 0;
        for (SessionId sessionId : this.state.getSessionIds()) {
            SessionState sessionState = this.state.getSessionState(sessionId);
            if (sessionState == null) continue;
            result += sessionState.getConsumerIds().size();
        }
        return result;
    }

    public int getProducerCount() {
        int result = 0;
        for (SessionId sessionId : this.state.getSessionIds()) {
            SessionState sessionState = this.state.getSessionState(sessionId);
            if (sessionState == null) continue;
            result += sessionState.getProducerIds().size();
        }
        return result;
    }

    public Response processAddDestination(DestinationInfo dest) throws Exception {
        ExceptionResponse resp = null;
        try {
            this.protocolManager.addDestination(this, dest);
        }
        catch (Exception e) {
            resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse((Throwable)e);
        }
        return resp;
    }

    public Response processAddProducer(ProducerInfo info) throws Exception {
        ExceptionResponse resp = null;
        try {
            this.protocolManager.addProducer(this, info);
        }
        catch (Exception e) {
            resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : (e instanceof ActiveMQNonExistentQueueException ? new ExceptionResponse((Throwable)new InvalidDestinationException(e.getMessage())) : new ExceptionResponse((Throwable)e));
        }
        return resp;
    }

    public Response processAddSession(SessionInfo info) throws Exception {
        if (!this.state.getSessionIds().contains(info.getSessionId())) {
            this.protocolManager.addSession(this, info);
            try {
                this.state.addSession(info);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                this.protocolManager.removeSession(this.context, info);
            }
        }
        return null;
    }

    public Response processBeginTransaction(TransactionInfo info) throws Exception {
        TransactionId txId = info.getTransactionId();
        if (!this.txMap.containsKey(txId)) {
            this.txMap.put(txId, info);
        }
        return null;
    }

    public Response processBrokerInfo(BrokerInfo arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processCommitTransactionOnePhase(TransactionInfo info) throws Exception {
        this.protocolManager.commitTransactionOnePhase(info);
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        return null;
    }

    public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Exception {
        this.protocolManager.commitTransactionTwoPhase(info);
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        return null;
    }

    public Response processConnectionControl(ConnectionControl arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processConnectionError(ConnectionError arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processConsumerControl(ConsumerControl arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processControlCommand(ControlCommand arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processEndTransaction(TransactionInfo info) throws Exception {
        this.protocolManager.endTransaction(info);
        TransactionId txId = info.getTransactionId();
        if (!this.txMap.containsKey(txId)) {
            this.txMap.put(txId, info);
        }
        return null;
    }

    public Response processFlush(FlushCommand arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processForgetTransaction(TransactionInfo info) throws Exception {
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        this.protocolManager.forgetTransaction(info.getTransactionId());
        return null;
    }

    public Response processKeepAlive(KeepAliveInfo arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processMessage(Message messageSend) {
        ExceptionResponse resp = null;
        try {
            ProducerId producerId = messageSend.getProducerId();
            AMQProducerBrokerExchange producerExchange = this.getProducerBrokerExchange(producerId);
            AMQConnectionContext pcontext = producerExchange.getConnectionContext();
            ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
            boolean sendProducerAck = !messageSend.isResponseRequired() && producerInfo.getWindowSize() > 0 && !pcontext.isInRecoveryMode();
            AMQSession session = this.protocolManager.getSession(producerId.getParentId());
            if (producerExchange.canDispatch(messageSend)) {
                SendingResult result = session.send(producerExchange, messageSend, sendProducerAck);
                if (result.isBlockNextSend()) {
                    if (!this.context.isNetworkConnection() && result.isSendFailIfNoSpace()) {
                        throw new ResourceAllocationException("Usage Manager Memory Limit reached. Stopping producer (" + producerId + ") to prevent flooding " + result.getBlockingAddress() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info");
                    }
                    if (producerInfo.getWindowSize() > 0 || messageSend.isResponseRequired()) {
                        this.context.setDontSendReponse(true);
                    } else {
                        session.blockingWaitForSpace(producerExchange, result);
                    }
                } else if (sendProducerAck) {
                    ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), messageSend.getSize());
                    this.dispatchAsync((Command)ack);
                }
            }
        }
        catch (Throwable e) {
            resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse(e);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AMQProducerBrokerExchange getProducerBrokerExchange(ProducerId id) throws IOException {
        AMQProducerBrokerExchange result = this.producerExchanges.get(id);
        if (result == null) {
            Map<ProducerId, AMQProducerBrokerExchange> map = this.producerExchanges;
            synchronized (map) {
                SessionState ss;
                result = new AMQProducerBrokerExchange();
                result.setConnectionContext(this.context);
                if (this.context.isReconnect() || this.context.isNetworkConnection()) {
                    result.setLastStoredSequenceId(0L);
                }
                if ((ss = this.state.getSessionState(id.getParentId())) != null) {
                    result.setProducerState(ss.getProducerState(id));
                    ProducerState producerState = ss.getProducerState(id);
                    if (producerState != null && producerState.getInfo() != null) {
                        ProducerInfo info = producerState.getInfo();
                        result.setMutable(info.getDestination() == null || info.getDestination().isComposite());
                    }
                }
                this.producerExchanges.put(id, result);
            }
        }
        return result;
    }

    public Response processMessageAck(MessageAck ack) throws Exception {
        AMQConsumerBrokerExchange consumerBrokerExchange = this.consumerExchanges.get(ack.getConsumerId());
        consumerBrokerExchange.acknowledge(ack);
        return null;
    }

    public Response processMessageDispatch(MessageDispatch arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processMessageDispatchNotification(MessageDispatchNotification arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processMessagePull(MessagePull arg0) throws Exception {
        AMQConsumerBrokerExchange amqConsumerBrokerExchange = this.consumerExchanges.get(arg0.getConsumerId());
        if (amqConsumerBrokerExchange == null) {
            throw new IllegalStateException("Consumer does not exist");
        }
        amqConsumerBrokerExchange.processMessagePull(arg0);
        return null;
    }

    public Response processPrepareTransaction(TransactionInfo info) throws Exception {
        this.protocolManager.prepareTransaction(info);
        return null;
    }

    public Response processProducerAck(ProducerAck arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processRecoverTransactions(TransactionInfo info) throws Exception {
        Set sIds = this.state.getSessionIds();
        TransactionId[] recovered = this.protocolManager.recoverTransactions(sIds);
        return new DataArrayResponse((DataStructure[])recovered);
    }

    public Response processRemoveConnection(ConnectionId id, long lastDeliveredSequenceId) throws Exception {
        this.state.shutdown();
        for (SessionId sessionId : this.state.getSessionIds()) {
            try {
                this.processRemoveSession(sessionId, lastDeliveredSequenceId);
            }
            catch (Throwable e) {}
        }
        try {
            this.protocolManager.removeConnection(this.context, this.state.getInfo(), null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    public Response processRemoveConsumer(ConsumerId id, long lastDeliveredSequenceId) throws Exception {
        SessionId sessionId = id.getParentId();
        SessionState ss = this.state.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a consumer from a session that had not been registered: " + sessionId);
        }
        ConsumerState consumerState = ss.removeConsumer(id);
        if (consumerState == null) {
            throw new IllegalStateException("Cannot remove a consumer that had not been registered: " + id);
        }
        ConsumerInfo info = consumerState.getInfo();
        info.setLastDeliveredSequenceId(lastDeliveredSequenceId);
        AMQConsumerBrokerExchange consumerBrokerExchange = this.consumerExchanges.get(id);
        consumerBrokerExchange.removeConsumer();
        this.removeConsumerBrokerExchange(id);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsumerBrokerExchange(ConsumerId id) {
        Map<ConsumerId, AMQConsumerBrokerExchange> map = this.consumerExchanges;
        synchronized (map) {
            this.consumerExchanges.remove(id);
        }
    }

    public Response processRemoveDestination(DestinationInfo info) throws Exception {
        ActiveMQDestination dest = info.getDestination();
        this.protocolManager.removeDestination(this, dest);
        return null;
    }

    public Response processRemoveProducer(ProducerId id) throws Exception {
        this.protocolManager.removeProducer(id);
        return null;
    }

    public Response processRemoveSession(SessionId id, long lastDeliveredSequenceId) throws Exception {
        SessionState session = this.state.getSessionState(id);
        if (session == null) {
            throw new IllegalStateException("Cannot remove session that had not been registered: " + id);
        }
        session.shutdown();
        for (ConsumerId consumerId : session.getConsumerIds()) {
            try {
                this.processRemoveConsumer(consumerId, lastDeliveredSequenceId);
            }
            catch (Throwable e) {}
        }
        for (ProducerId producerId : session.getProducerIds()) {
            try {
                this.processRemoveProducer(producerId);
            }
            catch (Throwable e) {}
        }
        this.state.removeSession(id);
        this.protocolManager.removeSession(this.context, session.getInfo());
        return null;
    }

    public Response processRemoveSubscription(RemoveSubscriptionInfo subInfo) throws Exception {
        this.protocolManager.removeSubscription(subInfo);
        return null;
    }

    public Response processRollbackTransaction(TransactionInfo info) throws Exception {
        this.protocolManager.rollbackTransaction(info);
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        return null;
    }

    public Response processShutdown(ShutdownInfo info) throws Exception {
        return null;
    }

    public Response processWireFormat(WireFormatInfo arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public int getMaximumConsumersAllowedPerConnection() {
        return 1000000;
    }

    public int getMaximumProducersAllowedPerConnection() {
        return 1000000;
    }

    public void deliverMessage(MessageDispatch dispatch) {
        Message m = dispatch.getMessage();
        if (m != null) {
            long endTime = System.currentTimeMillis();
            m.setBrokerOutTime(endTime);
        }
        this.protocolManager.send(this, (Command)dispatch);
    }

    public WireFormat getMarshaller() {
        return this.wireFormat;
    }

    public void registerTempQueue(ActiveMQDestination queue) {
        this.tempQueues.add(queue);
    }

    public void disconnect(String reason, boolean fail) {
        this.destroy();
    }

    public void fail(ActiveMQException e, String message) {
        this.destroy();
    }

    public void setAdvisorySession(AMQSession amqSession) {
        this.advisorySession = amqSession;
    }

    public AMQSession getAdvisorySession() {
        return this.advisorySession;
    }

    public AMQConnectionContext getConext() {
        return this.context;
    }
}

