/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.state.ConnectionState;

public class AMQConnectionContext {
    private OpenWireConnection connection;
    private OpenWireProtocolManager broker;
    private boolean inRecoveryMode;
    private ConnectionId connectionId;
    private String clientId;
    private String userName;
    private boolean reconnect;
    private WireFormatInfo wireFormatInfo;
    private Object longTermStoreContext;
    private boolean producerFlowControl = true;
    private boolean networkConnection;
    private boolean faultTolerant;
    private final AtomicBoolean stopping = new AtomicBoolean();
    private final MessageEvaluationContext messageEvaluationContext;
    private boolean dontSendResponse;
    private boolean clientMaster = true;
    private ConnectionState connectionState;
    private XATransactionId xid;

    public AMQConnectionContext() {
        this.messageEvaluationContext = new MessageEvaluationContext();
    }

    public AMQConnectionContext(MessageEvaluationContext messageEvaluationContext) {
        this.messageEvaluationContext = messageEvaluationContext;
    }

    public AMQConnectionContext(ConnectionInfo info) {
        this();
        this.setClientId(info.getClientId());
        this.setUserName(info.getUserName());
        this.setConnectionId(info.getConnectionId());
    }

    public AMQConnectionContext copy() {
        AMQConnectionContext rc = new AMQConnectionContext(this.messageEvaluationContext);
        rc.connection = this.connection;
        rc.broker = this.broker;
        rc.inRecoveryMode = this.inRecoveryMode;
        rc.connectionId = this.connectionId;
        rc.clientId = this.clientId;
        rc.userName = this.userName;
        rc.reconnect = this.reconnect;
        rc.wireFormatInfo = this.wireFormatInfo;
        rc.longTermStoreContext = this.longTermStoreContext;
        rc.producerFlowControl = this.producerFlowControl;
        rc.networkConnection = this.networkConnection;
        rc.faultTolerant = this.faultTolerant;
        rc.stopping.set(this.stopping.get());
        rc.dontSendResponse = this.dontSendResponse;
        rc.clientMaster = this.clientMaster;
        return rc;
    }

    public OpenWireProtocolManager getBroker() {
        return this.broker;
    }

    public void setBroker(OpenWireProtocolManager broker) {
        this.broker = broker;
    }

    public OpenWireConnection getConnection() {
        return this.connection;
    }

    public void setConnection(OpenWireConnection connection) {
        this.connection = connection;
    }

    public boolean isInRecoveryMode() {
        return this.inRecoveryMode;
    }

    public void setInRecoveryMode(boolean inRecoveryMode) {
        this.inRecoveryMode = inRecoveryMode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public WireFormatInfo getWireFormatInfo() {
        return this.wireFormatInfo;
    }

    public void setWireFormatInfo(WireFormatInfo wireFormatInfo) {
        this.wireFormatInfo = wireFormatInfo;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(ConnectionId connectionId) {
        this.connectionId = connectionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public MessageEvaluationContext getMessageEvaluationContext() {
        return this.messageEvaluationContext;
    }

    public Object getLongTermStoreContext() {
        return this.longTermStoreContext;
    }

    public void setLongTermStoreContext(Object longTermStoreContext) {
        this.longTermStoreContext = longTermStoreContext;
    }

    public boolean isProducerFlowControl() {
        return this.producerFlowControl;
    }

    public void setProducerFlowControl(boolean disableProducerFlowControl) {
        this.producerFlowControl = disableProducerFlowControl;
    }

    public synchronized boolean isNetworkConnection() {
        return this.networkConnection;
    }

    public synchronized void setNetworkConnection(boolean networkConnection) {
        this.networkConnection = networkConnection;
    }

    public AtomicBoolean getStopping() {
        return this.stopping;
    }

    public void setDontSendReponse(boolean b) {
        this.dontSendResponse = b;
    }

    public boolean isDontSendReponse() {
        return this.dontSendResponse;
    }

    public boolean isClientMaster() {
        return this.clientMaster;
    }

    public void setClientMaster(boolean clientMaster) {
        this.clientMaster = clientMaster;
    }

    public boolean isFaultTolerant() {
        return this.faultTolerant;
    }

    public void setFaultTolerant(boolean faultTolerant) {
        this.faultTolerant = faultTolerant;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public void setXid(XATransactionId id) {
        this.xid = id;
    }

    public XATransactionId getXid() {
        return this.xid;
    }

    public boolean isAllowLinkStealing() {
        return true;
    }
}

