/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.utils.LinkedListIterator;

public class MQTTRetainMessageManager {
    private MQTTSession session;

    public MQTTRetainMessageManager(MQTTSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRetainedMessage(ServerMessage message, String address, boolean reset) throws Exception {
        LinkedListIterator iterator;
        SimpleString retainAddress = new SimpleString(MQTTUtil.convertMQTTAddressFilterToCoreRetain(address));
        Queue queue = this.session.getServer().locateQueue(retainAddress);
        if (queue == null) {
            queue = this.session.getServerSession().createQueue(retainAddress, retainAddress, null, false, true);
        }
        message.setAddress(retainAddress);
        LinkedListIterator linkedListIterator = iterator = queue.iterator();
        synchronized (linkedListIterator) {
            if (iterator.hasNext()) {
                Long messageId = ((MessageReference)iterator.next()).getMessage().getMessageID();
                queue.deleteReference(messageId.longValue());
            }
            if (!reset) {
                this.session.getServerSession().send(message.copy(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRetainedMessagesToQueue(SimpleString queueName, String address) throws Exception {
        Queue queue = this.session.getServer().locateQueue(queueName);
        String retainAddress = MQTTUtil.convertMQTTAddressFilterToCoreRetain(address);
        BindingQueryResult bindingQueryResult = this.session.getServerSession().executeBindingQuery(new SimpleString(retainAddress));
        for (SimpleString retainedQueueName : bindingQueryResult.getQueueNames()) {
            Queue retainedQueue = this.session.getServer().locateQueue(retainedQueueName);
            MQTTRetainMessageManager mQTTRetainMessageManager = this;
            synchronized (mQTTRetainMessageManager) {
                LinkedListIterator i = retainedQueue.iterator();
                if (i.hasNext()) {
                    ServerMessage message = ((MessageReference)i.next()).getMessage().copy(this.session.getServer().getStorageManager().generateID());
                    queue.addTail(message.createReference(queue), true);
                }
            }
        }
    }
}

