/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTMessageInfo;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.server.ServerMessage;

public class MQTTSessionState {
    private String clientId;
    private ServerMessage willMessage;
    private final ConcurrentMap<String, MqttTopicSubscription> subscriptions = new ConcurrentHashMap<String, MqttTopicSubscription>();
    private Map<Integer, MQTTMessageInfo> messageRefStore;
    private ConcurrentMap<String, Map<Long, Integer>> addressMessageMap;
    private Set<Integer> pubRec;
    private Set<Integer> pub;
    private boolean attached = false;
    private MQTTLogger log = MQTTLogger.LOGGER;
    private Map<Integer, Pair<String, Long>> outboundMessageReferenceStore;
    private ConcurrentMap<String, ConcurrentMap<Long, Integer>> reverseOutboundReferenceStore;
    private final Object outboundLock = new Object();
    private AtomicInteger lastId = new AtomicInteger(0);

    public MQTTSessionState(String clientId) {
        this.clientId = clientId;
        this.pubRec = new HashSet<Integer>();
        this.pub = new HashSet<Integer>();
        this.outboundMessageReferenceStore = new ConcurrentHashMap<Integer, Pair<String, Long>>();
        this.reverseOutboundReferenceStore = new ConcurrentHashMap<String, ConcurrentMap<Long, Integer>>();
        this.messageRefStore = new ConcurrentHashMap<Integer, MQTTMessageInfo>();
        this.addressMessageMap = new ConcurrentHashMap<String, Map<Long, Integer>>();
    }

    int generateId() {
        this.lastId.compareAndSet(Short.MAX_VALUE, 1);
        return this.lastId.addAndGet(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOutbandMessageRef(int mqttId, String address, long serverMessageId, int qos) {
        Object object = this.outboundLock;
        synchronized (object) {
            this.outboundMessageReferenceStore.put(mqttId, (Pair<String, Long>)new Pair((Object)address, (Object)serverMessageId));
            if (qos == 2) {
                if (this.reverseOutboundReferenceStore.containsKey(address)) {
                    ((ConcurrentMap)this.reverseOutboundReferenceStore.get(address)).put(serverMessageId, mqttId);
                } else {
                    ConcurrentHashMap<Long, Integer> serverToMqttId = new ConcurrentHashMap<Long, Integer>();
                    serverToMqttId.put(serverMessageId, mqttId);
                    this.reverseOutboundReferenceStore.put(address, serverToMqttId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<String, Long> removeOutbandMessageRef(int mqttId, int qos) {
        Object object = this.outboundLock;
        synchronized (object) {
            Pair<String, Long> messageInfo = this.outboundMessageReferenceStore.remove(mqttId);
            if (qos == 1) {
                return messageInfo;
            }
            Map map = (Map)this.reverseOutboundReferenceStore.get(messageInfo.getA());
            if (map != null) {
                map.remove(messageInfo.getB());
                if (map.isEmpty()) {
                    this.reverseOutboundReferenceStore.remove(messageInfo.getA());
                }
                return messageInfo;
            }
            return null;
        }
    }

    Set<Integer> getPubRec() {
        return this.pubRec;
    }

    Set<Integer> getPub() {
        return this.pub;
    }

    boolean getAttached() {
        return this.attached;
    }

    void setAttached(boolean attached) {
        this.attached = attached;
    }

    boolean isWill() {
        return this.willMessage != null;
    }

    ServerMessage getWillMessage() {
        return this.willMessage;
    }

    void setWillMessage(ServerMessage willMessage) {
        this.willMessage = willMessage;
    }

    void deleteWillMessage() {
        this.willMessage = null;
    }

    Collection<MqttTopicSubscription> getSubscriptions() {
        return this.subscriptions.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addSubscription(MqttTopicSubscription subscription) {
        ConcurrentMap<String, MqttTopicSubscription> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.addressMessageMap.putIfAbsent(MQTTUtil.convertMQTTAddressFilterToCore(subscription.topicName()), new ConcurrentHashMap());
            MqttTopicSubscription existingSubscription = (MqttTopicSubscription)this.subscriptions.get(subscription.topicName());
            if (existingSubscription != null) {
                if (subscription.qualityOfService().value() > existingSubscription.qualityOfService().value()) {
                    this.subscriptions.put(subscription.topicName(), subscription);
                    return true;
                }
            } else {
                this.subscriptions.put(subscription.topicName(), subscription);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(String address) {
        ConcurrentMap<String, MqttTopicSubscription> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.subscriptions.remove(address);
            this.addressMessageMap.remove(address);
        }
    }

    MqttTopicSubscription getSubscription(String address) {
        return (MqttTopicSubscription)this.subscriptions.get(address);
    }

    String getClientId() {
        return this.clientId;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    void storeMessageRef(Integer mqttId, MQTTMessageInfo messageInfo, boolean storeAddress) {
        Map addressMap;
        this.messageRefStore.put(mqttId, messageInfo);
        if (storeAddress && (addressMap = (Map)this.addressMessageMap.get(messageInfo.getAddress())) != null) {
            addressMap.put(messageInfo.getServerMessageId(), mqttId);
        }
    }

    void removeMessageRef(Integer mqttId) {
        Map addressMap;
        MQTTMessageInfo info = this.messageRefStore.remove(mqttId);
        if (info != null && (addressMap = (Map)this.addressMessageMap.get(info.getAddress())) != null) {
            addressMap.remove(info.getServerMessageId());
        }
    }

    MQTTMessageInfo getMessageInfo(Integer mqttId) {
        return this.messageRefStore.get(mqttId);
    }
}

