/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="dependency-scan", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ArtemisDependencyScanPlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String name;
    @Parameter
    private String[] libListWithDeps;
    @Parameter
    private String[] libList;
    @Parameter
    private String variableName;
    @Parameter
    private String file;
    @Parameter
    private String pathSeparator = File.pathSeparator;
    @Parameter
    private File targetFolder;
    private MavenProject project;
    @Parameter
    private boolean optional = false;

    @Override
    protected boolean isIgnore() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        block18: {
            super.doExecute();
            this.getLog().debug((CharSequence)("Local " + String.valueOf(this.localRepository)));
            this.project = (MavenProject)this.getPluginContext().get("project");
            Map properties = this.getPluginContext();
            Set entries = properties.entrySet();
            this.getLog().debug((CharSequence)("Entries.size " + entries.size()));
            for (Map.Entry entry : entries) {
                this.getLog().debug((CharSequence)("... key=" + String.valueOf(entry.getKey()) + " = " + String.valueOf(entry.getValue())));
            }
            try {
                StringBuilder sb = new StringBuilder();
                Set<File> filesSet = this.resolveDependencies(this.libListWithDeps, this.libList);
                if (this.variableName != null || this.file != null) {
                    String separatorUsed = "";
                    for (File f : filesSet) {
                        sb.append(separatorUsed);
                        sb.append(f.getAbsolutePath());
                        separatorUsed = this.pathSeparator;
                    }
                    String classPathGenerated = sb.toString();
                    this.setVariable(classPathGenerated);
                    if (this.file != null) {
                        File fileOutput = new File(this.file);
                        try {
                            if (this.getLog().isDebugEnabled()) {
                                this.getLog().debug((CharSequence)("Generating file " + this.file + " with classpath output for " + this.variableName));
                                this.getLog().debug((CharSequence)classPathGenerated);
                            }
                            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileOutput)));
                            printStream.print(classPathGenerated);
                            printStream.close();
                        }
                        catch (Exception e) {
                            this.getLog().error((CharSequence)"could not generate file with classpath", (Throwable)e);
                        }
                    }
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("targetFolder=" + String.valueOf(this.targetFolder)));
                }
                if (this.targetFolder != null) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("copying libraries into " + String.valueOf(this.targetFolder)));
                    }
                    this.targetFolder.mkdirs();
                    for (File file : filesSet) {
                        File targetFile = new File(this.targetFolder, file.getName());
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("copying " + String.valueOf(file.toPath()) + " into " + String.valueOf(targetFile.toPath())));
                        }
                        Files.copy(file.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            }
            catch (Throwable e) {
                this.getLog().error(e);
                if (this.optional) {
                    this.setVariable("");
                    break block18;
                }
                throw new MojoFailureException(e.getMessage());
            }
            finally {
                this.done();
            }
        }
    }

    private void setVariable(String classPathGenerated) {
        if (this.variableName != null) {
            this.project.getProperties().setProperty(this.variableName, classPathGenerated);
            this.getLog().debug((CharSequence)("dependency-scan setting: -D" + this.variableName + "=\"" + classPathGenerated + "\""));
        }
    }
}

