/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.DefaultConnectionProperties;
import org.apache.activemq.artemis.jms.server.config.JMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.JMSConfigurationImpl;
import org.apache.activemq.artemis.jms.server.embedded.EmbeddedJMS;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedJMSResource
extends ExternalResource {
    static final String SERVER_NAME = "embedded-jms-server";
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    Integer serverId = null;
    Configuration configuration;
    JMSConfiguration jmsConfiguration;
    EmbeddedJMS jmsServer;
    InternalClient internalClient;

    public EmbeddedJMSResource() {
        this(false);
    }

    public EmbeddedJMSResource(boolean useNetty) {
        try {
            this.configuration = new ConfigurationImpl().setName(SERVER_NAME).setPersistenceEnabled(false).setSecurityEnabled(false).addAcceptorConfiguration("invm", "vm://0");
            if (useNetty) {
                this.configuration.addAcceptorConfiguration("netty", DefaultConnectionProperties.DEFAULT_BROKER_BIND_URL);
            }
            this.jmsConfiguration = new JMSConfigurationImpl();
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EmbeddedJMSResource addAcceptor(String name, String uri) throws Exception {
        this.configuration.addAcceptorConfiguration(name, uri);
        return this;
    }

    public EmbeddedJMSResource(int serverId) {
        this.serverId = serverId;
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("serverId", serverId);
        this.configuration = new ConfigurationImpl().setName("embedded-jms-server-" + serverId).setPersistenceEnabled(false).setSecurityEnabled(false).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName(), props));
        this.jmsConfiguration = new JMSConfigurationImpl();
        this.init();
    }

    public EmbeddedJMSResource(Configuration configuration, JMSConfiguration jmsConfiguration) {
        this.configuration = configuration;
        this.jmsConfiguration = jmsConfiguration;
        this.init();
    }

    public EmbeddedJMSResource(String filename) {
        this(filename, filename);
    }

    public EmbeddedJMSResource(String serverConfigurationFileName, String jmsConfigurationFileName) {
        if (serverConfigurationFileName == null) {
            throw new IllegalArgumentException("ActiveMQServer configuration file name cannot be null");
        }
        if (jmsConfigurationFileName == null) {
            throw new IllegalArgumentException("JMSServerManager configuration file name cannot be null");
        }
        FileDeploymentManager coreDeploymentManager = new FileDeploymentManager(serverConfigurationFileName);
        FileConfiguration coreConfiguration = new FileConfiguration();
        coreDeploymentManager.addDeployable((Deployable)coreConfiguration);
        try {
            coreDeploymentManager.readConfiguration();
        }
        catch (Exception readCoreConfigEx) {
            throw new EmbeddedJMSResourceException(String.format("Failed to read ActiveMQServer configuration from file %s", serverConfigurationFileName), readCoreConfigEx);
        }
        this.configuration = coreConfiguration;
        FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
        FileDeploymentManager jmsDeploymentManager = new FileDeploymentManager(jmsConfigurationFileName);
        jmsDeploymentManager.addDeployable((Deployable)jmsConfiguration);
        try {
            jmsDeploymentManager.readConfiguration();
        }
        catch (Exception readJmsConfigEx) {
            throw new EmbeddedJMSResourceException(String.format("Failed to read JMSServerManager configuration from file %s", jmsConfigurationFileName), readJmsConfigEx);
        }
        this.jmsConfiguration = jmsConfiguration;
        this.init();
    }

    public static void setMessageProperties(Message message, Map<String, Object> properties) {
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                try {
                    message.setObjectProperty(property.getKey(), property.getValue());
                }
                catch (JMSException jmsEx) {
                    throw new EmbeddedJMSResourceException(String.format("Failed to set property {%s = %s}", property.getKey(), property.getValue().toString()), (Exception)((Object)jmsEx));
                }
            }
        }
    }

    private void init() {
        if (this.jmsServer == null) {
            this.jmsServer = new EmbeddedJMS().setConfiguration(this.configuration).setJmsConfiguration(this.jmsConfiguration);
        }
    }

    public void start() {
        this.log.info("Starting {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getServerName());
        try {
            this.jmsServer.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception encountered starting %s: %s", this.jmsServer.getClass().getSimpleName(), this.getServerName()), ex);
        }
    }

    public void stop() {
        this.log.info("Stopping {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getServerName());
        if (this.internalClient != null) {
            this.internalClient.stop();
            this.internalClient = null;
        }
        if (this.jmsServer != null) {
            try {
                this.jmsServer.stop();
            }
            catch (Exception ex) {
                this.log.warn(String.format("Exception encountered stopping %s: %s - ignoring", this.jmsServer.getClass().getSimpleName(), this.getServerName()), (Throwable)ex);
            }
        }
    }

    protected void before() throws Throwable {
        this.log.info("Starting {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getServerName());
        this.start();
        super.before();
    }

    protected void after() {
        this.log.info("Stopping {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getServerName());
        super.after();
        this.stop();
    }

    public EmbeddedJMS getJmsServer() {
        return this.jmsServer;
    }

    public String getServerName() {
        String name = "unknown";
        ActiveMQServer activeMQServer = this.jmsServer.getActiveMQServer();
        if (activeMQServer != null) {
            name = activeMQServer.getConfiguration().getName();
        } else if (this.configuration != null) {
            name = this.configuration.getName();
        }
        return name;
    }

    public String getVmURL() {
        String vmURL = "vm://0";
        for (TransportConfiguration transportConfiguration : this.configuration.getAcceptorConfigurations()) {
            Map params = transportConfiguration.getParams();
            if (params == null || !params.containsKey("serverId")) continue;
            vmURL = "vm://" + params.get("serverId");
        }
        return vmURL;
    }

    public Queue getDestinationQueue(String destinationName) {
        Queue queue = null;
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)1);
        String address = destination.getAddress();
        String name = destination.getName();
        if (destination.isQueue()) {
            queue = this.jmsServer.getActiveMQServer().locateQueue(destination.getSimpleAddress());
        } else {
            List queueNames;
            BindingQueryResult bindingQueryResult = null;
            try {
                bindingQueryResult = this.jmsServer.getActiveMQServer().bindingQuery(destination.getSimpleAddress());
            }
            catch (Exception ex) {
                this.log.error(String.format("getDestinationQueue( %s ) - bindingQuery for %s failed", destinationName, destination.getAddress()), (Throwable)ex);
                return null;
            }
            if (bindingQueryResult.isExists() && (queueNames = bindingQueryResult.getQueueNames()).size() > 0) {
                queue = this.jmsServer.getActiveMQServer().locateQueue((SimpleString)queueNames.get(0));
            }
        }
        return queue;
    }

    public List<Queue> getTopicQueues(String topicName) {
        LinkedList<Queue> queues = new LinkedList<Queue>();
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)topicName, (byte)2);
        if (!destination.isQueue()) {
            BindingQueryResult bindingQueryResult = null;
            try {
                bindingQueryResult = this.jmsServer.getActiveMQServer().bindingQuery(destination.getSimpleAddress());
            }
            catch (Exception ex) {
                this.log.error(String.format("getTopicQueues( %s ) - bindingQuery for %s failed", topicName, destination.getAddress()), (Throwable)ex);
                return queues;
            }
            if (bindingQueryResult.isExists()) {
                ActiveMQServer activeMQServer = this.jmsServer.getActiveMQServer();
                for (SimpleString queueName : bindingQueryResult.getQueueNames()) {
                    queues.add(activeMQServer.locateQueue(queueName));
                }
            }
        }
        return queues;
    }

    public long getMessageCount(String destinationName) {
        long count = 0L;
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)1);
        if (destination.isQueue()) {
            Queue queue = this.getDestinationQueue(destinationName);
            if (queue == null) {
                this.log.warn("getMessageCount(destinationName) - destination {} not found; returning -1", (Object)destinationName);
                count = -1L;
            } else {
                count = queue.getMessageCount();
            }
        } else {
            for (Queue topicQueue : this.getTopicQueues(destinationName)) {
                count += topicQueue.getMessageCount();
            }
        }
        return count;
    }

    public BytesMessage createBytesMessage() {
        return this.getInternalClient().createBytesMessage();
    }

    public TextMessage createTextMessage() {
        return this.getInternalClient().createTextMessage();
    }

    public MapMessage createMapMessage() {
        return this.getInternalClient().createMapMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.getInternalClient().createObjectMessage();
    }

    public StreamMessage createStreamMessage() {
        return this.getInternalClient().createStreamMessage();
    }

    public BytesMessage createMessage(byte[] body) {
        return this.createMessage(body, null);
    }

    public TextMessage createMessage(String body) {
        return this.createMessage(body, null);
    }

    public MapMessage createMessage(Map<String, Object> body) {
        return this.createMessage(body, null);
    }

    public ObjectMessage createMessage(Serializable body) {
        return this.createMessage(body, null);
    }

    public BytesMessage createMessage(byte[] body, Map<String, Object> properties) {
        BytesMessage message = this.createBytesMessage();
        if (body != null) {
            try {
                message.writeBytes(body);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException(String.format("Failed to set body {%s} on BytesMessage", new String(body)), (Exception)((Object)jmsEx));
            }
        }
        EmbeddedJMSResource.setMessageProperties((Message)message, properties);
        return message;
    }

    public TextMessage createMessage(String body, Map<String, Object> properties) {
        TextMessage message = this.createTextMessage();
        if (body != null) {
            try {
                message.setText(body);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException(String.format("Failed to set body {%s} on TextMessage", body), (Exception)((Object)jmsEx));
            }
        }
        EmbeddedJMSResource.setMessageProperties((Message)message, properties);
        return message;
    }

    public MapMessage createMessage(Map<String, Object> body, Map<String, Object> properties) {
        MapMessage message = this.createMapMessage();
        if (body != null) {
            for (Map.Entry<String, Object> entry : body.entrySet()) {
                try {
                    message.setObject(entry.getKey(), entry.getValue());
                }
                catch (JMSException jmsEx) {
                    throw new EmbeddedJMSResourceException(String.format("Failed to set body entry {%s = %s} on MapMessage", entry.getKey(), entry.getValue().toString()), (Exception)((Object)jmsEx));
                }
            }
        }
        EmbeddedJMSResource.setMessageProperties((Message)message, properties);
        return message;
    }

    public ObjectMessage createMessage(Serializable body, Map<String, Object> properties) {
        ObjectMessage message = this.createObjectMessage();
        if (body != null) {
            try {
                message.setObject(body);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException(String.format("Failed to set body {%s} on ObjectMessage", body.toString()), (Exception)((Object)jmsEx));
            }
        }
        EmbeddedJMSResource.setMessageProperties((Message)message, properties);
        return message;
    }

    public void pushMessage(String destinationName, Message message) {
        if (destinationName == null) {
            throw new IllegalArgumentException("sendMessage failure - destination name is required");
        }
        if (message == null) {
            throw new IllegalArgumentException("sendMessage failure - a Message is required");
        }
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)1);
        this.getInternalClient().pushMessage(destination, message);
    }

    public BytesMessage pushMessage(String destinationName, byte[] body) {
        BytesMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public TextMessage pushMessage(String destinationName, String body) {
        TextMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public MapMessage pushMessage(String destinationName, Map<String, Object> body) {
        MapMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public ObjectMessage pushMessage(String destinationName, Serializable body) {
        ObjectMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public BytesMessage pushMessageWithProperties(String destinationName, byte[] body, Map<String, Object> properties) {
        BytesMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public TextMessage pushMessageWithProperties(String destinationName, String body, Map<String, Object> properties) {
        TextMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public MapMessage pushMessageWithProperties(String destinationName, Map<String, Object> body, Map<String, Object> properties) {
        MapMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public ObjectMessage pushMessageWithProperties(String destinationName, Serializable body, Map<String, Object> properties) {
        ObjectMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public Message peekMessage(String destinationName) {
        if (null == this.jmsServer) {
            throw new NullPointerException("peekMessage failure  - BrokerService is null");
        }
        if (destinationName == null) {
            throw new IllegalArgumentException("peekMessage failure - destination name is required");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public BytesMessage peekBytesMessage(String destinationName) {
        return (BytesMessage)this.peekMessage(destinationName);
    }

    public TextMessage peekTextMessage(String destinationName) {
        return (TextMessage)this.peekMessage(destinationName);
    }

    public MapMessage peekMapMessage(String destinationName) {
        return (MapMessage)this.peekMessage(destinationName);
    }

    public ObjectMessage peekObjectMessage(String destinationName) {
        return (ObjectMessage)this.peekMessage(destinationName);
    }

    public StreamMessage peekStreamMessage(String destinationName) {
        return (StreamMessage)this.peekMessage(destinationName);
    }

    private InternalClient getInternalClient() {
        if (this.internalClient == null) {
            this.log.info("Creating InternalClient");
            this.internalClient = new InternalClient();
            this.internalClient.start();
        }
        return this.internalClient;
    }

    private class InternalClient {
        ConnectionFactory connectionFactory;
        Connection connection;
        Session session;
        MessageProducer producer;

        InternalClient() {
        }

        void start() {
            this.connectionFactory = new ActiveMQConnectionFactory(EmbeddedJMSResource.this.getVmURL());
            try {
                this.connection = this.connectionFactory.createConnection();
                this.session = this.connection.createSession();
                this.producer = this.session.createProducer(null);
                this.connection.start();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException("InternalClient creation failure", (Exception)((Object)jmsEx));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            try {
                this.producer.close();
            }
            catch (JMSException jmsEx) {
                EmbeddedJMSResource.this.log.warn("JMSException encounter closing InternalClient Session - MessageProducer", (Throwable)jmsEx);
            }
            finally {
                this.producer = null;
            }
            try {
                this.session.close();
            }
            catch (JMSException jmsEx) {
                EmbeddedJMSResource.this.log.warn("JMSException encounter closing InternalClient Session - ignoring", (Throwable)jmsEx);
            }
            finally {
                this.session = null;
            }
            if (null != this.connection) {
                try {
                    this.connection.close();
                }
                catch (JMSException jmsEx) {
                    EmbeddedJMSResource.this.log.warn("JMSException encounter closing InternalClient Connection - ignoring", (Throwable)jmsEx);
                }
                finally {
                    this.connection = null;
                }
            }
        }

        public BytesMessage createBytesMessage() {
            this.checkSession();
            try {
                return this.session.createBytesMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException("Failed to create BytesMessage", (Exception)((Object)jmsEx));
            }
        }

        public TextMessage createTextMessage() {
            this.checkSession();
            try {
                return this.session.createTextMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException("Failed to create TextMessage", (Exception)((Object)jmsEx));
            }
        }

        public MapMessage createMapMessage() {
            this.checkSession();
            try {
                return this.session.createMapMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException("Failed to create MapMessage", (Exception)((Object)jmsEx));
            }
        }

        public ObjectMessage createObjectMessage() {
            this.checkSession();
            try {
                return this.session.createObjectMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException("Failed to create ObjectMessage", (Exception)((Object)jmsEx));
            }
        }

        public StreamMessage createStreamMessage() {
            this.checkSession();
            try {
                return this.session.createStreamMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException("Failed to create StreamMessage", (Exception)((Object)jmsEx));
            }
        }

        public void pushMessage(ActiveMQDestination destination, Message message) {
            if (this.producer == null) {
                throw new IllegalStateException("JMS MessageProducer is null - has the InternalClient been started?");
            }
            try {
                this.producer.send((Destination)destination, message);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedJMSResourceException(String.format("Failed to push %s to %s", message.getClass().getSimpleName(), destination.toString()), (Exception)((Object)jmsEx));
            }
        }

        void checkSession() {
            if (this.session == null) {
                throw new IllegalStateException("JMS Session is null - has the InternalClient been started?");
            }
        }
    }

    public static class EmbeddedJMSResourceException
    extends RuntimeException {
        public EmbeddedJMSResourceException(String message) {
            super(message);
        }

        public EmbeddedJMSResourceException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

