/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class BytesUtils {
    private BytesUtils() {
    }

    public static long align(long value, long alignment) {
        return value + (alignment - 1L) & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void zerosDirect(ByteBuffer buffer) {
        int remaining;
        long address = PlatformDependent.directBufferAddress((ByteBuffer)buffer);
        for (remaining = buffer.capacity(); remaining >= 8; remaining -= 8) {
            PlatformDependent.putLong((long)address, (long)0L);
            address += 8L;
        }
        while (remaining > 0) {
            PlatformDependent.putByte((long)address, (byte)0);
            ++address;
            --remaining;
        }
    }
}

