/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.jboss.logging.Logger;

public class Reclaimer {
    private static final Logger logger = Logger.getLogger(Reclaimer.class);

    private static void trace(String message) {
        logger.trace((Object)message);
    }

    public void scan(JournalFile[] files) {
        block0: for (int i = 0; i < files.length; ++i) {
            int j;
            JournalFile currentFile = files[i];
            int posCount = currentFile.getPosCount();
            int totNeg = 0;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("posCount on " + currentFile + " = " + posCount));
            }
            for (j = i; j < files.length; ++j) {
                if (logger.isTraceEnabled() && files[j].getNegCount(currentFile) != 0) {
                    logger.trace((Object)("Negative from " + files[j] + " into " + currentFile + " = " + files[j].getNegCount(currentFile)));
                }
                totNeg += files[j].getNegCount(currentFile);
            }
            currentFile.setCanReclaim(true);
            if (posCount <= totNeg) {
                for (j = 0; j <= i; ++j) {
                    JournalFile file = files[j];
                    int negCount = currentFile.getNegCount(file);
                    if (negCount == 0 || file.isCanReclaim()) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(currentFile + " Can't be reclaimed because " + file + " has negative values"));
                    }
                    currentFile.setCanReclaim(false);
                    continue block0;
                }
                continue;
            }
            currentFile.setCanReclaim(false);
        }
    }
}

