/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NoProgressException;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ProgressCheckRejectionPolicy
implements RejectedExecutionHandler {
    public static final String NAME = "progress_check";
    private long period = 10000L;
    private long last_completed = -1L;
    private long last_change = 0L;
    private RejectedExecutionHandler fallback = null;

    public ProgressCheckRejectionPolicy(String rejection_policy) {
        String policy = rejection_policy.toLowerCase();
        if (!policy.startsWith(NAME)) {
            throw new IllegalStateException(rejection_policy);
        }
        if ((policy = policy.substring(NAME.length())).startsWith("=")) {
            String[] attributes;
            for (String attribute : attributes = policy.substring(1).split(",", 0)) {
                String[] parts = attribute.split(":");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Attribute '" + attribute + "' in " + rejection_policy);
                }
                String key = parts[0].trim();
                String value = parts[1].trim();
                if (key.equals("period")) {
                    try {
                        this.period = Long.parseLong(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Cannot parse period value in " + rejection_policy, e);
                    }
                }
                if (!key.equals("fallback")) continue;
                this.fallback = Util.parseRejectionPolicy(rejection_policy.substring(rejection_policy.indexOf("fallback:") + 9));
            }
        }
    }

    @Override
    public synchronized void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        long completed = executor.getCompletedTaskCount();
        if (completed < this.last_completed) {
            throw new IllegalStateException("Number of completed tasks shouldn't decrease");
        }
        if (completed == this.last_completed) {
            long now = System.currentTimeMillis();
            if (now - this.last_change > this.period) {
                String message = String.format("No progress for %d ms, possible distributed deadlock. Try raising threadpool size\n\tMin size: %d\n\tMax size: %d\n\tCurrent size: %d\n\tActive: %d\n\tLargest size: %d\n\tCompleted tasks: %d\n\tTotal scheduled: %d", now - this.last_change, executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getPoolSize(), executor.getActiveCount(), executor.getLargestPoolSize(), executor.getCompletedTaskCount(), executor.getTaskCount());
                throw new NoProgressException(message);
            }
        } else {
            this.last_change = System.currentTimeMillis();
            this.last_completed = completed;
        }
        if (this.fallback != null) {
            this.fallback.rejectedExecution(r, executor);
        }
    }
}

