/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Lifecycle;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ThreadPool;

public class AsyncExecutor<T>
implements Lifecycle {
    @Property(description="If not enabled, tasks will executed on the runner's thread")
    protected boolean enabled = true;
    @ManagedAttribute(description="Total number of times a message was sent (includes rejected messages)", type=AttributeType.SCALAR)
    protected final LongAdder num_sends = new LongAdder();
    @ManagedAttribute(description="Number of rejected message due to an exhausted thread pool (includes dropped messages and messages sent on the caller's thread", type=AttributeType.SCALAR)
    protected final LongAdder num_rejected = new LongAdder();
    @ManagedAttribute(description="Number of dropped tasks (when DONT_BLOCK flag is set in the message)", type=AttributeType.SCALAR)
    protected final LongAdder num_drops_on_full_thread_pool = new LongAdder();
    @ManagedAttribute(description="Messages that were sent on the caller's thread due to an exhausted pool", type=AttributeType.SCALAR)
    protected final LongAdder num_sends_on_callers_thread = new LongAdder();
    protected ThreadPool thread_pool;
    protected Executor executor;

    public boolean enabled() {
        return this.enabled;
    }

    public AsyncExecutor<T> enable(boolean b) {
        this.enabled = b;
        return this;
    }

    public ThreadPool threadPool() {
        return this.thread_pool;
    }

    public AsyncExecutor<T> threadPool(ThreadPool p) {
        this.thread_pool = p;
        return this;
    }

    public long numSends() {
        return this.num_sends.sum();
    }

    public long numSendsOnCallersThread() {
        return this.num_sends_on_callers_thread.sum();
    }

    public long numDropsOnFullThreadPool() {
        return this.num_drops_on_full_thread_pool.sum();
    }

    public long numRejected() {
        return this.num_rejected.sum();
    }

    public AsyncExecutor() {
    }

    public AsyncExecutor(ThreadPool p) {
        this.thread_pool = p;
    }

    public void resetStats() {
        this.num_sends.reset();
        this.num_rejected.reset();
        this.num_drops_on_full_thread_pool.reset();
        this.num_sends_on_callers_thread.reset();
    }

    public CompletableFuture<T> execute(Supplier<T> t, boolean can_be_dropped) {
        Task<T> task = new Task<T>(t, new CompletableFuture());
        Executor exec = this.executor;
        try {
            this.num_sends.increment();
            if (this.enabled && (exec = this.exec()) != null) {
                return CompletableFuture.supplyAsync(t, exec);
            }
            return CompletableFuture.completedFuture(t.get());
        }
        catch (RejectedExecutionException ex) {
            this.num_rejected.increment();
            if (!can_be_dropped) {
                task.run();
                this.num_sends_on_callers_thread.increment();
            } else {
                task.completeExceptionally(ex);
                this.num_drops_on_full_thread_pool.increment();
            }
            return task.cf;
        }
    }

    public String toString() {
        return String.format("rejected: %,d, drops=%,d, sends_on_caller: %,d, pool: %s\n", this.num_rejected.sum(), this.num_drops_on_full_thread_pool.sum(), this.num_sends_on_callers_thread.sum(), this.thread_pool.toString());
    }

    protected Executor exec() {
        Executor exec = this.executor;
        return exec != null ? exec : (exec = (this.executor = this.thread_pool.pool()));
    }

    protected static class Task<T>
    implements Runnable {
        protected final Supplier<T> task;
        protected final CompletableFuture<T> cf;

        protected Task(Supplier<T> task, CompletableFuture<T> cf) {
            this.task = task;
            this.cf = cf;
        }

        protected Task<T> completeExceptionally(Throwable t) {
            this.cf.completeExceptionally(t);
            return this;
        }

        @Override
        public void run() {
            try {
                T result = this.task.get();
                this.cf.complete(result);
            }
            catch (Throwable t) {
                this.cf.completeExceptionally(t);
            }
        }
    }
}

