/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.openmbean;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageOpenTypeFactory<M extends Message> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CompositeType compositeType;
    private final List<String> itemNamesList = new ArrayList<String>();
    private final List<String> itemDescriptionsList = new ArrayList<String>();
    private final List<OpenType> itemTypesList = new ArrayList<OpenType>();
    protected TabularType stringPropertyTabularType;
    protected TabularType booleanPropertyTabularType;
    protected TabularType bytePropertyTabularType;
    protected TabularType shortPropertyTabularType;
    protected TabularType intPropertyTabularType;
    protected TabularType longPropertyTabularType;
    protected TabularType floatPropertyTabularType;
    protected TabularType doublePropertyTabularType;
    protected Object[][] typedPropertyFields;

    public MessageOpenTypeFactory() {
        try {
            this.init();
            this.compositeType = this.createCompositeType();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
    }

    protected String getTypeName() {
        return Message.class.getName();
    }

    public CompositeType getCompositeType() throws OpenDataException {
        return this.compositeType;
    }

    protected void init() throws OpenDataException {
        this.addItem("type", "The message type", SimpleType.BYTE);
        this.addItem("address", "The Address", SimpleType.STRING);
        this.addItem("messageID", "The message ID", SimpleType.STRING);
        this.addItem("protocol", "The message protocol", SimpleType.STRING);
        this.addItem("userID", "The user ID", SimpleType.STRING);
        this.addItem("durable", "Is the message durable", SimpleType.BOOLEAN);
        this.addItem("expiration", "The message expiration", SimpleType.LONG);
        this.addItem("priority", "The message priority", SimpleType.BYTE);
        this.addItem("redelivered", "Has the message been redelivered", SimpleType.BOOLEAN);
        this.addItem("timestamp", "The message timestamp", SimpleType.LONG);
        this.addItem("largeMessage", "Is the message treated as a large message", SimpleType.BOOLEAN);
        this.addItem("persistentSize", "The message size when persisted on disk", SimpleType.LONG);
        this.addItem("PropertiesText", "The properties text", SimpleType.STRING);
        this.stringPropertyTabularType = this.createTabularType(String.class, SimpleType.STRING);
        this.booleanPropertyTabularType = this.createTabularType(Boolean.class, SimpleType.BOOLEAN);
        this.bytePropertyTabularType = this.createTabularType(Byte.class, SimpleType.BYTE);
        this.shortPropertyTabularType = this.createTabularType(Short.class, SimpleType.SHORT);
        this.intPropertyTabularType = this.createTabularType(Integer.class, SimpleType.INTEGER);
        this.longPropertyTabularType = this.createTabularType(Long.class, SimpleType.LONG);
        this.floatPropertyTabularType = this.createTabularType(Float.class, SimpleType.FLOAT);
        this.doublePropertyTabularType = this.createTabularType(Double.class, SimpleType.DOUBLE);
        this.addItem("StringProperties", "User String Properties", this.stringPropertyTabularType);
        this.addItem("BooleanProperties", "User Boolean Properties", this.booleanPropertyTabularType);
        this.addItem("ByteProperties", "User Byte Properties", this.bytePropertyTabularType);
        this.addItem("ShortProperties", "User Short Properties", this.shortPropertyTabularType);
        this.addItem("IntProperties", "User Int Properties", this.intPropertyTabularType);
        this.addItem("LongProperties", "User Long Properties", this.longPropertyTabularType);
        this.addItem("FloatProperties", "User Float Properties", this.floatPropertyTabularType);
        this.addItem("DoubleProperties", "User Double Properties", this.doublePropertyTabularType);
        this.typedPropertyFields = new Object[][]{{"StringProperties", this.stringPropertyTabularType, String.class}, {"BooleanProperties", this.booleanPropertyTabularType, Boolean.class}, {"ByteProperties", this.bytePropertyTabularType, Byte.class}, {"ShortProperties", this.shortPropertyTabularType, Short.class}, {"IntProperties", this.intPropertyTabularType, Integer.class}, {"LongProperties", this.longPropertyTabularType, Long.class}, {"FloatProperties", this.floatPropertyTabularType, Float.class}, {"DoubleProperties", this.doublePropertyTabularType, Double.class}};
    }

    public Map<String, Object> getFields(M m, int valueSizeLimit, int deliveryCount) throws OpenDataException {
        HashMap<String, Object> rc = new HashMap<String, Object>();
        rc.put("messageID", "" + m.getMessageID());
        rc.put("protocol", m.getProtocolName());
        if (m.getUserID() != null) {
            String userID = m.getUserID().toString();
            rc.put("userID", userID.startsWith("ID:") ? userID : "ID:" + userID);
        } else {
            rc.put("userID", "");
        }
        rc.put("address", m.getAddress() == null ? "" : m.getAddress());
        rc.put("durable", m.isDurable());
        rc.put("expiration", m.getExpiration());
        rc.put("timestamp", m.getTimestamp());
        rc.put("priority", m.getPriority());
        rc.put("redelivered", deliveryCount > 1);
        rc.put("largeMessage", m.isLargeMessage());
        try {
            rc.put("persistentSize", m.getPersistentSize());
        }
        catch (ActiveMQException e1) {
            rc.put("persistentSize", -1);
        }
        Map<String, Object> propertyMap = this.expandProperties(m, valueSizeLimit);
        rc.put("PropertiesText", JsonUtil.truncate(String.valueOf(propertyMap), valueSizeLimit));
        for (Object[] typedPropertyInfo : this.typedPropertyFields) {
            TabularDataSupport tabularData = null;
            try {
                tabularData = this.createTabularData(propertyMap, (TabularType)typedPropertyInfo[1], (Class)typedPropertyInfo[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tabularData != null && !tabularData.isEmpty()) {
                rc.put((String)typedPropertyInfo[0], tabularData);
                continue;
            }
            rc.put((String)typedPropertyInfo[0], null);
        }
        return rc;
    }

    protected Map<String, Object> expandProperties(M m, int valueSizeLimit) {
        return m.toPropertyMap(valueSizeLimit);
    }

    protected String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected CompositeType createCompositeType() throws OpenDataException {
        String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
        String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
        OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
        return new CompositeType(this.getTypeName(), this.getDescription(), itemNames, itemDescriptions, itemTypes);
    }

    protected String getDescription() {
        return this.getTypeName();
    }

    protected <T> TabularType createTabularType(Class<T> type, OpenType openType) throws OpenDataException {
        String typeName = "java.util.Map<java.lang.String, " + type.getName() + ">";
        String[] keyValue = new String[]{"key", "value"};
        OpenType[] openTypes = new OpenType[]{SimpleType.STRING, openType};
        CompositeType rowType = new CompositeType(typeName, typeName, keyValue, keyValue, openTypes);
        return new TabularType(typeName, typeName, rowType, new String[]{"key"});
    }

    protected TabularDataSupport createTabularData(Map<String, Object> entries, TabularType type, Class valueType) throws IOException, OpenDataException {
        TabularDataSupport answer = new TabularDataSupport(type);
        for (String key : entries.keySet()) {
            CompositeDataSupport compositeData;
            Object value = entries.get(key);
            if (valueType.isInstance(value)) {
                compositeData = this.createTabularRowValue(type, key, value);
                answer.put(compositeData);
                continue;
            }
            if (valueType != String.class || !(value instanceof SimpleString)) continue;
            compositeData = this.createTabularRowValue(type, key, value.toString());
            answer.put(compositeData);
        }
        return answer;
    }

    protected CompositeDataSupport createTabularRowValue(TabularType type, String key, Object value) throws OpenDataException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("key", key);
        fields.put("value", value);
        return new CompositeDataSupport(type.getRowType(), fields);
    }

    protected void addItem(String name, String description, OpenType type) {
        this.itemNamesList.add(name);
        this.itemDescriptionsList.add(description);
        this.itemTypesList.add(type);
    }
}

