/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.Arrays;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ExtendedUUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.UUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@Deprecated
public class TopologyUUID
extends ExtendedUUID {
    protected static final byte[] SITE_ID = Util.stringToBytes("site-id");
    protected static final byte[] RACK_ID = Util.stringToBytes("rack-id");
    protected static final byte[] MACHINE_ID = Util.stringToBytes("machine-id");
    private static final long serialVersionUID = 332097758637301279L;

    public TopologyUUID() {
    }

    protected TopologyUUID(byte[] data, String site_id, String rack_id, String machine_id) {
        super(data);
        this.put(SITE_ID, Util.stringToBytes(site_id));
        this.put(RACK_ID, Util.stringToBytes(rack_id));
        this.put(MACHINE_ID, Util.stringToBytes(machine_id));
    }

    protected TopologyUUID(long most_sig_bits, long least_sig_bits, String site_id, String rack_id, String machine_id) {
        super(most_sig_bits, least_sig_bits);
        this.put(SITE_ID, Util.stringToBytes(site_id));
        this.put(RACK_ID, Util.stringToBytes(rack_id));
        this.put(MACHINE_ID, Util.stringToBytes(machine_id));
    }

    public static TopologyUUID randomUUID(String site_id, String rack_id, String machine_id) {
        return new TopologyUUID(TopologyUUID.generateRandomBytes(), site_id, rack_id, machine_id);
    }

    public static TopologyUUID randomUUID(String logical_name, String site_id, String rack_id, String machine_id) {
        TopologyUUID retval = new TopologyUUID(TopologyUUID.generateRandomBytes(), site_id, rack_id, machine_id);
        UUID.add(retval, logical_name);
        return retval;
    }

    public String getSiteId() {
        return Util.bytesToString(this.get(SITE_ID));
    }

    public void setSiteId(String site_id) {
        this.put(SITE_ID, Util.stringToBytes(site_id));
    }

    public String getRackId() {
        return Util.bytesToString(this.get(RACK_ID));
    }

    public void setRackId(String rack_id) {
        this.put(RACK_ID, Util.stringToBytes(rack_id));
    }

    public String getMachineId() {
        return Util.bytesToString(this.get(MACHINE_ID));
    }

    public void setMachineId(String machine_id) {
        this.put(MACHINE_ID, Util.stringToBytes(machine_id));
    }

    public boolean isSameSite(TopologyUUID addr) {
        return addr != null && Arrays.equals(this.get(SITE_ID), addr.get(SITE_ID));
    }

    public boolean isSameRack(TopologyUUID addr) {
        return addr != null && Arrays.equals(this.get(RACK_ID), addr.get(RACK_ID));
    }

    public boolean isSameMachine(TopologyUUID addr) {
        return addr != null && Arrays.equals(this.get(MACHINE_ID), addr.get(MACHINE_ID));
    }
}

