/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.stack;

import java.util.Collection;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Interval;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Retransmitter;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeScheduler;

public class DefaultRetransmitter
extends Retransmitter {
    private final ConcurrentNavigableMap<Long, Retransmitter.Task> msgs = new ConcurrentSkipListMap<Long, Retransmitter.Task>();

    public DefaultRetransmitter(Address sender, Retransmitter.RetransmitCommand cmd, TimeScheduler sched) {
        super(sender, cmd, sched);
    }

    @Override
    public void add(long first_seqno, long last_seqno) {
        if (first_seqno > last_seqno) {
            long tmp = first_seqno;
            first_seqno = last_seqno;
            last_seqno = tmp;
        }
        for (long seqno = first_seqno; seqno <= last_seqno; ++seqno) {
            SeqnoTask new_task = new SeqnoTask(seqno, this.retransmit_timeouts.copy(), this.cmd, this.sender);
            Retransmitter.Task old_task = this.msgs.putIfAbsent(seqno, new_task);
            if (old_task != null) continue;
            new_task.doSchedule();
        }
    }

    @Override
    public void remove(long seqno) {
        Retransmitter.Task task = (Retransmitter.Task)this.msgs.remove(seqno);
        if (task != null) {
            task.cancel();
        }
    }

    public void remove(long seqno, boolean remove_all_below) {
        if (!remove_all_below) {
            this.remove(seqno);
            return;
        }
        if (this.msgs.isEmpty()) {
            return;
        }
        NavigableMap to_be_removed = this.msgs.headMap((Object)seqno, true);
        if (to_be_removed.isEmpty()) {
            return;
        }
        Collection values = to_be_removed.values();
        for (Retransmitter.Task task : values) {
            if (task == null) continue;
            task.cancel();
        }
        to_be_removed.clear();
    }

    @Override
    public void reset() {
        for (Retransmitter.Task task : this.msgs.values()) {
            task.cancel();
        }
        this.msgs.clear();
    }

    public String toString() {
        Set keys = this.msgs.keySet();
        int size = keys.size();
        StringBuilder sb = new StringBuilder();
        sb.append(size).append(" messages to retransmit");
        if (size < 50) {
            sb.append(": ").append(keys);
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.msgs.size();
    }

    protected class SeqnoTask
    extends Retransmitter.Task {
        private long seqno;

        protected SeqnoTask(long seqno, Interval intervals, Retransmitter.RetransmitCommand cmd, Address msg_sender) {
            super(DefaultRetransmitter.this, intervals, cmd, msg_sender);
            this.seqno = -1L;
            this.seqno = seqno;
        }

        public String toString() {
            return String.valueOf(this.seqno);
        }

        @Override
        protected void callRetransmissionCommand() {
            this.command.retransmit(this.seqno, this.seqno, this.msg_sender);
        }
    }
}

