/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.rules;

import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.rules.SUPERVISOR;

public abstract class Rule
implements Runnable {
    protected SUPERVISOR sv;
    protected Log log;

    public Rule supervisor(SUPERVISOR sv) {
        this.sv = sv;
        return this;
    }

    public Rule log(Log log) {
        this.log = log;
        return this;
    }

    public abstract String name();

    public abstract String description();

    public void init() {
    }

    public void destroy() {
    }

    public abstract boolean eval();

    public abstract String condition();

    public abstract void trigger() throws Throwable;

    @Override
    public void run() {
        if (!this.eval()) {
            return;
        }
        try {
            String condition = this.condition();
            if (condition == null) {
                condition = "executed rule " + this.name();
            }
            this.sv.addCondition(condition);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.sv.getLocalAddress() + ": executing rule " + this.name());
            }
            this.trigger();
        }
        catch (Throwable t) {
            this.log.error(this.sv.getLocalAddress() + ": failed executiong rule " + this.name(), t);
        }
    }
}

