/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Channel;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.ReceiverAdapter;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Unsupported;
import org.apache.activemq.artemis.shaded.org.jgroups.jmx.JmxConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@Unsupported
public class ReplicatedTree
extends ReceiverAdapter {
    public static final String SEPARATOR = "/";
    static final int INDENT = 4;
    Node root = new Node("/", "/", null, null);
    final List<ReplicatedTreeListener> listeners = new ArrayList<ReplicatedTreeListener>();
    JChannel channel = null;
    String groupname = "ReplicatedTree-Group";
    final List<Address> members = new ArrayList<Address>();
    long state_fetch_timeout = 10000L;
    boolean jmx = false;
    protected final Log log = LogFactory.getLog(this.getClass());
    boolean remote_calls = true;
    String props = "udp.xml";
    private boolean send_message = false;

    public ReplicatedTree(String groupname, String props, long state_fetch_timeout) throws Exception {
        if (groupname != null) {
            this.groupname = groupname;
        }
        if (props != null) {
            this.props = props;
        }
        this.state_fetch_timeout = state_fetch_timeout;
        this.channel = new JChannel(this.props);
        this.channel.setReceiver(this);
        this.channel.connect(this.groupname);
        this.start();
    }

    public ReplicatedTree(String groupname, String props, long state_fetch_timeout, boolean jmx) throws Exception {
        if (groupname != null) {
            this.groupname = groupname;
        }
        if (props != null) {
            this.props = props;
        }
        this.jmx = jmx;
        this.state_fetch_timeout = state_fetch_timeout;
        this.channel = new JChannel(this.props);
        this.channel.setReceiver(this);
        this.channel.connect(this.groupname);
        if (jmx) {
            MBeanServer server = Util.getMBeanServer();
            if (server == null) {
                throw new Exception("No MBeanServers found; need to run with an MBeanServer present, or inside JDK 5");
            }
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        this.start();
    }

    public ReplicatedTree() {
    }

    public ReplicatedTree(JChannel channel) throws Exception {
        this.channel = channel;
        channel.setReceiver(this);
        this.viewAccepted(channel.getView());
        this.start();
    }

    public void setRemoteCalls(boolean flag) {
        this.remote_calls = flag;
    }

    public void setRootNode(Node n) {
        this.root = n;
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getAddress() : null;
    }

    public List<Address> getMembers() {
        return this.members;
    }

    public void fetchState(long timeout) throws Exception {
        this.channel.getState(null, timeout);
    }

    public void addReplicatedTreeListener(ReplicatedTreeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeReplicatedTreeListener(ReplicatedTreeListener listener) {
        this.listeners.remove(listener);
    }

    public final void start() throws Exception {
        this.channel.getState(null, this.state_fetch_timeout);
    }

    public void stop() {
        Util.close((Closeable)this.channel);
    }

    public void put(String fqn, HashMap data) {
        if (!this.remote_calls) {
            this._put(fqn, data);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast PUT request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(1, fqn, data)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting PUT request: " + ex);
                }
            }
        } else {
            this._put(fqn, data);
        }
    }

    public void put(String fqn, String key, Object value) {
        if (!this.remote_calls) {
            this._put(fqn, key, value);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast PUT request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(1, fqn, key, value)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting PUT request: " + ex);
                }
            }
        } else {
            this._put(fqn, key, value);
        }
    }

    public void remove(String fqn) {
        if (!this.remote_calls) {
            this._remove(fqn);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast REMOVE request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(2, fqn)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting REMOVE request: " + ex);
                }
            }
        } else {
            this._remove(fqn);
        }
    }

    public void remove(String fqn, String key) {
        if (!this.remote_calls) {
            this._remove(fqn, key);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast REMOVE request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(2, fqn, key)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting REMOVE request: " + ex);
                }
            }
        } else {
            this._remove(fqn, key);
        }
    }

    public boolean exists(String fqn) {
        if (fqn == null) {
            return false;
        }
        return this.findNode(fqn) != null;
    }

    public Set getKeys(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Map<String, Object> data = n.getData();
        if (data == null) {
            return null;
        }
        return data.keySet();
    }

    public Object get(String fqn, String key) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getData(key);
    }

    Map<String, Object> get(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getData();
    }

    public String print(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.toString();
    }

    public Set getChildrenNames(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Map<String, Node> m = n.getChildren();
        if (m != null) {
            return m.keySet();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int indent = 0;
        Map<String, Node> children = this.root.getChildren();
        if (children != null && !children.isEmpty()) {
            Collection<Node> nodes = children.values();
            Iterator<Node> it = nodes.iterator();
            while (it.hasNext()) {
                it.next().print(sb, indent);
                sb.append('\n');
            }
        } else {
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getGroupMembersNumber() {
        return this.members.size();
    }

    public void _put(String fqn, HashMap data) {
        StringHolder child_name = new StringHolder();
        boolean child_exists = false;
        if (fqn == null) {
            return;
        }
        Node n = this.findParentNode(fqn, child_name, true);
        if (child_name.getValue() != null) {
            child_exists = n.childExists(child_name.getValue());
            n.createChild(child_name.getValue(), fqn, n, data);
        } else {
            child_exists = true;
            n.setData(data);
        }
        if (child_exists) {
            this.notifyNodeModified(fqn);
        } else {
            this.notifyNodeAdded(fqn);
        }
    }

    public void _put(String fqn, String key, Object value) {
        StringHolder child_name = new StringHolder();
        boolean child_exists = false;
        if (fqn == null || key == null || value == null) {
            return;
        }
        Node n = this.findParentNode(fqn, child_name, true);
        if (child_name.getValue() != null) {
            child_exists = n.childExists(child_name.getValue());
            n.createChild(child_name.getValue(), fqn, n, key, value);
        } else {
            child_exists = true;
            n.setData(key, value);
        }
        if (child_exists) {
            this.notifyNodeModified(fqn);
        } else {
            this.notifyNodeAdded(fqn);
        }
    }

    public void _remove(String fqn) {
        StringHolder child_name = new StringHolder();
        if (fqn == null) {
            return;
        }
        if (fqn.equals(SEPARATOR)) {
            this.root.removeAll();
            this.notifyNodeRemoved(fqn);
            return;
        }
        Node n = this.findParentNode(fqn, child_name, false);
        if (n == null) {
            return;
        }
        n.removeChild(child_name.getValue(), fqn);
        this.notifyNodeRemoved(fqn);
    }

    public void _remove(String fqn, String key) {
        if (fqn == null || key == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n != null) {
            n.removeData(key);
        }
    }

    public void _removeData(String fqn) {
        if (fqn == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n != null) {
            n.removeData();
        }
    }

    @Override
    public void receive(Message msg) {
        block10: {
            Request req = null;
            if (msg == null || msg.getLength() == 0) {
                return;
            }
            try {
                req = (Request)msg.getObject();
                String fqn = req.fqn;
                switch (req.type) {
                    case 1: {
                        if (req.key != null && req.value != null) {
                            this._put(fqn, req.key, req.value);
                            break;
                        }
                        this._put(fqn, req.data);
                        break;
                    }
                    case 2: {
                        if (req.key != null) {
                            this._remove(fqn, req.key);
                            break;
                        }
                        this._remove(fqn);
                        break;
                    }
                    default: {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("type " + req.type + " unknown");
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block10;
                this.log.error("failed unmarshalling request: " + ex);
            }
        }
    }

    @Override
    public void getState(OutputStream ostream) throws Exception {
        Util.objectToStream(this.root.clone(), new DataOutputStream(ostream));
    }

    @Override
    public void setState(InputStream istream) throws Exception {
        Object obj = Util.objectFromStream(new DataInputStream(istream));
        this.root = (Node)((Node)obj).clone();
        this.notifyAllNodesCreated(this.root);
    }

    @Override
    public void viewAccepted(View new_view) {
        List<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.notifyViewChange(new_view);
            this.members.clear();
            this.members.addAll(new_mbrs);
        }
        this.send_message = this.members.size() > 1;
    }

    Node findParentNode(String fqn, StringHolder child_name, boolean create_if_not_exists) {
        Node curr = this.root;
        StringBuilder sb = null;
        if (fqn == null || fqn.equals(SEPARATOR) || fqn != null && fqn.isEmpty()) {
            return curr;
        }
        sb = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(fqn, SEPARATOR);
        while (tok.countTokens() > 1) {
            String name = tok.nextToken();
            sb.append(SEPARATOR).append(name);
            Node node = curr.getChild(name);
            if (node == null && create_if_not_exists) {
                node = curr.createChild(name, sb.toString(), null, null);
            }
            if (node == null) {
                return null;
            }
            curr = node;
        }
        if (tok.countTokens() > 0 && child_name != null) {
            child_name.setValue(tok.nextToken());
        }
        return curr;
    }

    Node findNode(String fqn) {
        StringHolder sh = new StringHolder();
        Node n = this.findParentNode(fqn, sh, false);
        String child_name = sh.getValue();
        if (fqn == null || fqn.equals(SEPARATOR) || fqn != null && fqn.isEmpty()) {
            return this.root;
        }
        if (n == null || child_name == null) {
            return null;
        }
        return n.getChild(child_name);
    }

    void notifyNodeAdded(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).nodeAdded(fqn);
        }
    }

    void notifyNodeRemoved(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).nodeRemoved(fqn);
        }
    }

    void notifyNodeModified(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).nodeModified(fqn);
        }
    }

    void notifyViewChange(View v) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).viewChange(v);
        }
    }

    void notifyAllNodesCreated(Node curr) {
        if (curr == null) {
            return;
        }
        this.notifyNodeAdded(curr.fqn);
        Map<String, Node> children = curr.getChildren();
        if (children != null) {
            for (Node n : children.values()) {
                this.notifyAllNodesCreated(n);
            }
        }
    }

    public static void main(String[] args) {
        ReplicatedTree tree = null;
        HashMap<String, Object> m = new HashMap<String, Object>();
        String props = null;
        try {
            tree = new ReplicatedTree(null, props, 10000L);
            tree.addReplicatedTreeListener(new MyListener());
            tree.put("/a/b/c", null);
            tree.put("/a/b/c1", null);
            tree.put("/a/b/c2", null);
            tree.put("/a/b1/chat", null);
            tree.put("/a/b1/chat2", null);
            tree.put("/a/b1/chat5", null);
            System.out.println(tree);
            m.put("name", "Bela Ban");
            m.put("age", 36);
            m.put("cube", "240-17");
            tree.put("/a/b/c", m);
            System.out.println("info for for \"/a/b/c\" is " + tree.print("/a/b/c"));
            tree.put("/a/b/c", "age", 37);
            System.out.println("info for for \"/a/b/c\" is " + tree.print("/a/b/c"));
            tree.remove("/a/b");
            System.out.println(tree);
            tree.stop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static class MyListener
    implements ReplicatedTreeListener {
        MyListener() {
        }

        @Override
        public void nodeAdded(String fqn) {
            System.out.println("** node added: " + fqn);
        }

        @Override
        public void nodeRemoved(String fqn) {
            System.out.println("** node removed: " + fqn);
        }

        @Override
        public void nodeModified(String fqn) {
            System.out.println("** node modified: " + fqn);
        }

        @Override
        public void viewChange(View new_view) {
            System.out.println("** view change: " + new_view);
        }
    }

    private static class Request
    implements Serializable {
        static final int PUT = 1;
        static final int REMOVE = 2;
        int type = 0;
        String fqn = null;
        String key = null;
        Object value = null;
        HashMap data = null;
        private static final long serialVersionUID = 7772753222127676782L;

        private Request(int type, String fqn) {
            this.type = type;
            this.fqn = fqn;
        }

        private Request(int type, String fqn, HashMap data) {
            this(type, fqn);
            this.data = data;
        }

        private Request(int type, String fqn, String key) {
            this(type, fqn);
            this.key = key;
        }

        private Request(int type, String fqn, String key, Object value) {
            this(type, fqn);
            this.key = key;
            this.value = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Request.type2String(this.type)).append(" (");
            if (this.fqn != null) {
                sb.append(" fqn=" + this.fqn);
            }
            switch (this.type) {
                case 1: {
                    if (this.data != null) {
                        sb.append(", data=" + this.data);
                    }
                    if (this.key != null) {
                        sb.append(", key=" + this.key);
                    }
                    if (this.value == null) break;
                    sb.append(", value=" + this.value);
                    break;
                }
                case 2: {
                    if (this.key == null) break;
                    sb.append(", key=" + this.key);
                    break;
                }
            }
            sb.append(')');
            return sb.toString();
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return "PUT";
                }
                case 2: {
                    return "REMOVE";
                }
            }
            return "UNKNOWN";
        }
    }

    private static class StringHolder {
        String s = null;

        private StringHolder() {
        }

        void setValue(String s) {
            this.s = s;
        }

        String getValue() {
            return this.s;
        }
    }

    public static class Node
    implements Serializable {
        String name = null;
        String fqn = null;
        Node parent = null;
        TreeMap<String, Node> children = null;
        Map<String, Object> data = null;
        private static final long serialVersionUID = -3077676554440038890L;

        private Node(String child_name, String fqn, Node parent, Map<String, Object> data) {
            this.name = child_name;
            this.fqn = fqn;
            this.parent = parent;
            if (data != null) {
                this.data = (HashMap)((HashMap)data).clone();
            }
        }

        private Node(String child_name, String fqn, Node parent, String key, Object value) {
            this.name = child_name;
            this.fqn = fqn;
            this.parent = parent;
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.put(key, value);
        }

        void setData(Map data) {
            if (data == null) {
                return;
            }
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.putAll(data);
        }

        void setData(String key, Object value) {
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.put(key, value);
        }

        Map<String, Object> getData() {
            return this.data;
        }

        Object getData(String key) {
            return this.data != null ? this.data.get(key) : null;
        }

        boolean childExists(String child_name) {
            return child_name != null && this.children != null && this.children.containsKey(child_name);
        }

        Node createChild(String child_name, String fqn, Node parent, HashMap<String, Object> data) {
            Node child = null;
            if (child_name == null) {
                return null;
            }
            if (this.children == null) {
                this.children = new TreeMap();
            }
            if ((child = this.children.get(child_name)) != null) {
                child.setData(data);
            } else {
                child = new Node(child_name, fqn, parent, data);
                this.children.put(child_name, child);
            }
            return child;
        }

        Node createChild(String child_name, String fqn, Node parent, String key, Object value) {
            Node child = null;
            if (child_name == null) {
                return null;
            }
            if (this.children == null) {
                this.children = new TreeMap();
            }
            if ((child = this.children.get(child_name)) != null) {
                child.setData(key, value);
            } else {
                child = new Node(child_name, fqn, parent, key, value);
                this.children.put(child_name, child);
            }
            return child;
        }

        Node getChild(String child_name) {
            return child_name == null ? null : (this.children == null ? null : this.children.get(child_name));
        }

        Map<String, Node> getChildren() {
            return this.children;
        }

        void removeData(String key) {
            if (this.data != null) {
                this.data.remove(key);
            }
        }

        void removeData() {
            if (this.data != null) {
                this.data.clear();
            }
        }

        void removeChild(String child_name, String fqn) {
            if (child_name != null && this.children != null && this.children.containsKey(child_name)) {
                this.children.remove(child_name);
            }
        }

        void removeAll() {
            if (this.children != null) {
                this.children.clear();
            }
        }

        void print(StringBuilder sb, int indent) {
            Node.printIndent(sb, indent);
            sb.append(ReplicatedTree.SEPARATOR).append(this.name);
            if (this.children != null && !this.children.isEmpty()) {
                Collection<Node> values = this.children.values();
                Iterator<Node> it = values.iterator();
                while (it.hasNext()) {
                    sb.append('\n');
                    it.next().print(sb, indent + 4);
                }
            }
        }

        static void printIndent(StringBuilder sb, int indent) {
            if (sb != null) {
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append("\nname=" + this.name);
            }
            if (this.fqn != null) {
                sb.append("\nfqn=" + this.fqn);
            }
            if (this.data != null) {
                sb.append("\ndata=" + this.data);
            }
            return sb.toString();
        }

        public Object clone() throws CloneNotSupportedException {
            Node n = new Node(this.name, this.fqn, this.parent != null ? (Node)this.parent.clone() : null, this.data);
            if (this.children != null) {
                n.children = (TreeMap)this.children.clone();
            }
            return n;
        }
    }

    public static interface ReplicatedTreeListener {
        public void nodeAdded(String var1);

        public void nodeRemoved(String var1);

        public void nodeModified(String var1);

        public void viewChange(View var1);
    }
}

