/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.Request;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestCorrelator;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestOptions;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.ResponseMode;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RspFilter;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Rsp;
import org.apache.activemq.artemis.shaded.org.jgroups.util.RspList;

public class GroupRequest<T>
extends Request {
    protected final Map<Address, Rsp<T>> requests;
    int num_valid;
    int num_received;

    public GroupRequest(RequestCorrelator corr, Collection<Address> targets, RequestOptions options) {
        super(corr, options);
        int size = targets.size();
        this.requests = new HashMap<Address, Rsp<T>>(size);
        this.setTargets(targets);
    }

    @Override
    public void sendRequest(Message req) throws Exception {
        this.sendRequest(req, this.requests.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender, boolean is_exception) {
        if (this.done) {
            return;
        }
        Rsp<Object> rsp = this.requests.get(sender);
        if (rsp == null) {
            return;
        }
        RspFilter rsp_filter = this.options.getRspFilter();
        boolean responseReceived = false;
        this.lock.lock();
        try {
            if (!rsp.wasReceived()) {
                if (!rsp.wasSuspected() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                if (responseReceived = rsp_filter == null || rsp_filter.isAcceptable(response_value, sender)) {
                    if (is_exception && response_value instanceof Throwable) {
                        rsp.setException((Throwable)response_value);
                    } else {
                        rsp.setValue(response_value);
                    }
                    ++this.num_valid;
                }
            }
            boolean bl = this.done = this.responsesComplete() || rsp_filter != null && !rsp_filter.needMoreResponses();
            if (responseReceived || this.done) {
                this.cond.signal(true);
            }
            if (this.done && this.corr != null && this.req_id > 0L) {
                this.corr.done(this.req_id);
            }
            if (responseReceived || this.done) {
                this.checkCompletion(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null) {
            return;
        }
        boolean changed = false;
        Rsp<T> rsp = this.requests.get(suspected_member);
        if (rsp != null && rsp.setSuspected()) {
            changed = true;
            this.lock.lock();
            try {
                if (!rsp.wasReceived() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                this.cond.signal(true);
                this.checkCompletion(this);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void siteUnreachable(String site) {
        boolean changed = false;
        for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
            Rsp<T> rsp;
            SiteAddress addr;
            Address member = entry.getKey();
            if (!(member instanceof SiteAddress) || !(addr = (SiteAddress)member).getSite().equals(site) || (rsp = entry.getValue()) == null || !rsp.setUnreachable()) continue;
            changed = true;
            this.lock.lock();
            try {
                if (!rsp.wasReceived() && !rsp.wasSuspected()) {
                    ++this.num_received;
                }
                this.cond.signal(true);
                this.checkCompletion(this);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View view) {
        if (view == null || this.requests == null || this.requests.isEmpty()) {
            return;
        }
        boolean changed = false;
        this.lock.lock();
        try {
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Rsp<T> rsp;
                Address mbr = entry.getKey();
                if (mbr instanceof SiteAddress || view.containsMember(mbr) || !(rsp = entry.getValue()).setSuspected()) continue;
                if (!rsp.wasReceived() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                changed = true;
            }
            if (changed) {
                this.cond.signal(true);
                this.checkCompletion(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportClosed() {
        boolean changed = false;
        this.lock.lock();
        try {
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Rsp<T> rsp = entry.getValue();
                if (rsp == null || rsp.wasReceived() || rsp.wasSuspected() || rsp.wasUnreachable()) continue;
                rsp.setException(new IllegalStateException("transport was closed"));
                ++this.num_received;
                changed = true;
            }
            if (changed) {
                this.cond.signal(true);
                this.checkCompletion(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public RspList<T> getResults() {
        Collection<Rsp<T>> rsps = this.requests.values();
        return new RspList<T>(rsps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList<T> get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            this.waitForResults(0L);
        }
        finally {
            this.lock.unlock();
        }
        return this.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ok;
        this.lock.lock();
        try {
            ok = this.waitForResults(unit.toMillis(timeout));
        }
        finally {
            this.lock.unlock();
        }
        if (!ok) {
            throw new TimeoutException();
        }
        return this.getResults();
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        if (!this.requests.isEmpty()) {
            ret.append(", entries:\n");
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                Rsp<T> rsp = entry.getValue();
                ret.append(mbr).append(": ").append(rsp).append("\n");
            }
        }
        return ret.toString();
    }

    private void setTargets(Collection<Address> mbrs) {
        for (Address mbr : mbrs) {
            this.requests.put(mbr, new Rsp(mbr));
        }
    }

    private static int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private void sendRequest(Message request_msg, Collection<Address> targetMembers) throws Exception {
        try {
            this.corr.sendRequest(targetMembers, request_msg, this.options.getMode() == ResponseMode.GET_NONE ? null : this, this.options);
        }
        catch (Exception ex) {
            if (this.corr != null && this.req_id > 0L) {
                this.corr.done(this.req_id);
            }
            throw ex;
        }
    }

    @Override
    protected boolean responsesComplete() {
        if (this.done) {
            return true;
        }
        int num_total = this.requests.size();
        switch (this.options.getMode()) {
            case GET_FIRST: {
                return this.num_valid >= 1 || this.num_received >= num_total;
            }
            case GET_ALL: {
                return this.num_valid >= num_total || this.num_received >= num_total;
            }
            case GET_MAJORITY: {
                int majority = GroupRequest.determineMajority(num_total);
                return this.num_valid >= majority || this.num_received >= num_total;
            }
            case GET_NONE: {
                return true;
            }
        }
        if (log.isErrorEnabled()) {
            log.error("rsp_mode " + (Object)((Object)this.options.getMode()) + " unknown !");
        }
        return false;
    }
}

