/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.AbstractJsonFactory;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.BufferStrategy;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.CommentsJsonStreamParserImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonInMemoryParser;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonStreamParserImpl;

public class JsonParserFactoryImpl
extends AbstractJsonFactory
implements JsonParserFactory {
    public static final String MAX_STRING_LENGTH = "org.apache.activemq.artemis.shaded.org.apache.johnzon.max-string-length";
    public static final int DEFAULT_MAX_STRING_LENGTH = Integer.getInteger("org.apache.activemq.artemis.shaded.org.apache.johnzon.max-string-length", 0xA00000);
    public static final String BUFFER_LENGTH = "org.apache.activemq.artemis.shaded.org.apache.johnzon.default-char-buffer";
    public static final int DEFAULT_BUFFER_LENGTH = Integer.getInteger("org.apache.activemq.artemis.shaded.org.apache.johnzon.default-char-buffer", 65536);
    public static final String SUPPORTS_COMMENTS = "org.apache.activemq.artemis.shaded.org.apache.johnzon.supports-comments";
    public static final boolean DEFAULT_SUPPORTS_COMMENT = Boolean.getBoolean("org.apache.activemq.artemis.shaded.org.apache.johnzon.supports-comments");
    static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList("org.apache.activemq.artemis.shaded.org.apache.johnzon.buffer-strategy", "org.apache.activemq.artemis.shaded.org.apache.johnzon.max-string-length", "org.apache.activemq.artemis.shaded.org.apache.johnzon.default-char-buffer", "org.apache.activemq.artemis.shaded.org.apache.johnzon.supports-comments");
    private final int maxSize;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;
    private final BufferStrategy.BufferProvider<char[]> valueBufferProvider;
    private final boolean supportsComments;

    JsonParserFactoryImpl(Map<String, ?> config) {
        super(config, SUPPORTED_CONFIG_KEYS, null);
        int bufferSize = this.getInt(BUFFER_LENGTH, DEFAULT_BUFFER_LENGTH);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("buffer length must be greater than zero");
        }
        this.maxSize = this.getInt(MAX_STRING_LENGTH, DEFAULT_MAX_STRING_LENGTH);
        this.bufferProvider = this.getBufferProvider().newCharProvider(bufferSize);
        this.valueBufferProvider = this.getBufferProvider().newCharProvider(this.maxSize);
        this.supportsComments = this.getBool(SUPPORTS_COMMENTS, DEFAULT_SUPPORTS_COMMENT);
    }

    private JsonParser getDefaultJsonParserImpl(InputStream in) {
        if (this.supportsComments) {
            return new CommentsJsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
        }
        return new JsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    private JsonParser getDefaultJsonParserImpl(InputStream in, Charset charset) {
        if (this.supportsComments) {
            return new CommentsJsonStreamParserImpl(in, charset, this.maxSize, this.bufferProvider, this.valueBufferProvider);
        }
        return new JsonStreamParserImpl(in, charset, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    private JsonParser getDefaultJsonParserImpl(Reader in) {
        if (this.supportsComments) {
            return new CommentsJsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
        }
        return new JsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return this.getDefaultJsonParserImpl(reader);
    }

    @Override
    public JsonParser createParser(InputStream in) {
        return this.getDefaultJsonParserImpl(in);
    }

    @Override
    public JsonParser createParser(InputStream in, Charset charset) {
        return this.getDefaultJsonParserImpl(in, charset);
    }

    @Override
    public JsonParser createParser(JsonObject obj) {
        return new JsonInMemoryParser(obj);
    }

    @Override
    public JsonParser createParser(JsonArray array) {
        return new JsonInMemoryParser(array);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }

    public JsonParser createInternalParser(InputStream in) {
        return this.getDefaultJsonParserImpl(in);
    }

    public JsonParser createInternalParser(InputStream in, Charset charset) {
        return this.getDefaultJsonParserImpl(in, charset);
    }

    public JsonParser createInternalParser(Reader reader) {
        return this.getDefaultJsonParserImpl(reader);
    }
}

