/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.QueueQueryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.server.QueueQueryResult;

public class SessionQueueQueryResponseMessage_V3
extends SessionQueueQueryResponseMessage_V2 {
    protected boolean autoCreated;
    protected boolean purgeOnNoConsumers;
    protected RoutingType routingType;
    protected int maxConsumers;

    public SessionQueueQueryResponseMessage_V3(QueueQueryResult result) {
        this(result.getName(), result.getAddress(), result.isDurable(), result.isTemporary(), result.getFilterString(), result.getConsumerCount(), result.getMessageCount(), result.isExists(), result.isAutoCreateQueues(), result.isAutoCreated(), result.isPurgeOnNoConsumers(), result.getRoutingType(), result.getMaxConsumers());
    }

    public SessionQueueQueryResponseMessage_V3() {
        this(null, null, false, false, null, 0, 0L, false, false, false, false, RoutingType.MULTICAST, -1);
    }

    private SessionQueueQueryResponseMessage_V3(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, long messageCount, boolean exists, boolean autoCreateQueues, boolean autoCreated, boolean purgeOnNoConsumers, RoutingType routingType, int maxConsumers) {
        super((byte)-14);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
        this.autoCreateQueues = autoCreateQueues;
        this.autoCreated = autoCreated;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.routingType = routingType;
        this.maxConsumers = maxConsumers;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
    }

    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.autoCreated);
        buffer.writeBoolean(this.purgeOnNoConsumers);
        buffer.writeByte(this.routingType.getType());
        buffer.writeInt(this.maxConsumers);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.autoCreated = buffer.readBoolean();
        this.purgeOnNoConsumers = buffer.readBoolean();
        this.routingType = RoutingType.getType(buffer.readByte());
        this.maxConsumers = buffer.readInt();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoCreated ? 1231 : 1237);
        result = 31 * result + (this.purgeOnNoConsumers ? 1231 : 1237);
        result = 31 * result + this.routingType.hashCode();
        result = 31 * result + this.maxConsumers;
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append("]");
        return buff.toString();
    }

    @Override
    public String getParentString() {
        StringBuffer buff = new StringBuffer(super.getParentString());
        buff.append(", autoCreated=" + this.autoCreated);
        buff.append(", purgeOnNoConsumers=" + this.purgeOnNoConsumers);
        buff.append(", routingType=" + (Object)((Object)this.routingType));
        buff.append(", maxConsumers=" + this.maxConsumers);
        return buff.toString();
    }

    @Override
    public ClientSession.QueueQuery toQueueQuery() {
        return new QueueQueryImpl(this.isDurable(), this.isTemporary(), this.getConsumerCount(), this.getMessageCount(), this.getFilterString(), this.getAddress(), this.getName(), this.isExists(), this.isAutoCreateQueues(), this.getMaxConsumers(), this.isAutoCreated(), this.isPurgeOnNoConsumers(), this.getRoutingType());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryResponseMessage_V3)) {
            return false;
        }
        SessionQueueQueryResponseMessage_V3 other = (SessionQueueQueryResponseMessage_V3)obj;
        if (this.autoCreated != other.autoCreated) {
            return false;
        }
        if (this.purgeOnNoConsumers != other.purgeOnNoConsumers) {
            return false;
        }
        if (this.routingType == null ? other.routingType != null : !this.routingType.equals((Object)other.routingType)) {
            return false;
        }
        return this.maxConsumers == other.maxConsumers;
    }
}

