/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.loadbalance.ConnectionLoadBalancingPolicy;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.AfterConnectInternalListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.cluster.DiscoveryEntry;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManagerFactory;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.remoting.Connector;
import org.apache.activemq.artemis.uri.ServerLocatorParser;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ActiveMQThreadPoolExecutor;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.uri.FluentPropertyBeanIntrospectorWithIgnores;

public final class ServerLocatorImpl
implements ServerLocatorInternal,
DiscoveryListener {
    private static final Logger logger = Logger.getLogger(ServerLocatorImpl.class);
    private static final long serialVersionUID = -1615857864410205260L;
    private ClientProtocolManagerFactory protocolManagerFactory = ActiveMQClientProtocolManagerFactory.getInstance(this);
    private final boolean ha;
    private boolean finalizeCheck = true;
    private boolean clusterConnection;
    private transient String identity;
    private final Set<ClientSessionFactoryInternal> factories = new HashSet<ClientSessionFactoryInternal>();
    private final Set<ClientSessionFactoryInternal> connectingFactories = new HashSet<ClientSessionFactoryInternal>();
    private volatile TransportConfiguration[] initialConnectors;
    private final DiscoveryGroupConfiguration discoveryGroupConfiguration;
    private final StaticConnector staticConnector = new StaticConnector();
    private final Topology topology;
    private final Object topologyArrayGuard = new Object();
    private volatile Pair<TransportConfiguration, TransportConfiguration>[] topologyArray;
    private volatile boolean receivedTopology;
    private boolean compressLargeMessage;
    private transient boolean shutdownPool;
    private transient ExecutorService threadPool;
    private transient ScheduledExecutorService scheduledThreadPool;
    private transient DiscoveryGroup discoveryGroup;
    private transient ConnectionLoadBalancingPolicy loadBalancingPolicy;
    private boolean cacheLargeMessagesClient;
    private long clientFailureCheckPeriod;
    private long connectionTTL;
    private long callTimeout;
    private long callFailoverTimeout;
    private int minLargeMessageSize;
    private int consumerWindowSize;
    private int consumerMaxRate;
    private int confirmationWindowSize;
    private int producerWindowSize;
    private int producerMaxRate;
    private boolean blockOnAcknowledge;
    private boolean blockOnDurableSend;
    private boolean blockOnNonDurableSend;
    private boolean autoGroup;
    private boolean preAcknowledge;
    private String connectionLoadBalancingPolicyClassName;
    private int ackBatchSize;
    private boolean useGlobalPools;
    private int scheduledThreadPoolMaxSize;
    private int threadPoolMaxSize;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private long maxRetryInterval;
    private int reconnectAttempts;
    private int initialConnectAttempts;
    private boolean failoverOnInitialConnection;
    private int initialMessagePacketSize;
    private final Object stateGuard = new Object();
    private transient STATE state;
    private transient CountDownLatch latch;
    private final List<Interceptor> incomingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private final List<Interceptor> outgoingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private Executor startExecutor;
    private AfterConnectInternalListener afterConnectListener;
    private String groupID;
    private String nodeID;
    private TransportConfiguration clusterTransportConfiguration;
    private boolean useTopologyForLoadBalancing;
    private final Exception traceException = new Exception();
    public static Runnable finalizeCallback;

    public static synchronized void clearThreadPools() {
        ActiveMQClient.clearThreadPools();
    }

    private synchronized void setThreadPools() {
        if (this.threadPool != null) {
            return;
        }
        if (this.useGlobalPools) {
            this.threadPool = ActiveMQClient.getGlobalThreadPool();
            this.scheduledThreadPool = ActiveMQClient.getGlobalScheduledThreadPool();
        } else {
            this.shutdownPool = true;
            ThreadFactory factory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-client-factory-threads-" + System.identityHashCode(this), true, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.threadPool = this.threadPoolMaxSize == -1 ? Executors.newCachedThreadPool(factory) : new ActiveMQThreadPoolExecutor(0, this.threadPoolMaxSize, 60L, TimeUnit.SECONDS, factory);
            factory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-client-factory-pinger-threads-" + System.identityHashCode(this), true, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.scheduledThreadPool = Executors.newScheduledThreadPool(this.scheduledThreadPoolMaxSize, factory);
        }
    }

    @Override
    public synchronized boolean setThreadPools(ExecutorService threadPool, ScheduledExecutorService scheduledThreadPool) {
        if (threadPool == null || scheduledThreadPool == null) {
            return false;
        }
        if (this.threadPool == null && this.scheduledThreadPool == null) {
            this.useGlobalPools = false;
            this.shutdownPool = false;
            this.threadPool = threadPool;
            this.scheduledThreadPool = scheduledThreadPool;
            return true;
        }
        return false;
    }

    private void instantiateLoadBalancingPolicy() {
        if (this.connectionLoadBalancingPolicyClassName == null) {
            throw new IllegalStateException("Please specify a load balancing policy class name on the session factory");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ServerLocatorImpl.this.loadBalancingPolicy = (ConnectionLoadBalancingPolicy)ClassloadingUtil.newInstanceFromClassLoader(ServerLocatorImpl.this.connectionLoadBalancingPolicyClassName);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialise() throws ActiveMQException {
        if (this.state == STATE.INITIALIZED) {
            return;
        }
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state == STATE.CLOSING) {
                throw new ActiveMQIllegalStateException();
            }
            try {
                this.state = STATE.INITIALIZED;
                this.latch = new CountDownLatch(1);
                this.setThreadPools();
                this.instantiateLoadBalancingPolicy();
                if (this.discoveryGroupConfiguration != null) {
                    this.discoveryGroup = ServerLocatorImpl.createDiscoveryGroup(this.nodeID, this.discoveryGroupConfiguration);
                    this.discoveryGroup.registerListener(this);
                    this.discoveryGroup.start();
                }
            }
            catch (Exception e) {
                this.state = null;
                throw ActiveMQClientMessageBundle.BUNDLE.failedToInitialiseSessionFactory(e);
            }
        }
    }

    private static DiscoveryGroup createDiscoveryGroup(String nodeID, DiscoveryGroupConfiguration config) throws Exception {
        DiscoveryGroup group = new DiscoveryGroup(nodeID, config.getName(), config.getRefreshTimeout(), config.getBroadcastEndpointFactory(), null);
        return group;
    }

    private ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration discoveryGroupConfiguration, TransportConfiguration[] transportConfigs) {
        this.traceException.fillInStackTrace();
        this.topology = topology == null ? new Topology(this) : topology;
        this.ha = useHA;
        this.discoveryGroupConfiguration = discoveryGroupConfiguration;
        this.initialConnectors = transportConfigs != null ? transportConfigs : null;
        this.nodeID = UUIDGenerator.getInstance().generateStringUUID();
        this.clientFailureCheckPeriod = ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
        this.connectionTTL = ActiveMQClient.DEFAULT_CONNECTION_TTL;
        this.callTimeout = 30000L;
        this.callFailoverTimeout = 30000L;
        this.minLargeMessageSize = 102400;
        this.consumerWindowSize = 0x100000;
        this.consumerMaxRate = -1;
        this.confirmationWindowSize = -1;
        this.producerWindowSize = 65536;
        this.producerMaxRate = -1;
        this.blockOnAcknowledge = false;
        this.blockOnDurableSend = true;
        this.blockOnNonDurableSend = false;
        this.autoGroup = false;
        this.preAcknowledge = false;
        this.ackBatchSize = 0x100000;
        this.connectionLoadBalancingPolicyClassName = ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
        this.useGlobalPools = true;
        this.threadPoolMaxSize = -1;
        this.scheduledThreadPoolMaxSize = 5;
        this.retryInterval = 2000L;
        this.retryIntervalMultiplier = ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER;
        this.maxRetryInterval = ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL;
        this.reconnectAttempts = 0;
        this.initialConnectAttempts = 1;
        this.failoverOnInitialConnection = false;
        this.cacheLargeMessagesClient = false;
        this.initialMessagePacketSize = 1500;
        this.cacheLargeMessagesClient = false;
        this.compressLargeMessage = false;
        this.clusterConnection = false;
        this.useTopologyForLoadBalancing = true;
    }

    public static ServerLocator newLocator(String uri) {
        try {
            ServerLocatorParser parser = new ServerLocatorParser();
            URI newURI = parser.expandURI(uri);
            return (ServerLocator)parser.newObject(newURI, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerLocator newLocator(URI uri) {
        try {
            ServerLocatorParser parser = new ServerLocatorParser();
            return (ServerLocator)parser.newObject(uri, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ServerLocatorImpl(boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(new Topology(null), useHA, groupConfiguration, null);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(boolean useHA, TransportConfiguration ... transportConfigs) {
        this(new Topology(null), useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(topology, useHA, groupConfiguration, null);
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, TransportConfiguration ... transportConfigs) {
        this(topology, useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
    }

    @Override
    public void resetToInitialConnectors() {
        this.receivedTopology = false;
        this.topologyArray = null;
        this.topology.clear();
    }

    @Override
    public boolean allInVM() {
        for (TransportConfiguration config : this.getStaticTransportConfigurations()) {
            if (config.getFactoryClassName().contains("InVMConnectorFactory")) continue;
            return false;
        }
        return true;
    }

    private ServerLocatorImpl(ServerLocatorImpl locator) {
        this.ha = locator.ha;
        this.finalizeCheck = locator.finalizeCheck;
        this.clusterConnection = locator.clusterConnection;
        this.initialConnectors = locator.initialConnectors;
        this.discoveryGroupConfiguration = locator.discoveryGroupConfiguration;
        this.topology = locator.topology;
        this.topologyArray = locator.topologyArray;
        this.receivedTopology = locator.receivedTopology;
        this.compressLargeMessage = locator.compressLargeMessage;
        this.cacheLargeMessagesClient = locator.cacheLargeMessagesClient;
        this.clientFailureCheckPeriod = locator.clientFailureCheckPeriod;
        this.connectionTTL = locator.connectionTTL;
        this.callTimeout = locator.callTimeout;
        this.callFailoverTimeout = locator.callFailoverTimeout;
        this.minLargeMessageSize = locator.minLargeMessageSize;
        this.consumerWindowSize = locator.consumerWindowSize;
        this.consumerMaxRate = locator.consumerMaxRate;
        this.confirmationWindowSize = locator.confirmationWindowSize;
        this.producerWindowSize = locator.producerWindowSize;
        this.producerMaxRate = locator.producerMaxRate;
        this.blockOnAcknowledge = locator.blockOnAcknowledge;
        this.blockOnDurableSend = locator.blockOnDurableSend;
        this.blockOnNonDurableSend = locator.blockOnNonDurableSend;
        this.autoGroup = locator.autoGroup;
        this.preAcknowledge = locator.preAcknowledge;
        this.connectionLoadBalancingPolicyClassName = locator.connectionLoadBalancingPolicyClassName;
        this.ackBatchSize = locator.ackBatchSize;
        this.useGlobalPools = locator.useGlobalPools;
        this.scheduledThreadPoolMaxSize = locator.scheduledThreadPoolMaxSize;
        this.threadPoolMaxSize = locator.threadPoolMaxSize;
        this.retryInterval = locator.retryInterval;
        this.retryIntervalMultiplier = locator.retryIntervalMultiplier;
        this.maxRetryInterval = locator.maxRetryInterval;
        this.reconnectAttempts = locator.reconnectAttempts;
        this.initialConnectAttempts = locator.initialConnectAttempts;
        this.failoverOnInitialConnection = locator.failoverOnInitialConnection;
        this.initialMessagePacketSize = locator.initialMessagePacketSize;
        this.startExecutor = locator.startExecutor;
        this.afterConnectListener = locator.afterConnectListener;
        this.groupID = locator.groupID;
        this.nodeID = locator.nodeID;
        this.clusterTransportConfiguration = locator.clusterTransportConfiguration;
        this.useTopologyForLoadBalancing = locator.useTopologyForLoadBalancing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportConfiguration selectConnector() {
        Pair<TransportConfiguration, TransportConfiguration>[] usedTopology;
        Object object = this.topologyArrayGuard;
        synchronized (object) {
            usedTopology = this.topologyArray;
        }
        object = this;
        synchronized (object) {
            if (usedTopology != null && this.useTopologyForLoadBalancing) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Selecting connector from topology.");
                }
                int pos = this.loadBalancingPolicy.select(usedTopology.length);
                Pair<TransportConfiguration, TransportConfiguration> pair = usedTopology[pos];
                return pair.getA();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Selecting connector from initial connectors.");
            }
            int pos = this.loadBalancingPolicy.select(this.initialConnectors.length);
            return this.initialConnectors[pos];
        }
    }

    @Override
    public void start(Executor executor) throws Exception {
        this.initialise();
        this.startExecutor = executor;
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            ServerLocatorImpl.this.connect();
                        }
                        catch (Exception e) {
                            if (ServerLocatorImpl.this.isClosed()) break block2;
                            ActiveMQClientLogger.LOGGER.errorConnectingToNodes(e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public ClientProtocolManager newProtocolManager() {
        return this.getProtocolManagerFactory().newProtocolManager();
    }

    @Override
    public ClientProtocolManagerFactory getProtocolManagerFactory() {
        if (this.protocolManagerFactory == null) {
            this.protocolManagerFactory = ActiveMQClientProtocolManagerFactory.getInstance(this);
        }
        return this.protocolManagerFactory;
    }

    @Override
    public ServerLocator setProtocolManagerFactory(ClientProtocolManagerFactory protocolManagerFactory) {
        this.protocolManagerFactory = protocolManagerFactory;
        protocolManagerFactory.setLocator(this);
        return this;
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public ClientSessionFactoryInternal connect() throws ActiveMQException {
        return this.connect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSessionFactoryInternal connect(boolean skipWarnings) throws ActiveMQException {
        ClientSessionFactoryInternal returnFactory = null;
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            if (this.getNumInitialConnectors() > 0 && this.discoveryGroup == null) {
                returnFactory = (ClientSessionFactoryInternal)this.staticConnector.connect(skipWarnings);
            }
        }
        if (returnFactory != null) {
            this.addFactory(returnFactory);
            return returnFactory;
        }
        return (ClientSessionFactoryInternal)this.createSessionFactory();
    }

    @Override
    public ClientSessionFactoryInternal connectNoWarnings() throws ActiveMQException {
        return this.connect(true);
    }

    @Override
    public ServerLocatorImpl setAfterConnectionInternalListener(AfterConnectInternalListener listener) {
        this.afterConnectListener = listener;
        return this;
    }

    @Override
    public AfterConnectInternalListener getAfterConnectInternalListener() {
        return this.afterConnectListener;
    }

    @Override
    public ClientSessionFactory createSessionFactory(String nodeID) throws Exception {
        TopologyMemberImpl topologyMember = this.topology.getMember(nodeID);
        if (logger.isTraceEnabled()) {
            logger.trace("Creating connection factory towards " + nodeID + " = " + topologyMember + ", topology=" + this.topology.describe());
        }
        if (topologyMember == null) {
            return null;
        }
        if (topologyMember.getLive() != null) {
            ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.createSessionFactory(topologyMember.getLive());
            if (topologyMember.getBackup() != null) {
                factory.setBackupConnector(topologyMember.getLive(), topologyMember.getBackup());
            }
            return factory;
        }
        if (topologyMember.getLive() == null && topologyMember.getBackup() != null) {
            ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.createSessionFactory(topologyMember.getBackup());
            return factory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration) throws Exception {
        this.assertOpen();
        this.initialise();
        ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(this, transportConfiguration, this.callTimeout, this.callFailoverTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.incomingInterceptors, this.outgoingInterceptors);
        this.addToConnecting(factory);
        try {
            try {
                factory.connect(this.reconnectAttempts, this.failoverOnInitialConnection);
            }
            catch (ActiveMQException e1) {
                factory.close();
                throw e1;
            }
            this.addFactory(factory);
            ClientSessionFactoryImpl clientSessionFactoryImpl = factory;
            return clientSessionFactoryImpl;
        }
        finally {
            this.removeFromConnecting(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration, int reconnectAttempts, boolean failoverOnInitialConnection) throws Exception {
        this.assertOpen();
        this.initialise();
        ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(this, transportConfiguration, this.callTimeout, this.callFailoverTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.incomingInterceptors, this.outgoingInterceptors);
        this.addToConnecting(factory);
        try {
            try {
                factory.connect(reconnectAttempts, failoverOnInitialConnection);
            }
            catch (ActiveMQException e1) {
                factory.close();
                throw e1;
            }
            this.addFactory(factory);
            ClientSessionFactoryImpl clientSessionFactoryImpl = factory;
            return clientSessionFactoryImpl;
        }
        finally {
            this.removeFromConnecting(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromConnecting(ClientSessionFactoryInternal factory) {
        Set<ClientSessionFactoryInternal> set = this.connectingFactories;
        synchronized (set) {
            this.connectingFactories.remove(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConnecting(ClientSessionFactoryInternal factory) {
        Set<ClientSessionFactoryInternal> set = this.connectingFactories;
        synchronized (set) {
            this.assertOpen();
            this.connectingFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory() throws ActiveMQException {
        long timeout;
        boolean ok;
        this.assertOpen();
        this.initialise();
        if (this.getNumInitialConnectors() == 0 && this.discoveryGroup != null && !(ok = this.discoveryGroup.waitForBroadcast(timeout = this.clusterConnection ? 0L : this.discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout()))) {
            throw ActiveMQClientMessageBundle.BUNDLE.connectionTimedOutInInitialBroadcast();
        }
        ClientSessionFactory factory = null;
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            boolean retry;
            int attempts = 0;
            do {
                retry = false;
                TransportConfiguration tc = this.selectConnector();
                if (tc == null) {
                    throw ActiveMQClientMessageBundle.BUNDLE.noTCForSessionFactory();
                }
                try {
                    factory = new ClientSessionFactoryImpl(this, tc, this.callTimeout, this.callFailoverTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.incomingInterceptors, this.outgoingInterceptors);
                    try {
                        this.addToConnecting((ClientSessionFactoryInternal)factory);
                        factory.connect(this.initialConnectAttempts, this.failoverOnInitialConnection);
                    }
                    finally {
                        this.removeFromConnecting((ClientSessionFactoryInternal)factory);
                    }
                }
                catch (ActiveMQException e) {
                    factory.close();
                    if (e.getType() == ActiveMQExceptionType.NOT_CONNECTED) {
                        ++attempts;
                        Object object = this.topologyArrayGuard;
                        synchronized (object) {
                            if (this.topologyArray != null && attempts == this.topologyArray.length) {
                                throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToServers();
                            }
                            if (this.topologyArray == null && attempts == this.getNumInitialConnectors()) {
                                throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToServers();
                            }
                        }
                        retry = true;
                        continue;
                    }
                    throw e;
                }
            } while (retry);
        }
        if (this.topology != null && !factory.waitForTopology(this.callTimeout, TimeUnit.MILLISECONDS)) {
            factory.cleanup();
            throw ActiveMQClientMessageBundle.BUNDLE.connectionTimedOutOnReceiveTopology(this.discoveryGroup);
        }
        this.addFactory((ClientSessionFactoryInternal)factory);
        return factory;
    }

    @Override
    public boolean isHA() {
        return this.ha;
    }

    @Override
    public ServerLocator setIncomingInterceptorList(String interceptorList) {
        this.feedInterceptors(this.incomingInterceptors, interceptorList);
        return this;
    }

    @Override
    public String getIncomingInterceptorList() {
        return this.fromInterceptors(this.incomingInterceptors);
    }

    @Override
    public ServerLocator setOutgoingInterceptorList(String interceptorList) {
        this.feedInterceptors(this.outgoingInterceptors, interceptorList);
        return this;
    }

    @Override
    public String getOutgoingInterceptorList() {
        return this.fromInterceptors(this.outgoingInterceptors);
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public ServerLocatorImpl setCacheLargeMessagesClient(boolean cached) {
        this.cacheLargeMessagesClient = cached;
        return this;
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public ServerLocatorImpl setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    @Override
    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public ServerLocatorImpl setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.connectionTTL = connectionTTL;
        return this;
    }

    @Override
    public long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public ServerLocatorImpl setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.callTimeout = callTimeout;
        return this;
    }

    @Override
    public long getCallFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    @Override
    public ServerLocatorImpl setCallFailoverTimeout(long callFailoverTimeout) {
        this.checkWrite();
        this.callFailoverTimeout = callFailoverTimeout;
        return this;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public ServerLocatorImpl setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.minLargeMessageSize = minLargeMessageSize;
        return this;
    }

    @Override
    public int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public ServerLocatorImpl setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.consumerWindowSize = consumerWindowSize;
        return this;
    }

    @Override
    public int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public ServerLocatorImpl setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.consumerMaxRate = consumerMaxRate;
        return this;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public ServerLocatorImpl setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.confirmationWindowSize = confirmationWindowSize;
        return this;
    }

    @Override
    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public ServerLocatorImpl setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.producerWindowSize = producerWindowSize;
        return this;
    }

    @Override
    public int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public ServerLocatorImpl setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.producerMaxRate = producerMaxRate;
        return this;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public ServerLocatorImpl setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.blockOnAcknowledge = blockOnAcknowledge;
        return this;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public ServerLocatorImpl setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.blockOnDurableSend = blockOnDurableSend;
        return this;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public ServerLocatorImpl setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        return this;
    }

    @Override
    public boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public ServerLocatorImpl setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.autoGroup = autoGroup;
        return this;
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public ServerLocatorImpl setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.preAcknowledge = preAcknowledge;
        return this;
    }

    @Override
    public int getAckBatchSize() {
        return this.ackBatchSize;
    }

    @Override
    public ServerLocatorImpl setAckBatchSize(int ackBatchSize) {
        this.checkWrite();
        this.ackBatchSize = ackBatchSize;
        return this;
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public ServerLocatorImpl setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.useGlobalPools = useGlobalPools;
        return this;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public ServerLocatorImpl setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
        return this;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public ServerLocatorImpl setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.threadPoolMaxSize = threadPoolMaxSize;
        return this;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public ServerLocatorImpl setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.retryInterval = retryInterval;
        return this;
    }

    @Override
    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public ServerLocatorImpl setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.maxRetryInterval = retryInterval;
        return this;
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public ServerLocatorImpl setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public ServerLocatorImpl setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    @Override
    public ServerLocatorImpl setInitialConnectAttempts(int initialConnectAttempts) {
        this.checkWrite();
        this.initialConnectAttempts = initialConnectAttempts;
        return this;
    }

    @Override
    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    @Override
    public boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    @Override
    public ServerLocatorImpl setFailoverOnInitialConnection(boolean failover) {
        this.checkWrite();
        this.failoverOnInitialConnection = failover;
        return this;
    }

    @Override
    public String getConnectionLoadBalancingPolicyClassName() {
        return this.connectionLoadBalancingPolicyClassName;
    }

    @Override
    public ServerLocatorImpl setConnectionLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.checkWrite();
        this.connectionLoadBalancingPolicyClassName = loadBalancingPolicyClassName;
        return this;
    }

    @Override
    public TransportConfiguration[] getStaticTransportConfigurations() {
        if (this.initialConnectors == null) {
            return new TransportConfiguration[0];
        }
        return Arrays.copyOf(this.initialConnectors, this.initialConnectors.length);
    }

    @Override
    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.discoveryGroupConfiguration;
    }

    @Override
    public ServerLocatorImpl addIncomingInterceptor(Interceptor interceptor) {
        this.incomingInterceptors.add(interceptor);
        return this;
    }

    @Override
    public ServerLocatorImpl addOutgoingInterceptor(Interceptor interceptor) {
        this.outgoingInterceptors.add(interceptor);
        return this;
    }

    @Override
    public boolean removeIncomingInterceptor(Interceptor interceptor) {
        return this.incomingInterceptors.remove(interceptor);
    }

    @Override
    public boolean removeOutgoingInterceptor(Interceptor interceptor) {
        return this.outgoingInterceptors.remove(interceptor);
    }

    @Override
    public int getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    @Override
    public ServerLocatorImpl setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.initialMessagePacketSize = size;
        return this;
    }

    @Override
    public ServerLocatorImpl setGroupID(String groupID) {
        this.checkWrite();
        this.groupID = groupID;
        return this;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public boolean isCompressLargeMessage() {
        return this.compressLargeMessage;
    }

    @Override
    public ServerLocatorImpl setCompressLargeMessage(boolean avoid) {
        this.compressLargeMessage = avoid;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWrite() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != null && this.state != STATE.CLOSED) {
                throw new IllegalStateException("Cannot set attribute on SessionFactory after it has been used");
            }
        }
    }

    private int getNumInitialConnectors() {
        if (this.initialConnectors == null) {
            return 0;
        }
        return this.initialConnectors.length;
    }

    @Override
    public ServerLocatorImpl setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public ServerLocatorImpl setNodeID(String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public ServerLocatorImpl setClusterConnection(boolean clusterConnection) {
        this.clusterConnection = clusterConnection;
        return this;
    }

    @Override
    public boolean isClusterConnection() {
        return this.clusterConnection;
    }

    @Override
    public TransportConfiguration getClusterTransportConfiguration() {
        return this.clusterTransportConfiguration;
    }

    @Override
    public ServerLocatorImpl setClusterTransportConfiguration(TransportConfiguration tc) {
        this.clusterTransportConfiguration = tc;
        return this;
    }

    protected void finalize() throws Throwable {
        if (this.finalizeCheck) {
            this.close();
        }
        super.finalize();
    }

    @Override
    public void cleanup() {
        this.doClose(false);
    }

    @Override
    public void close() {
        this.doClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean sendClose) {
        HashSet<ClientSessionFactoryInternal> clonedFactory;
        Set<ClientSessionFactoryInternal> set = this.stateGuard;
        synchronized (set) {
            if (this.state == STATE.CLOSED) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this + " is already closed when calling closed");
                }
                return;
            }
            this.state = STATE.CLOSING;
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        set = this.connectingFactories;
        synchronized (set) {
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.causeExit();
            }
        }
        if (this.discoveryGroup != null) {
            set = this;
            synchronized (set) {
                try {
                    this.discoveryGroup.stop();
                }
                catch (Exception e) {
                    ActiveMQClientLogger.LOGGER.failedToStopDiscovery(e);
                }
            }
        }
        this.staticConnector.disconnect();
        set = this.connectingFactories;
        synchronized (set) {
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.causeExit();
            }
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.close();
            }
            this.connectingFactories.clear();
        }
        Iterator e = this.factories;
        synchronized (e) {
            clonedFactory = new HashSet<ClientSessionFactoryInternal>(this.factories);
            this.factories.clear();
        }
        for (ClientSessionFactoryInternal clientSessionFactoryInternal : clonedFactory) {
            clientSessionFactoryInternal.causeExit();
        }
        for (ClientSessionFactory clientSessionFactory : clonedFactory) {
            if (sendClose) {
                try {
                    clientSessionFactory.close();
                }
                catch (Throwable e2) {
                    logger.debug((Object)e2.getMessage(), e2);
                    clientSessionFactory.cleanup();
                }
                continue;
            }
            clientSessionFactory.cleanup();
        }
        if (this.shutdownPool) {
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        ActiveMQClientLogger.LOGGER.timedOutWaitingForTermination();
                    }
                }
                catch (InterruptedException e3) {
                    throw new ActiveMQInterruptedException(e3);
                }
            }
            if (this.scheduledThreadPool != null) {
                this.scheduledThreadPool.shutdown();
                try {
                    if (!this.scheduledThreadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        ActiveMQClientLogger.LOGGER.timedOutWaitingForScheduledPoolTermination();
                    }
                }
                catch (InterruptedException e4) {
                    throw new ActiveMQInterruptedException(e4);
                }
            }
        }
        Object object = this.stateGuard;
        synchronized (object) {
            this.state = STATE.CLOSED;
        }
    }

    @Override
    public void notifyNodeDown(long eventTime, String nodeID) {
        if (!this.ha) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("nodeDown " + this + " nodeID=" + nodeID + " as being down"), new Exception("trace"));
        }
        this.topology.removeMember(eventTime, nodeID);
        if (this.clusterConnection) {
            this.updateArraysAndPairs();
        } else if (this.topology.isEmpty()) {
            this.receivedTopology = false;
            this.topologyArray = null;
        } else {
            this.updateArraysAndPairs();
            if (this.topology.nodes() == 1 && this.topology.getMember(this.nodeID) != null) {
                this.receivedTopology = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNodeUp(long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("NodeUp " + this + "::nodeID=" + nodeID + ", connectorPair=" + connectorPair), new Exception("trace"));
        }
        TopologyMemberImpl member = new TopologyMemberImpl(nodeID, backupGroupName, scaleDownGroupName, connectorPair.getA(), connectorPair.getB());
        this.topology.updateMember(uniqueEventID, nodeID, member);
        TopologyMemberImpl actMember = this.topology.getMember(nodeID);
        if (actMember != null && actMember.getLive() != null && actMember.getBackup() != null) {
            HashSet<ClientSessionFactoryInternal> clonedFactories = new HashSet<ClientSessionFactoryInternal>();
            Set<ClientSessionFactoryInternal> set = this.factories;
            synchronized (set) {
                clonedFactories.addAll(this.factories);
            }
            for (ClientSessionFactory clientSessionFactory : clonedFactories) {
                ((ClientSessionFactoryInternal)clientSessionFactory).setBackupConnector(actMember.getLive(), actMember.getBackup());
            }
        }
        this.updateArraysAndPairs();
        if (last) {
            this.receivedTopology = true;
        }
    }

    public String toString() {
        if (this.identity != null) {
            return "ServerLocatorImpl (identity=" + this.identity + ") [initialConnectors=" + Arrays.toString(this.initialConnectors == null ? new TransportConfiguration[]{} : this.initialConnectors) + ", discoveryGroupConfiguration=" + this.discoveryGroupConfiguration + "]";
        }
        return "ServerLocatorImpl [initialConnectors=" + Arrays.toString(this.initialConnectors == null ? new TransportConfiguration[]{} : this.initialConnectors) + ", discoveryGroupConfiguration=" + this.discoveryGroupConfiguration + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArraysAndPairs() {
        Object object = this.topologyArrayGuard;
        synchronized (object) {
            Collection<TopologyMemberImpl> membersCopy = this.topology.getMembers();
            Pair[] topologyArrayLocal = (Pair[])Array.newInstance(Pair.class, membersCopy.size());
            int count = 0;
            for (TopologyMemberImpl pair : membersCopy) {
                Pair<TransportConfiguration, TransportConfiguration> transportConfigs = pair.getConnector();
                topologyArrayLocal[count++] = new Pair<TransportConfiguration, TransportConfiguration>(this.protocolManagerFactory.adaptTransportConfiguration(transportConfigs.getA()), this.protocolManagerFactory.adaptTransportConfiguration(transportConfigs.getB()));
            }
            this.topologyArray = topologyArrayLocal;
        }
    }

    @Override
    public synchronized void connectorsChanged(List<DiscoveryEntry> newConnectors) {
        if (this.receivedTopology) {
            return;
        }
        TransportConfiguration[] newInitialconnectors = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, newConnectors.size());
        int count = 0;
        for (DiscoveryEntry entry : newConnectors) {
            newInitialconnectors[count++] = entry.getConnector();
            if (!this.ha || this.topology.getMember(entry.getNodeID()) != null) continue;
            TopologyMemberImpl member = new TopologyMemberImpl(entry.getNodeID(), null, null, entry.getConnector(), null);
            this.topology.updateMember(0L, entry.getNodeID(), member);
        }
        TransportConfiguration[] transportConfigurationArray = this.initialConnectors = newInitialconnectors.length == 0 ? null : newInitialconnectors;
        if (this.clusterConnection && !this.receivedTopology && this.getNumInitialConnectors() > 0) {
            Runnable connectRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ServerLocatorImpl.this.connect();
                    }
                    catch (ActiveMQException e) {
                        ActiveMQClientLogger.LOGGER.errorConnectingToNodes(e);
                    }
                }
            };
            if (this.startExecutor != null) {
                this.startExecutor.execute(connectRunnable);
            } else {
                connectRunnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void factoryClosed(ClientSessionFactory factory) {
        boolean isEmpty;
        Set<ClientSessionFactoryInternal> set = this.factories;
        synchronized (set) {
            this.factories.remove(factory);
            isEmpty = this.factories.isEmpty();
        }
        if (!this.clusterConnection && isEmpty) {
            this.receivedTopology = false;
            this.topologyArray = null;
        }
    }

    @Override
    public ServerLocator setUseTopologyForLoadBalancing(boolean useTopologyForLoadBalancing) {
        this.useTopologyForLoadBalancing = useTopologyForLoadBalancing;
        return this;
    }

    @Override
    public boolean getUseTopologyForLoadBalancing() {
        return this.useTopologyForLoadBalancing;
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public boolean isConnectable() {
        return this.getNumInitialConnectors() > 0 || this.getDiscoveryGroupConfiguration() != null;
    }

    @Override
    public ServerLocatorImpl addClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.addClusterTopologyListener(listener);
        return this;
    }

    @Override
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.removeClusterTopologyListener(listener);
    }

    public TransportConfiguration[] getInitialConnectors() {
        return this.initialConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFactory(ClientSessionFactoryInternal factory) {
        if (factory == null) {
            return;
        }
        if (this.isClosed()) {
            factory.close();
            return;
        }
        TransportConfiguration backup = null;
        if (this.ha) {
            backup = this.topology.getBackupForConnector((Connector)factory.getConnector());
        }
        factory.setBackupConnector(factory.getConnectorConfiguration(), backup);
        Set<ClientSessionFactoryInternal> set = this.factories;
        synchronized (set) {
            this.factories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOpen() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != null && this.state != STATE.INITIALIZED) {
                throw new IllegalStateException("Server locator is closed (maybe it was garbage collected)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.stateGuard;
        synchronized (object) {
            return this.state != STATE.INITIALIZED;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        ServerLocatorImpl clone = new ServerLocatorImpl(this);
        return clone;
    }

    public boolean isReceivedTopology() {
        return this.receivedTopology;
    }

    private String fromInterceptors(List<Interceptor> interceptors) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Interceptor value : interceptors) {
            if (!first) {
                buffer.append(",");
            }
            first = false;
            buffer.append(value.getClass().getName());
        }
        return buffer.toString();
    }

    private void feedInterceptors(final List<Interceptor> interceptors, final String interceptorList) {
        interceptors.clear();
        if (interceptorList == null || interceptorList.trim().equals("")) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String[] arrayInterceptor;
                for (String strValue : arrayInterceptor = interceptorList.split(",")) {
                    Interceptor interceptor = (Interceptor)ClassloadingUtil.newInstanceFromClassLoader(strValue.trim());
                    interceptors.add(interceptor);
                }
                return null;
            }
        });
    }

    static {
        FluentPropertyBeanIntrospectorWithIgnores.addIgnore(ServerLocatorImpl.class.getName(), "setThreadPools");
        finalizeCallback = null;
    }

    private final class StaticConnector
    implements Serializable {
        private static final long serialVersionUID = 6772279632415242634L;
        private List<Connector> connectors;

        private StaticConnector() {
        }

        public ClientSessionFactory connect(boolean skipWarnings) throws ActiveMQException {
            ServerLocatorImpl.this.assertOpen();
            ServerLocatorImpl.this.initialise();
            this.createConnectors();
            try {
                int retryNumber = 0;
                while (!ServerLocatorImpl.this.isClosed()) {
                    ++retryNumber;
                    for (Connector conn : this.connectors) {
                        ClientSessionFactory csf;
                        if (logger.isDebugEnabled()) {
                            logger.debug(this + "::Submitting connect towards " + conn);
                        }
                        if ((csf = conn.tryConnect()) == null) continue;
                        csf.getConnection().addFailureListener(new FailureListener(){

                            @Override
                            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
                                if (ServerLocatorImpl.this.clusterConnection && exception.getType() == ActiveMQExceptionType.DISCONNECTED) {
                                    try {
                                        ServerLocatorImpl.this.start(ServerLocatorImpl.this.startExecutor);
                                    }
                                    catch (Exception e) {
                                        ActiveMQClientLogger.LOGGER.errorStartingLocator(e);
                                    }
                                }
                            }

                            @Override
                            public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                                this.connectionFailed(me, failedOver);
                            }

                            public String toString() {
                                return "FailureListener('restarts cluster connections')";
                            }
                        });
                        if (logger.isDebugEnabled()) {
                            logger.debug("Returning " + csf + " after " + retryNumber + " retries on StaticConnector " + ServerLocatorImpl.this);
                        }
                        return csf;
                    }
                    if (ServerLocatorImpl.this.initialConnectAttempts >= 0 && retryNumber > ServerLocatorImpl.this.initialConnectAttempts) break;
                    if (!ServerLocatorImpl.this.latch.await(ServerLocatorImpl.this.retryInterval, TimeUnit.MILLISECONDS)) continue;
                    return null;
                }
            }
            catch (RejectedExecutionException e) {
                if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                    return null;
                }
                logger.debug((Object)"Rejected execution", e);
                throw e;
            }
            catch (Exception e) {
                if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                    return null;
                }
                ActiveMQClientLogger.LOGGER.errorConnectingToNodes(e);
                throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToStaticConnectors(e);
            }
            if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                return null;
            }
            ActiveMQClientLogger.LOGGER.errorConnectingToNodes(ServerLocatorImpl.this.traceException);
            throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToStaticConnectors2();
        }

        private synchronized void createConnectors() {
            if (this.connectors != null) {
                for (Connector conn : this.connectors) {
                    if (conn == null) continue;
                    conn.disconnect();
                }
            }
            this.connectors = new ArrayList<Connector>();
            if (ServerLocatorImpl.this.initialConnectors != null) {
                for (TransportConfiguration initialConnector : ServerLocatorImpl.this.initialConnectors) {
                    ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(ServerLocatorImpl.this, initialConnector, ServerLocatorImpl.this.callTimeout, ServerLocatorImpl.this.callFailoverTimeout, ServerLocatorImpl.this.clientFailureCheckPeriod, ServerLocatorImpl.this.connectionTTL, ServerLocatorImpl.this.retryInterval, ServerLocatorImpl.this.retryIntervalMultiplier, ServerLocatorImpl.this.maxRetryInterval, ServerLocatorImpl.this.reconnectAttempts, ServerLocatorImpl.this.threadPool, ServerLocatorImpl.this.scheduledThreadPool, ServerLocatorImpl.this.incomingInterceptors, ServerLocatorImpl.this.outgoingInterceptors);
                    factory.disableFinalizeCheck();
                    this.connectors.add(new Connector(initialConnector, factory));
                }
            }
        }

        public synchronized void disconnect() {
            if (this.connectors != null) {
                for (Connector connector : this.connectors) {
                    connector.disconnect();
                }
            }
        }

        protected void finalize() throws Throwable {
            if (!ServerLocatorImpl.this.isClosed() && ServerLocatorImpl.this.finalizeCheck) {
                ActiveMQClientLogger.LOGGER.serverLocatorNotClosed(ServerLocatorImpl.this.traceException, System.identityHashCode(this));
                if (finalizeCallback != null) {
                    finalizeCallback.run();
                }
                ServerLocatorImpl.this.close();
            }
            super.finalize();
        }

        private final class Connector {
            private final TransportConfiguration initialConnector;
            private volatile ClientSessionFactoryInternal factory;

            private Connector(TransportConfiguration initialConnector, ClientSessionFactoryInternal factory) {
                this.initialConnector = initialConnector;
                this.factory = factory;
            }

            public ClientSessionFactory tryConnect() throws ActiveMQException {
                if (logger.isDebugEnabled()) {
                    logger.debug(this + "::Trying to connect to " + this.factory);
                }
                try {
                    ClientSessionFactoryInternal factoryToUse = this.factory;
                    if (factoryToUse != null) {
                        ServerLocatorImpl.this.addToConnecting(factoryToUse);
                        try {
                            factoryToUse.connect(1, false);
                        }
                        finally {
                            ServerLocatorImpl.this.removeFromConnecting(factoryToUse);
                        }
                    }
                    return factoryToUse;
                }
                catch (ActiveMQException e) {
                    logger.debug((Object)(this + "::Exception on establish connector initial connection"), e);
                    return null;
                }
            }

            public void disconnect() {
                if (this.factory != null) {
                    this.factory.causeExit();
                    this.factory.cleanup();
                    this.factory = null;
                }
            }

            public String toString() {
                return "Connector [initialConnector=" + this.initialConnector + "]";
            }
        }
    }

    private static enum STATE {
        INITIALIZED,
        CLOSED,
        CLOSING;

    }
}

