/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.util.Arrays;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientLogger;
import org.slf4j.Logger;

public class ActiveMQJMSClientLogger_impl
implements ActiveMQJMSClientLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQJMSClientLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void connectionLeftOpen(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ132000: I'm closing a JMS connection you left open. Please make sure you close all JMS connections explicitly before letting them go out of scope! see stacktrace to find out where it was created", e);
        }
    }

    @Override
    public void onMessageError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ132001: Unhandled exception thrown from onMessage", e);
        }
    }

    @Override
    public void errorCallingExcListener(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ134000: Failed to call JMS exception listener", e);
        }
    }

    @Override
    public void errorCreatingMessage(String messageToString, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ134002: Queue Browser failed to create message {}", (Object)messageToString, (Object)e);
        }
    }

    @Override
    public void errorPreparingMessageForReceipt(String messagetoString, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ134003: Message Listener failed to prepare message for receipt, message={}", (Object)messagetoString, (Object)e);
        }
    }

    @Override
    public void errorProcessingMessage(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ134004: Message Listener failed to process message", e);
        }
    }

    @Override
    public void errorRecoveringSession(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ134005: Message Listener failed to recover session", e);
        }
    }

    @Override
    public void errorCallingFailoverListener(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ134006: Failed to call Failover listener", e);
        }
    }
}

